#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "pixq_options_page.h"
#include "props_page_hikari_view.h"
#include "ui_props_page_hikari_view.h"

props_page_hikari_view::props_page_hikari_view(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::props_page_hikari_view)
{
    ui->setupUi(this);
    _sPageId = (short)pixq_EnvItem::ItemCategoryHikariView;
}

props_page_hikari_view::~props_page_hikari_view()
{
    delete ui;
}

void props_page_hikari_view::closeEvent(QCloseEvent * /* event */ )
{
   Check( );

   return;
}

void props_page_hikari_view::keyPressEvent(QKeyEvent *event)
{
   switch (event->key()) {
   case Qt::Key_Enter:
      // ignore this
      goto PIX_EXIT;
      break;

   default:
      break;
   }

   props_page_hikari_view::keyPressEvent( event );

PIX_EXIT:
   return;
}

void props_page_hikari_view::SetData( void )
{
   pixq_Properties *pEnv = GetEnv( );
   QFont jp_fn, en_fn;

   // *******************
   // *** Hikari \ ***
   // *******************

   // JapanesetHg

   jp_fn = pEnv->_HikariViewHikariJpFont.lfGet();
   ui->hikari_font_jp_sample->setFont( jp_fn );
   ui->hikari_font_jp_sample->setText( "X̌" );

   // EnglishtHg

   en_fn = pEnv->_HikariViewHikariEnFont.lfGet();
   ui->hikari_font_en_sample->setFont( en_fn );
   ui->hikari_font_en_sample->setText( "Daily Light" );

   // \Őߔԍ̕\,ShowChapterVerseNumber̂ǂꂩ 
   SetShowVerseNumber( );

   // draw table boundary
   
   SetBool( &pEnv->_HikariViewShowTableLines, ui->hikari_show_column_line_check );

   // ߔԍƗʃJɂH

   SetBool( &pEnv->_HikariViewVersesSeparateColumn, ui->hikari_verses_separate_column_check );

   // System
   
   SetSystemLanguage( );

   return;
}

bool props_page_hikari_view::Check( void )
{
   bool bRetCode = false;
   pixq_Properties *pEnv = GetEnv( );

   // ************
   // *** \ ***
   // ************

   // JapanesetHg
   // done

   // EnglishtHg
   // done

   // background color
   // done

   // igA1\̏ꍇɌ,1܂2i
   // done

   // \Őߔԍ̕\,ShowChapterVerseNumber̂ǂꂩ 
   // done

   // draw table boundary

   GetBool( &pEnv->_HikariViewShowTableLines, ui->hikari_show_column_line_check );

   // ߔԍƗʃJɂH

   GetBool( &pEnv->_HikariViewVersesSeparateColumn, ui->hikari_verses_separate_column_check );

   // --- DONE ---
   bRetCode = true;
//PIX_EXIT:
   return bRetCode;
}

void props_page_hikari_view::SetSystemLanguage( void )
{
   pixq_Properties *pEnv = GetEnv( );
   int iLanguage;

   ui->hikari_language_jp_radio->setChecked( false );
   ui->hikari_language_en_radio->setChecked( false );

   // bible version

   iLanguage = pEnv->_HikariBibleSystemLanguage.iGet( );

   switch( iLanguage ) {
   case pixq_Properties::PixTopoLanguangeJp:
      ui->hikari_language_jp_radio->setChecked( true );
      break;
   case pixq_Properties::PixTopoLanguangeEn:
      ui->hikari_language_en_radio->setChecked( true );
      break;
   }

   return;
}

void props_page_hikari_view::on_hikari_font_jp_button_clicked()
{
    pixq_Properties *pEnv = GetEnv( );
    QFont newFn;
    QFont fn = pEnv->_HikariViewHikariJpFont.lfGet( );
    QFontDialog dlg( fn );

    if( QDialog::Accepted != dlg.exec( ) ) {
       goto PIX_EXIT;
    }

    newFn = dlg.selectedFont( );
    pEnv->_HikariViewHikariJpFont.Set( newFn );

    SetData( );

 PIX_EXIT:
    return;
}

void props_page_hikari_view::on_hikari_font_en_button_clicked()
{
    pixq_Properties *pEnv = GetEnv( );
    QFont newFn;
    QFont fn = pEnv->_HikariViewHikariEnFont.lfGet( );
    QFontDialog dlg( fn );

    if( QDialog::Accepted != dlg.exec( ) ) {
       goto PIX_EXIT;
    }

    newFn = dlg.selectedFont( );
    pEnv->_HikariViewHikariEnFont.Set( newFn );

    SetData( );

 PIX_EXIT:
    return;
}

void props_page_hikari_view::on_hikari_verse_show_chapter_verse_radio_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iValue = pixq_Properties::VerseNumberChapterVerse;

   pEnv->_HikariViewShowVerseNum.Set( iValue );
   SetShowVerseNumber( );

   return;
}

void props_page_hikari_view::on_hikari_verse_show_verse_radio_clicked()
{
    pixq_Properties *pEnv = GetEnv( );
    int iValue = pixq_Properties::VerseNumberVerse;

    pEnv->_HikariViewShowVerseNum.Set( iValue );
    SetShowVerseNumber( );

    return;
}

void props_page_hikari_view::SetShowVerseNumber( void )
{
   pixq_Properties *pEnv = GetEnv( );
   int iValue;

   ui->hikari_verse_show_chapter_verse_radio->setChecked( false );
   ui->hikari_verse_show_verse_radio->setChecked( false );

   // bible version

   iValue = pEnv->_HikariViewShowVerseNum.iGet( );

   switch( iValue ) {
   case pixq_Properties::VerseNumberChapterVerse:
      ui->hikari_verse_show_chapter_verse_radio->setChecked( true );
      break;
   case pixq_Properties::VerseNumberVerse:
      ui->hikari_verse_show_verse_radio->setChecked( true );
      break;
   }

   return;
}

void props_page_hikari_view::on_hikari_language_jp_radio_clicked(bool checked)
{
   pixq_Properties *pEnv = GetEnv( );
   int iLanguage = pixq_Properties::PixTopoLanguangeJp;

   if( checked ) {
      pEnv->_HikariBibleSystemLanguage.Set( iLanguage );
      SetSystemLanguage( );
   }

   return;
}

void props_page_hikari_view::on_hikari_language_en_radio_clicked(bool checked)
{
   pixq_Properties *pEnv = GetEnv( );
   int iLanguage = pixq_Properties::PixTopoLanguangeEn;

   if( checked ) {
      pEnv->_HikariBibleSystemLanguage.Set( iLanguage );
      SetSystemLanguage( );
   }

   return;

}
