#pragma once

#include <QtCore>
#include <QtGui>
#include <QApplication>

#include <QBrush>
#include <QPen>
#include <QPixmap>
#include <QWidget>

#include "pixq_options_page.h"

namespace Ui {
    class props_page_hikari_view;
}

class props_page_hikari_view : public QWidget, public pixq_options_page
{
    Q_OBJECT

public:
    explicit props_page_hikari_view(QWidget *parent = 0);
    ~props_page_hikari_view();

private slots:
    void on_hikari_font_jp_button_clicked();

    void on_hikari_font_en_button_clicked();

    void on_hikari_verse_show_chapter_verse_radio_clicked();
    void on_hikari_verse_show_verse_radio_clicked();

    void on_hikari_language_jp_radio_clicked(bool checked);

    void on_hikari_language_en_radio_clicked(bool checked);

private:
    Ui::props_page_hikari_view *ui;

public:
   void SetData( void );
   bool Check( void );

protected:
    void closeEvent(QCloseEvent *event);
    void keyPressEvent(QKeyEvent *event);

private:
  void  SetShowVerseNumber( void );

private:
   void SetSystemLanguage( void );
};
