#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "pixq_options_page.h"
#include "props_page_image.h"
#include "ui_props_page_image.h"

props_page_image::props_page_image(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::props_page_image)
{
    ui->setupUi(this);
    _sPageId = (short)pixq_EnvItem::ItemCategoryImage;
}

props_page_image::~props_page_image()
{
    delete ui;
}

void props_page_image::closeEvent(QCloseEvent * /* event */ )
{
   Check( );

   return;
}

void props_page_image::SetData( void )
{   
   pixq_Properties *pEnv = GetEnv( );
   QString strValue;

   // *** set current data ***
   
   // texture filter
   SetTextureFilter( );

   // gamma correction for image
   
   Set2Double( &pEnv->_ImageGammaCorrection, ui->m_GammaEdit );
   //ui->m_GammaEdit->setValidator( new QDoubleValidator( 0.0, 100.0, 2, ui->m_GammaEdit ) );

   // use Ping's 10_10_10_2 texture if applicable
   
   SetBool( &pEnv->_Image10BitTexture, ui->m_10BitCheck );

   // sampling interval for image statistics/histogram
   
   SetInteger( &pEnv->_ImageStatSamplePitch, ui->m_IntervalEdit );   

   ui->m_IntervalEdit->setValidator( new QIntValidator( 1, 20, ui->m_IntervalEdit ) );
      
   // get and show statistics when new frame is selected?
   
   SetBool( &pEnv->_ImageStatActiveFrame, ui->image_active_stat_check ); 

   // --- Done ---
   return;
}

   
bool props_page_image::Check( void )
{  
   pixq_Properties *pEnv = GetEnv( );
   bool bRetCode = false;

   // texture filter
   
   // gamma correction for image
   
   if( !GetDouble( &pEnv->_ImageGammaCorrection, ui->m_GammaEdit ) ) { 
      QMessageBox::critical( this, "ERROR", "Enter Real Value." );
      goto PIX_EXIT;
   } 
   
   // use Ping's 10_10_10_2 texture if applicable
   
   GetBool( &pEnv->_Image10BitTexture, ui->m_10BitCheck ); 

   // sampling interval for image statistics/histopram

   if( !GetInteger( &pEnv->_ImageStatSamplePitch, ui->m_IntervalEdit ) ) { 
      QMessageBox::critical( this, "ERROR", "Enter Integer Value." );
      goto PIX_EXIT;
   } 
   
   // get and show statistics when new frame is selected?
   
   GetBool( &pEnv->_ImageStatActiveFrame, ui->image_active_stat_check ); 

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// set texture style mode
//
void props_page_image::SetTextureFilter( void )
{   
   pixq_Properties *pEnv = GetEnv( );
   int iTexFilter;

   ui->FilterNearestRadio->setChecked( false );
   ui->FilterLinearRadio->setChecked( false );

   // texture style
   iTexFilter = pEnv->_ImageTextureFilter.iGet( );

   switch( iTexFilter ) {
   case pixq_Properties::TextureFilterNearest:
      ui->FilterNearestRadio->setChecked( true );
      break;
   case pixq_Properties::TextureFilterLinear:
      ui->FilterLinearRadio->setChecked( true );
      break;
   }
   
   return;
}

void props_page_image::on_FilterNearestRadio_clicked(bool checked)
{
    pixq_Properties *pEnv = GetEnv( );

    if( checked ) {
       pEnv->_ImageTextureFilter.Set( pixq_Properties::TextureFilterNearest );
    }

    SetTextureFilter( );

    return;

}

void props_page_image::on_FilterLinearRadio_clicked(bool checked)
{
    pixq_Properties *pEnv = GetEnv( );

    if( checked ) {
       pEnv->_ImageTextureFilter.Set( pixq_Properties::TextureFilterLinear );
    }

    SetTextureFilter( );

    return;
}
