#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "pixq_options_page.h"
#include "props_page_playback.h"
#include "ui_props_page_playback.h"

props_page_playback::props_page_playback(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::props_page_playback)
{
    ui->setupUi(this);
    
    _sPageId = (short)pixq_EnvItem::ItemCategoryPlayback;
}

props_page_playback::~props_page_playback()
{
    delete ui;
}

void props_page_playback::closeEvent(QCloseEvent * /* event */ )
{
   Check( );

   return;
}

//
// set current data
//
void props_page_playback::SetData( void )
{   
   pixq_Properties *pEnv = GetEnv( );
   bool bValue;
   int iValue;
   QString strValue;
   QColor colValue;

   // *** set current data ***

   // target frame rate

   // sampling frame number to measure frame rate

   // sleep milliseconds after each frame, manually set to fixed value

   // use fixed sleep time? instead of statically optimized sleep time?

   // tolerance for difference between real frame rate and target 
   
   // *** 2 ***

   // show wiper/box as line

   bValue = pEnv->_PlaybackDrawWiperLine.GetBool( );
   ui->DrawWipeBoxDrawCheck->setCheckState( bValue ? Qt::Checked : Qt::Unchecked );

   // wiper/box color

   SetWiperLineColor( );

   // box(scope) radius, pixels on screen

   iValue = pEnv->_PlaybackBoxRadius.iGet( );  
   strValue.sprintf( "%d", iValue );
   ui->PlaybackBoxRadiusEdit->setText( strValue ); 

   // *** 3 ***

   // number of pixels at the edge, top/bottom
   iValue = pEnv->_PlaybackEdgePixelsTop.iGet( );   
   strValue.sprintf( "%d", iValue );
   ui->PlaybackEdgePixelsTopEdit->setText( strValue );  

   // number of pixels at the edge, left/right
   iValue = pEnv->_PlaybackEdgePixelsLeft.iGet( );   
   strValue.sprintf( "%d", iValue );
   ui->PlaybackEdgePixelsLeftEdit->setText( strValue );  
   
   // --- Done ---
   return;
}
   
bool props_page_playback::Check( void )
{  
   bool bRetCode = false;
   pixq_Properties *pEnv = GetEnv( );
   bool bOK;
   bool bValue;
   int iValue;
   QString strValue;
   Qt::CheckState cs;
   
   // *** set current data ***

   // target frame rate


   // number of frame to get statistics


   // sleep milliseconds after each frame, manually set to fixed value


   // use fixed sleep time? instead of statically optimized sleep time?


   // tolerance for difference between real frame rate and target 
 

   // *** 2 ***

   // show wiper/box as line

   cs = ui->DrawWipeBoxDrawCheck->checkState( );
   bValue = ( Qt::Checked == cs ) ? true : false;
   pEnv->_PlaybackDrawWiperLine.Set( bValue );

   // wiper/box color

   // already set by button

   // box(scope) radius, pixels on screen
   
   strValue = ui->PlaybackBoxRadiusEdit->text( );
   iValue = strValue.toInt( &bOK );
   if( !bOK ) goto PIX_EXIT;
   pEnv->_PlaybackBoxRadius.Set( iValue );  

   // *** 3 ***

   // number of pixels at the edge, top/bottom
   
   strValue = ui->PlaybackEdgePixelsTopEdit->text( );
   iValue = strValue.toInt( &bOK );
   if( !bOK ) goto PIX_EXIT;
   pEnv->_PlaybackEdgePixelsTop.Set( iValue );  

   // number of pixels at the edge, left/right
   
   strValue = ui->PlaybackEdgePixelsLeftEdit->text( );
   iValue = strValue.toInt( &bOK );
   if( !bOK ) goto PIX_EXIT;
   pEnv->_PlaybackEdgePixelsLeft.Set( iValue );  

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

void props_page_playback::SetWiperLineColor( void )
{
   pixq_Properties *pEnv = GetEnv( );
   QColor colValue = pEnv->_PlaybackWiperLineColor.colGet( );
   
   ui->WiperBoxColorLabel->setText( colValue.name());
   ui->WiperBoxColorLabel->setPalette( QPalette( colValue ) );
   ui->WiperBoxColorLabel->setAutoFillBackground( true );

   return;
}

void props_page_playback::on_WiperBoxColorButton_clicked()
{
   pixq_Properties *pEnv = GetEnv( );
   int iRet;
   QColorDialog dlg;
   QColor colValue = pEnv->_PlaybackWiperLineColor.colGet( );
   
   dlg.setCurrentColor( colValue );

   iRet = dlg.exec( );
   if( QDialog::Accepted != iRet ) {
      goto PIX_EXIT;
   }

   colValue = dlg.currentColor( );
   pEnv->_PlaybackWiperLineColor.Set( colValue );

   SetWiperLineColor( );

PIX_EXIT:
   return;
}
