#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "pixq_options_page.h"
#include "props_page_system.h"
#include "ui_props_page_system.h"

props_page_system::props_page_system(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::props_page_system)
{
    ui->setupUi(this);
    
    _sPageId = (short)pixq_EnvItem::ItemCategorySystem;
}

props_page_system::~props_page_system()
{
    delete ui;
}

void props_page_system::closeEvent(QCloseEvent * /* event */ )
{
   Check( );

   return;
}

//
// set current data
//

void props_page_system::SetData( void )
{   
   pixq_Properties *pEnv = GetEnv( );
   QString strValue;

   // *** set current data ***
      
   // use disk cache for playback
   SetBool( &pEnv->_SystemUseDiskCache, ui->system_use_cuda_check ); 

   // use CUDA program if applicable?   
   
   SetBool( &pEnv->_SystemUseCuda, ui->system_use_cuda_check ); 
      
   // screen number to use for dual view configuration, 0(left) or 1(right)
   
   SetMonitorPosition( );

   // Type of 3D-TV, must be one of TypeOfThreeDimensionalTV;

   Set3dtvFormat( );

   // directory to store all dmr sampler batch files
   
   SetString( &pEnv->_SystemSamplerBatchPath, ui->system_sampler_batch_path_edit ); 

   // report processing time after image processing?

   SetBool( &pEnv->_SystemSamplerReportTime, ui->system_sampler_reportTime_check ); 
   
   // show detailed message in DMR2Sampler?
   
   SetBool( &pEnv->_SystemSamplerDetailMsg, ui->system_sampler_detail_message_check ); 
     
   // --- Done ---
   return;
}
   
bool props_page_system::Check( void )
{  
   bool bRetCode = false;
   pixq_Properties *pEnv = GetEnv( );
   QString strValue;
      
   // use disk cache for playback

   GetBool( &pEnv->_SystemUseDiskCache, ui->system_use_cuda_check ); 

   // use CUDA program if applicable?

   GetBool( &pEnv->_SystemUseCuda, ui->system_use_cuda_check );

   // screen number to use for dual view configuration, 0(left) or 1(right)
   // done

   // directory to store all dmr sampler batch files
   
   GetString( &pEnv->_SystemSamplerBatchPath, ui->system_sampler_batch_path_edit ); 

   // report processing time after image processing?

   GetBool( &pEnv->_SystemSamplerReportTime, ui->system_sampler_reportTime_check ); 

   // show detailed message in DMR2Sampler?
   
   GetBool( &pEnv->_SystemSamplerDetailMsg, ui->system_sampler_detail_message_check ); 

   // --- Done ---
   bRetCode = true;
//PIX_EXIT:
   return bRetCode;
}

void props_page_system::on_system_sampler_batch_path_button_clicked()
{
   QFileDialog dlg( this );
   int nSize;
   QString  strDir;
   QStringList fileNames;
   
   dlg.setFileMode( QFileDialog::Directory );
   dlg.setOption( QFileDialog::ShowDirsOnly );

   dlg.setAcceptMode( QFileDialog::AcceptOpen );
   dlg.setLabelText( QFileDialog::LookIn, tr("Select Batch Directory") );

   if( QDialog::Accepted != dlg.exec( ) ) {
      goto PIX_EXIT;
   }

   fileNames = dlg.selectedFiles( );
   nSize = fileNames.size( );
   if( 1 > nSize ) {
      goto PIX_EXIT;
   }

   strDir = fileNames.at( 0 );
   ui->system_sampler_batch_path_edit->setText( strDir );
   
   // --- Done ---
PIX_EXIT:
   return;
}

void props_page_system::SetMonitorPosition( void )
{   
   pixq_Properties *pEnv = GetEnv( );
   int iSide;

   ui->system_fullscreen_side_left_radio->setChecked( false );
   ui->system_fullscreen_side_right_radio->setChecked( false );

   iSide = pEnv->_SystemMonitorPosition.iGet( );

   switch( iSide ) {
   case 0:
      ui->system_fullscreen_side_left_radio->setChecked( true );
      break;
   case 1:
      ui->system_fullscreen_side_right_radio->setChecked( true );
      break;
   }
   
   return;
}

void props_page_system::on_system_fullscreen_side_left_radio_clicked(bool checked)
{
   pixq_Properties *pEnv = GetEnv( );
   int iSide = 0;

   if( checked ) {
      pEnv->_SystemMonitorPosition.Set( iSide );
   }
   
   SetMonitorPosition( );

   return;
}

void props_page_system::on_system_fullscreen_side_right_radio_clicked(bool checked)
{
   pixq_Properties *pEnv = GetEnv( );
   int iSide = 1;
   
   if( checked ) {
      pEnv->_SystemMonitorPosition.Set( iSide );
   }
   
   SetMonitorPosition( );

   return;
}

void props_page_system::on_system_3dtv_side_by_side_radio_clicked(bool checked)
{
   pixq_Properties *pEnv = GetEnv( );
   int iFormat = pixq_Properties::TV3DTypeSplitSideBySide;
   
   if( checked ) {
      pEnv->_System3DPictureFormat.Set( iFormat );
   }
   
   Set3dtvFormat( );

   return;
}

void props_page_system::on_system_3dtv_top_bottom_radio_clicked(bool checked)
{
   pixq_Properties *pEnv = GetEnv( );
   int iFormat = pixq_Properties::TV3DTypeSplitTopAndBottom;
   
   if( checked ) {
      pEnv->_System3DPictureFormat.Set( iFormat );
   }
   
   Set3dtvFormat( );

   return;
}

void props_page_system::on_system_3dtv_dlp_radio_clicked(bool checked)
{
   pixq_Properties *pEnv = GetEnv( );
   int iFormat = pixq_Properties::TV3DTypeDlpCheckeredFlag;
   
   if( checked ) {
      pEnv->_System3DPictureFormat.Set( iFormat );
   }
   
   Set3dtvFormat( );

   return;
}

void props_page_system::on_system_3dtv_opengl_quadbuffer_radio_clicked(bool checked)
{
   pixq_Properties *pEnv = GetEnv( );
   int iFormat = pixq_Properties::TV3DTypeOpenGLQuadBuffer;
   
   if( checked ) {
      pEnv->_System3DPictureFormat.Set( iFormat );
   }
   
   Set3dtvFormat( );

   return;
}

void props_page_system::Set3dtvFormat( void )
{   
   pixq_Properties *pEnv = GetEnv( );
   int iFormat;

   ui->system_3dtv_opengl_quadbuffer_radio->setChecked( false );
   ui->system_3dtv_dlp_radio->setChecked( false );
   ui->system_3dtv_side_by_side_radio->setChecked( false );
   ui->system_3dtv_top_bottom_radio->setChecked( false );

   iFormat = pEnv->_System3DPictureFormat.iGet( );

   switch( iFormat ) {
   case pixq_Properties::TV3DTypeOpenGLQuadBuffer:
      ui->system_3dtv_opengl_quadbuffer_radio->setChecked( true );
      break;

   case pixq_Properties::TV3DTypeDlpCheckeredFlag:
      ui->system_3dtv_dlp_radio->setChecked( true );
      break;

   case pixq_Properties::TV3DTypeSplitSideBySide:
      ui->system_3dtv_side_by_side_radio->setChecked( true );
      break;

   case pixq_Properties::TV3DTypeSplitTopAndBottom:
      ui->system_3dtv_top_bottom_radio->setChecked( true );
      break;
   }
   
   return;
}