#include <QtGui>
#include <QDesktopServices>
#include <QUrl>

#include "website_label_widget.h"

website_label_widget::website_label_widget(QWidget *parent)
    : QLabel(parent)
{
   _defCursor = cursor( );
}

void website_label_widget::mousePressEvent( QMouseEvent * event ) 
{
   Q_UNUSED(event);

   QString strUrl = text( );
   QString strSite = "http://" + strUrl;

   QDesktopServices::openUrl( QUrl( strSite ) );

   return;
}

void website_label_widget::enterEvent ( QEvent * event )
{
   Q_UNUSED(event);

   _defCursor = cursor( );
   setCursor( Qt::PointingHandCursor );

   return;
}

void website_label_widget::leaveEvent ( QEvent * event ) 
{
   Q_UNUSED(event);

   setCursor( _defCursor );

   return;
}