#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "bagster_common.h"
#include "bagster_window.h"
#include "bagster_calendar_widget.h"

bagster_calendar_widget::bagster_calendar_widget(QWidget *parent)
   : QCalendarWidget(parent)
{
   setVerticalHeaderFormat( QCalendarWidget::NoVerticalHeader );
   setHorizontalHeaderFormat( QCalendarWidget::ShortDayNames );

   connect(this, SIGNAL(clicked(QDate)), this, SLOT(showMessage(QDate)));

   return;
}

void bagster_calendar_widget::SelectTodayCalendar( void )
{
   QDate current;
   QDate date;
   int iMonth = _pWindow->GetCurrentMonth( );
   int iDay = _pWindow->GetCurrentDay( );

   current = QDate::currentDate( );  
   int iYear = current.year( );

   date.setDate( iYear, iMonth, iDay );
   setSelectedDate( date );

   return;
}

void bagster_calendar_widget::showMessage(QDate	date)
{
   int iMonth = date.month( );
   int iDay = date.day( );

   _pWindow->SetCurrentMonth( iMonth );
   _pWindow->SetCurrentDay( iDay );
   _pWindow->ShowDaysWords( );

   return;
}
