#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "bagster_common.h"
#include "bagster_window.h"

#include "bagster_calendar_widget.h"
#include "bagster_ctrl.h"

BagsterCtrl::BagsterCtrl(QWidget *parent)
    : QWidget(parent)
{
    ui.setupUi(this);
    
    connect( ui.bagster_occasions, SIGNAL(currentRowChanged(int)), this,
       SLOT(occasionChanged(int)));

    connect( ui.bagster_occasions, SIGNAL(itemClicked(QListWidgetItem*)), this,
       SLOT(occasionClicked(QListWidgetItem*)));

    return;
} 

void BagsterCtrl::occasionChanged(int row)
{
   BagsterWindow *pMain = GetParent( );

   pMain->SetOccasionWords( row );

   return;    
}

void BagsterCtrl::occasionClicked(QListWidgetItem * /* item */ )
{
   BagsterWindow *pMain = GetParent( );
   int iRow = ui.bagster_occasions->currentRow( );

   pMain->SetOccasionWords( iRow );

   return;    
}

void BagsterCtrl::SetParent( BagsterWindow *pParent )
{
   _pParent = pParent;

   ui.bagster_calendar->SetWindow( pParent );
   ui.bagster_calendar->SetCtrl( this );

   return;
}

void BagsterCtrl::SelectTodayCalendar( void )
{
   ui.bagster_calendar->SelectTodayCalendar( );

   return;
}

void BagsterCtrl::SetOccasionsList( void )
{   
   BagsterWindow *pMain = GetParent( );
   pixq_Properties *pEnv = pMain->GetDailyEnv( );
   bool bJapanese = pEnv->BagsterBibleVersionJapanese( );

   QStringList strOccasions;
   QStringList strEnOccasions;

   if( !pMain->MakeCccasionsList( strOccasions, strEnOccasions ) ) {
      goto PIXEXIT;
   }

   if( bJapanese ) {
      ui.bagster_occasions->SetOccasionsList( strOccasions );
   } else {
      ui.bagster_occasions->SetOccasionsList( strEnOccasions );

   }

PIXEXIT:
   return;
}