#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "bagster_common.h"
#include "bagster_window.h"
#include "bagster_header_label.h"

bagster_header_label::bagster_header_label(QWidget *parent) :
    QWidget(parent) 
{
   setMinimumHeight( 25 );
   setMaximumHeight( 25 );
}

void bagster_header_label::paintEvent(QPaintEvent * /* event */)
{
   pixq_Properties *pEnv = _pParent->GetDailyEnv( );
   QString strHeader = _pParent->GetHeaderLabel( );

   QFont fn = pEnv->_BagsterHeaderFont.lfGet( );
   QColor fn_color = pEnv->_BagsterHeaderFgColor.colGet( );
   QColor bg0_color = pEnv->_BagsterHeaderBg0Color.colGet( );
   QColor bg1_color = pEnv->_BagsterHeaderBg1Color.colGet( );

   QRect rect = QRect( 0, 0, width(), height() );

   QPainter painter( this );
            
   QLinearGradient linearGradient( rect.topLeft(), rect.bottomLeft() );
   linearGradient.setColorAt( 0.0, bg0_color );
   linearGradient.setColorAt( 1.0, bg1_color );
   painter.setBrush( linearGradient );

   //painter.setRenderHint(QPainter::Antialiasing, false);
   painter.setPen( palette().dark().color() );
   //painter.setBrush( Qt::NoBrush );
   painter.drawRect( rect );

   // sewt header label

   //setFont( fn );
   painter.setPen( fn_color );
   painter.setFont( fn );
   painter.drawText( rect, Qt::AlignCenter, strHeader );

   // done!
   painter.end( );

   return;
}