#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "bagster_common.h"

#include "bagster_view.h"
#include "bagster_ctrl.h"
#include "bagster_calendar_widget.h"
#include "bagster_header_label.h"

#include "bagster_window.h"
#include "ui_bagster_window.h"

QString BagsterWindow::_strOrganisation = "PixTopo";
QString BagsterWindow::_strApplication = "Bagster";

BagsterWindow::BagsterWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::BagsterWindow)
{
   int k, iKanshSec;
   QIcon icon;

   // TEST

//qDebug( "Entered BagsterWindow::BagsterWindow\n" );

   QTextCodec::setCodecForCStrings(QTextCodec::codecForLocale());

   ui->setupUi(this);    
    
   _Splitter = new QSplitter( Qt::Vertical );

   // properties

   _DailyEnv = new pixq_Properties;
   _DailyEnv->InitEnv( _strOrganisation, _strApplication );

   // GUI

   _strHeaderLabel = "********";

   _Header = new bagster_header_label( this );
   _Header->SetParent( this );;

   _WebView = new BagsterView( this );
   _WebView->SetParent( this );
   
   // create control panel

   _Control = new BagsterCtrl;
   _Control->SetParent( this );

   _Splitter->addWidget( _Header );
   _Splitter->addWidget( _WebView );
   _Splitter->addWidget( _Control );

   _Splitter->setStretchFactor( 0, 0 );
   _Splitter->setStretchFactor( 1, 1 );

   _Splitter->setCollapsible( 0, false );
   _Splitter->setCollapsible( 1, false );
   _Splitter->setCollapsible( 2, true );

   // create status bar

   for( k = 0 ; k < 3 ; k++ ) {
      _statusLabel[k] = new QLabel( "Daily Light", this );
      _statusLabel[k]->setFrameStyle( QFrame::Sunken );
      _statusLabel[k]->setFrameShape( QFrame::Panel );
   }

   statusBar()->addPermanentWidget( _statusLabel[0], 1 );
   statusBar()->addPermanentWidget( _statusLabel[1], 1 );
   statusBar()->addPermanentWidget( _statusLabel[2], 1 );

   // *** tray icon ***

   createTrayIcon();

   // *** create meanu and actions

   setCentralWidget( _Splitter );

   setWindowTitle( _strApplication );

   CreateToolBars( );

   // window̃ACR
   // JPEG, PNG, GIF
   // SVG s

   //icon = QIcon( ":/images/cross-64x64.png" );
   icon = QIcon( ":/images/ehagaki2x.png" );
   setWindowIcon( icon );

   _trayIcon->setIcon( icon );
   _trayIcon->setToolTip( _strApplication );
   _trayIcon->show( );

   // set occasions

   _Control->SetOccasionsList( );

   // restore last window gometry

   readSettings( );
   
   // start timer

   _iBagsterTimerId = -1; 
   
   InitCurrentDay( );

   _LastCheckedTime = QDateTime::currentDateTime( );
   _bShownAmToday = false;
   _bShownPmToday = false;

   iKanshSec = 60 * 1000; // 1~bɕϊ  
   
   _iBagsterTimerId = startTimer( iKanshSec ); 

   // 
   
   SetDisplayContents( ShowingDailyLightsDaily );
   SetTodaysWords( );

   ShowBagsterContents( );  

   //

   return;
}

BagsterWindow::~BagsterWindow()
{
   delete ui;
    
   if( NULL != _DailyEnv ) {
      delete _DailyEnv;
      _DailyEnv = NULL;
   }

   return;
}

void BagsterWindow::CreateToolBars( void )
{
   // main tool bar

   ui->mainToolBar->addAction( ui->action_file_todays_words );
   ui->mainToolBar->addAction( ui->action_file_options );
   //ui->mainToolBar->addAction( ui->action_file_close );

   //ui->mainToolBar->addSeparator( );

   ui->mainToolBar->addAction( ui->action_view_previous_words );
   ui->mainToolBar->addAction( ui->action_view_next_words );
   ui->mainToolBar->addAction( ui->action_view_close_control );

   return;
}

void BagsterWindow::iconActivated(QSystemTrayIcon::ActivationReason reason)
{
   switch (reason) {
   case QSystemTrayIcon::Trigger:
      break;

   case QSystemTrayIcon::DoubleClick:
      show( );
      break; 

   case QSystemTrayIcon::MiddleClick:
      break;
   default:
      break;
   }

   return;
}

//
// make icons and set up menu in the system tray icon
//
void BagsterWindow::createTrayIcon( void )
{
   // *** action from tray icon menu ***

   _trayRestoreAction = new QAction( tr("\"), this );
   connect( _trayRestoreAction, SIGNAL(triggered()), this, SLOT( show( ) ) );

   _trayQuitAction = new QAction( tr("I"), this );
   connect( _trayQuitAction, SIGNAL(triggered()), qApp, SLOT( quit( ) ) );

   // *** tray icon menu ***

   _trayIconMenu = new QMenu( this );
   _trayIconMenu->addAction( _trayRestoreAction );
   _trayIconMenu->addAction( _trayQuitAction );

   // *** tray icon menu ***

   _trayIcon = new QSystemTrayIcon( this );
   _trayIcon->setContextMenu( _trayIconMenu );
   
   _trayRestoreAction->setEnabled( true );
   _trayQuitAction->setEnabled( true );

   connect( _trayIcon, SIGNAL(activated(QSystemTrayIcon::ActivationReason)), this, 
      SLOT(iconActivated(QSystemTrayIcon::ActivationReason)));

   return;
}

void BagsterWindow::timerEvent( QTimerEvent *ev )
{
   if( _iBagsterTimerId == ev->timerId( ) ) { 
      CheckTimer( );
   } else {
      QObject::timerEvent( ev );
   }

   return;
}

void BagsterWindow::showEvent( QShowEvent * /* ev */ )
{
   return;
}

void BagsterWindow::closeEvent( QCloseEvent *ev )
{
   // just hide the window in the task tray
   // do not exit
   hide( );
   ev->ignore( );
  
   return;
}

void BagsterWindow::keyPressEvent(QKeyEvent *event)
{
   switch (event->key()) {
   case Qt::Key_Up:
      break;

   case Qt::Key_Down:
      break;

   case Qt::Key_Left:
      ShowPrevDay( );
      break;

   case Qt::Key_Right:
      ShowNextDay( );
      break;

   case Qt::Key_Plus:
      break;

   case Qt::Key_Minus:
      break;

   case Qt::Key_Space:
   case Qt::Key_Enter:
      break;

   default:
      break;
   }

   return;
}

//**********************************************************************
//**********************************************************************
//*** t@C *********************************************************
//**********************************************************************
//**********************************************************************

void BagsterWindow::on_action_file_todays_words_triggered()
{
   SetTodaysWords( );  

   ShowDaysWords( );

   return;
}

void BagsterWindow::on_action_file_options_triggered()
{
   pixq_Properties *pEnv = GetDailyEnv( );
   int iMode;

   iMode = EnvModeBagster;
   if( !ShowPixProperty_PC( _strOrganisation, _strApplication, pEnv, iMode ) ) {
      goto PIX_EXIT;
   }
   
   // store the changed env

   pEnv->SetRegEnv( _strOrganisation, _strApplication );

   ShowDaysWords( );

   _Control->SetOccasionsList( );

PIX_EXIT:
   return;
}

void BagsterWindow::on_action_file_close_triggered()
{
   close( );
   
   return;
}

void BagsterWindow::on_action_file_exit_triggered()
{
   writeSettings( );
   qApp->quit( );
   
   return;
}

//**********************************************************************
//**********************************************************************
//*** \ *************************************************************
//**********************************************************************
//**********************************************************************

void BagsterWindow::on_action_view_next_words_triggered()
{
   ShowNextDay( );

   return;
}

void BagsterWindow::on_action_view_previous_words_triggered()
{
   ShowPrevDay( );

   return;
}

void BagsterWindow::on_action_view_close_control_triggered()
{
   QList<int> list_sizes;
#ifdef _DEBUG
   QList<int> list_sizes2;
#endif
   int nPanes, nHeight[3];

   list_sizes = _Splitter->sizes();
   nPanes = (int)list_sizes.size( );
   nHeight[0] = list_sizes.at( 0 );
   nHeight[1] = list_sizes.at( 1 );
   nHeight[2] = list_sizes.at( 2 );

   if( 0 < nHeight[2] ) {

      // hide the calendar area
      
      // memorize the last height
      _iCtrlHeight = list_sizes.at( 2 );
   
      list_sizes.clear( );
      list_sizes.push_back( nHeight[0] );
      list_sizes.push_back( nHeight[1] + nHeight[2] );
      list_sizes.push_back( 0 );
   
   } else {
      // restore the calendar
      
      nHeight[0] = list_sizes.at( 0 );
      nHeight[1] = list_sizes.at( 1 ) - _iCtrlHeight;
      nHeight[2] = _iCtrlHeight;
    
      list_sizes.clear( );
      list_sizes.push_back( nHeight[0] );
      list_sizes.push_back( nHeight[1] );
      list_sizes.push_back( nHeight[2] );
   }
   
   _Splitter->setSizes( list_sizes );
   _Splitter->refresh( );

#ifdef _DEBUG
  list_sizes2 = _Splitter->sizes( );
   nHeight[0] = list_sizes2.at( 0 );
   nHeight[1] = list_sizes2.at( 1 );
   nHeight[2] = list_sizes2.at( 2 );
#endif

PIX_EXIT:
   return;
}

void BagsterWindow::on_action_view_calendar_triggered()
{

}

void BagsterWindow::on_action_view_special_occasions_triggered()
{

}

//**********************************************************************
//**********************************************************************
//*** wv ***********************************************************
//**********************************************************************
//**********************************************************************

void BagsterWindow::on_action_help_about_bagster_triggered()
{

    pixq_Version ver = Version( _strApplication );
    ShowPixAbout_PC( &ver );

    return;
}

void BagsterWindow::on_action_help_usage_bagster_triggered()
{
    QString strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );
    //strPath.append( "/manual/index.htm\0" );

    QString strFile = "file:///";
    strFile.append( strPath );
    strFile.append( "/index.pdf\0" );

    QDesktopServices::openUrl( QUrl( strFile ) );

    return;
}
