// 
// *** MainWindow ***
//

#pragma once

#include <QtCore>
#include <QtGui>
#include <QApplication>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

QT_BEGIN_NAMESPACE
class QWebView;
class QLabel;
QT_END_NAMESPACE

class BagsterView;
class BagsterCtrl;

class bagster_header_label;

namespace Ui {
    class BagsterWindow;
}

class BagsterWindow : public QMainWindow
{
    Q_OBJECT

public:
   enum {
      ShowingDailyLightsDaily = 0,
      ShowingDailyLightsOccasions,
   } ShowingContents;

public:
   static QString _strOrganisation;
   static QString _strApplication;

public:
    explicit BagsterWindow(QWidget *parent = 0);
    ~BagsterWindow();

private:
    Ui::BagsterWindow *ui;

    QString _strHeaderLabel;

    // \e
    // ShowingContentŝǂꂩ
    short _sDisplayContents;

public:
   short sGetDisplayContents( void ) { return _sDisplayContents; }
   void SetDisplayContents( short sContents ) { _sDisplayContents = sContents; }

private slots:
    void on_action_file_exit_triggered();
    void on_action_file_close_triggered();
    void on_action_file_options_triggered();
    void on_action_file_todays_words_triggered();

    void on_action_view_close_control_triggered();
    void on_action_view_previous_words_triggered();
    void on_action_view_next_words_triggered();
    void on_action_view_calendar_triggered();
    void on_action_view_special_occasions_triggered();

    void on_action_help_about_bagster_triggered();
    void on_action_help_usage_bagster_triggered();

    void iconActivated(QSystemTrayIcon::ActivationReason reason);

protected:
   void closeEvent(QCloseEvent *event);   
   void timerEvent(QTimerEvent *e);
   void keyPressEvent(QKeyEvent *event);
    void showEvent(QShowEvent *event);

public:
   bool MakeCccasionsList( QStringList &strOccasions, 
      QStringList &strEnOccasions );

private:
   void readSettings( void );
   void writeSettings( void );

   void CreateToolBars( void );

public:
   void ShowNextDay( void );
   void ShowPrevDay( void );

   void CheckTimer( void );

   QString GetHeaderLabel( void ) { return _strHeaderLabel; }

private:
   QSplitter *_Splitter;
   
   bagster_header_label *_Header;

   BagsterView *_WebView;

   BagsterCtrl *_Control;

   int _iCtrlHeight;

   // status bar
   QLabel *_statusLabel[3];

private:
   int _iCurrentMonth;
   int _iCurrentDay;
   bool _bCurrentAm;

   int _iCurrentOccasion;

   pixq_Properties *_DailyEnv;

   // timer
   int _iBagsterTimerId;

   // last time hikari was shown by timer
   QDateTime _LastCheckedTime;
   bool _bShownAmToday;
   bool _bShownPmToday;

   // *** tray icon ***

private:
   QSystemTrayIcon *_trayIcon;
   QMenu *_trayIconMenu;

   QAction *_trayRestoreAction;
   QAction *_trayQuitAction;

   void createTrayIcon( );

public:
   //
   // utlity functions
   //

   void ShowBagsterContents( void );
   void SetTodaysWords( void );
   void ShowDaysWords( void );
   
   void ShowCurrentOccasion( void );
   void SetOccasionWords( int iOccasion );

   bool GetDaysWords( QFile *file,
      int iMonth, 
      int iDay, 
      bool bAm, 
      QStringList *strLines );

   bool GetDaysWords( int iMonth,
      int iDay, 
      bool bAm, 
      QStringList *strLines );

   bool GetOccasionWords( QFile *file,
      int iOccasion, 
      QStringList *strLines );

   bool GetOccasionWords( int iOccasion, 
      QStringList *strLines );

   bool bFindAllEntries( int nEntries,
                            int iVersion,
                            QString &strLines,
                            BibleAllBooks &bl,
                            QXmlStreamReader &reader );

   QString SetDateLabel( int iMonth, int iDay, bool bAm );

   bool bSetBagsterDaysWords( QStringList *vstrLines );

   bool bSetBagsterDaysWords( QStringList *vstrLines,
      QString *strLines );

   void AddHtml( QStringList *vstrHtml, QString strLine );

   void SetHtmlTemplate( QStringList *vstrHtml );
 
public:
   //
   // data
   //
   int GetCurrentMonth( void ) { return _iCurrentMonth; }
   int GetCurrentDay( void ) { return _iCurrentDay; }
   bool GetCurrentAm( void ) { return _bCurrentAm; }

   void SetCurrentMonth( int iMonth ) { _iCurrentMonth = iMonth; }
   void SetCurrentDay( int iDay ) { _iCurrentDay = iDay; }
   void SetCurrentAm( bool bAm ) { _bCurrentAm = bAm; }

   void InitCurrentDay( void ) {
      _iCurrentMonth = -1;
      _iCurrentDay = -1;
      _bCurrentAm = true;
      //
      _iCurrentOccasion = -1;
   }

   pixq_Properties *GetDailyEnv( void ) { return _DailyEnv; }

};

