#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "bagster_common.h"

#include "bagster_view.h"
#include "bagster_ctrl.h"
#include "bagster_calendar_widget.h"
#include "bagster_window.h"

//
// template html
//

void BagsterWindow::AddHtml( QStringList *vstrHtml,
                           QString strLine )
{
   vstrHtml->push_back( strLine );
}

/***********************************************************************

http://www.htmq.com/style/font-size.shtml

font-sizevpeB́AtHg̃TCYw肷ۂɎgp܂B 

l

[1]lŎw
lpxemexȂǂ̒PʂĎw肵܂B
pxƂ1sNZ1ƂPʂŁAۂɕ\TCY72dpi96dpi
j^̉𑜓xɂω܂B
emƂ̓tHg̍1ƂPʂłB
exƂ͏̢x̍1ƂPʂłB
lɂ͕̒l͎wł܂B

[2]Ŏw
lŎw肵܂B

[3]L[[hŎw
xx-smallAx-smallAsmallAmediumAlargeAx-largeAxx-large7iKA
mediumWTCYłB
1iKオ1.2{̃TCYɂȂ܂B
smallerAlargerw肷Ƒ傫1iK㉺܂B

gp
X^CV[g͊Ot@Cisample.cssjɋLqB
span.sample1 {font-size: 12px; }
span.sample2 {font-size: 12em; }
span.sample3 {font-size: 12ex; }
span.sample4 {font-size: 80%; }
span.sample5 {font-size: 100%; }
span.sample6 {font-size: 120%; }
span.sample7 {font-size: xx-small; }
span.sample8 {font-size: x-small; }
span.sample9 {font-size: small; }
span.sample10 {font-size: medium; }
span.sample11 {font-size: large; }
span.sample12 {font-size: x-large; }
span.sample13 {font-size: xx-large; }

HTML\[X
<html>
<head>
<link rel="stylesheet" href="sample.css" type="text/css">
</head>
<body>
<span class="sample1">̑傫12px</span><br>
<span class="sample2">̑傫12em</span><br>
<span class="sample3">̑傫12ex</span><br>
<span class="sample4">̑傫80%</span><br>
<span class="sample5">̑傫100%</span><br>
<span class="sample6">̑傫120%</span><br>
<span class="sample7">̑傫xx-small</span><br>
<span class="sample8">̑傫x-small</span><br>
<span class="sample9">̑傫small</span><br>
<span class="sample10">̑傫medium</span><br>
<span class="sample11">̑傫large</span><br>
<span class="sample12">̑傫x-large</span><br>
<span class="sample13">̑傫xx-large</span>
</body>
</html> 

***********************************************************************/

void BagsterWindow::SetHtmlTemplate( QStringList *vstrHtml )
{
   pixq_Properties *pEnv = GetDailyEnv( );
   
   QColor rgb = pEnv->_BagsterBgColor.colGet( );
   int iRed = rgb.red( );
   int iGreen = rgb.green( );
   int iBlue = rgb.blue( );
   QString str_bg_color, str_line;
   int iLineHeight = pEnv->_BagsterLineHeight.iGet( );

   QFont jp_fn = pEnv->_BagsterJapaneseFont.lfGet( );
   QFont en_fn = pEnv->_BagsterEnglishFont.lfGet( );
   bool bJapanese = pEnv->BagsterBibleVersionJapanese( );

   QString strLang;
   QString strName;
   int iPointSize;

   if( bJapanese ) {
      strLang = "ja-JP";
      strName = jp_fn.rawName( );
      iPointSize = jp_fn.pointSize( );
   } else {
      strLang = "en-US";
      strName = en_fn.rawName( );
      iPointSize = en_fn.pointSize( );
   }

   vstrHtml->clear( );

   AddHtml( vstrHtml, "<HTML>\0");
   AddHtml( vstrHtml, "<HEAD>\0");
   AddHtml( vstrHtml, "<META HTTP-EQUIV=\"CONTENT-TYPE\" CONTENT=\"text/html; charset=utf-16\">\0");
   AddHtml( vstrHtml, "<TITLE>Daily Light</TITLE>\0");
   AddHtml( vstrHtml, "<META HTTP-EQUIV=\"Content-Style-Type\" CONTENT=\"text/css\">\0");

   AddHtml( vstrHtml, "<STYLE TYPE=\"text/css\">\0");
   AddHtml( vstrHtml, "<!--\0");
   AddHtml( vstrHtml, "		A:link { text-decoration: none }\0");
   AddHtml( vstrHtml, "		A:visited { text-decoration: none }\0");  

   //
   // line height s
   //
   str_line.sprintf( "    table { line-height: %d% ; }\0", iLineHeight ); 
	AddHtml( vstrHtml, str_line );  

   AddHtml( vstrHtml, "	-->\0");
   AddHtml( vstrHtml, "</STYLE>\0");
   AddHtml( vstrHtml, "</HEAD>\0");

   //
   // background color
   //
   str_bg_color.sprintf( "\"%02x%02x%02x\"\0", iRed, iGreen, iBlue );
   str_line = "<BODY BGCOLOR=" + str_bg_color + " DIR=\"LTR\">\0";
   AddHtml( vstrHtml, str_line );
   
   AddHtml( vstrHtml, "<CENTER>\0");

   AddHtml( vstrHtml, "	<TABLE WIDTH=80%  CELLPADDING=3 CELLSPACING=1>\0");
  
   // *** table row TR
 /*
   AddHtml( vstrHtml, "<TR>\0");
   AddHtml( vstrHtml, "<TD WIDTH=100% >\0");

   str_line = "<P LANG=\"" + strLang + "\" ALIGN=CENTER>\0)";
   AddHtml( vstrHtml, str_line);
   AddHtml( vstrHtml, "</P>\0");

   AddHtml( vstrHtml, "</TD>\0");
   AddHtml( vstrHtml, "</TR>\0");
*/

   // language
   str_line = "<P LANG=\"" + strLang + "\" ALIGN=LEFT>\0";
   AddHtml( vstrHtml, str_line );

   AddHtml( vstrHtml, "<TR>\0");

   AddHtml( vstrHtml, "<TD WIDTH=100% BGCOLOR=\"#999999\">\0");

   //
   // sڂ̃tHg
   //
   AddHtml( vstrHtml, "<FONT COLOR=\"#ffffff\">\0");

   str_line = " <FONT FACE=\"" + strName + "\">\0"; 
   AddHtml( vstrHtml, str_line );

   str_line.sprintf( "<FONT SIZE=1 STYLE=\"font-size: %dpt\">\0", iPointSize );
   AddHtml( vstrHtml, str_line );

   //
   // s
   //

   AddHtml( vstrHtml, "<B>\0");
   AddHtml( vstrHtml, "__TOPLINE__\0");
   AddHtml( vstrHtml, "</B>\0");
   
   //
   // sڂ̃tHg/I
   //
   AddHtml( vstrHtml, "				</FONT>\0");
   AddHtml( vstrHtml, "				</FONT>\0");
   AddHtml( vstrHtml, "				</FONT>\0");

   AddHtml( vstrHtml, "			</TD>\0");
   AddHtml( vstrHtml, "		</TR>\0");

   AddHtml( vstrHtml, "		<TR>\0");
   AddHtml( vstrHtml, "			<TD WIDTH=100%>\0");

   //
   // *** 2sڈȍ~̃tHg ***
   //

   // color
   AddHtml( vstrHtml, "<FONT COLOR=\"#000000\">\0");

   // font name
   str_line = " <FONT FACE=\"" + strName + "\">\0"; 
   AddHtml( vstrHtml, str_line );

   // size
   str_line.sprintf( "<FONT SIZE=1 STYLE=\"font-size: %dpt\">\0", iPointSize );
   AddHtml( vstrHtml, str_line );
   
   //
   // *** 2sڈȍ~ ***
   //
   AddHtml( vstrHtml, "__LINE__\0");
   
   //
   // *** 2sڈȍ~̃tHg/I ***
   //
   AddHtml( vstrHtml, "				</FONT>\0");
   AddHtml( vstrHtml, "				</FONT>\0");
   AddHtml( vstrHtml, "				</FONT>\0");
   
   AddHtml( vstrHtml, "			</TD>\0");
   AddHtml( vstrHtml, "		</TR>\0");

   AddHtml( vstrHtml, "				</P>\0");

   AddHtml( vstrHtml, "	</TABLE>\0");
   AddHtml( vstrHtml, "</CENTER>\0");

   AddHtml( vstrHtml, "</BODY>\0");
   AddHtml( vstrHtml, "</HTML>\0");
                      
   return;            
}


QString BagsterWindow::SetDateLabel( int iMonth,
                                 int iDay,
                                 bool bAm )
{
   QString strBuffer;

   if( bAm ) {
      strBuffer.sprintf( "%d%d", iMonth, iDay );
   } else {
      strBuffer.sprintf( "%d%d[", iMonth, iDay );
   }

   return strBuffer;
}

//
// notes:
// template.html is embeded above
//
bool BagsterWindow::bSetBagsterDaysWords( QStringList *vstrLines, // [i] list of day's words
                                 QString *strLines ) // [o] html contents
{
   bool bRetCode = false;
   int i, nLines, nCount, iTmpLinePos, iLinePos;
   QString strMessage, strLine, strBuffer, strTodayFile, strData;
   QStringList vstrHtml;
   QStringList vstrInsert;

   QFile *file = NULL;
   QTextStream *out = NULL;

   QString strTopLinePos = "__TOPLINE__";
   QString strLinePos = "__LINE__";

   // get daily words file
   // get template html

   strTodayFile = GetTodaysHtmlFile_PC( );

   // open two files

   vstrHtml.clear( );
   SetHtmlTemplate( &vstrHtml );
  
   // find position to insert lines
      
   iTmpLinePos = -1;
   iLinePos = -1;
   nCount = (int)vstrHtml.size( );
   for( i = 0 ; i < nCount ; i++ ) {
      strBuffer = vstrHtml.at( i );
      if( 0 <= strBuffer.indexOf( strTopLinePos, 0 ) ) {
         iTmpLinePos = i;
      }
      if( 0 <= strBuffer.indexOf( strLinePos, 0 ) ) {
         iLinePos = i;
      }
   }

   if( 0 > iTmpLinePos ) {
      // template.htmlُ̈
      goto PIX_EXIT;
   }
   
   if( 0 > iLinePos ) {
      // template.htmlُ̈
      goto PIX_EXIT;
   }

   // set todays words

   nLines = (int)vstrLines->size( );
   vstrInsert.clear( );

   for( i = 0 ; i < nLines ; i++ ) {
      strData = vstrLines->at( i );
      if( 0 == i ) {
         vstrHtml.erase( vstrHtml.begin( ) + iTmpLinePos );
         vstrHtml.insert( iTmpLinePos, strData );
      } else {
         //vstrInsert.push_back( tr("<div STYLE=\"line-height: 160%\">") );
         vstrInsert.push_back( strData );
         //vstrInsert.push_back( tr("</div>") );
         if( i < nLines-1 ) {
            vstrInsert.push_back( tr("<BR>") );
            vstrInsert.push_back( tr("<BR>") );
         }
      }
   }

   vstrHtml.erase( vstrHtml.begin( ) + iLinePos );
   nLines = (int)vstrInsert.size( );
   for( i = 0 ; i < nLines ; i++ ) {
      strData = vstrInsert.at( i );
      vstrHtml.insert( vstrHtml.begin( ) + iLinePos + i, strData );
   }

   //

   if( !CreateFolder_PC( strTodayFile ) ) {
      strMessage = "ERROR! Failed to Create Temporary Path:\n" + strTodayFile;
      QMessageBox::critical( NULL, _strApplication, strMessage );
      goto PIX_EXIT;
   }

   file = new QFile( strTodayFile );
   if ( !file->open( QIODevice::WriteOnly | QIODevice::Text ) ) {
      strMessage = "ERROR! Failed to Create Temporary File:\n" + strTodayFile;
      QMessageBox::critical( NULL, _strApplication, strMessage );
      goto PIX_EXIT;
   }

   out = new QTextStream( file );
   out->setCodec( "UTF-16" );
   out->setGenerateByteOrderMark( true );

   //
   strLines->clear( );

   nCount = (int)vstrHtml.size( );
   for( i = 0 ; i < nCount ; i++ ) {
      strBuffer = vstrHtml.at( i );
      *out << strBuffer << endl;
      //
      strLines->push_back( strBuffer );
      strLines->push_back( " " );
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}


bool BagsterWindow::bSetBagsterDaysWords( QStringList *vstrLines )
{
   bool bRetCode = false;
   QString strLines;

   if( !bSetBagsterDaysWords( vstrLines, &strLines ) ) {
      goto PIX_EXIT;
   }
   
   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   strLines.clear( );
   return bRetCode;
}

//
// get todays words in string list
//
bool BagsterWindow::GetDaysWords( int iMonth,
                                    int iDay, 
                                    bool bAm,
                                    QStringList *strLines )
{
   bool bRetCode = false;
   QString strError, strDate, strDailyFile;
   pixq_Properties *pEnv = GetDailyEnv( );
   
   QFile *file = NULL;

   //_tsetlocale( LC_ALL, _T("Japanese_Japan.932"));

   strDailyFile = GetBagsterDailyWordsFile_PC( pEnv );

   file = new QFile( strDailyFile );
   if ( !file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      strError = "ERROR! Failed to open file " + strDailyFile + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   if( !GetDaysWords( file, iMonth, iDay,  bAm, strLines ) ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}

