#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "bagster_common.h"

#include "bagster_view.h"
#include "bagster_ctrl.h"
#include "bagster_calendar_widget.h"
#include "bagster_header_label.h"
#include "bagster_window.h"


static bool FindMonth( int iMonth, 
                       QXmlStreamReader &reader ) // [i/o] 
{
   bool bRetCode = false;
   bool bFound, bStatus, bOK;
   int iValue;
   QString strName, strValue;
   QXmlStreamAttributes attr;
   
   bStatus = true;
   bFound = false;
   while( bStatus ) {

      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }
   
      // find the month
   
      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }
   
      strName = reader.name().toString( );
   
      if( "Month" != strName ) {
         continue;
      }

      attr = reader.attributes();
      strValue = attr.value( "ID" ).toString();
      iValue = strValue.toInt( &bOK );
      if( !bOK ) {
         bStatus = false;
         continue;
      }
   
      if( iValue == iMonth ) {
         bStatus = false;
         bFound = true;
         continue;
      }

      reader.skipCurrentElement();
      
   }

   if( ! bFound ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

static bool FindDay( int iDay, 
                       QXmlStreamReader &reader ) // [i/o] 
{
   bool bRetCode = false;
   bool bFound, bStatus, bOK;
   int iValue;
   QString strName, strValue;
   QXmlStreamAttributes attr;
   
   bStatus = true;
   bFound = false;
   while( bStatus ) {
	
      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }

      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }

      strName = reader.name().toString( );
   
      if( "Day" != strName ) {
         continue;
      }

      attr = reader.attributes();
      strValue = attr.value( "ID" ).toString();
      iValue = strValue.toInt( &bOK );
      if( !bOK ) {
         continue;
      }

      if( iValue == iDay ) {
         bFound = true;
         bStatus = false;
         continue;
      } 
      
      reader.skipCurrentElement();
   }

   if( ! bFound ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}


static bool FindAmPm( bool bAm, 
                      int &nLines, // [o] number of lines
                       QXmlStreamReader &reader ) // [i/o] 
{
   bool bRetCode = false;
   bool bFound, bOK, bStatus;
   QString strName, strValue;
   QChar chValue, chAm;
   QXmlStreamAttributes attr;
   
   chAm = bAm ? 'A' : 'P';

   bStatus = true;
   bFound = false;
   while( bStatus ) {

      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }

      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }

      strName = reader.name().toString( );
   
      if( "AMPM" != strName ) {
         continue;
      }
      
      attr = reader.attributes();
      strValue = attr.value( "ID" ).toString();
      chValue = strValue.at( 0 );

      if( chValue == chAm ) {
         bFound = true;
         bStatus = false;
         
         strValue = attr.value( "Size" ).toString();
         nLines = strValue.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }

         continue;
      } 
      
      reader.skipCurrentElement();
   }

   if( ! bFound ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}   

//
// hikari in xml
//
bool BagsterWindow::GetDaysWords( QFile *file, // [i]
                                 int iMonth,
                                 int iDay, 
                                 bool bAm,
                                 QStringList *strLines ) // [o]
{
   bool bRetCode = false;
   int nLines, nSize;
   bool bStatus, bFound;
   QString strWords, strValue;
   QXmlStreamReader reader;

   //
   // check xml file
   //

   reader.setDevice( file );

   if( !reader.readNextStartElement( ) ) {
      goto PIX_EXIT;
   }

   if( reader.name() != "bagster" ) {
      goto PIX_EXIT;
   }

   if( reader.attributes().value("version") != "1.0") {
      goto PIX_EXIT;
   }

   //
	 
   if( !FindMonth( iMonth, reader ) ) {
      goto PIX_EXIT;
   }

   if( !FindDay( iDay, reader ) ) {
      goto PIX_EXIT;
   }

   if( !FindAmPm( bAm, nLines, reader ) ) {
      goto PIX_EXIT;
   }
   
   // get all words
   
   strLines->clear( );
   bStatus = true;
   bFound = false;
   while( bStatus ) {
      
      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }

      reader.readNext( );
      
      strValue = reader.name( ).toString( );

      if( !reader.isStartElement( ) ) {
         continue;
      }

      if( "Words" == strValue ) {
         strWords = reader.readElementText( );
         strLines->push_back( strWords );
      }

      nSize = (int)strLines->size( );
      if( nSize >= nLines ) {
         bStatus = false;
         bFound = true;
         continue;
      }
   }

   if( !bFound ) {
      goto PIX_EXIT;
   }
       
#ifdef _DEBUG
   nSize = strLines->size( );
   for( int i = 0 ; i < nLines ; i++ ) {
      strWords = strLines->at( i );
   }
#endif

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

void BagsterWindow::ShowDaysWords( void )
{
   pixq_Properties *pEnv = GetDailyEnv( );
   QStringList vstrLines;
   QString strDate, strUrl, strLabel, strBible, strProgram, strLines;
   QUrl url;
   QUrl baseUrl;
   int iMonth = _iCurrentMonth;
   int iDay = _iCurrentDay;
   bool bAm = _bCurrentAm;
   bool bJapanese = pEnv->BagsterBibleVersionJapanese( );

//qDebug( "Entered ShowDaysWords...\n" );

   // get today's data

   if( !GetDaysWords( iMonth, iDay, bAm, &vstrLines ) ) {
      qDebug( "ERROR! GetDaysWords Failed.\n" );
      goto PIX_EXIT;
   }

   if( !bSetBagsterDaysWords( &vstrLines, &strLines ) ) {
      qDebug( "ERROR! bSetBagsterDaysWords Failed.\n" );
      goto PIX_EXIT;
   }

   strUrl = GetTodaysHtmlFile_PC( );
   baseUrl = QUrl::fromLocalFile( strUrl );
/*
   url.setUrl( strUrl );
   _WebView->load( url );
*/
   _WebView->setHtml( strLines, baseUrl );

   // set header label

   strDate = SetDateLabel( iMonth, iDay, bAm );
   strBible = pEnv->BagsterGetBibleVersionName( );

   _strHeaderLabel = strDate + "[" + strBible + "]";
   _Header->repaint( );

   // set date on status bar

   _statusLabel[0]->setText( strDate );

   if( bJapanese ) {
      strProgram = "X̌";
   } else {
      strProgram = "Daily Light on Daily Path";
   }
   _statusLabel[1]->setText( strProgram );

   _statusLabel[2]->setText( strBible );

   // set calendar

   _Control->SelectTodayCalendar( );

PIX_EXIT:
   return;
}

void BagsterWindow::ShowBagsterContents( void )
{
   switch( _sDisplayContents ) {
   case ShowingDailyLightsDaily:
      ShowDaysWords( );  
      break;

   case ShowingDailyLightsOccasions:
      ShowCurrentOccasion( );
      break;
   }

   return;
}

void BagsterWindow::SetTodaysWords( void )
{
   QDate date;
   QTime time;
   int iHour;
   date = QDate::currentDate( );
   time = QTime::currentTime( );

   // get date and time

   //iYear = time.GetYear( );
   _iCurrentMonth = date.month( );
   _iCurrentDay = date.day( );
   iHour = time.hour( );
   _bCurrentAm = ( 12 > iHour ) ? true : false;
   
   if( 2 == _iCurrentMonth && 29 == _iCurrentDay ) {
      _iCurrentDay = 28;
   }

   return;
}

void BagsterWindow::ShowNextDay( void ) 
{
   int nDays[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, -1 };
   int nMonthDays;

   if( 0 > _iCurrentMonth ) {
      SetTodaysWords( ); // ShowNextDay  
      goto PIX_EXIT;
   }

   if( 12 == _iCurrentMonth && ( 31 == _iCurrentDay ) && ( !_bCurrentAm ) ) {
      _iCurrentMonth = 1;
      _iCurrentDay = 1;
      _bCurrentAm = true;
      ShowDaysWords( ); // ShowNextDay
      goto PIX_EXIT;
   }

   if( _bCurrentAm ) {
      _bCurrentAm = false;
      ShowDaysWords( ); // ShowNextDay
      goto PIX_EXIT;
   }

   nMonthDays = nDays[_iCurrentMonth-1];
   if( _iCurrentDay == nMonthDays ) {
      _iCurrentMonth = _iCurrentMonth + 1;
      _iCurrentDay = 1;
      _bCurrentAm = true;
      ShowDaysWords( ); // ShowNextDay
      goto PIX_EXIT;
   }

   _iCurrentDay = _iCurrentDay + 1;
   _bCurrentAm = true;
   ShowDaysWords( ); // ShowNextDay

PIX_EXIT:
   return;
}

void BagsterWindow::ShowPrevDay( void )
{
   int nDays[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, -1 };
   int nMonthDays;

   if( 0 > _iCurrentMonth ) {
      SetTodaysWords( ); // ShowPrevDay  
      ShowDaysWords( );
      goto PIX_EXIT;
   }

   if( 1 == _iCurrentMonth && ( 1 == _iCurrentDay ) && ( _bCurrentAm ) ) {
      _iCurrentMonth = 12;
      _iCurrentDay = 31;
      _bCurrentAm = false;
      ShowDaysWords( ); // ShowPrevDay
      goto PIX_EXIT;
   }

   if( !_bCurrentAm ) {
      _bCurrentAm = true;
      ShowDaysWords( ); // ShowPrevDay
      goto PIX_EXIT;
   }

   nMonthDays = nDays[_iCurrentMonth-1];
   if( 1 == _iCurrentDay ) {
      _iCurrentMonth = _iCurrentMonth - 1;
      _iCurrentDay = nDays[_iCurrentMonth-1];
      _bCurrentAm = false;
      ShowDaysWords( ); // ShowPrevDay
      goto PIX_EXIT;
   }

   _iCurrentDay = _iCurrentDay - 1;
   _bCurrentAm = false;
   ShowDaysWords( ); // ShowPrevDay

PIX_EXIT:
   return;
}

void BagsterWindow::CheckTimer( void )
{
   pixq_Properties *pEnv = GetDailyEnv( );
   bool bShow;
   QDateTime current, show_am, show_pm;
   QDate dt, last_dt;
   QTime tm;
   int iHour, iMin, iSecond;
   int iLastDay, iMonth, iDay, iYear;
   
   current = QDateTime::currentDateTime( );
   //((CDailyLightMainFrame*)AfxGetMainWnd())->Restore( );

   bShow = pEnv->_BagsterShowEveryDay.GetBool( );
   if( !bShow ) {
      goto PIX_EXIT;
   }

   // has date changed?
   
   dt = current.date( );
   tm = current.time( );
   iYear = dt.year( ); 
   iMonth = dt.month( ); 
   iDay = dt.day( );
   last_dt = _LastCheckedTime.date( );
   iLastDay = last_dt.day( );
   if( iLastDay != iDay ) {
      _bShownAmToday = false; 
      _bShownPmToday = false; 
   }

   // time to show the morning words

   if( !_bShownAmToday ) {
      iHour = pEnv->_BagsterAmShowHour.iGet( );
      iMin = pEnv->_BagsterAmShowMinuite.iGet( );
      iSecond = pEnv->_BagsterAmShowSecond.iGet( );
      dt.setYMD( iYear, iMonth, iDay );
      tm.setHMS( iHour, iMin, iSecond );
      show_am.setDate( dt );
      show_am.setTime( tm );

      if( current > show_am ) {
         // show today's morning word   
         showNormal( );  
         SetTodaysWords( );
         ShowDaysWords( );
         setWindowState( Qt::WindowActive );
         _bShownAmToday = true;
      }
   }

   // time to show the evening words

   if( !_bShownPmToday ) {
      iHour = pEnv->_BagsterPmShowHour.iGet( );
      iMin = pEnv->_BagsterPmShowMinuite.iGet( );
      iSecond = pEnv->_BagsterPmShowSecond.iGet( );
      dt.setYMD( iYear, iMonth, iDay );
      tm.setHMS( iHour, iMin, iSecond );
      show_pm.setDate( dt );
      show_pm.setTime( tm );
      
      if( current > show_pm ) {
         // show today's evening word 
         showNormal( );
         SetTodaysWords( );
         ShowDaysWords( );
         setWindowState( Qt::WindowActive );
         _bShownPmToday = true;
      }
   }

PIX_EXIT:
   _LastCheckedTime = current;
   return;
}

void BagsterWindow::readSettings()
{
   pixq_Properties *pEnv = GetDailyEnv( );
   
   QPoint ps;
   QSize sz;
   //QPoint ps = settings.value( "pos", QPoint(200, 200) ).toPoint( );
   //QSize sz = settings.value( "size", QSize( 400, 400 ) ).toSize( );
   
   int iLeft = pEnv->_BagsterWinLeft.iGet( );
   int iTop = pEnv->_BagsterWinTop.iGet( );
   int iWidth = pEnv->_BagsterWinWidth.iGet( );
   int iHeight = pEnv->_BagsterWinHeight.iGet( );

   ps.setX ( iLeft );
   ps.setY ( iTop );
   sz.setWidth ( iWidth );
   sz.setHeight ( iHeight );

   move( ps );
   resize( sz );
  
   return;
}

void BagsterWindow::writeSettings()
{
   pixq_Properties *pEnv = GetDailyEnv( );

   QPoint ps = pos( );
   QSize sz = size( );
   
   int iLeft = ps.x( );
   int iTop = ps.y( );
   int iWidth = sz.width( );
   int iHeight = sz.height( );

   //settings.setValue( "pos", ps );
   //settings.setValue( "size", sz );

   pEnv->_BagsterWinLeft.Set( iLeft );
   pEnv->_BagsterWinTop.Set( iTop );
   pEnv->_BagsterWinWidth.Set( iWidth );
   pEnv->_BagsterWinHeight.Set( iHeight );

   pEnv->SetRegEnv( _strOrganisation, _strApplication );

   return;
}

void BagsterWindow::ShowCurrentOccasion( void )
{
   pixq_Properties *pEnv = GetDailyEnv( );
   QStringList vstrLines;
   QStringList strOccasions, strEnOccasions;
   QString strDate, strUrl, strLabel, strBible, strProgram, strLines;
   QString strOccasion;
   QUrl url;
   QUrl baseUrl;

   bool bJapanese = pEnv->BagsterBibleVersionJapanese( );

   // 
   if( 0 > _iCurrentOccasion ) {
      _iCurrentOccasion = 0;
   }

   int iOccasion = _iCurrentOccasion + 1;

   // get today's data

   if( !GetOccasionWords( iOccasion, &vstrLines ) ) {
      qDebug( "ERROR! GetDaysWords Failed.\n" );
      goto PIX_EXIT;
   }

   if( !bSetBagsterDaysWords( &vstrLines, &strLines ) ) {
      qDebug( "ERROR! bSetBagsterDaysWords Failed.\n" );
      goto PIX_EXIT;
   }

   strUrl = GetTodaysHtmlFile_PC( );
   baseUrl = QUrl::fromLocalFile( strUrl );
/*
   url.setUrl( strUrl );
   _WebView->load( url );
*/
   _WebView->setHtml( strLines, baseUrl );

   //
   // set header label
   //

   if( !MakeCccasionsList( strOccasions, strEnOccasions ) ) {
      qDebug( "ERROR! MakeCccasionsList Failed.\n" );
      goto PIX_EXIT;
   }
      
   if( bJapanese ) {
      strOccasion = strOccasions.at( _iCurrentOccasion );
   } else {
      strOccasion = strEnOccasions.at( _iCurrentOccasion );
   }
   strDate.sprintf( "%d: ", iOccasion );
   strDate = strDate + strOccasion;
   strBible = pEnv->BagsterGetBibleVersionName( );

   _strHeaderLabel = strDate + "[" + strBible + "]";
   _Header->repaint( );

   // set date on status bar

   _statusLabel[0]->setText( strDate );

   if( bJapanese ) {
      strProgram = "X̌";
   } else {
      strProgram = "Daily Light on Daily Path";
   }
   _statusLabel[1]->setText( strProgram );
   _statusLabel[2]->setText( strBible );

   // set calendar

   _Control->SelectTodayCalendar( );

PIX_EXIT:
   return;
}


void BagsterWindow::SetOccasionWords( int iOccasion )
{
   SetDisplayContents( ShowingDailyLightsOccasions );
   _iCurrentOccasion = iOccasion;

   ShowBagsterContents( );

PIX_EXIT:
   return;
}


//
// get occasion's in string list
//
bool BagsterWindow::GetOccasionWords( int iOccasion,
                                    QStringList *strLines )
{
   bool bRetCode = false;
   QString strError, strXmlFile;
   
   QFile *file = NULL;

   //_tsetlocale( LC_ALL, _T("Japanese_Japan.932"));

   strXmlFile = GetBagsterOccasionsXmlFile_PC( );

   file = new QFile( strXmlFile );
   if ( !file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      strError = "ERROR! Failed to open file " + strXmlFile + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   if( !GetOccasionWords( file, iOccasion, strLines ) ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}


static bool FindOccasion( int iOccasion, 
                          int &nLines, // [o]
                       QXmlStreamReader &reader ) // [i/o] 
{
   bool bRetCode = false;
   bool bFound, bStatus, bOK;
   int iValue;
   QString strName, strValue;
   QXmlStreamAttributes attr;
   
   bStatus = true;
   bFound = false;
   while( bStatus ) {

      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }
   
      // find the month
   
      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }
   
      strName = reader.name().toString( );
   
      if( "Occasion" != strName ) {
         continue;
      }

      attr = reader.attributes();
      strValue = attr.value( "ID" ).toString();
      iValue = strValue.toInt( &bOK );
      if( !bOK ) {
         bStatus = false;
         continue;
      }
   
      if( iValue == iOccasion ) {
         bStatus = false;
         bFound = true;
         
         strValue = attr.value( "MaxLine" ).toString();
         nLines = strValue.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }

         continue;
      }

      reader.skipCurrentElement();
      
   }

   if( ! bFound ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

static bool bFindVersionEntries( int iVersion,
                                QString &strWords,
                                QXmlStreamReader &reader ) // [i/o] 
{
   bool bRetCode = false;
   bool bFound, bStatus;
   QString strName, strValue, strVersion, strVerses, strSource;
   QXmlStreamAttributes attr;
   
   // get all words

   switch( iVersion ) {     
   case pixq_Properties::BibleShinkaiyaku2:
      strVersion = "Shin";
      break;

   case pixq_Properties::BibleKougoyaku:
      strVersion = "Kougo";
      break;
      
   case pixq_Properties::BibleKingJames:
      strVersion = "Kjv";
      break;
      
   case pixq_Properties::BibleIntlStandard:
      strVersion = "ISV";
      break;
   
   default:
      goto PIX_EXIT;
      break;
   }

   bStatus = true;
   bFound = false;
   while( bStatus ) {
      
      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }

      reader.readNext( );
      
      strValue = reader.name( ).toString( );

      if( !reader.isStartElement( ) ) {
         continue;
      }

      if( strVersion == strValue ) {
         strWords = reader.readElementText( );
         bFound = true;
         bStatus = false;
      }
   }

   if( ! bFound ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool BagsterWindow::bFindAllEntries( int nEntries, // [o]
                            int iVersion,
                            QString &strLines,
                            BibleAllBooks &bl,
                            QXmlStreamReader &reader ) // [i/o] 
{
   bool bRetCode = false;
   bool bFound, bStatus, bOK;
   int i, nSize, iBook, iValue;
   QString strValue, strName, strWords, strLine, strSource, strBook, strVerses;
   QXmlStreamAttributes attr;
   
   pixq_Properties *pEnv = GetDailyEnv( );
   bool bJapanese = pEnv->BagsterBibleVersionJapanese( );

   QStringList strEntries;
   
   strEntries.clear( );

   bStatus = true;
   bFound = false;
   while( bStatus ) {

      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }
   
      // find the month
   
      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }
   
      strName = reader.name().toString( );
   
      if( "Entry" != strName ) {
         continue;
      }

      // get attributes

      attr = reader.attributes();

      strValue = attr.value( "ID" ).toString();
      iValue = strValue.toInt( &bOK );
      if( !bOK ) {
         bStatus = false;
         continue;
      }
   
      strValue = attr.value( "Book" ).toString();
      iBook = strValue.toInt( &bOK );
      if( !bOK ) {
         bStatus = false;
         continue;
      }
   
      strBook = attr.value( "Chapter" ).toString();   
      strVerses = attr.value( "Verses" ).toString();

      // generate verse string

      strSource = "(";
      if( bJapanese ) {
         strSource = strSource + bl.GetShinkaiName( iBook, 0 );
      } else {
         strSource = strSource + bl.GetBookEnAbbrev( iBook, 0 );
      }
      strSource = strSource + strBook;
      strSource = strSource + ":";
      strSource = strSource + strVerses;
      strSource = strSource + ")";

      //

      if( !bFindVersionEntries( iVersion, strWords, reader ) ) {
         goto PIX_EXIT;
      } 

      strLine = strWords + strSource;
      strEntries.push_back( strLine );
      
      reader.skipCurrentElement();

      nSize = strEntries.size( );
      if( nSize >= nEntries ) {
         bStatus = false;
         bFound = true;
         continue;
      }
      
   }

   if( ! bFound ) {
      goto PIX_EXIT;
   }

   // create output line

   strLines.clear( );
   for( i = 0 ; i < nEntries ; i++ ) {
      strLine = strEntries.at( i );
      strLines = strLines + strLine + " ";
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// hikari in xml
//
bool BagsterWindow::GetOccasionWords( QFile *file, // [i]
                                 int iOccasion,
                                 QStringList *strLines ) // [o]
{
   bool bRetCode = false;
   int nEntries, iLine, nLines, nSize, iValue;
   bool bOK, bStatus, bFound;
   QString strName, strWords, strValue, strLine;

#ifdef _DEBUG
   int iXmlLine;
#endif

   BibleAllBooks bl;
   QXmlStreamReader reader;
   QXmlStreamAttributes attr;

   pixq_Properties *pEnv = GetDailyEnv( );
   int iVersion = pEnv->_BagsterBibleVersion.iGet( );

   // make a list of all bible books

   bl.Setup( );

   //
   // check xml file
   //

   reader.setDevice( file );

   if( !reader.readNextStartElement( ) ) {
      goto PIX_EXIT;
   }

   if( reader.name() != "occasions" ) {
      goto PIX_EXIT;
   }

   if( reader.attributes().value("version") != "1.0") {
      goto PIX_EXIT;
   }

   //
	 
   if( !FindOccasion( iOccasion, nLines, reader ) ) {
      goto PIX_EXIT;
   }
   
   // get all words
   
   strLines->clear( );

   bStatus = true;
   bFound = false;
   while( bStatus ) {
      
      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }

      // find the month
   
#ifdef _DEBUG
      iXmlLine = reader.lineNumber( );
#endif
      
      reader.readNext( );

#ifdef _DEBUG
      iXmlLine = reader.lineNumber( );
#endif

  //    if( !reader.readNextStartElement()) {
  //       bStatus = false;
  //       continue;
  //    }
   
      strName = reader.name().toString( );
   
      if( "Line" != strName ) {
         continue;
      }

      attr = reader.attributes();

      strValue = attr.value( "ID" ).toString();
      iValue = strValue.toInt( &bOK );
      if( !bOK ) {
         bStatus = false;
         continue;
      }

      iLine = iValue;

      strValue = attr.value( "Size" ).toString();
      iValue = strValue.toInt( &bOK );
      if( !bOK ) {
         bStatus = false;
         continue;
      }

      nEntries = iValue;

      // read entries

      if( !bFindAllEntries( nEntries, iVersion, strLine, bl, reader ) ) {
         goto PIX_EXIT;
      } 

      strLines->push_back( strLine );

#ifdef _DEBUG
      iXmlLine = reader.lineNumber( );
#endif

      reader.skipCurrentElement();

#ifdef _DEBUG
      iXmlLine = reader.lineNumber( );
#endif

      //

      nSize = (int)strLines->size( );
      if( nSize >= nLines ) {
         bStatus = false;
         bFound = true;
         continue;
      }
   }

   if( !bFound ) {
      goto PIX_EXIT;
   }
       
#ifdef _DEBUG
   nSize = strLines->size( );
   for( int i = 0 ; i < nLines ; i++ ) {
      strWords = strLines->at( i );
   }
#endif

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool BagsterWindow::MakeCccasionsList( QStringList &strOccasions, // [o] japanese
                                      QStringList &strEnOccasions ) // [o] 
{
   bool bRetCode = false;
   bool bFound, bOK, bStatus;
   int iValue;
   QString strEnName, strXmlFile, strError, strName, strValue;
   QChar chValue, chAm;
   QXmlStreamReader reader;
   QXmlStreamAttributes attr;
   QFile *file = NULL;
   
   strXmlFile = GetBagsterOccasionsXmlFile_PC( );

   file = new QFile( strXmlFile );
   if ( !file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      strError = "ERROR! Failed to open file " + strXmlFile + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   reader.setDevice( file );

   // check the header

   if( !reader.readNextStartElement( ) ) {
      goto PIX_EXIT;
   }

   if( reader.name() != "occasions" ) {
      goto PIX_EXIT;
   }

   if( reader.attributes().value("version") != "1.0") {
      goto PIX_EXIT;
   }

   //

   strOccasions.clear( );
   strEnOccasions.clear( );

   bStatus = true;
   bFound = false;
   while( bStatus ) {

      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }
   
      // find the month
   
      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }
   
      strName = reader.name().toString( );
   
      if( "Occasion" != strName ) {
         continue;
      }

      attr = reader.attributes();

      strValue = attr.value( "ID" ).toString();
      iValue = strValue.toInt( &bOK );
      if( !bOK ) {
         bStatus = false;
         continue;
      }
   
      strName = attr.value( "Name" ).toString();
      strEnName = attr.value( "EnName" ).toString();

      strOccasions.push_back( strName );
      strEnOccasions.push_back( strEnName );

      reader.skipCurrentElement();      
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}   
