﻿#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"
#include "hikari_window.h"
#include "bible_plan_dialog.h"
#include "ui_bible_plan_dialog.h"

bible_plan_dialog::bible_plan_dialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::bible_plan_dialog)
{
   ui->setupUi(this);
   _bCtrlShown = false;
}

bible_plan_dialog::~bible_plan_dialog()
{
    delete ui;
}

void bible_plan_dialog::on_close_button_clicked()
{
    writeSettings( );
    done( -1 );

    return;
}

void bible_plan_dialog::DaySelected( int iDay )
{
    writeSettings( );
    done( iDay );

    return;
}

void bible_plan_dialog::Init( void )
{
   hikari_window *pMain = (hikari_window*)GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   int iPlan;
   QString strPlan;
  
   bool bJapanese = pMain->HikariSystemJapanese( );

   //

   ui->plan_table->SetParent( pMain ); 
   ui->plan_table->SetDialog( (bible_plan_dialog*) this); 
   ui->plan_table->SetBiblePlan( );

   //

   iPlan = pEnv->_HikariPlanSelected.iGet( );
   if( bJapanese ) {
      strPlan = "聖書通読：" + BiblePlanYear::PlanJpTitle( iPlan );
   } else {
      strPlan = "Yearly Bible Plan: " + BiblePlanYear::PlanEnTitle( iPlan );
   }
   setWindowTitle( strPlan );

   return;
}

void bible_plan_dialog::showEvent( QShowEvent * /*ev*/ )
{
   if( _bCtrlShown ) {
      goto PIX_EXIT;
   }

   readSettings( );

   _bCtrlShown = true;

PIX_EXIT:
   return;
}


void bible_plan_dialog::readSettings( void )
{   
   int iCount;
   QByteArray geo;

   QString strOrganisation = hikari_window::_strOrganisation;
   QString strApplication = hikari_window::_strApplication;
   QSettings settings( strOrganisation, strApplication );

   geo = settings.value("plan_geometry").toByteArray( );
   iCount = geo.count( );
   if( 0 >= iCount ) {
      // first time
      QSize sz( 500, 500 );
      QPoint ps( 40, 40 );
      move( ps );
      resize( sz );
   } else {
      restoreGeometry( geo );
   }

   return;
}

void bible_plan_dialog::writeSettings( void )
{   
   QByteArray geo;

   QString strOrganisation = hikari_window::_strOrganisation;
   QString strApplication = hikari_window::_strApplication;
   QSettings settings( strOrganisation, strApplication );

   geo = saveGeometry( );
   settings.setValue( "plan_geometry", geo );

   return;
}

void bible_plan_dialog::keyPressEvent(QKeyEvent *event)
{
   switch (event->key()) {
   case Qt::Key_Escape:
      DaySelected( -1 );
      break;

   default:
      break;
   }

   return;
}