#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"
#include "bible_plan_dialog.h"
#include "hikari_window.h"
#include "bible_plan_table.h"

bible_plan_table::bible_plan_table(QWidget *parent)
    : QTableWidget(parent)
{
   _bTableInitialized = false;
   
#ifdef _DEBUG
   _bLong = false;
#endif // _DEBUG
}

//
// two image panes must be of same width!
//
void bible_plan_table::resizeEvent( QResizeEvent * /*ev*/ )
{
   int iRow, nRows;
   if( !_bTableInitialized ) {
      goto PIX_EXIT;
   }

   SetTableColumns( );
   
   nRows = rowCount( );
   for( iRow = 0 ; iRow < nRows ; iRow++ ) {
      resizeRowToContents( iRow ); 
   }
      
   resizeRowsToContents( );

   _bTableInitialized = true;

PIX_EXIT:
   return;
}

void bible_plan_table::keyPressEvent(QKeyEvent *event)
{
   bible_plan_dialog *pDlg = GetDialog( );

   switch (event->key()) {
   case Qt::Key_F1:
#ifdef _DEBUG
      _bLong = !_bLong;
      SetBiblePlan( );
#endif // _DEBUG
      break;

   case Qt::Key_Escape:
      pDlg->DaySelected( -1 );
      break;

   default:
      break;
   }

   return;
}

void bible_plan_table::SetTableStyles( void )
{
   QString style;
   
   style = "QTableWidget::item { ";
   style += " padding-bottom:1px; ";
   style += " padding-top:1px; ";
   style += " padding-left:1px; ";
   style += " padding-right:1px; ";
   //style += " background-color: green; ";
   style += " }";

   setStyleSheet( style );

   style = "QTableWidget::item:selected { ";
   style += "foreground-color: blue; ";
   style += "background-color: gray; ";
   style += " }";

   setStyleSheet( style );

   return;
}

void bible_plan_table::SetTableColumns( void )
{
   int nCols = columnCount( );
   SetTableColumns( nCols );

   return;
}

void bible_plan_table::SetTableColumns( int nCols )
{
   int k, nTableWidth, nColWidth, nScrollWidth;
   QSize sz, scroll_sz;
   QScrollBar *vert;
   double dActiveWidth;

   int nMinWidth = 60;

   if( 0 >= nCols ) {
      goto PIX_EXIT;
   }

   // scroll bar

   setHorizontalScrollBarPolicy( Qt::ScrollBarAsNeeded );
   setVerticalScrollBarPolicy( Qt::ScrollBarAlwaysOn );

   vert = verticalScrollBar( );
   scroll_sz = vert->size( );
   nScrollWidth = scroll_sz.width( );
   
   setColumnCount( nCols );
 
   // set table width
   
   sz = size( );
   nTableWidth = sz.width( );
   dActiveWidth = (double)( nTableWidth - nScrollWidth ) * 0.99;

   // set width of each column

   nColWidth = (int)( dActiveWidth / (double)nCols );
   nColWidth = max( nColWidth, nMinWidth );
   for( k = 0 ; k < nCols ; k++ ) {
      setColumnWidth( k, nColWidth );
   }

PIX_EXIT:
   return;
}

//
// 
//
void bible_plan_table::SetBiblePlan( void )
{
   hikari_window *pMain = GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   BibleAllBooks *pBL = pMain->GetBibleBooks( );

   short sStatus;
   int nDays, iDay, iPlan;
   int iLang, iRow, nCols, nRows, nMaxRows, iCol;
   QString strTooltip, strUnit;

   QColor read_color = pEnv->_HikariPlanReadColor.colGet( );
   QColor part_read_color = pEnv->_HikariPlanPartReadColor.colGet( );
   QColor not_read_color = pEnv->_HikariPlanNotReadColor.colGet( );
   QColor bg_color = pEnv->_HikariPlanBackgroundColor.colGet( );
	
   QBrush read_brush( read_color, Qt::SolidPattern );
   QBrush part_read_brush( part_read_color, Qt::SolidPattern );
   QBrush not_read_brush( not_read_color, Qt::Dense4Pattern );
   QBrush bg_brush( bg_color, Qt::Dense3Pattern );

   QColor read_text_color = pEnv->_HikariPlanReadTextColor.colGet( );
   QColor part_read_text_color = pEnv->_HikariPlanPartReadTextColor.colGet( );
   QColor not_read_text_color = pEnv->_HikariPlanNotReadTextColor.colGet( );
	
   QBrush read_text_brush( read_text_color, Qt::SolidPattern );
   QBrush part_read_text_brush( part_read_text_color, Qt::SolidPattern );
   QBrush not_read_text_brush( not_read_text_color, Qt::SolidPattern );

   BiblePlanYear plan;
   BiblePlanDay day;

   QVector<int> tableRows;

   QFont fn_j, fn_e;

   bool bJapanese = pMain->HikariSystemJapanese( );

   // load plan
   
   iPlan = pEnv->_HikariPlanSelected.iGet( );

   if( !plan.LoadInitPlan( iPlan ) ) {
      goto PIX_EXIT;
   }

   iDay = BiblePlanYear::GetLastReadDay( pEnv );
   nDays = plan.NumberOfDays( );

   // set up table

   plan.setTableRows( tableRows );
   nCols = tableRows.size( );
   nMaxRows = tableRows.at( 0 );
   for( iCol = 1 ; iCol < nCols ; iCol++ ) {
      nRows = tableRows.at( iCol );
      nMaxRows = max( nMaxRows, nRows );
   }

   setShowGrid( true );
   SetTableColumns( nCols );
   SetTableStyles( );

   fn_j = pEnv->_HikariViewSearchJpFont.lfGet( );
   fn_e = pEnv->_HikariViewSearchEnFont.lfGet( );
   iLang = pEnv->_HikariBibleSystemLanguage.iGet( );

   //

   horizontalHeader( )->hide( );
   verticalHeader( )->hide( );

   setSelectionMode( QAbstractItemView::SingleSelection );
   setSelectionBehavior( QAbstractItemView::SelectItems );

   // set each line

   setRowCount( nMaxRows );
   
   iDay = 0;
   for( iCol = 0 ; iCol < nCols ; iCol++ ) {
      nRows = tableRows.at( iCol );
      for( iRow = 0 ; iRow < nRows ; iRow++ ) {

         QTableWidgetItem *itemBook = new QTableWidgetItem( );

         // split verse number from verses

         itemBook->setFlags( itemBook->flags() & ~Qt::ItemIsEditable );
         itemBook->setTextAlignment( Qt::AlignTop | Qt::AlignLeft );
     
         if( bJapanese ) {
            itemBook->setFont( fn_j );   
         } else {
            itemBook->setFont( fn_e );    
         }

         //

         day = plan.GetDaysPlan( iDay );
         sStatus = day.GetReadStatus( );
         
#ifdef _DEBUG
         if( _bLong ) {
            strUnit = day.ChaptersList( pBL );
         } else {
            strUnit = day.ChaptersShortList( pBL );
         }
#else
        // strUnit = day.ChaptersList( pBL );
         strUnit = day.ChaptersShortList( pBL );
#endif // _DEBUG
      
         switch( sStatus ) {
         case BiblePlanDay::DaysPlanAllRead:
            //itemBook->setCheckState( Qt::Checked );
            itemBook->setBackground( read_brush );
            itemBook->setForeground( read_text_brush );
            strTooltip = "Ǘ";
            break;
         case BiblePlanDay::DaysPlanPartRead:
           // itemBook->setCheckState( Qt::PartiallyChecked );
            itemBook->setBackground( part_read_brush );
            itemBook->setForeground( part_read_text_brush );
            strTooltip = "ꕔǗ";
            break;
         case BiblePlanDay::DaysPlanNotRead:
         default:
            //itemBook->setCheckState( Qt::Unchecked );
            itemBook->setBackground( not_read_brush );
            itemBook->setForeground( not_read_text_brush );
            strTooltip = "";
            break;
         }

         strTooltip = "_uNbNŕ\";

         itemBook->setToolTip( strTooltip );
         itemBook->setText( strUnit );
         itemBook->setData( Qt::UserRole, iDay );         
            
         setItem( iRow, iCol, itemBook );
   
         //

         iDay++;
      }

      for( iRow = nRows ; iRow < nMaxRows ; iRow++ ) {
         QTableWidgetItem *itemBook = new QTableWidgetItem( );
         itemBook->setBackground( bg_brush );
         itemBook->setData( Qt::UserRole, -1 );    
         setItem( iRow, iCol, itemBook );
      }

      resizeRowToContents( iRow ); 

   }
      
   resizeRowsToContents( );
   scrollToTop( );

   _bTableInitialized = true;

   //
   
   connect( this, SIGNAL(cellDoubleClicked(int,int)), this,
      SLOT(cellSelected(int,int)));

PIX_EXIT:
   return;            
}

//
// Check Box pressed
//
void bible_plan_table::cellSelected( int row, int column )
{
   bool bOK;
   int iDay;
   bible_plan_dialog *pDlg = GetDialog( );

   QTableWidgetItem *it = item( row, column ); 
   iDay = it->data( Qt::UserRole ).toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

   if( 0 > iDay ) {
      goto PIX_EXIT;
   }

   pDlg->DaySelected( iDay );
   
PIX_EXIT:
   return;        
}