#pragma once

#include <QtCore>
#include <QApplication>
#include <QTableWidget>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

class hikari_window;
class bible_plan_dialog;

class bible_plan_table: public QTableWidget
{
   Q_OBJECT

#ifdef _DEBUG
   bool _bLong;
#endif // _DEBUG
public:
   bible_plan_table(QWidget *parent = 0);

   void SetParent( hikari_window *pParent ) { _pParent = pParent; }
   hikari_window *GetParent( void ) { return _pParent; }

   void SetDialog( bible_plan_dialog *pDialog ) { _pDialog = pDialog; }
   bible_plan_dialog *GetDialog( void ) { return _pDialog; }

private:
   bool _bTableInitialized;
    hikari_window *_pParent;
    bible_plan_dialog *_pDialog;

   void SetTableColumns( int nCols );
   void SetTableColumns( void );

public:  
   void SetBiblePlan( void );
   void SetTableStyles( void );
   
protected:
   void resizeEvent( QResizeEvent* );
   void keyPressEvent(QKeyEvent *event);

private slots:   
   void cellSelected( int row, int column );
};
