#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"
#include "hikari_window.h"
#include "hikari_bagster.h"

hikari_bagster::hikari_bagster(QWidget *parent)
    : QWidget(parent)
{
   ui.setupUi(this);
    
   ui.hikari_calendar->setVerticalHeaderFormat( QCalendarWidget::NoVerticalHeader );
   ui.hikari_calendar->setHorizontalHeaderFormat( QCalendarWidget::ShortDayNames ); 

   EnableSlots( true );

   return;
} 

void hikari_bagster::EnableSlots( bool bEnabled )
{
   if( bEnabled ) {
      connect(ui.hikari_calendar, SIGNAL(clicked(QDate)), this, 
         SLOT(showMessage(QDate)));
      connect( ui.hikari_occasions, SIGNAL(currentRowChanged(int)), this,
         SLOT(occasionChanged(int)));   
      connect( ui.hikari_occasions, SIGNAL(itemClicked(QListWidgetItem*)), this,
         SLOT(occasionClicked(QListWidgetItem*)));

   } else {
      disconnect( ui.hikari_calendar, SIGNAL(clicked(QDate)), this, NULL );
      disconnect( ui.hikari_occasions, SIGNAL(currentRowChanged(int)), this, NULL );
      disconnect( ui.hikari_occasions, SIGNAL(itemClicked(QListWidgetItem*)), this, NULL );
   }

   return;
} 


void hikari_bagster::showMessage(QDate	date)
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );

   int iContent = pixq_Properties::ContentDevotion;
   int iDev = pixq_Properties::DevotionTypeDailyDays;
   int iMonth = date.month( );
   int iDay = date.day( );

   pContent->SetContent( iContent );
   pContent->SetBook( iDev );
   pContent->SetCurrentMonth( iMonth );
   pContent->SetCurrentDay( iDay );
  
   pMain->ShowContent( );

   return;
}

void hikari_bagster::occasionChanged(int row)
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   bool bOK;
   QListWidgetItem *item = NULL;
   int iOccasion;

   if( 0 > row ) {
      goto PIX_EXIT;
   }

   int iContent = pixq_Properties::ContentDevotion;
   int iDev = pixq_Properties::DevotionTypeDailyOccasion;

   pContent->SetContent( iContent );
   pContent->SetBook( iDev );

   item = ui.hikari_occasions->item( row );
   iOccasion = item->data( Qt::UserRole ).toInt( &bOK );
   pContent->SetCurrentOccasion( iOccasion );

   pMain->ShowContent( );

PIX_EXIT:
   return;    
}

void hikari_bagster::occasionClicked(QListWidgetItem *item )
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   bool bOK;
   int iOccasion;

   int iContent = pixq_Properties::ContentDevotion;
   int iDev = pixq_Properties::DevotionTypeDailyOccasion;

   pContent->SetContent( iContent );
   pContent->SetBook( iDev );

   iOccasion = item->data( Qt::UserRole ).toInt( &bOK );
   pContent->SetCurrentOccasion( iOccasion );

   pMain->ShowContent( );

   return;    
}

void hikari_bagster::SelectOccasion( void )
{   
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   QListWidgetItem *item = NULL;
   int iOccasion = pContent->GetCurrentOccasion( );

   int i;
   QString strName;
   bool bOK;
   bool bFound = false;

   QStringList strOccasions;
   QStringList strEnOccasions;

   int nLength = ui.hikari_occasions->count( );

   // disable slots

   EnableSlots( false );

   bFound = false;
   for( i = 0 ; !bFound &&  i < nLength ; i++ ) {

      item = ui.hikari_occasions->item( i );      
      if( iOccasion != item->data( Qt::UserRole ).toInt( &bOK ) ) {
         continue;
      }

      ui.hikari_occasions->setCurrentRow( i );
      bFound = true;
   }

   // set signal - slots
   
   EnableSlots( true );

   return;
}


void hikari_bagster::SelectTodayCalendar( void )
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   int iMonth = pContent->GetCurrentMonth( );
   int iDay = pContent->GetCurrentDay( );

   QDate current;
   QDate date;

   current = QDate::currentDate( );  
   int iYear = current.year( );

   // disable slots

   EnableSlots( false );

   //

   date.setDate( iYear, iMonth, iDay );
   ui.hikari_calendar->setSelectedDate( date );

   // set signal - slots
   
   EnableSlots( true );

   return;
}

void hikari_bagster::SetOccasionsList( void )
{   
   hikari_window *pMain = GetParent( );
   bool bJapanese = pMain->HikariSystemJapanese( );
   int i, nSize;
   QString strName;

   QStringList strOccasions;
   QStringList strEnOccasions;

   // disable slots

   EnableSlots( false );

   //

   if( !pMain->MakeCccasionsList( strOccasions, strEnOccasions ) ) {
      goto PIX_EXIT;
   }

   ui.hikari_occasions->setSortingEnabled ( false );
   ui.hikari_occasions->clear( );

   nSize = (int)strOccasions.size( );
   for( i = 0 ; i < nSize ; i++ ) {
      QListWidgetItem *item = new QListWidgetItem;

      if( bJapanese ) {
         strName = strOccasions.at( i );
      } else {
         strName = strEnOccasions.at( i );
      }
      
      item->setText( strName );
      item->setData( Qt::UserRole, i+1 );

      ui.hikari_occasions->addItem( item );
   }

   // set signal - slots
   
   EnableSlots( true );

PIX_EXIT:
   return;
}