#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"
#include "bible_plan_dialog.h"
#include "hikari_window.h"
//#include "hikari_ctrl.h"

#include "hikari_bible_plan.h"
#include "ui_hikari_bible_plan.h"

hikari_bible_plan::hikari_bible_plan(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::hikari_bible_plan)
{
    ui->setupUi(this);
   _bCtrlShown = false;
}

hikari_bible_plan::~hikari_bible_plan()
{
    delete ui;
}

void hikari_bible_plan::showEvent( QShowEvent * /*ev*/ )
{
   if( _bCtrlShown ) {
      goto PIX_EXIT;
   }
   
   initData( );
   setPlan( );

   _bCtrlShown = true;

PIX_EXIT:
   return;
}

void hikari_bible_plan::SetParent( hikari_window *pParent )  
{
   QLocale lc;
   QFont fn = font( );

   QString strFamily = fn.family( );
   int iPntSize = fn.pointSize( );

   lc = QLocale( QLocale::Japanese, QLocale::Japan );
   setLocale( lc );

   _pParent = pParent;
   ui->bible_plan_table->SetParent( pParent );
   ui->bible_plan_chart->SetParent( pParent );

   ui->bible_plan_combo->setLocale( lc );
   ui->bible_plan_combo->setFont( fn );
   
   return;
}

void hikari_bible_plan::initData( void )
{
   hikari_window *pMain = (hikari_window*)GetParent( );
   QString strPlan;
   QList<int> iPlanNumbers;
   QLocale lc;
   bool bFound;
   int i, iPlan, nSize, iLastPlan;

   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   bool bJapanese = pMain->HikariSystemJapanese( );

   //

   disconnect( ui->bible_plan_combo, SIGNAL(currentIndexChanged(int)), this, NULL );  

   // set all plan in combo
   // ʓǃv, one of BibleYearReadPlan

   pixq_Properties::BibleReadPlanList( iPlanNumbers );
   nSize = (int)iPlanNumbers.size( );

   ui->bible_plan_combo->clear( );

   for( i = 0 ; i < nSize ; i++ ) {
      iPlan = iPlanNumbers.at( i );
      if( bJapanese ) {
         strPlan = BiblePlanYear::PlanJpTitle( iPlan );
      } else {
         strPlan = BiblePlanYear::PlanEnTitle( iPlan );
      }

      ui->bible_plan_combo->addItem( strPlan, iPlan );
   }

   //

   iLastPlan = pEnv->_HikariPlanSelected.iGet( );

   bFound = false;
   for( i = 0 ; !bFound && i < nSize ; i++ ) {
      iPlan = ui->bible_plan_combo->itemData( i, Qt::UserRole ).toInt( );
      if( iPlan != iLastPlan ) continue;
      ui->bible_plan_combo->setCurrentIndex( i );
      bFound = true;
   }

   //

   connect( ui->bible_plan_combo, SIGNAL(currentIndexChanged(int)), this,
         SLOT(currentPlanChanged(int)));

   return;
}

void hikari_bible_plan::setPlan( void )
{
   hikari_window *pMain = (hikari_window*)GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   int nDays, iDay, iPlan;
   QString strNote;
   BiblePlanYear plan;

   bool bJapanese = pMain->HikariSystemJapanese( );

   iPlan = pEnv->_HikariPlanSelected.iGet( );
   if( bJapanese ) {
      strNote = BiblePlanYear::PlanJpNote( iPlan );
   } else {
      strNote = BiblePlanYear::PlanJpNote( iPlan );
   }

   //ui->bible_plan_chart->setWhatsThis( strNote );
   //ui->bible_plan_list_button->setWhatsThis( strNote );
   ui->bible_plan_chart->setToolTip( strNote );
   ui->bible_plan_table->setToolTip( strNote );
   ui->bible_plan_list_button->setToolTip( strNote );

   // set today's read plan

   ui->bible_plan_table->setPlanUnit( );

   // set slider
   
   disconnect( ui->bible_plan_slider, SIGNAL(valueChanged(int)), this, NULL );  

   if( !plan.LoadInitPlan( iPlan ) ) {
      goto PIX_EXIT;
   }

   iDay = BiblePlanYear::GetLastReadDay( pEnv );
   nDays = plan.NumberOfDays( );

   ui->bible_plan_slider->setMinimum( 0 );
   ui->bible_plan_slider->setMaximum( nDays-1 );
   ui->bible_plan_slider->setValue( iDay );   
   ui->bible_plan_slider->setTracking( false );

   // create plan read chart

   ui->bible_plan_chart->setChart( plan );
   
   //

   connect( ui->bible_plan_slider, SIGNAL(valueChanged(int)), this,
         SLOT(daySelected(int)));

PIX_EXIT:
   return;
}

void hikari_bible_plan::readSetChart( void )
{
   hikari_window *pMain = (hikari_window*)GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   int iPlan;
   BiblePlanYear plan;

   iPlan = pEnv->_HikariPlanSelected.iGet( );

   if( !plan.LoadInitPlan( iPlan ) ) {
      goto PIX_EXIT;
   }

   // create plan read chart

   ui->bible_plan_chart->setChart( plan );
   ui->bible_plan_chart->update( );
   
PIX_EXIT:
   return;
}

void hikari_bible_plan::on_bible_plan_list_button_clicked()
{
   hikari_window *pMain = (hikari_window*)GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   bible_plan_dialog list;
   int iDay;
   
   QString strOrganisation = hikari_window::_strOrganisation;
   QString strApplication = hikari_window::_strApplication;

   list.SetParent( pMain ); 
   list.Init( );

   iDay = list.exec( );
   if( 0 > iDay ) {
      goto PIX_EXIT;
   }

   //
   
   BiblePlanYear::SetLastReadDay( pEnv, iDay, strOrganisation, strApplication );

   ui->bible_plan_slider->setValue( iDay );

   // set today's read plan

   ui->bible_plan_table->setPlanUnit( );
   update( );

PIX_EXIT:
   return;
}

void hikari_bible_plan::currentPlanChanged(int index)
{
   hikari_window *pMain = (hikari_window*)GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   int iPlan;

   QString strOrganisation = hikari_window::_strOrganisation;
   QString strApplication = hikari_window::_strApplication;

   //

   iPlan = ui->bible_plan_combo->itemData( index, Qt::UserRole ).toInt( );
   pEnv->_HikariPlanSelected.Set( iPlan );
   pEnv->SetRegEnv( strOrganisation, strApplication );

   setPlan( );
   update( );

   return;
}

void hikari_bible_plan::daySelected( int iValue )
{
   hikari_window *pMain = (hikari_window*)GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   int iDay;

   QString strOrganisation = hikari_window::_strOrganisation;
   QString strApplication = hikari_window::_strApplication;

   // read the plan

   //iDay = ui->bible_plan_slider->value( );
   iDay = iValue;
   BiblePlanYear::SetLastReadDay( pEnv, iDay, strOrganisation, strApplication );

   // set today's read plan

   ui->bible_plan_table->setPlanUnit( );
   update( );

   return;
}

void hikari_bible_plan::on_bible_plan_prev_button_clicked()
{
   hikari_window *pMain = (hikari_window*)GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   int iDay;

   QString strOrganisation = hikari_window::_strOrganisation;
   QString strApplication = hikari_window::_strApplication;

   // get the last read day

   iDay = BiblePlanYear::GetLastReadDay( pEnv );
   if( 0 >= iDay ) {
      // do nothing
       goto PIX_EXIT;
   }

   // read the plan

   iDay = iDay - 1;
   BiblePlanYear::SetLastReadDay( pEnv, iDay, strOrganisation, strApplication );

   ui->bible_plan_slider->setValue( iDay );

   // set today's read plan

   ui->bible_plan_table->setPlanUnit( );

 PIX_EXIT:
    return;
}

void hikari_bible_plan::on_bible_plan_next_button_clicked()
{
   hikari_window *pMain = (hikari_window*)GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   int iDay, nDays, iPlan;

   QString strOrganisation = hikari_window::_strOrganisation;
   QString strApplication = hikari_window::_strApplication;

   // get number of all days on the currently selectred plan

   iPlan = pEnv->_HikariPlanSelected.iGet( );
   nDays = BiblePlanYear::GetNumberOfDays( iPlan );
   if( 0 >= nDays ) {
      goto PIX_EXIT;
   }

   // get the last read day

   iDay = BiblePlanYear::GetLastReadDay( pEnv );

   iDay = iDay + 1;
   if( iDay >= nDays ) {
      // do nothing
      goto PIX_EXIT;
   }

   BiblePlanYear::SetLastReadDay( pEnv, iDay, strOrganisation, strApplication );

   ui->bible_plan_slider->setValue( iDay );

   // set today's read plan

   ui->bible_plan_table->setPlanUnit( );

 PIX_EXIT:
    return;
}
