﻿#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"
#include "hikari_window.h"
#include "hikari_books.h"

hikari_books::hikari_books(QWidget *parent) :
    QToolBox(parent)
{
   setSizePolicy( QSizePolicy( QSizePolicy::Preferred, QSizePolicy::Ignored ) );
    
   setMinimumWidth( 80 );
   setMaximumWidth( 160 );

   _OldBookList = new QListWidget;
   _NewBookList = new QListWidget;
   _DevList = new QListWidget;
   _ShioriList = new QListWidget;

   _OldBookList->setSizePolicy( QSizePolicy( QSizePolicy::Preferred, QSizePolicy::Ignored ) );
   _NewBookList->setSizePolicy( QSizePolicy( QSizePolicy::Preferred, QSizePolicy::Ignored ) );
   _DevList->setSizePolicy( QSizePolicy( QSizePolicy::Preferred, QSizePolicy::Ignored ) );
   _ShioriList->setSizePolicy( QSizePolicy( QSizePolicy::Preferred, QSizePolicy::Ignored ) );
  
   _OldBookList->setHorizontalScrollBarPolicy( Qt::ScrollBarAlwaysOff );
   _NewBookList->setHorizontalScrollBarPolicy( Qt::ScrollBarAlwaysOff );
   _DevList->setHorizontalScrollBarPolicy( Qt::ScrollBarAlwaysOff );
   _ShioriList->setHorizontalScrollBarPolicy( Qt::ScrollBarAlwaysOff );

   //

   AddItems( );

   //

   SwitchChangeSlots( true );
   
   return;
}


void hikari_books::paintEvent(QPaintEvent * /* event */)
{
   return;
}

//
// enable / disable slots
//
void hikari_books::SwitchChangeSlots( bool bActive )
{
   if( bActive ) {
      connect( _OldBookList, SIGNAL(currentRowChanged(int)), this, SLOT(oldBookChanged(int)) );
      connect( _NewBookList, SIGNAL(currentRowChanged(int)), this, SLOT(newBookChanged(int)) );   
      connect( _DevList, SIGNAL(currentRowChanged(int)), this, SLOT(devChanged(int)) );  
      connect( _ShioriList, SIGNAL(currentRowChanged(int)), this, SLOT(shioriChanged(int)) );
      //
      connect( this, SIGNAL(currentChanged(int)), this, SLOT(contentChanged(int)) );
   } else {
      disconnect( _OldBookList, SIGNAL(currentRowChanged(int)), this, NULL );
      disconnect( _NewBookList, SIGNAL(currentRowChanged(int)), this, NULL );   
      disconnect( _DevList, SIGNAL(currentRowChanged(int)), this, NULL );     
      disconnect( _ShioriList, SIGNAL(currentRowChanged(int)), this, NULL );    
      //
      disconnect( this, SIGNAL(currentChanged(int)), this, NULL );
   }

   return;
}

hikari_books::~hikari_books()
{
    return;
}

void hikari_books::oldBookChanged(int row)
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );

   bool bOK;
   int iContent, iBook;
   QListWidgetItem *item = NULL;

   if( 0 > row ) goto PIX_EXIT;
   
   item = _OldBookList->item( row );
   
   iContent = pixq_Properties::ContentOldTestament;
   iBook = item->data( Qt::UserRole ).toInt( &bOK );

   //

   pContent->SetContent( iContent );
   pContent->SetBook( iBook );
   pMain->ShowContent( );

PIX_EXIT:
   return;    
}

void hikari_books::newBookChanged(int row)
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   bool bOK;
   int iContent, iBook;
   QListWidgetItem *item = NULL;

   if( 0 > row ) goto PIX_EXIT;

   item = _NewBookList->item( row );

   iContent = pixq_Properties::ContentNewTestament;
   iBook = item->data( Qt::UserRole ).toInt( &bOK );

   //

   pContent->SetContent( iContent );
   pContent->SetBook( iBook );
   pMain->ShowContent( );

PIX_EXIT:
   return;    
}

void hikari_books::devChanged(int row)
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   bool bOK;
   int iContent, iDev;
   QListWidgetItem *item = NULL;

   if( 0 > row ) goto PIX_EXIT;

   item = _DevList->item( row );

   iContent = pixq_Properties::ContentDevotion;
   iDev = item->data( Qt::UserRole ).toInt( &bOK );

   //

   pContent->SetContent( iContent );
   pContent->SetBook( iDev );
   pMain->ShowContent( );

PIX_EXIT:
   return;    
}

void hikari_books::shioriChanged(int row)
{
   hikari_window *pMain = GetParent( );

   if( 0 > row ) goto PIX_EXIT;

   // get n-th shiori

   if( !pMain->OpenShiori( row ) ) {
      goto PIX_EXIT;
   }

PIX_EXIT:
   return;    
}

void hikari_books::contentChanged( int iIndex )
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   int iContent;

   switch( iIndex ) {
   case ContentIndexOld:
      iContent = pixq_Properties::ContentOldTestament;
      break;

   case ContentIndexNew:
      iContent = pixq_Properties::ContentNewTestament;
      break;
      
   case ContentIndexDev:
      iContent = pixq_Properties::ContentDevotion;
      break;

   case ContentIndexShiori:
      goto PIX_EXIT;
      break;
   }

   //
   
   pContent->SetContent( iContent );
   pMain->ShowContent( );

PIX_EXIT:
   return;    
}

void hikari_books::SetOldTestament( void )
{
   hikari_window *pMain = GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   BibleAllBooks *pBL = pMain->GetBibleBooks( );

   BibleBook bc;
   QString strBook;
   int i;
   int iOldStart = BibleAllBooks::_iOldBookStart;
   int iOldEnd = BibleAllBooks::_iOldBookEnd;

   int iLang = pEnv->_HikariBibleSystemLanguage.iGet( );

   QLocale lc;

   lc = QLocale( QLocale::Japanese, QLocale::Japan );
   _OldBookList->setLocale( lc );

   // sel old testament

   _OldBookList->setSortingEnabled ( false );
   _OldBookList->clear( );

   for( i = iOldStart ; i <= iOldEnd ; i++ ) {
      bc = pBL->GetBook( i-1 );
      strBook = bc.GetBookName( iLang );

      QListWidgetItem *item = new QListWidgetItem;
      item->setText( strBook );
      item->setData( Qt::UserRole, i );

      _OldBookList->addItem( item );
   }

   //

   return;
}

void hikari_books::SetNewTestament( void )
{
   hikari_window *pMain = GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   BibleAllBooks *pBL = pMain->GetBibleBooks( );

   BibleBook bc;
   QString strBook;
   int i;
   int iNewStart = BibleAllBooks::_iNewBookStart;
   int iNewEnd = BibleAllBooks::_iNewBookEnd;

   int iLang = pEnv->_HikariBibleSystemLanguage.iGet( );

   // sel new testament

   _NewBookList->setSortingEnabled ( false );
   _NewBookList->clear( );

   for( i = iNewStart ; i <= iNewEnd ; i++ ) {
      bc = pBL->GetBook( i-1 );
      strBook = bc.GetBookName( iLang );
      
      QListWidgetItem *item = new QListWidgetItem;
      item->setText( strBook );
      item->setData( Qt::UserRole, i );
      _NewBookList->addItem( item );
   }

   return;
}

void hikari_books::SetDevotions( void )
{
   hikari_window *pMain = GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   QVector<int> viDevotions;
   QString strDev;
   int iDev, nLength, i;

   int iLang = pEnv->_HikariBibleSystemLanguage.iGet( );

   MakeDevotionsList_PC( viDevotions );
   nLength = (int)viDevotions.size( );

   _DevList->setSortingEnabled ( false );
   _DevList->clear( );

   for( i = 0 ; i < nLength ; i++ ) {

      iDev = viDevotions.at( i );
      strDev = GetDevotionName_PC( iLang, iDev );

      QListWidgetItem *item = new QListWidgetItem;
      item->setText( strDev );
      item->setData( Qt::UserRole, QVariant(iDev) );
      _DevList->addItem( item );
   }

   return;
}

void hikari_books::SetShiori( void )
{
   hikari_window *pMain = GetParent( );
   bool bEnabled;
   int i, nShiori;
   QString strLabel;
   BibleAllShiori data;
   BibleShiori shiori;
   BibleAllBooks *pBL = pMain->GetBibleBooks( );

   bool bJapanese = pMain->HikariSystemJapanese( );

   if( !data.Load( ) ) {
      goto PIX_EXIT;
   }

   _ShioriList->setSortingEnabled ( false );
   _ShioriList->clear( );

   nShiori = (int)data.Size( );
   nShiori = min( nShiori, BibleAllShiori::MaxShioriNumber( ) );

   for( i = 0 ; i < nShiori ; i++ ) {

      shiori = data.GetNthShiori( i );
      strLabel = shiori.SetLabel( pBL, bJapanese );
      bEnabled = shiori.Valid( );

      QListWidgetItem *item = new QListWidgetItem;
      item->setText( strLabel );
      item->setData( Qt::UserRole, QVariant( i ) );
      _ShioriList->addItem( item );
   }

PIX_EXIT:
   return;
}

void hikari_books::AddItems( void )
{
   QIcon icon[3];
   
   addItem( _OldBookList, tr( "Old Testament" ) ); 
   addItem( _NewBookList, tr( "New Testament" ) ); 
   addItem( _DevList, tr( "Devotions" ) );         
   addItem( _ShioriList, tr( "Shiori" ) );      

   //

   icon[0] = QIcon( ":/images/bible_o.png" );
   icon[1] = QIcon( ":/images/bible_n.png" );
   icon[2] = QIcon( ":/images/bible_pray.png" );
   icon[3] = QIcon( ":/images/bookmark-new32.png" );
    
   setItemIcon ( 0, icon[0] ); 
   setItemIcon ( 1, icon[1] ); 
   setItemIcon ( 2, icon[2] ); 
   setItemIcon ( 3, icon[3] ); 

   return;
}

void hikari_books::SetItemsText( void )
{
   hikari_window *pMain = GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   int iLang = pEnv->_HikariBibleSystemLanguage.iGet( );

   switch( iLang ) {
   case pixq_Properties::PixTopoLanguangeJp:
      setItemText( 0, tr( "旧約聖書" ) ); 
      setItemText( 1, tr( "新約聖書" ) ); 
      setItemText( 2, tr( "祈りの言葉" ) );
      setItemText( 3, tr( "しおり" ) ); 
      break;
   
   case pixq_Properties::PixTopoLanguangeEn:
   default: 
      setItemText( 0, tr( "Old Testament" ) ); 
      setItemText( 1, tr( "New Testament" ) ); 
      setItemText( 2, tr( "Devotions" ) );     
      setItemText( 3, tr( "Bookmark" ) );     
      break;
   }

   return;
}

void hikari_books::ShowOldTestament( void )
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   bool bOK;
   bool bFound = false;
   int i;
   int iBook = pContent->GetOldBook( );
   int nLength = _OldBookList->count( );
   QListWidgetItem *item = NULL;

   bFound = false;
   for( i = 0 ; !bFound &&  i < nLength ; i++ ) {

      item = _OldBookList->item( i );      
      if( iBook != item->data( Qt::UserRole ).toInt( &bOK ) ) {
         continue;
      }

      _OldBookList->setCurrentRow( i );
      bFound = true;
   }

   //

   return;
}

void hikari_books::ShowNewTestament( void )
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   bool bOK;
   bool bFound = false;
   int i;
   int iBook = pContent->GetNewBook( );
   int nLength = _NewBookList->count( );
   QListWidgetItem *item = NULL;

   // sel new testament

   bFound = false;
   for( i = 0 ; !bFound &&  i < nLength ; i++ ) {

      item = _NewBookList->item( i );      
      if( iBook != item->data( Qt::UserRole ).toInt( &bOK ) ) {
         continue;
      }

      _NewBookList->setCurrentRow( i );
      bFound = true;
   }

   return;
}

void hikari_books::ShowDevotions( void )
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   bool bOK;
   bool bFound = false;
   int i;
   int iBook = pContent->GetDevotion( );
   int nLength = _DevList->count( );
   QListWidgetItem *item = NULL;

   bFound = false;
   for( i = 0 ; !bFound &&  i < nLength ; i++ ) {

      item = _DevList->item( i );      
      if( iBook != item->data( Qt::UserRole ).toInt( &bOK ) ) {
         continue;
      }

      _DevList->setCurrentRow( i );
      bFound = true;
   }

   return;
}

void hikari_books::ShowSelection( void )
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   int iContent = pContent->GetContent( );

   // disable slots

   SwitchChangeSlots( false );

   //

   switch( iContent ) {
   case pixq_Properties::ContentOldTestament:
      setCurrentIndex( ContentIndexOld );
      ShowOldTestament( );
      break;
   
   case pixq_Properties::ContentNewTestament:
      setCurrentIndex( ContentIndexNew );
      ShowNewTestament( );
      break;
   
   case pixq_Properties::ContentDevotion:
      setCurrentIndex( ContentIndexDev );
      ShowDevotions( );
      break;
      
   }

   // enable slots

   SwitchChangeSlots( true );

   return;
}

void hikari_books::SetBooks( void )
{
   QLocale lc;

   lc = QLocale( QLocale::Japanese, QLocale::Japan );
   setLocale( lc );

   // sel old testament

   SetOldTestament( );

   // sel new testament

   SetNewTestament( );

   // set devotion

   SetDevotions( );

   // set shiori

   SetShiori( );

   //

   SetItemsText( );

   return;
}