#pragma once

#include <QApplication>
#include <QListWidget>
#include <QToolBox>

class hikari_window;

class hikari_books : public QToolBox
{
    Q_OBJECT
    
public:
   enum {
      ContentIndexOld = 0,
      ContentIndexNew = 1,
      ContentIndexDev = 2,
      ContentIndexShiori = 3,
   };

public:
    explicit hikari_books(QWidget *parent = 0);
    ~hikari_books();
        
public:
   void SetParent( hikari_window *pParent ) { _pParent = pParent; }
   hikari_window *GetParent( void ) { return _pParent; }
   
private:
    hikari_window *_pParent;

    QListWidget *_OldBookList;
    QListWidget *_NewBookList;
    QListWidget *_DevList;
    QListWidget *_ShioriList;

public:
   void AddItems( void );
   void SetItemsText( void );  

   void SetOldTestament( void ); 
   void SetNewTestament( void ); 
   void SetDevotions( void ); 
   void SetShiori( void ); 
   
   void ShowOldTestament( void ); 
   void ShowNewTestament( void ); 
   void ShowDevotions( void );

   void ShowSelection( void ); 
   void SetBooks( void ); 

   void SwitchChangeSlots( bool bActive );

private slots:

   void oldBookChanged( int iRow );
   void newBookChanged( int iRow );
   void devChanged( int iRow );
   void shioriChanged( int iRow );

   void contentChanged( int iIndex );
   
protected:
   void paintEvent(QPaintEvent *event);
};
