#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"
#include "hikari_window.h"
#include "hikari_chapters.h"

int hikari_chapters::_nCellSize = 32;

hikari_chapters::hikari_chapters(QWidget *parent) 
    : QTableWidget(parent)
{
   _bTableInitialized = false;
   _bMouseDragging = false;

   SwitchChangeSlots( true );

   return;
}
    
//
// enable / disable slots
//
void hikari_chapters::SwitchChangeSlots( bool bActive )
{
   if( bActive ) {
      connect( this, SIGNAL(currentCellChanged( int,int,int,int )), 
         this, SLOT(chapterSelected(int,int,int,int)));
   } else {
      disconnect( this, SIGNAL(currentCellChanged( int,int,int,int )), 
         this, NULL );
   }

   return;
}


//
// two image panes must be of same width!
//
void hikari_chapters::resizeEvent( QResizeEvent * /*ev*/ )
{
   int nHeight, nscrollHeight;
   QScrollBar *bar;
   QSize scroll_sz;

   if( !_bTableInitialized ) {
      goto PIX_EXIT;
   }

   setSizePolicy( QSizePolicy( QSizePolicy::Preferred, QSizePolicy::Fixed ) );
   
   //

   setHorizontalScrollBarPolicy( Qt::ScrollBarAsNeeded );
   //setHorizontalScrollBarPolicy( Qt::ScrollBarAlwaysOn );
   setVerticalScrollBarPolicy( Qt::ScrollBarAlwaysOff );

   nHeight = _nCellSize;

   bar = (QScrollBar*)horizontalScrollBar( );
   scroll_sz = bar->size( );
   nscrollHeight = scroll_sz.height( );

   setMinimumHeight( nHeight + nscrollHeight );
   setMaximumHeight( nHeight + nscrollHeight );

PIX_EXIT:
   return;
}

void hikari_chapters::showEvent( QShowEvent * /*ev*/ )
{

   return;
}

void hikari_chapters::chapterSelected( int currentRow,
                                        int currentColumn, 
                                        int /*previousRow*/,
                                        int /*previousColumn*/ )
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );

   bool bOK;
   int iChapter;   
   QTableWidgetItem *it;
   
   it = item( currentRow, currentColumn ); 
   iChapter = ((QVariant)it->data( Qt::UserRole )).toInt( &bOK );

   //

   pContent->SetChapter( iChapter );
   pMain->ShowContent( );

   return;
}

hikari_chapters::~hikari_chapters()
{
   return;
}

void hikari_chapters::SetTableStyles( void )
{
   QString style;

   // set table style
   
   style = "QTableWidget::item { ";
   style += " padding-bottom:2px; ";
   style += " padding-top:2px; ";
   style += " padding-left:2px; ";
   style += " padding-right:2px; ";
   style += " background-color: white; ";
   style += " }";

   setStyleSheet( style );

   style = "QTableWidget::item:hover { ";
   style += "color: rgb( 31, 31, 255 ); ";
   style += " background-color: rgb( 127, 127, 255 ); ";
   style += " }";

   style += "QTableWidget::item:selected{ ";
   style += "color: white; ";
   style += "background-color: rgb( 9, 54, 156 ); ";
   style += " }";

   setStyleSheet( style );

   return;
}

void hikari_chapters::ShowChaptersList( void )
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   int nChapters, i, iBook, iContent, iChapter;

   BibleAllBooks *pBL = pMain->GetBibleBooks( );

   QString strChapter;
   QFont fn;

   // disable slots

   SwitchChangeSlots( false );

   iContent = pContent->GetContent( );
   iBook = pContent->GetBook( );
   iChapter = pContent->GetBookChapter( );

   nChapters = pBL->GetBookChapters( iBook - 1 );

   //

   setColumnCount( nChapters );
   setRowCount( 1 );

   setShowGrid( true );
   SetTableStyles( );

   horizontalHeader( )->hide( );
   verticalHeader( )->hide( );

   setSelectionMode( QAbstractItemView::SingleSelection );
   setSelectionBehavior( QAbstractItemView::SelectItems );

   //

   fn = font( );
   fn.setBold( false );
   fn.setFamily( "Ariel" );
   fn.setPointSizeF( 8 );
   //fn.setPixelSize( -1 );
   fn.setWeight( QFont::DemiBold );
   fn.setStyle( QFont::StyleNormal );
   setFont( fn );

   // set chapters

   for( i = 0 ; i < nChapters ; i++ ) {
      QTableWidgetItem *item  = new QTableWidgetItem;
      strChapter.sprintf( "%d", i+1 );
      item->setText( strChapter );
      item->setData( Qt::UserRole, i+1 );
      item->setTextAlignment( Qt::AlignCenter );
      setItem( 0, i, item );
      setColumnWidth( i, _nCellSize );
   }

   // enable slots

   SwitchChangeSlots( true );

   _bTableInitialized = true;

   return;
}

void hikari_chapters::Init( void )
{
   setHorizontalScrollBarPolicy( Qt::ScrollBarAlwaysOn );
   setVerticalScrollBarPolicy( Qt::ScrollBarAlwaysOff );

   return;
}

void hikari_chapters::ShowSelection( void )
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   bool bOK;
   bool bFound = false;
   int i;
   int iChapter = pContent->GetBookChapter( );
   int nLength = columnCount( );
   QTableWidgetItem *it = NULL;

   // disable slots

   SwitchChangeSlots( false );

   //

   bFound = false;
   for( i = 0 ; !bFound &&  i < nLength ; i++ ) {

      it = item( 0, i );      
      if( iChapter != it->data( Qt::UserRole ).toInt( &bOK ) ) {
         continue;
      }

      setCurrentCell( 0, i );
      bFound = true;
   }

   // enable slots

   SwitchChangeSlots( true );

   return;
}

void hikari_chapters::Enable( bool bEnable )
{
   setEnabled( bEnable );

   return;
}

void hikari_chapters::enterEvent( QEvent * /* eve */ )
{

   return;
}


void hikari_chapters::mouseMoveEvent( QMouseEvent *eve )
{
   QPoint ps;
   QRect rt;
   QMargins mr;
   QString strLabel;

#ifdef _DEBUG
   hikari_window *pMain = GetParent( );
#endif

   int iX, iY;
   int iMouseX = eve->x();
   int iMouseY = eve->y();

   // right button pressed down
/*
   if( Qt::RightButton == eve->button( ) ) {
      _bMouseDragging = true;
   } else {
      _bMouseDragging = false;
   }
   */

   if( _bMouseDragging ) {
      //setCursor( Qt::DragMoveCursor );
      setCursor( Qt::ClosedHandCursor );
   } else {
      setCursor( Qt::OpenHandCursor );
   }

   // --- drag the chapter table ---

   if( _bMouseDragging ) {
      iX = iMouseX - _MousePoint.x( );
      iY = iMouseY - _MousePoint.y( );

    //  scroll( iX, 0 );
   }


   _MousePoint = eve->pos( );

#ifdef _DEBUG
   ps = pos( );
   rt = contentsRect( );
   mr = contentsMargins( );
   strLabel.sprintf( "mr %d,%d", iX, iY );
   pMain->SetStatusLabel( 2, strLabel );
   pMain->update( );
#endif

   return;
}

void hikari_chapters::mousePressEvent( QMouseEvent *eve )
{
   switch( eve->button( ) ) {      
   case Qt::RightButton:
      _bMouseDragging = true;
      setCursor( Qt::ClosedHandCursor );
      _MousePoint = eve->pos( );     
      goto PIX_EXIT; 
      break;
   }

   QTableWidget::mousePressEvent( eve );

PIX_EXIT:
   return;
}

void hikari_chapters::mouseReleaseEvent( QMouseEvent *eve )
{
   switch( eve->button( ) ) {      
   case Qt::RightButton:    
      _bMouseDragging = false;  
      setCursor( Qt::OpenHandCursor );
      _MousePoint = eve->pos( ); 
      goto PIX_EXIT;
      break;
   }

   QTableWidget::mouseReleaseEvent( eve );

PIX_EXIT:
   return;
}
