#pragma once

#include <QtCore>
#include <QApplication>
#include <QTableWidget>

class hikari_window;

class hikari_chapters : public QTableWidget
{
    Q_OBJECT
    
public:
    explicit hikari_chapters(QWidget *parent = 0);
    ~hikari_chapters();
    
protected:
   void mouseMoveEvent( QMouseEvent *eve );
   void mousePressEvent( QMouseEvent *eve );
   void mouseReleaseEvent( QMouseEvent *eve );
   void enterEvent( QEvent *eve );  
    
public:
   void SetParent( hikari_window *pParent ) { _pParent = pParent; }
   hikari_window *GetParent( void ) { return _pParent; }
   
   void Init( void );

private:
   void SetTableStyles( void );
   bool _bTableInitialized;
    hikari_window *_pParent;

public:
   void SwitchChangeSlots( bool bActive );
   void ShowChaptersList( void );
   void Enable( bool bEnable );
   void ShowSelection( void ); 

private:
   // true if mouse is dragging
   bool _bMouseDragging;

   QPoint _MousePoint;

   static int _nCellSize;

private slots: 
   void chapterSelected( int currentRow, int currentColumn, int previousRow,
      int previousColumn );
   
protected:
   void resizeEvent( QResizeEvent* );
   void showEvent(QShowEvent *event);
};
