#pragma once

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

class hikari_content
{
public:
   hikari_content(void);
   ~hikari_content(void);

public:
   static int _iLastOldBook;
   static int _iFirstNewBook;

private:
   // AVAfH[V
   // one of pixq_Properties::HikariBibleContent
   int _iContent;

   // 1-39
   int _iOldBook;

   // 40-66
   int _iNewBook;

   // devotion type, one of pixq_Properties::HikariDevotionContent
   int _iDevotion;

   // last selected chapter for each book of the bible

   int _iBookChapter[66];

   // Daily Light
   
   int _iCurrentMonth;
   int _iCurrentDay;
   bool _bCurrentAm;

   int _iCurrentOccasion;

   // 
public:
   void Init( void );
   void Set( const pixq_Properties *pEnv );
   void Store( pixq_Properties *pEnv );

   int GetContent( void ) { return _iContent; }

   int GetOldBook( void ) { return _iOldBook; }
   int GetNewBook( void ) { return _iNewBook; }
   int GetDevotion( void ) { return _iDevotion; }

   int GetBook( void );

   QString GetContentName( void );

   int GetBookChapter( void );
   int GetBookChapter( int iBook );
   
   void SetContent( int iContent );
   void SetBook( int iBook );
   void SetChapter( int iChapter );
   
   bool SetBibleContent( int iBook, int iChapter );

   //
   // data
   //
   int GetCurrentMonth( void ) { return _iCurrentMonth; }
   int GetCurrentDay( void ) { return _iCurrentDay; }
   bool GetCurrentAm( void ) { return _bCurrentAm; }

   void SetCurrentMonth( int iMonth ) { _iCurrentMonth = iMonth; }
   void SetCurrentDay( int iDay ) { _iCurrentDay = iDay; }
   void SetCurrentAm( bool bAm ) { _bCurrentAm = bAm; }

   void ShiftCurrentMonth( int iShift ) { _iCurrentMonth = _iCurrentMonth + iShift; }
   void ShiftCurrentDay( int iShift ) { _iCurrentDay = _iCurrentDay + iShift; }

   void InitCurrentDay( void ) {
      _iCurrentMonth = -1;
      _iCurrentDay = -1;
      _bCurrentAm = true;
      //
      _iCurrentOccasion = 1;
   }
   
   int GetCurrentOccasion( void ) { return _iCurrentOccasion; }
   void SetCurrentOccasion( int iOccasion ) { _iCurrentOccasion = iOccasion; }
};
