﻿#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"
#include "hikari_window.h"

#include "hikari_ctrl.h"
#include "hikari_search.h"
#include "hikari_bible_plan.h"

hikari_ctrl::hikari_ctrl(QWidget *parent)
    : QTabWidget(parent)
{
   //_bCtrlShown = false;

    return;
}

hikari_ctrl::~hikari_ctrl()
{
    return;
}

void hikari_ctrl::setCurrentPage( int iPageType ) 
{
   bool bOK, bFound;
   int iPage, nPages, i;
   QWidget *pPage;
   QString strName;

#ifdef _DEBUG
   hikari_window *pMain = (hikari_window*)GetParent( );
   QSplitter *pSplitter = pMain->GetContentsSplitter( );
   int k, nSizes, nHeights[4];
   QList<int> sizes;

   sizes = pSplitter->sizes( );
   nSizes = (int)sizes.size( );
   for( k = 0 ; k < nSizes ; k++ ) {
      nHeights[k] = sizes.at( k );
   }
#endif // _DEBUG

   // find a widget(page) to match this page type and show it!

   nPages = (int)count( );
   bFound = false;
   for( i = 0 ; !bFound && i < nPages ; i++ ) {
      pPage = widget( i );
      iPage = (pPage->property( "type" )).toInt( &bOK );
      if( !bOK ) continue;

      if( iPage == iPageType ) {
         // this is the page!
         setCurrentWidget( pPage );
         
         strName = (pPage->property( "name" )).toString( );
         bFound = true;
      }
   }

   // set curent data

   update( );

   return;
}

//
// returns:
// the current page type
// or -1 on error
//
int hikari_ctrl::GetCurrentPage( void ) 
{
   bool bOK;
   int iPage = -1;

   QWidget *pPage = currentWidget( );
   if( !pPage ) {
      goto PIX_EXIT;
   }

   // find a widget(page) to match this page type and show it!

   iPage = (pPage->property( "type" )).toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

PIX_EXIT:
   return iPage;
}

void hikari_ctrl::AddPropPage( QWidget *pPage,
                            QString strName,
                            int iPageType ) 
{
   int iPage = count( );
   addTab( (QWidget*)pPage, strName );
   
   pPage->setProperty( "page", QVariant( iPage ) );
   pPage->setProperty( "name", QVariant( strName ) );
   pPage->setProperty( "type", QVariant( iPageType ) );

   return;
}

void hikari_ctrl::Init( void )
{
   QDialogButtonBox::StandardButtons btn;
   QLocale lc;
   
   hikari_window *pMain = (hikari_window*)GetParent( );

   lc = QLocale( QLocale::Japanese, QLocale::Japan );
   setLocale( lc );

   // 
   
   AddPropPage( (QWidget*)&_CtrlSearch, tr("検索"), (int)control_page_search );
   AddPropPage( (QWidget*)&_CtrlBiblePlan, tr("通読"), (int)control_page_plan );
   AddPropPage( (QWidget*)&_CtrlBagster, tr("日々の光"), (int)control_page_bagster );
   
   //

   _CtrlSearch.SetParent( pMain );
   _CtrlBiblePlan.SetParent( pMain );
   _CtrlBagster.SetParent( pMain );

   // select the first page

   setCurrentPage( (int)control_page_search ); 

   // set data

   _CtrlBagster.SetOccasionsList( );

   // apperance

   setSizePolicy( QSizePolicy( QSizePolicy::Preferred, QSizePolicy::Preferred ) );
   
   setTabPosition( QTabWidget::South );

   return;
}

void hikari_ctrl::SelectTabSearch( void )
{
   setCurrentPage( (int)control_page_search ); 

   return;
}

void hikari_ctrl::SelectTabPlan( void )
{
   setCurrentPage( (int)control_page_plan ); 

   return;
}

void hikari_ctrl::SelectTabBagster( void )
{
   setCurrentPage( (int)control_page_bagster ); 

   return;
}

void hikari_ctrl::SelectTodayCalendar( void )
{
   _CtrlBagster.SelectTodayCalendar( );

   return;
}

void hikari_ctrl::SelectOccasion( void )
{
   _CtrlBagster.SelectOccasion( );

   return;
}

void hikari_ctrl::SetOccasionsList( void )
{
   _CtrlBagster.SetOccasionsList( );

   return;
}

void hikari_ctrl::showEvent( QShowEvent * /*ev*/ )
{   
   // set the height of each widget

   // show the first content!
   
   //pMain->ShowContent( );

   return;
}

//
// if bagster tab is show, hide the control panel
//
void hikari_ctrl::HideTabBagster( void )
{
   int iPage = GetCurrentPage( );
   if( control_page_bagster == iPage ) {
#ifdef _USE_DOC_WIDGET
      ((QDockWidget*)GetDock( ))->hide( );
#else
      hide( );  
#endif // _USE_DOC_WIDGET
   }

   return;
}

//
// if plan tab is show, hide the control panel
//
void hikari_ctrl::HideTabPlan( void )
{
   int iPage = GetCurrentPage( );
   if( control_page_plan == iPage ) {
#ifdef _USE_DOC_WIDGET
      ((QDockWidget*)GetDock( ))->hide( );
#else
      hide( );  
#endif // _USE_DOC_WIDGET
   }

   return;
}

//
// if search tab is show, hide the control panel
//
void hikari_ctrl::HideTabSearch( void )
{
   int iPage = GetCurrentPage( );
   if( control_page_search == iPage ) {
#ifdef _USE_DOC_WIDGET
      ((QDockWidget*)GetDock( ))->hide( );
#else
      hide( );  
#endif // _USE_DOC_WIDGET
   }

   return;
}