#pragma once

#include <QtCore>
#include <QApplication>
#include <QTabWidget>

#include "hikari_window.h"
#include "hikari_search.h"
#include "hikari_bible_plan.h"
#include "hikari_bagster.h"

class hikari_window;

class hikari_ctrl : public QTabWidget
{
   Q_OBJECT

public:
   enum {
      //
      control_page_none = -1,
      //
      // Do Not Change These Numbers!
      //
      control_page_search = 101,
      control_page_plan,
      control_page_bagster,
      //
    } value_control_page;

public:
   hikari_ctrl(QWidget *parent = 0);
    ~hikari_ctrl();

   void SetParent( hikari_window *pParent )  { _pParent = pParent; }
   hikari_window *GetParent( void ) { return _pParent; }

#ifdef _USE_DOC_WIDGET
   void SetDock( QDockWidget *pDock )  { _pDock = pDock; }
   QDockWidget *GetDock( void ) { return _pDock; }
#endif // _USE_DOC_WIDGET

public:
   void Init( void );
   void SelectTabSearch( void );
   void SelectTabPlan( void );
   void SelectTabBagster( void );

   void HideTabBagster( void );
   void HideTabPlan( void );
   void HideTabSearch( void );

   void SelectTodayCalendar( void );
   void SelectOccasion( void );
   void SetOccasionsList( void );

   void setCurrentPage( int iPageType ); 
   int GetCurrentPage( void ); 

public:
   hikari_bible_plan *GetBiblePlanPanel( void ) { return (hikari_bible_plan*)&_CtrlBiblePlan; }

private:
   void AddPropPage( QWidget *pPage, QString strName, int iPageType );

private:
    hikari_window *_pParent;
    
#ifdef _USE_DOC_WIDGET
   QDockWidget *_pDock; 
#endif // _USE_DOC_WIDGET

    hikari_search _CtrlSearch;
    hikari_bible_plan _CtrlBiblePlan;
    hikari_bagster _CtrlBagster;
   
 //   bool _bCtrlShown;

protected:
    void showEvent(QShowEvent *event);

private slots:
};
