#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"
#include "hikari_window.h"
#include "hikari_header_label.h"

hikari_header_label::hikari_header_label(QWidget *parent) :
    QWidget(parent) 
{
   setMinimumHeight( 25 );
   setMaximumHeight( 25 );
}

void hikari_header_label::showEvent( QShowEvent * /*ev*/ )
{

   return;
}

void hikari_header_label::paintEvent(QPaintEvent * /* event */)
{
   hikari_window *pMain = GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   QString strHeader = pMain->GetHeaderLabel( );

   QFont fn = pEnv->_HikariHeaderFont.lfGet( );
   QColor fn_color = pEnv->_HikariHeaderFgColor.colGet( );
   QColor bg0_color = pEnv->_HikariHeaderBg0Color.colGet( );
   QColor bg1_color = pEnv->_HikariHeaderBg1Color.colGet( );

   QRect rect = QRect( 0, 0, width(), height() );

   QPainter painter( this );
            
   QLinearGradient linearGradient( rect.topLeft(), rect.bottomLeft() );
   linearGradient.setColorAt( 0.0, bg0_color );
   linearGradient.setColorAt( 1.0, bg1_color );
   painter.setBrush( linearGradient );

   //painter.setRenderHint(QPainter::Antialiasing, false);
   painter.setPen( palette().dark().color() );
   //painter.setBrush( Qt::NoBrush );
   painter.drawRect( rect );

   // sewt header label

   QTextCodec::setCodecForCStrings(QTextCodec::codecForLocale());

   //setFont( fn );
   painter.setPen( fn_color );
   painter.setFont( fn );

  // QTextCodec::codecForLocale()->toUnicode(str);

   painter.drawText( rect, Qt::AlignCenter, strHeader );
  // painter.drawText( rect, Qt::AlignCenter, strHeader );

   // done!
   painter.end( );

   return;
}