#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"
#include "hikari_window.h"
#include "hikari_read_day.h"
#include "hikari_read_chart.h"

hikari_read_chart::hikari_read_chart(QWidget *parent)
    : QWidget(parent)
{   
   _pPlanChart = (QImage*)NULL;

   return;
}

hikari_read_chart::~hikari_read_chart()
{
   if( _pPlanChart ) {
      delete _pPlanChart;
      _pPlanChart = NULL;
   }

   return;
}

void hikari_read_chart::resizeEvent( QResizeEvent * /* eve */)
{   
   PlotChart( );
   
   return;
}

void hikari_read_chart::setChart( const BiblePlanYear &plan )
{   
   hikari_window *pMain = (hikari_window*)GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );

   int i, j, nCols, nRows, nMaxRows, nDays, iDay;
   short sStatus;
   QVector<int> tableRows;
   BiblePlanDay day;

   QColor read_color = pEnv->_HikariPlanReadColor.colGet( );
   QColor part_read_color = pEnv->_HikariPlanPartReadColor.colGet( );
   QColor not_read_color = pEnv->_HikariPlanNotReadColor.colGet( );
   QColor bg_color = pEnv->_HikariPlanBackgroundColor.colGet( );
   
   QRgb read_value = read_color.rgb( );
   QRgb part_read_value = part_read_color.rgb( );
   QRgb not_read_value = not_read_color.rgb( );

   plan.setTableRows( tableRows );
   nCols = tableRows.size( );
   nMaxRows = tableRows.at( 0 );
   for( i = 1 ; i < nCols ; i++ ) {
      nRows = tableRows.at( i );
      nMaxRows = max( nMaxRows, nRows );
   }

    if( _pPlanChart ) {
       delete _pPlanChart;
       _pPlanChart = NULL;
    }

   _pPlanChart = new QImage( nMaxRows, nCols, QImage::Format_RGB888 );
   _pPlanChart->fill( bg_color );

   nDays = plan.NumberOfDays( );

   iDay = 0;
   for( i = 0 ; i < nCols ; i++ ) {
      nRows = tableRows.at( i );
      for( j = 0 ; j < nRows ; j++ ) {
         if( iDay >= nDays ) continue;
         day = plan.GetDaysPlan( iDay );
         sStatus = day.GetReadStatus( );
         switch( sStatus ) {
         case BiblePlanDay::DaysPlanAllRead:
            _pPlanChart->setPixel( j, i, read_value );
            break;
         case BiblePlanDay::DaysPlanPartRead:
            _pPlanChart->setPixel( j, i, part_read_value );
            break;
         case BiblePlanDay::DaysPlanNotRead:
         default:
            _pPlanChart->setPixel( j, i, not_read_value );
            break;
         }
         iDay++;
      }
    }

#ifdef _DEBUG
    //_pPlanChart->save( "c:\\agent\\bible3.png" );
#endif

   return;
}

void hikari_read_chart::paintEvent(QPaintEvent * /* event */)
{   
   PlotChart( );

   return;
}

void hikari_read_chart::PlotChart( void )
{
   QPainter painter( this );
   QSize sz = size( );
   
   painter.setPen(palette().dark().color());
   painter.setBrush(Qt::NoBrush);

   QRectF target = rect( );
   //QRectF source = _pPlanChart->rect( );

   if( _pPlanChart ) {      
      QRectF target = rect( );
      QRectF source = _pPlanChart->rect( );
      painter.drawImage( target, *_pPlanChart, source );
   }

   //painter.drawImage( target, *_pPlanChart, source );
   painter.drawRect(QRect(0, 0, sz.width() - 1, sz.height() - 1));
   //painter.drawLine( 0, 0, sz.width() - 1, sz.height() - 1);

   return;
}

