#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"
#include "hikari_window.h"
#include "hikari_read_day.h"

hikari_read_day::hikari_read_day(QWidget *parent)
    : QTableWidget(parent)
{
   _bTableInitialized = false;
}

void hikari_read_day::setPlanUnit( void )
{  
   hikari_window *pMain = (hikari_window*)GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   BibleAllBooks *pBL = pMain->GetBibleBooks( );

   QIcon icon[3];

   bool bWhole;
   int iPlan, iDay, iLang, i, iCol, iChapter, iBook, nChapters, iVerse0, iVerse1, iReadYear;
   int nDays, iReadMonth, iReadDay;
   QString strTooltip, strHeader, strBook, strChapter;
   BibleBook bc;

   BiblePlanYear plan;
   BiblePlanDay day;
   BiblePlanChapterUnit chapter_unit;
   QTableWidgetItem *itemHeader0, *itemHeader1;

   QFont fn_j, fn_e;

   //

   connectSignals( false );

   // read the day's plan

   iPlan = pEnv->_HikariPlanSelected.iGet( );
   if( !plan.LoadInitPlan( iPlan ) ) {
      goto PIX_EXIT;
   }

   iDay = BiblePlanYear::GetLastReadDay( pEnv );
   day = plan.GetDaysPlan( iDay );

   nDays = plan.NumberOfDays( );

   //

   _bTableInitialized = true;

   SetTableColumns( );
   SetTableStyles( );
   setShowGrid( false );
   setShowGrid( true );

   fn_j = pEnv->_HikariViewSearchJpFont.lfGet( );
   fn_e = pEnv->_HikariViewSearchEnFont.lfGet( );
   iLang = pEnv->_HikariBibleSystemLanguage.iGet( );

   setSelectionMode( QAbstractItemView::SingleSelection );
   setSelectionBehavior( QAbstractItemView::SelectRows );

   clearSelection( );

   nChapters = day.Size( );
   setRowCount( nChapters );

   iCol = columnCount( );
   
   icon[0] = QIcon( ":/images/bible2.png" );
   icon[1] = QIcon( ":/images/bible2.png" );

   // show header

   itemHeader0 = new QTableWidgetItem( );
   strHeader.sprintf( "%d / %d ", iDay+1, nDays );
   itemHeader0->setTextAlignment( Qt::AlignVCenter | Qt::AlignCenter );
   itemHeader0->setFont( fn_j );  
   itemHeader0->setText( strHeader );  
   setHorizontalHeaderItem ( 0, itemHeader0 );

   itemHeader1 = new QTableWidgetItem( );
   itemHeader1->setTextAlignment( Qt::AlignVCenter | Qt::AlignCenter );
   itemHeader1->setFont( fn_j );  
   itemHeader1->setText( "\" );  
   setHorizontalHeaderItem ( 1, itemHeader1 );

   // show day's plan

   for( i = 0 ; i < nChapters ; i++ ) {
      QTableWidgetItem *itemChapter = new QTableWidgetItem( );
      //QTableWidgetItem *itemRead = new QTableWidgetItem( );

      // split verse number from verses

      itemChapter->setFlags( itemChapter->flags() & ~Qt::ItemIsEditable );
      //itemChapter->setFlags( itemChapter->flags() & Qt::ItemIsEnabled );
      //itemChapter->setFlags( itemChapter->flags() & Qt::ItemIsSelectable );
      //itemChapter->setFlags( itemChapter->flags() & Qt::ItemIsUserCheckable );
      itemChapter->setTextAlignment( Qt::AlignVCenter | Qt::AlignLeft );
      //itemChapter->setTextAlignment( Qt::AlignVCenter | Qt::AlignCenter );
      itemChapter->setFont( fn_j );  

      //itemRead->setTextAlignment( Qt::AlignVCenter | Qt::AlignCenter );
      //itemRead->setFlags( itemRead->flags() & ~Qt::ItemIsEditable );
      //itemRead->setFont( fn_j );  

      //

      chapter_unit = day.Unit( i );

      bWhole = chapter_unit.GetWhole( );
      iBook = chapter_unit.GetBook( );
      bc = pBL->GetBook( iBook-1 );
      strBook = bc.GetBookName( iLang );

      iChapter = chapter_unit.GetChapter( );
      if( bWhole ) {
         strChapter.sprintf( " %d", iChapter );
      } else {
         iVerse0 = chapter_unit.GetVerse0( );
         iVerse1 = chapter_unit.GetVerse1( );
         strChapter.sprintf( " %d:%d-%d", iChapter, iVerse0, iVerse1 );
      }

      strBook = strBook + strChapter;
      itemChapter->setText( strBook );
      itemChapter->setData( Qt::UserRole, i );

      // read?

      iReadYear = chapter_unit.GetReadYear( );
      if( 0 > iReadYear ) {
         //itemChapter->setIcon( icon[0] );
         itemChapter->setCheckState( Qt::Unchecked );
         strTooltip = "ǂ񂾂獶́`FbNI";
      } else {
         iReadMonth = chapter_unit.GetReadMonth( );
         iReadDay = chapter_unit.GetReadDay( );
         //itemChapter->setIcon( icon[1] );  
         itemChapter->setCheckState( Qt::Checked );
         strTooltip.sprintf( "%4dN%d%dɓǂ", iReadYear, iReadMonth, iReadDay );
      }
      
      itemChapter->setToolTip( strTooltip );

      //

      iCol = 0;
      setItem( i, iCol, itemChapter );

      //

      iCol = 1;
      QWidget *wdg = new QWidget;
      QPushButton *btn = new QPushButton( "\" );
      QHBoxLayout *layout = new QHBoxLayout( wdg );
      
      btn->setMaximumWidth( _nShowBtnWidth );
      btn->setProperty( "Chapter", QVariant( i ) );
      connect( btn, SIGNAL(clicked()), this, SLOT(showClicked()));

      layout->addWidget( btn );
      layout->setSpacing( 0 );
      layout->setMargin( 0 );
      layout->setAlignment( Qt::AlignCenter );
      wdg->setLayout( layout );
      setCellWidget( i, iCol, wdg );
      //setCellWidget( i, iCol, btn );

      //
      
      resizeRowToContents( i ); 
   }

   resizeRowsToContents( );
   scrollToTop( );
  
PIX_EXIT:
   connectSignals( true );
   return;
}

void hikari_read_day::SetTableColumns( void )
{
   int nTableWidth, nColWidth, nCols, nScrollWidth;
   int nButtonWidth;
   QSize sz, scroll_sz;
   QScrollBar *vert;
   double dActiveWidth;

   if( !_bTableInitialized ) {
      goto PIX_EXIT;
   }

   // scroll bar

   setHorizontalScrollBarPolicy( Qt::ScrollBarAlwaysOff );
   setVerticalScrollBarPolicy( Qt::ScrollBarAsNeeded );

   vert = verticalScrollBar( );
   scroll_sz = vert->size( );
   nScrollWidth = scroll_sz.height( );
   nScrollWidth = 0;

   setColumnCount( 2 );

   horizontalHeader( )->show( );
   verticalHeader( )->hide( );
   horizontalHeader( )->setResizeMode( QHeaderView::Fixed );

   //

   nButtonWidth = _nShowBtnWidth + _nShowBtnOffset + _nShowBtnOffset;
   nCols = columnCount( );
      
   // set table width
   
   sz = size( );
   nTableWidth = sz.width( );
   dActiveWidth = (double)( nTableWidth - nScrollWidth ) * 0.99;

   // set width of each column

   nColWidth = (int)dActiveWidth - nButtonWidth - 2;
   setColumnWidth( 0, nColWidth );
   
   setColumnWidth( 1, nButtonWidth );

PIX_EXIT:
   return;
}

void hikari_read_day::SetTableStyles( void )
{
   QString style;

   // set table style
   
   style.clear( );
   
   style += "QTableWidget { ";
   style += " padding-bottom:3px; ";
   style += " padding-top:3px; ";
   style += " padding-left:3px; ";
   style += " padding-right:3px; ";
   style += " }";

   style += "QTableWidget::item { ";
   style += " padding-bottom:1px; ";
   style += " padding-top:1px; ";
   style += " padding-left:1px; ";
   style += " padding-right:1px; ";
   //style += " background-color: green; ";
   //style += " selection-color: yellow; ";
   style += " }";

   style += "QTableWidget::item:hover { ";
   style += "color: black; ";
   style += "background-color: rgb( 255, 255, 127 ); ";
   style += "text-decoration: underline; ";
   style += " }";

   style += "QTableWidget::item:selected { ";
   style += "color: blue; ";
   style += "background-color: white; ";
   //style += "background-color: gray; ";
   style += "text-decoration: underline; ";
   style += " }";

   setStyleSheet( style );

   return;
}

void hikari_read_day::showResult( int iPlanChapter )
{
   hikari_window *pMain = GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   hikari_content *pContent = pMain->GetContent( );
   bool bWhole;
   int iDay, iPlan, nChapters, iBook, iChapter;
   int iVerse0, iVerse1;
   
   BiblePlanYear plan;
   BiblePlanDay day;
   BiblePlanChapterUnit chapter_unit;

   connectSignals( false );

   // read the day's plan

   iPlan = pEnv->_HikariPlanSelected.iGet( );
   if( !plan.LoadInitPlan( iPlan ) ) {
      goto PIX_EXIT;
   }

   iDay = BiblePlanYear::GetLastReadDay( pEnv );
   day = plan.GetDaysPlan( iDay );

   nChapters = day.Size( );

   //

   if( iPlanChapter >= nChapters ) goto PIX_EXIT;

   chapter_unit = day.Unit( iPlanChapter );
   bWhole = chapter_unit.GetWhole( );
   iBook = chapter_unit.GetBook( );
   iChapter = chapter_unit.GetChapter( );

   if( !bWhole ) {
      iVerse0 = chapter_unit.GetVerse0( );
      iVerse1 = chapter_unit.GetVerse1( );
   }

   //

   pContent->SetBibleContent( iBook, iChapter );

   pMain->ShowContent( );
   if( !bWhole ) {
      pMain->EnableVerseRange( iVerse0, iVerse1 );
   }

PIX_EXIT:
   connectSignals( true );
   return;
}

void hikari_read_day::connectSignals( bool bConnect )
{   
   if( bConnect ) {
      connect( this, SIGNAL(cellChanged(int,int)), this,
         SLOT(cellChecked(int,int)));
      connect( this, SIGNAL(currentCellChanged(int,int,int,int)), this,
         SLOT(curChanged(int,int,int,int)));
   } else {
      disconnect( this, SIGNAL(cellChanged(int,int)), this, NULL );  
      disconnect( this, SIGNAL(currentCellChanged(int,int,int,int)), this, NULL );  
   }

   return;
}

//
// two image panes must be of same width!
//
void hikari_read_day::resizeEvent( QResizeEvent * /*ev*/ )
{
   if( !_bTableInitialized ) {
      goto PIX_EXIT;
   }

   SetTableColumns( );

PIX_EXIT:
   return;
}

void hikari_read_day::hideEvent( QShowEvent * /*ev*/ )
{   
   clearSelection( );
   return;
}


void hikari_read_day::curChanged( int /* currentRow */, 
                                 int /* currentColumn */,
                                 int /* previousRow */,
                                 int /* previousColumn */ )
{
   // cell changed -> no longer show the chapter!

   //showResult( currentRow );

   return;
}

//
// Check Box pressed
//
void hikari_read_day::cellChecked( int row, int column )
{
   bool bOK;
   int iPlanChapter;
   bool bRead;
   Qt::CheckState st;

   QTableWidgetItem *it = item( row, column ); 
   iPlanChapter = it->data( Qt::UserRole ).toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

   // set read/unread

   st = it->checkState( );
   if( Qt::Checked == st ) {
      // read today
      bRead = true;
   } else {
      bRead = false;
   }

   setRead( iPlanChapter, bRead );
   
PIX_EXIT:
   return;        
}
 
//
// \button clicked!
//
void hikari_read_day::showClicked( void )
{
   bool bOK;
   int iRow;

   iRow = (sender( )->property( "Chapter" )).toInt( &bOK );
   showResult( iRow );

   return;        
}

void hikari_read_day::setRead( int iPlanChapter, 
                              bool bRead )
{
   hikari_window *pMain = GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
  int iDay, iPlan, nChapters;
   
   BiblePlanYear plan;
   BiblePlanDay day;
   BiblePlanChapterUnit chapter_unit;

   connectSignals( false );

   // read the day's plan

   iPlan = pEnv->_HikariPlanSelected.iGet( );
   if( !plan.LoadInitPlan( iPlan ) ) {
      goto PIX_EXIT;
   }

   iDay = BiblePlanYear::GetLastReadDay( pEnv );
   day = plan.GetDaysPlan( iDay );

   nChapters = day.Size( );

   // get the check plan number of the day
   
   if( iPlanChapter < 0 || iPlanChapter >= nChapters ) {
      goto PIX_EXIT;
   }

   chapter_unit = day.Unit( iPlanChapter );

   // set read/unread

   if( bRead ) {
      // read todaty
      chapter_unit.ReadToday( );
   } else {
      chapter_unit.Unread( );
   }

   // set it back to the plan and save to xml

   day.setUnit( iPlanChapter, chapter_unit );
   plan.setDaysPlan( iDay, day );

   if( !plan.SavePlan( ) ) {
      // failed to update the plan!
      goto PIX_EXIT;
   }

   // refresh plan chart

   pMain->refreshPlanChart( );

PIX_EXIT:
   connectSignals( true );
   return;        
}

