#pragma once

#include <QtCore>
#include <QApplication>
#include <QTableWidget>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

class hikari_window;
class hikari_bible_plan;

class hikari_read_day: public QTableWidget
{
   Q_OBJECT

private:
   static const int _nShowBtnWidth = 50;
   static const int _nShowBtnOffset = 4;

public:
   hikari_read_day(QWidget *parent = 0);

   void SetParent( hikari_window *pParent ) { _pParent = pParent; }
   hikari_window *GetParent( void ) { return _pParent; }

   void setPlanUnit( void );

private:
   bool _bTableInitialized;
   hikari_window *_pParent;

   void SetTableColumns( void );
   void SetTableStyles( void );
   
protected:
   void resizeEvent( QResizeEvent* );
   
private:
    void showResult( int iPlanChapter );
    void setRead( int iPlanChapter, bool bRead );

protected:
   void hideEvent(QShowEvent *event);
   void connectSignals( bool bConnect );

private slots:   
   void curChanged( int,int,int,int );
   void cellChecked( int row, int column );
   void showClicked( void );
};

