#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"
#include "hikari_window.h"
#include "hikari_ctrl.h"

#include "hikari_search.h"
#include "ui_hikari_search.h"

hikari_search::hikari_search(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::hikari_search)
{
   ui->setupUi(this); 
   _bCtrlShown = false; 
}

void hikari_search::showEvent( QShowEvent * /*ev*/ )
{
   if( _bCtrlShown ) {
      goto PIX_EXIT;
   }
   
   setData( );

PIX_EXIT:
   _bCtrlShown = true;
   return;
}

hikari_search::~hikari_search()
{
    delete ui;
}

void hikari_search::returnPressed()
{
   startSearch( );
}

void hikari_search::on_search_button_clicked()
{
   startSearch( );
}

void hikari_search::SetParent( hikari_window *pParent )  
{
   QString strToolTip;
   bool bJapanese = pParent->HikariSystemJapanese( );

   _pParent = pParent;

   connect(ui->search_text_edit, SIGNAL(returnPressed()), this, SLOT(returnPressed()));

   //

   if( bJapanese ) {
      strToolTip = "󔒂ŋ؂āA錾tw肵Ăip͈pň͂ށj\n";
      strToolTip = strToolTip + "FGT Ƃ spirit \"He rebukes the sea\"";
   } else {
      strToolTip = "Enter the words to search separated by blank. Use quotation marks to search sentences.\n";
      strToolTip = strToolTip + "Example: spirit Jesus \"He rebukes the sea\"";
   }
   
   ui->search_text_edit->setToolTip( strToolTip );

   return;
}

void hikari_search::setData( void )
{
   hikari_window *pMain = (hikari_window*)GetParent( );
   QString strValue;
   pixq_Properties *pEnv = pMain->GetHikariEnv( );

   // last search word, just to memorize

   strValue = pEnv->_HikariBibleSearchLastWord.strGet( );
   if( !strValue.isEmpty( ) ) {
      ui->search_text_edit->setText( strValue );
   }

   // last search mode, one of BibleSearchWordsCombination

   setSearchMode( );

   return;
}

void hikari_search::setSearchMode( void )
{
   hikari_window *pMain = (hikari_window*)GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   int iValue;

   ui->serach_and_radio->setChecked( false );
   ui->serach_or_radio->setChecked( false );

   iValue = pEnv->_HikariBibleSearchLastMode.iGet( );
   switch( iValue ) {
   case pixq_Properties::SearchWordAnd:
      ui->serach_and_radio->setChecked( true );
      break;
   case pixq_Properties::SearchWordOr: 
      ui->serach_or_radio->setChecked( true );
      break;
   }

   return;
}


int hikari_search::getSearchMode( void )
{
   int iValue;

   if( ui->serach_and_radio->isChecked( ) ) {
      iValue = (int)pixq_Properties::SearchWordAnd;
   } else {
      iValue = (int)pixq_Properties::SearchWordOr;
   }

   return iValue;
}

//
// search words must look like xxxx dddd "wwww eeee rrrr"
//
bool hikari_search::checkSearchWords( QString strSearch, // [i] list of words untered
                                     QStringList &strWords ) // [o] list of all words
{
   bool bRetCode = false;
   bool bFound;
   int iFrom, nLen, nSize, iPos, i, nQuotes, nQuoted;
   QVector<int> viQuote, viBlanks;
   QString strWord;
   QStringList strSplit;
   
   QChar chQuote = '\"';
   QChar chBlank = ' ';
   QString strZenBlank = "@";
   QString strBlank = " ";
   QString strBlank2 = "  ";

   //

   strWords.clear( );

   strSearch = strSearch.trimmed( );

   nSize = (int)strSearch.size( );
   if( 0 >= nSize ) {
      goto PIX_EXIT;
   }

   // take care of blanks
   // replace Zenkaku blank with hankaku blank
   // if two connected blanks exist, replace them with single blank

   strSearch = strSearch.replace( strZenBlank, strBlank );

   bFound = true;
   while( bFound ) {
      iPos = strSearch.indexOf( strBlank2, 0 );
      if( 0 > iPos ) {
         bFound = false;
         continue;
      }

      strSearch = strSearch.replace( strBlank2, strBlank ); 
   }

   // look for all quotation marks(")

   nQuotes = strSearch.count( chQuote );
   if( 1 == ( nQuotes % 2 ) ) {
      goto PIX_EXIT;
   }

   if( 0 < nQuotes ) {
      iFrom = 0;
      viQuote.clear( );
      for( i = 0 ; i < nQuotes ; i++ ) {
         iPos = strSearch.indexOf( chQuote, iFrom );
         viQuote.push_back( iPos );
         iFrom = iPos + 1;
      }
   
      // make a list of words in quotation marks "xxx yyy zzz"
      // remove the extracted words from the original

      nQuoted = nQuotes / 2;
      for( i = 0 ; i < nQuoted ; i++ ) {
         iPos = viQuote.at( i * 2 );
         nLen = viQuote.at( i * 2 + 1 ) - iPos - 1;
         strWord = strSearch.mid( iPos, nLen );
         if( strWord.isEmpty( ) ) continue;
         strWords.push_back( strWord );
      }
   
      for( i = nQuoted-1 ; i >= 0 ; i-- ) {
         iPos = viQuote.at( i * 2 );
         nLen = viQuote.at( i * 2 + 1 ) - iPos + 1;
         strSearch.remove( iPos, nLen );
      }
   }

   // delimit the ledft string by blank

   strSearch = strSearch.trimmed( );
   nSize = (int)strSearch.size( );
   if( 0 >= nSize ) {
      bRetCode = true;
      goto PIX_EXIT;
   }

   strSplit = strSearch.split( chBlank, QString::SkipEmptyParts );

   strWords.append( strSplit );

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

void hikari_search::startSearch( void )
{
   hikari_window *pMain = (hikari_window*)GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   int nWords, i, iSearchMode, nCount, nJpCount, nEnCount;
   QString strLabel, strWord;
   QStringList strWords;
   BibleListVerse result;

   QString strOrganisation = hikari_window::_strOrganisation;
   QString strApplication = hikari_window::_strApplication;

   ui->search_result_table->SetParent( pMain );

   //

   strLabel = ui->search_text_edit->text( );

   if( !strLabel.size( ) ) {
      QString strError = "͂Ă.";
      QMessageBox::information( NULL, strApplication, strError );
      goto PIX_EXIT;
   }

   if( !checkSearchWords( strLabel, strWords ) ) {
      QString strError = "񂪐܂.";
      QMessageBox::information( NULL, strApplication, strError );
      goto PIX_EXIT;
   }

   nWords = (int)strWords.size( );
   if( 0 >= nWords ) {
      QString strError = "񂪐܂.";
      QMessageBox::information( NULL, strApplication, strError );
      goto PIX_EXIT;
   }

   for( i = 0 ; i < nWords ; i++ ) {
      strWord = strWords.at( i );
   }

   // check bible setting

   pMain->CheckSearchCondition( nJpCount, nEnCount ); 
   nCount = nJpCount + nEnCount;
   if( 0 >= nCount ) {
      QString strError = "ERROR! 鐹̔łw肵Ă.";
      QMessageBox::information( NULL, strApplication, strError );
      goto PIX_EXIT;
   } 

   iSearchMode = getSearchMode( );

   // start to search

   pMain->SearchWordStart( iSearchMode, strWords, result ); 

   ui->search_result_table->SetSearchResult( result );

   // search is done, store the search environment

   pEnv->_HikariBibleSearchLastWord.Set( strLabel );
   pEnv->_HikariBibleSearchLastMode.Set( iSearchMode );
   pEnv->SetRegEnv( strOrganisation, strApplication );

PIX_EXIT:
   return;
}

void hikari_search::on_setting_button_clicked()
{
   hikari_window *pMain = (hikari_window*)GetParent( );
   short sPage = (short)pixq_EnvItem::ItemCategoryHikariBible;
    
   pMain->ShowSetProperties( sPage );

   return;
}
