#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"
#include "hikari_window.h"
#include "hikari_search_result.h"

hikari_search_result::hikari_search_result(QWidget *parent)
    : QTableWidget(parent)
{
   _bTableInitialized = false;
}

//
// two image panes must be of same width!
//
void hikari_search_result::resizeEvent( QResizeEvent * /*ev*/ )
{
   if( !_bTableInitialized ) {
      goto PIX_EXIT;
   }

   SetTableColumns( );
   
   _iBookCol = -1;
   _iChapterCol = -1;
   _iWordCol = -1;   
   _iVersionCol = -1;

PIX_EXIT:
   return;
}
   

void hikari_search_result::SetTableStyles( void )
{
   QString style;
   
   style = "QTableWidget::item { ";
   style += " padding-bottom:1px; ";
   style += " padding-top:1px; ";
   style += " padding-left:1px; ";
   style += " padding-right:1px; ";
   //style += " background-color: green; ";
   style += " }";

   setStyleSheet( style );

   style = "QTableWidget::item:selected { ";
   style += "foreground-color: blue; ";
   style += "background-color: gray; ";
   style += " }";

   setStyleSheet( style );

   return;
}

void hikari_search_result::SetTableColumns( void )
{
   int k, nTableWidth, nColWidth, nCols, nScrollWidth;
   QSize sz, scroll_sz;
   QScrollBar *vert;
   double dRatioWidth, dSumWidth, dActiveWidth;
   vector<double> vdWidth;

   if( !_bTableInitialized ) {
      goto PIX_EXIT;
   }

   // scroll bar

   setHorizontalScrollBarPolicy( Qt::ScrollBarAlwaysOff );
   setVerticalScrollBarPolicy( Qt::ScrollBarAlwaysOn );

   vert = verticalScrollBar( );
   scroll_sz = vert->size( );
   nScrollWidth = scroll_sz.width( );

   //
   
   vdWidth.clear( );
   vdWidth.push_back( 10 ); // book name
   vdWidth.push_back( 10 ); // verse
   vdWidth.push_back( 100 ); // word
   vdWidth.push_back( 10 ); // version name

   nCols = (int)vdWidth.size( );
   setColumnCount( nCols );
 
   // set table width
   
   sz = size( );
   nTableWidth = sz.width( );
   dActiveWidth = (double)( nTableWidth - nScrollWidth ) * 0.99;

   // set width of each column

   dSumWidth = 0.0;
   for( k = 0 ; k < nCols ; k++ ) {
      dSumWidth = dSumWidth + vdWidth.at( k );
   }

   for( k = 0 ; k < nCols ; k++ ) {
      dRatioWidth = vdWidth.at( k ) / dSumWidth;
      nColWidth = (int)( dActiveWidth * dRatioWidth );
      setColumnWidth( k, nColWidth );
   }

PIX_EXIT:
   return;
}

//
// set two version in table
//
void hikari_search_result::SetSearchResult( BibleListVerse &res )
{
   hikari_window *pMain = GetParent( );
   BibleAllBooks *pBL = pMain->GetBibleBooks( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );

   int i, iVerse, iBook, iChapter, iCol, iVersion, nLines;
   QString strWord, strVersion, strBook, strVerse;

   QFont fn_j, fn_e;

   bool bJapanese;
   BibleVerse bv;
   
   // set up table

   disconnect( this, SIGNAL(cellClicked(int,int)), this, NULL );
   
   _bTableInitialized = true;

   SetTableColumns( );
   SetTableStyles( );

   fn_j = pEnv->_HikariViewSearchJpFont.lfGet( );
   fn_e = pEnv->_HikariViewSearchEnFont.lfGet( );

   //

   horizontalHeader( )->hide( );
   verticalHeader( )->hide( );

   setSelectionMode( QAbstractItemView::SingleSelection );
   setSelectionBehavior( QAbstractItemView::SelectRows );

   // set each line

   clearSelection( );

   nLines = res.Size( );
   setRowCount( nLines );
   
   for( i = 0 ; i < nLines ; i++ ) {

      QTableWidgetItem *itemBook = new QTableWidgetItem( );
      QTableWidgetItem *itemChapter = new QTableWidgetItem( );
      QTableWidgetItem *itemWord = new QTableWidgetItem( );
      QTableWidgetItem *itemVersion = new QTableWidgetItem( );

      // split verse number from verses

      itemBook->setTextAlignment( Qt::AlignTop | Qt::AlignLeft );
      itemChapter->setTextAlignment( Qt::AlignTop | Qt::AlignRight );
      itemWord->setTextAlignment( Qt::AlignTop | Qt::AlignLeft );
      itemVersion->setTextAlignment( Qt::AlignTop | Qt::AlignLeft );

      //

      bv = res.At( i );
      
      iVersion = bv.GetVersion( );
      iBook = bv.GetBook( );
      iChapter = bv.GetChapter( );
      iVerse = bv.GetVerse( );
      strWord = bv.GetWord( );

      //

      bJapanese = pixq_Properties::BibleVersionJapanese( iVersion );
      itemChapter->setFont( fn_e );   
      if( bJapanese ) {
         itemWord->setFont( fn_j );    
         itemBook->setFont( fn_j );   
         itemVersion->setFont( fn_j );   
      } else {
         itemWord->setFont( fn_e );    
         itemBook->setFont( fn_e );   
         itemVersion->setFont( fn_e );   
      }

      //
      
      if( bJapanese ) {
         strBook = pBL->GetJpShortName( iBook-1 );
      } else {
         strBook = pBL->KjvShortName( iBook-1 );
      }
      strVerse.sprintf( "%d:%d", iChapter, iVerse );
      strVersion = pixq_Properties::GetBibleVersionName( iVersion );

      //

      itemBook->setText( strBook );
      itemBook->setData( Qt::UserRole, iBook );

      itemChapter->setText( strVerse );
      itemChapter->setData( Qt::UserRole, iChapter );

      itemWord->setText( strWord );
      itemWord->setData( Qt::UserRole, iVerse );

      itemVersion->setText( strVersion );
      itemVersion->setData( Qt::UserRole, iVersion );

      //
            
      iCol = 0;
      setItem( i, iCol, itemBook );
      _iBookCol = iCol;

      iCol++;
      setItem( i, iCol, itemChapter );
      _iChapterCol = iCol;

      iCol++;
      setItem( i, iCol, itemWord );
      _iWordCol = iCol;
      
      iCol++;
      setItem( i, iCol, itemVersion );
      _iVersionCol = iCol;

      //

      resizeRowToContents( i ); 
   }
      
   resizeRowsToContents( );
   scrollToTop( );

   //
   
   connect( this, SIGNAL(cellClicked(int,int)), this,
         SLOT(cellSelected(int,int)));

//PIX_EXIT:
   return;            
}

void hikari_search_result::cellSelected( int row, int /* column */ )
{
   showResult( row );

   return;            
}


void hikari_search_result::showResult( int iRow )
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   bool bOK;
   int iBook, iChapter, iVerse, iVersion;
   
   QTableWidgetItem *itemBook = NULL;
   QTableWidgetItem *itemChapter = NULL;
   QTableWidgetItem *itemWord = NULL;
   QTableWidgetItem *itemVersion = NULL;

   if( 0 > iRow ) {
      goto PIX_EXIT;
   }

   disconnect( this, SIGNAL(cellClicked(int,int)), this, NULL );

   itemBook = item( iRow, _iBookCol );
   itemChapter = item( iRow, _iChapterCol );
   itemWord = item( iRow, _iWordCol );
   itemVersion = item( iRow, _iVersionCol );

   //
    
   iBook = itemBook->data( Qt::UserRole ).toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

   iChapter = itemChapter->data( Qt::UserRole ).toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

   iVerse = itemWord->data( Qt::UserRole ).toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

   iVersion = itemVersion->data( Qt::UserRole ).toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }

   //

   pContent->SetBibleContent( iBook, iChapter );

   pMain->ShowContent( );
   pMain->SelectBibleVerse( iVerse );

   connect( this, SIGNAL(cellClicked(int,int)), this,
         SLOT(cellSelected(int,int)));

PIX_EXIT:
   return;
}