#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"
#include "hikari_window.h"
#include "hikari_view.h"

hikari_view::hikari_view(QWidget *parent)
    : QTableWidget(parent)
{
   _bTableInitialized = false;
}

//
// two image panes must be of same width!
//
void hikari_view::resizeEvent( QResizeEvent * /*ev*/ )
{
   hikari_window *pMain = GetParent( );

   if( !_bTableInitialized ) {
      goto PIX_EXIT;
   }

   SetTableColumns( );
   createActions( );

   pMain->ShowContent( );

PIX_EXIT:
   return;
}

//
// when some bible chapter is shown, select specific verse(s)
//

void hikari_view::SelectBibleVerse( int iVerse )// [i] verse number starting from 1
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   bool bFound, bOK;
   int iRowVerse, i, nRows, nCol;
   QTableWidgetItem *it;
   int iContent = pContent->GetContent( );

   switch( iContent ) {
   case pixq_Properties::ContentOldTestament: 
   case pixq_Properties::ContentNewTestament:
      break;

   case pixq_Properties::ContentDevotion:
   default:
      goto PIX_EXIT;
      break;
   }

   //

   clearSelection( );

   nRows = rowCount( );
   nCol = columnCount( );

   // verse number is set as userRole of all items

   //setSelectionBehavior( QAbstractItemView::SelectRows );
   setSelectionBehavior( QAbstractItemView::SelectItems );

   bFound = false;
   for( i = 0 ; !bFound && i < nRows ; i++ ) {
      it = item( i, 0 );
      iRowVerse = it->data( Qt::UserRole ).toInt( &bOK );
      if( !bOK ) continue;

      if( iRowVerse == iVerse ) {
         scrollToItem( it, QAbstractItemView::PositionAtTop );
         selectRow( i );
         bFound = true;
      }
   }

PIX_EXIT:
   return;
}

//
void hikari_view::SetTableColumns( void )
{
   hikari_window *pMain = GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   bool bVerseSep = pEnv->_HikariViewVersesSeparateColumn.GetBool( );

   int k, nTableWidth, nColWidth, nCols, nScrollWidth;
   QSize sz, scroll_sz;
   QScrollBar *vert;
   double dRatioWidth, dSumWidth, dActiveWidth;
   vector<double> vdWidth;

   if( !_bTableInitialized ) {
      goto PIX_EXIT;
   }

   // scroll bar

   setHorizontalScrollBarPolicy( Qt::ScrollBarAlwaysOff );
   setVerticalScrollBarPolicy( Qt::ScrollBarAlwaysOn );

   vert = verticalScrollBar( );
   scroll_sz = vert->size( );
   nScrollWidth = scroll_sz.width( );

   //

   nCols = columnCount( );
   
   vdWidth.clear( );
   if( 1 == _nVersions ) {
      if( bVerseSep ) {
         vdWidth.push_back( 10.0 );
         vdWidth.push_back( 90.0 );
      } else {
         vdWidth.push_back( 100.0 );
      }
   } else {
      if( bVerseSep ) {
         vdWidth.push_back( 10.0 );
         vdWidth.push_back( 45.0 );
         vdWidth.push_back( 45.0 );
      } else {
         vdWidth.push_back( 50.0 );
         vdWidth.push_back( 50.0 );
      }
   }
   
   // set table width
   
   sz = size( );
   nTableWidth = sz.width( );
   dActiveWidth = (double)( nTableWidth - nScrollWidth ) * 0.99;

   // set width of each column

   dSumWidth = 0.0;
   for( k = 0 ; k < nCols ; k++ ) {
      dSumWidth = dSumWidth + vdWidth.at( k );
   }

   for( k = 0 ; k < nCols ; k++ ) {
      dRatioWidth = vdWidth.at( k ) / dSumWidth;
      nColWidth = (int)( dActiveWidth * dRatioWidth );
      setColumnWidth( k, nColWidth );
   }

PIX_EXIT:
   return;
}
   
void hikari_view::SetColumnCount( void )
{
   hikari_window *pMain = GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   bool bVerseSep = pEnv->_HikariViewVersesSeparateColumn.GetBool( );

   if( !_bTableInitialized ) {
      goto PIX_EXIT;
   }

   if( 1 == _nVersions ) {
      if( bVerseSep ) {
         setColumnCount( 2 );
      } else {
         setColumnCount( 1 );
      }
   } else {
      if( bVerseSep ) {
         setColumnCount( 3 );
      } else {
         setColumnCount( 2 );
      }
   }  

PIX_EXIT:
   return;
}

void hikari_view::SetTableStyles( void )
{
   QString style;

   // set table style
   
   style = "QTableWidget::item { ";
   style += " padding-bottom:2px; ";
   style += " padding-top:2px; ";
   style += " padding-left:2px; ";
   style += " padding-right:2px; ";
   //style += " background-color: green; ";
   //style += " selection-color: yellow; ";
   style += " }";

   setStyleSheet( style );

   style = "QTableWidget::item:hover { ";
   style += "color: black; ";
   style += " background-color: rgb( 191, 191, 255 ); ";
   style += " }";

   style += "QTableWidget::item:selected { ";
   style += "color: white; ";
   style += "background-color: rgb( 63, 63, 63 ); ";
   style += " }";


   setStyleSheet( style );

   return;
}

void hikari_view::SetTableFonts( QFont *fn0, QFont *fn1 )
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );

   bool bJapanese;
   int iContent, k, iVer[2];
   QFont *fn[2];

   iContent = pContent->GetContent( );

   switch( iContent ) {
   case pixq_Properties::ContentOldTestament: 
   case pixq_Properties::ContentNewTestament:
   iVer[0] = pEnv->_HikariBibleVersion.iGet( );
   iVer[1] = pEnv->_HikariBibleSecondVersion.iGet( );
      break;

   case pixq_Properties::ContentDevotion:
      iVer[0] = pEnv->_HikariBagsterBibleVer.iGet( );
      iVer[1] = pEnv->_HikariBagster2ndBibleVer.iGet( );
      break;

   default:
      goto PIX_EXIT;
      break;
   }

   fn[0] = fn0;
   fn[1] = fn1;

   for( k = 0 ; k < 2 ; k++ ) {
      bJapanese = pixq_Properties::BibleVersionJapanese( iVer[k] );
      if( bJapanese ) {
         *fn[k] = pEnv->_HikariViewHikariJpFont.lfGet( );
      } else {
         *fn[k] = pEnv->_HikariViewHikariEnFont.lfGet( );
      }
   
      fn[k]->setStretch( QFont::SemiCondensed );
   }

PIX_EXIT:
   return;
}

//
// set two version in table
//
void hikari_view::SetBibleContent( int nVersions, // [i] 1 or 2
                                  int iChapter,
                                  QList<int> &iVerseNum, 
                                  QStringList &vstrLines1,
                                  QStringList &vstrLines2 )
{
   hikari_window *pMain = GetParent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   int i, iVerse, nVerseLines, k, kk, iCol, nLineSize[2], nLines;

   QStringList *pLines[2];
   QString strChapter, strData[2], strVerse;
   bool bVerseSep = pEnv->_HikariViewVersesSeparateColumn.GetBool( );
   int iShowVerse = pEnv->_HikariViewShowVerseNum.iGet( );
   bool bDrawGrid = pEnv->_HikariViewShowTableLines.GetBool( );
   QFont fn[2];

   _bTableInitialized = false;
   
   //
   
   SetTableFonts( &fn[0], &fn[1] );

   pLines[0] = &vstrLines1;
   pLines[1] = &vstrLines2;

   // set up table

   _bTableInitialized = true;
   _nVersions = nVersions;
   SetColumnCount( ); 
   SetTableColumns( );

   SetTableStyles( );

   if( bDrawGrid ) {
      setShowGrid( true );
   } else {
      setShowGrid( false );
   }

   //

   horizontalHeader( )->hide( );
   verticalHeader( )->hide( );

   setSelectionMode( QAbstractItemView::ExtendedSelection );
   //setSelectionMode( QAbstractItemView::SingleSelection );
   setSelectionBehavior( QAbstractItemView::SelectItems );

  //setEditTriggers( QAbstractItemView::SelectedClicked );

   // set each line

   nLineSize[0] = 0;
   nLineSize[1] = 0;
   for( k = 0 ; k < nVersions ; k++ ) {
      nLineSize[k] = (int)pLines[k]->size( );
   }
   nLines = max( nLineSize[0], nLineSize[1] );

   // check!
#ifdef _DEBUG
   if( 2 == nVersions ) {
      if( nLineSize[0] != nLineSize[1] ) {
         hikari_content *pContent = pMain->GetContent( );
         int iVersion = pEnv->_HikariBibleVersion.iGet( );
         int i2Version = pEnv->_HikariBibleSecondVersion.iGet( );
         int iBook = pContent->GetBook( );
         int iChapter = pContent->GetBookChapter( );
         QString strFunction = "hikari_view::SetBibleContent";
         QString strError;         
         strError.sprintf( "ERROR! Numbers of Verse do not Match:\n"
            "Vers:%d/%d Book=%d Chp=%d",
            iVersion, i2Version,
            iBook, iChapter );
         QMessageBox::critical( NULL, strFunction, strError );
         goto PIX_EXIT;
      }
   }
#endif // _DEBUG
   
   // precaustion, unnecesary

   if( 2 == nVersions ) {
      for( k = 0 ; k < nVersions ; k++ ) {
         if( nLines == nLineSize[k] ) continue;
         for( kk = nLineSize[k] ; kk < nLines ; kk++ ) {
            pLines[k]->push_back( "-" );
         }
      }
      //
      nVerseLines = iVerseNum.size( );
      for( kk = nVerseLines ; kk < nLines ; kk++ ) {
         iVerseNum.push_back( kk );
      }
   }

   //

   setRowCount( nLines );
   
   for( i = 0 ; i < nLines ; i++ ) {

      QTableWidgetItem *itemVerse = new QTableWidgetItem( );
      //QPlainTextEdit *itemData[2];
      QTableWidgetItem *itemData[2];

      for( k = 0 ; k < nVersions ; k++ ) {
         strData[k] = pLines[k]->at( i );
         itemData[k] = new QTableWidgetItem( );
         //itemData[k] = new QPlainTextEdit( );
         //
         itemData[k]->setTextAlignment( Qt::AlignTop | Qt::AlignLeft );
         //itemData[k]->setFlags( itemData[k]->flags() & ~Qt::ItemIsSelectable );
         itemData[k]->setFlags( itemData[k]->flags() & ~Qt::ItemIsEditable );
         //itemData[k]->setFlags( itemData[k]->flags() & Qt::ItemIsEnabled );
         itemData[k]->setFont( fn[k] );   
      }

      // split verse number from verses
      // set verse at the item's user data

      iVerse = iVerseNum.at( i );
      switch( iShowVerse ) {
      case pixq_Properties::VerseNumberVerse:
         strChapter.sprintf( "%d", iVerse );
         break;

      case pixq_Properties::VerseNumberChapterVerse:
         strChapter.sprintf( "%d:%d", iChapter, iVerse );
         break;

      default:
         strChapter.clear( );
         break;
      }

      if( bVerseSep ) {
         itemVerse->setTextAlignment( Qt::AlignTop | Qt::AlignRight );
         //itemVerse->setFlags( itemVerse->flags() & ~Qt::ItemIsSelectable );
         itemVerse->setFlags( itemVerse->flags() & ~Qt::ItemIsEditable );
         //itemVerse->setFlags( itemVerse->flags() & Qt::ItemIsEnabled );
         itemVerse->setFont( fn[0] );
         itemVerse->setText( strChapter );
         itemVerse->setData( Qt::UserRole, iVerse );
         //
         for( k = 0 ; k < nVersions ; k++ ) {
            itemData[k]->setText( strData[k] );  
            itemData[k]->setData( Qt::UserRole, iVerse );
         }
      } else {
         for( k = 0 ; k < nVersions ; k++ ) {
            strVerse = strChapter + " " + strData[k];
            itemData[k]->setText( strVerse );    
            itemData[k]->setData( Qt::UserRole, iVerse ); 
         }
      }

      //
            
      iCol = 0;
      if( bVerseSep ) {
         setItem( i, iCol, itemVerse );
         iCol++;
      }

      for( k = 0 ; k < nVersions ; k++ ) {
         setItem( i, iCol, itemData[k] ); 
         iCol++;
      }
     
      //

      resizeRowToContents( i ); 
   }
      
   resizeRowsToContents( );
   scrollToTop( );

PIX_EXIT:
   return;            
}

//
// set two version in table
//
void hikari_view::SetDaysWords( int nVersions, // [i] 1 or 2
                              const QStringList *vstrLines1,
                              const QStringList *vstrLines2 )
{
   hikari_window *pMain = GetParent( );
   bool bJapanese[2];
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   int iVerse, nVerses, i, k, j, iCol, nLines, iVer[2];
   QString strBook, strVerseSeparater, strSeparater[2], strData[2]; 
   QString strSplitBook, strVerse, strSplitVerse[2];

   bool bVerseSep = pEnv->_HikariViewVersesSeparateColumn.GetBool( );
   bool bDrawGrid = pEnv->_HikariViewShowTableLines.GetBool( );
   QFont fn[2];

   const QStringList *pLines[2];

   QStringList strVerses[2], strBooks[2];

   _bTableInitialized = false;
   
   //
   
   SetTableFonts( &fn[0], &fn[1] );

   pLines[0] = vstrLines1;
   pLines[1] = vstrLines2;

   iVer[0] = pEnv->_HikariBagsterBibleVer.iGet( );
   iVer[1] = pEnv->_HikariBagster2ndBibleVer.iGet( );

   for( k = 0 ; k < 2 ; k++ ) {
      bJapanese[k] = pixq_Properties::BibleVersionJapanese( iVer[k] );
      if( bJapanese[k] ) {
         strSeparater[k] = "  ";
      } else {
         strSeparater[k] = "  ";
      }
   }
   
   if( bJapanese[0] ) {
      strVerseSeparater = "\n";
   } else {
      strVerseSeparater = "\n";
   }

   // set up table

   _bTableInitialized = true;
   _nVersions = nVersions;
   SetColumnCount( ); 
   SetTableColumns( );

   SetTableStyles( );

   if( bDrawGrid ) {
      setShowGrid( true );
   } else {
      setShowGrid( false );
   }

   //

   horizontalHeader( )->hide( );
   verticalHeader( )->hide( );

   setSelectionMode( QAbstractItemView::ExtendedSelection );
   setSelectionBehavior( QAbstractItemView::SelectItems );

   // set each line

   nLines = (int)vstrLines1->size( );
   setRowCount( nLines );
   
   iVerse = -1;
   for( i = 0 ; i < nLines ; i++ ) {

      QTableWidgetItem *itemVerse = new QTableWidgetItem( );
      QTableWidgetItem *itemData[2];
      for( k = 0 ; k < nVersions ; k++ ) {
         itemData[k] = new QTableWidgetItem( );
         strData[k] = pLines[k]->at( i );
      }

      // split words to lists of verses and book names  

      for( k = 0 ; k < nVersions ; k++ ) {
         if( !SplitBagsterLine_PC( strData[k], strVerses[k], strBooks[k] ) ) {
            goto PIX_EXIT;
         }
      }

      strSplitVerse[0].clear( );
      strSplitVerse[1].clear( );
      strSplitBook.clear( );
      nVerses = (int)strBooks[0].size( );
      
      for( j = 0 ; j < nVerses ; j++ ) {
         if( 0 < j ) {
            for( k = 0 ; k < nVersions ; k++ ) {
               strSplitVerse[k] = strSplitVerse[k] + strSeparater[k];
            }
            strSplitBook = strSplitBook + strVerseSeparater;
         }
         
         if( bVerseSep ) {
            //
            for( k = 0 ; k < nVersions ; k++ ) {
               strVerse = strVerses[k].at( j );
               strSplitVerse[k] = strSplitVerse[k] + strVerse;
            }        
            //
            strBook = strBooks[0].at( j );
            strSplitBook = strSplitBook + strBook;
         } else {
            for( k = 0 ; k < nVersions ; k++ ) {
               strVerse = strVerses[k].at( j );
               strBook = strBooks[k].at( j );
               strSplitVerse[k] = strSplitVerse[k] + strVerse;
               strSplitVerse[k] = strSplitVerse[k] + "[" + strBook + "]";}
         }
      }

      // set item userrole to -1 to indicate it is not chapter-verse data

      itemVerse->setTextAlignment( Qt::AlignTop | Qt::AlignRight );
      itemVerse->setFlags( itemVerse->flags() & ~Qt::ItemIsEditable );
      itemVerse->setFlags( itemVerse->flags() & ~Qt::ItemIsSelectable );
      itemVerse->setFlags( itemVerse->flags() & Qt::ItemIsEnabled );
      itemVerse->setFont( fn[0] );
      itemVerse->setText( strSplitBook );
      itemVerse->setData( Qt::UserRole, iVerse );

      for( k = 0 ; k < nVersions ; k++ ) {
         itemData[k]->setTextAlignment( Qt::AlignTop | Qt::AlignLeft );
         itemData[k]->setFlags( itemData[k]->flags() & ~Qt::ItemIsEditable );
         itemData[k]->setFlags( itemData[k]->flags() & ~Qt::ItemIsSelectable );
         itemData[k]->setFlags( itemData[k]->flags() & Qt::ItemIsEnabled );
         itemData[k]->setFont( fn[k] );
         itemData[k]->setText( strSplitVerse[k] );    
         itemData[k]->setData( Qt::UserRole, iVerse );
      }

      //
      
      iCol = 0;
      if( bVerseSep ) {
         setItem( i, iCol, itemVerse );
         iCol++;
      }
            
      for( k = 0 ; k < nVersions ; k++ ) {
         setItem( i, iCol, itemData[k] ); 
         iCol++;
      }
     
      //

      resizeRowToContents( i ); 
   }
      
   resizeRowsToContents( );
   scrollToTop( );

PIX_EXIT:
   return;
}

void hikari_view::createActions( void )
{
   QString strLabel;

   _shiori_store1_act = new QAction( tr( " 1" ), this );
   _shiori_store1_act->setData( (int)0 );
   //_shiori_store1_act->setCheckable( true );
   connect( _shiori_store1_act, SIGNAL(triggered()), this, SLOT(store_shiori()));

   _shiori_store2_act = new QAction( tr( " 2" ), this );
   _shiori_store2_act->setData( (int)1 );
   connect( _shiori_store2_act, SIGNAL(triggered()), this, SLOT(store_shiori()));
   
   _shiori_store3_act = new QAction( tr( " 3" ), this );
   _shiori_store3_act->setData( (int)2 );
   connect( _shiori_store3_act, SIGNAL(triggered()), this, SLOT(store_shiori()));

   _shiori_store4_act = new QAction( tr( " 4" ), this );
   _shiori_store4_act->setData( (int)3 );
   connect( _shiori_store4_act, SIGNAL(triggered()), this, SLOT(store_shiori()));
   
   _shiori_store5_act = new QAction( tr( " 5" ), this );
   _shiori_store5_act->setData( (int)4 );
   connect( _shiori_store5_act, SIGNAL(triggered()), this, SLOT(store_shiori()));

   _copy_act = new QAction( tr( "Rs[[Ctrl-C]" ), this );
   connect( _copy_act, SIGNAL(triggered()), this, SLOT(copy_verses()));

   return;
}

void hikari_view::store_shiori( void )
{
   hikari_window *pMain = GetParent( );
   QAction *action = qobject_cast<QAction *>(sender());
   int iShiori = action->data().toInt( );

    // action : inset shiori in this chapter

   switch( iShiori ) {
   case 0:
   case 1:
   case 2:
   case 3:
   case 4:
      pMain->StoreShiori( iShiori );
      break;
      
   default:
      goto PIX_EXIT;
      break;
    }

PIX_EXIT:
    return;
}

void hikari_view::copy_verses( void )
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   pixq_Properties *pEnv = pMain->GetHikariEnv( );
   BibleAllBooks *pBL = pMain->GetBibleBooks( );

   bool bFirst;
   int nCols, nRows, nSels, iRow0, iRow1, iCol0, iCol1;
   int i, k, iVer0, iVer1, iVerse0, iVerse1, iVersion[2];
   QTableWidgetSelectionRange range;
   QList<QTableWidgetSelectionRange> sel = selectedRanges( );
   QClipboard *clip;
   BibleBook bc;

   bool bBookName = pEnv->_HikariCopyIncludeBook.GetBool( );
   bool bVersionName = pEnv->_HikariCopyIncludeVersion.GetBool( );
   int iShowVerse = pEnv->_HikariCopyIncludeVerse.iGet( );
   bool bChangeLine = pEnv->_HikariCopyChangeLine.GetBool( );

   QString strHeader, strVersionName[2], strBookName[2];
   QString strChapter, strVerse, strBuffer;
   QStringList vstrLines[2];
   QList<int> iVerseNum[2];

   int nVersions = pEnv->_HikariVieBibleNum.iGet( );
   bool bVerseSep = pEnv->_HikariViewVersesSeparateColumn.GetBool( );

   int iContent = pContent->GetContent( );
   int iBook = pContent->GetBook( );
   int iChapter = pContent->GetBookChapter( );
   
   iVersion[0] = pEnv->_HikariBibleVersion.iGet( ); 
   iVersion[1] = pEnv->_HikariBibleSecondVersion.iGet( ); 

   bc = pBL->GetBook( iBook );
   strBookName[0] = bc.GetVersionBookName( iVersion[0] );
   strBookName[1] = bc.GetVersionBookName( iVersion[1] );

   strVersionName[0] = pixq_Properties::GetBibleVersionName( iVersion[0] );
   strVersionName[1] = pixq_Properties::GetBibleVersionName( iVersion[1] );

   switch( iContent ) {
   case pixq_Properties::ContentOldTestament: 
   case pixq_Properties::ContentNewTestament:
      break;

   case pixq_Properties::ContentDevotion:
   default:
      goto PIX_EXIT;
      break;
   }

   // copy verses into suystem's clipboard

   nSels = (int)sel.size( );
   if( 0 >= nSels ) goto PIX_EXIT;
  
   range = sel.at( 0 );
   nCols = range.columnCount( );
   nRows = range.rowCount( );
   if( 0 >= nCols ) goto PIX_EXIT;
   if( 0 >= nRows ) goto PIX_EXIT;

   iRow0 = range.topRow( );
   iRow1 = range.bottomRow( );
   iCol0 = range.leftColumn( );
   iCol1 = range.rightColumn( );

   if( bVerseSep ) {
      if( 0 == iCol1 ) {
         goto PIX_EXIT;
      }
      if( 1 >= iCol0 ) {
         iVer0 = 0;
      } else {
         iVer0 = 1;
      }
      if( 1 >= iCol1 ) {
         iVer1 = 0;
      } else {
         iVer1 = 1;
      }
   } else {
      iVer0 = iCol0;
      iVer1 = iCol1;
   }

   iVerse0 = iRow0;
   iVerse1 = iRow1;

   // get all verses in the string buffer

   for( k = 0 ; k < nVersions ; k++ ) {
      if( !pMain->GetChapterVerses( k, iBook, iChapter, iVerseNum[k], vstrLines[k] ) ) {
         goto PIX_EXIT;
      }
   }
  
   strBuffer.clear( );
   
   for( k = iVer0 ; k <= iVer1 ; k++ ) {
      //
      // add Enter between two version
      //
      if( k != iVer0 ) {
         strBuffer = strBuffer + tr("\n");
      }
      //
      // set book name
      //
      strHeader.clear( );
      if( bBookName ) {
         strHeader = strHeader + strBookName[k];         
      }
      //
      // set version name
      //
      if( bVersionName ) {
         strHeader = strHeader + tr("[");
         strHeader = strHeader + strVersionName[k];
         strHeader = strHeader + tr("]");
      }
      //
      if( !bChangeLine ) {
         switch( iShowVerse ) {
         case pixq_Properties::VerseNumberVerse:
            strChapter.sprintf( "%d-%d", iVerse0+1, iVerse1+1 );
            break;
         case pixq_Properties::VerseNumberChapterVerse:
            strChapter.sprintf( "%d:%d-%d", iChapter, iVerse0+1, iVerse1+1 );
            break;
         case pixq_Properties::VerseNumberNone:
         default:
            strChapter.clear( );
            break;
         }
         strHeader = strHeader + strChapter;
      }
      if( !strHeader.isEmpty( ) ) {
         strHeader = strHeader + tr("\n");
         strBuffer = strBuffer + strHeader;
      }

      //
      bFirst = true;
      for( i = iVerse0 ; i <= iVerse1 ; i++ ) {
         if( bChangeLine ) {
            if( !bFirst ) {
               strBuffer = strBuffer + tr("\n");
            }
         }
         //
         // include verse number
         //
         if( bChangeLine ) {
            switch( iShowVerse ) {
            case pixq_Properties::VerseNumberVerse:
               strChapter.sprintf( "%d ", i+1 );
               break;
            case pixq_Properties::VerseNumberChapterVerse:
               strChapter.sprintf( "%d:%d ", iChapter, i+1 );
               break;
            case pixq_Properties::VerseNumberNone:
            default:
               strChapter.clear( );
               break;
            }
            strBuffer = strBuffer + strChapter;
         }
         //
         strVerse = vstrLines[k].at( i );
         strBuffer = strBuffer + strVerse;
         bFirst = false;
      }
   }

   //

   clip = QApplication::clipboard( );
   clip->clear( );
   clip->setText( strBuffer );

PIX_EXIT:
   for( k = 0 ; k < nVersions ; k++ ) {
      vstrLines[k].clear( );
   }
    return;
}

//
// context menu
//
void hikari_view::contextMenuEvent(QContextMenuEvent *event)
{
   hikari_window *pMain = GetParent( );
   hikari_content *pContent = pMain->GetContent( );
   int iContent = pContent->GetContent( );

   QList<QTableWidgetSelectionRange> sel = selectedRanges( );
   int nSels = (int)sel.size( );

   QMenu menu(this);

   // set current page to shiori

   switch( iContent ) {
   case pixq_Properties::ContentOldTestament: 
   case pixq_Properties::ContentNewTestament:
      if( 0 < nSels ) {
         menu.addAction( _copy_act );
         menu.addSeparator( );
      }
      //
      menu.addAction( _shiori_store1_act );
      menu.addAction( _shiori_store2_act );
      menu.addAction( _shiori_store3_act );
      menu.addAction( _shiori_store4_act );
      menu.addAction( _shiori_store5_act );
      break;

   case pixq_Properties::ContentDevotion:
      break;

   default:
      goto PIX_EXIT;
      break;
   }

   // check current

   //_shiori_store1_act->setChecked( false );
   //_shiori_store2_act->setChecked( false );
   //_shiori_store3_act->setChecked( false );   
   //_shiori_store4_act->setChecked( false );
   //_shiori_store5_act->setChecked( false );
   
   menu.exec(event->globalPos());

PIX_EXIT:
   return;
}

void hikari_view::keyPressEvent(QKeyEvent *event)
{
   hikari_window *pMain = GetParent( );

   switch (event->key()) {
   case Qt::Key_Left:
      pMain->ShowPrevContent( );
      break;

   case Qt::Key_Right:
      pMain->ShowNextContent( );
      break;

   case Qt::Key_F5:
      // refresh
      pMain->ShowContent( );
      break;

   case Qt::Key_C:
      // detect control -c
      if( Qt::ControlModifier == QApplication::keyboardModifiers( ) ) { 
         copy_verses( );
      }
      break;

   case Qt::Key_Plus:
   case Qt::Key_Minus:
   case Qt::Key_Space:
   case Qt::Key_Enter:
   case Qt::Key_Escape:
   case Qt::Key_Up:
   case Qt::Key_Down:
   default:
      break;
   }

   return;
}

//
// enable specific range of table rows and disable other rows
//
void hikari_view::EnableVerseRange( int iVerse0, // [i] verse number starting from 1
                                   int iVerse1 ) // [i] verse number starting from 1
{
   bool bFirst, bEnable, bOK;
   int nCols, iRowVerse, i, nRows, k;
   QTableWidgetItem *it;
   
   //
   
   nRows = rowCount( ); 
   nCols = columnCount( ); 
   
   bFirst = false;
   for( i = 0 ; i < nRows ; i++ ) {
      it = item( i, 0 );
      iRowVerse = it->data( Qt::UserRole ).toInt( &bOK );
      
      if( iRowVerse >= iVerse0 && iRowVerse <= iVerse1 ) {
         bEnable = true;
      } else {
         bEnable = false;
      }

      for( k = 0 ; k < nCols ; k++ ) {
         it = item( i, k );

         if( bEnable ) {
            it->setFlags( it->flags() & Qt::ItemIsEnabled );
            if( !bFirst ) {
               scrollToItem( it, QAbstractItemView::PositionAtTop );
               bFirst = true;
            }
         } else {            
            it->setFlags( it->flags() & ~Qt::ItemIsEnabled );
         }
      }

   }

//PIX_EXIT:
   return;            
}

void hikari_view::showEvent( QShowEvent * /*ev*/ )
{
   return;
}
