#pragma once

#include <QtCore>
#include <QApplication>
#include <QTableWidget>

class hikari_window;

class hikari_view: public QTableWidget
{
   Q_OBJECT

public:
   hikari_view(QWidget *parent = 0);

   void SetParent( hikari_window *pParent ) { _pParent = pParent; }
   hikari_window *GetParent( void ) { return _pParent; }

private slots:
    void store_shiori( void );
    void copy_verses( void );

protected:
    void contextMenuEvent(QContextMenuEvent *event);

private:
   int _nVersions;

private:
    QAction *_copy_act;

    QAction *_shiori_store1_act;
    QAction *_shiori_store2_act;
    QAction *_shiori_store3_act;
    QAction *_shiori_store4_act;
    QAction *_shiori_store5_act;

private:

   bool _bTableInitialized;
   hikari_window *_pParent;

   void SetTableColumns( void );
   void SetColumnCount( void );
    
private:
    void createActions( void );

protected:
   void showEvent(QShowEvent *event);
   void keyPressEvent(QKeyEvent *event);

public:
   void SetDaysWords( int nVersions, const QStringList *vstrLines1,
      const QStringList *vstrLines2 );
   
   void SetBibleContent( int nVersions, int iChapter,
      QList<int> &iVerseNum, 
      QStringList &vstrLines1,
      QStringList &vstrLines2 );

   void SetTableStyles( void );
   void SetTableFonts( QFont *fn0, QFont *fn1 );

   void SelectBibleVerse( int iVerse );
   void EnableVerseRange( int iVerse0, int iVerse1 );
   
protected:
   void resizeEvent( QResizeEvent* );
};
