﻿#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"
#include "hikari_window.h"
#include "ui_hikari_window.h"

QString hikari_window::_strOrganisation = "PixTopo";
QString hikari_window::_strApplication = "Hikari";

hikari_window::hikari_window(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::hikari_window)
{
   int iKanshSec;

   _bMainShown = false;

   // TEST

   QTextCodec::setCodecForCStrings(QTextCodec::codecForLocale());

   ui->setupUi(this);    
    
   _ContentsSplitter = new QSplitter( Qt::Vertical );
   _MainSplitter = new QSplitter( Qt::Horizontal );

   // properties

   _DailyEnv = new pixq_Properties;
   _DailyEnv->InitEnv( _strOrganisation, _strApplication );

   // make a list of all bible books

   _bl.Setup( );
      
   // start timer

   _iHikariBagsterTimerId = -1; 

   //  InitCurrentDay( );
   _LastCheckedTime = QDateTime::currentDateTime( );
   _bShownAmToday = false;
   _bShownPmToday = false;

   iKanshSec = 60 * 1000; //
   
   _iHikariBagsterTimerId = startTimer( iKanshSec );

   // software update
   _UpdateXmlReply = (QNetworkReply*)NULL;

   // *** menu ***

   // hide menu items for development

#ifdef _DEBUG
   ui->action_file_reset_all_options->setVisible( true );
   ui->menu_data->menuAction()->setVisible( true );
   ui->action_help_update_latest_version_xml->setVisible( true );
#else
   ui->action_file_reset_all_options->setVisible( false );
   ui->menu_data->menuAction()->setVisible( false );
   ui->action_help_update_latest_version_xml->setVisible( false );
#endif

   ui->action_help_hikari_usage->setVisible( true );

   // show the initial data
   
   _Content = new hikari_content;
   _Content->Set( _DailyEnv );
   _Content->InitCurrentDay( );
   
   _assistant_proc = (QProcess*)NULL;

   return;
}

//
// create main GUI
//
void hikari_window::CreateMain( void )
{
   int k;
   QIcon icon;
   QSize sz = size( );

#ifdef _USE_DOC_WIDGET
   QMainWindow *main = new QMainWindow( this );
   QMenu *menu_gamen = ui->menu_gamen;
   Qt::DockWidgetAreas yoko_areas = Qt::TopDockWidgetArea | Qt::BottomDockWidgetArea;
   Qt::DockWidgetAreas side_areas = Qt::LeftDockWidgetArea | Qt::RightDockWidgetArea;
#endif // _USE_DOC_WIDGET

   // GUI

   _Books = new hikari_books( this );
   _Books->SetParent( this );
   _Books->SetBooks( );
      
   //

   _strHeaderLabel = "********";

   _Header = new hikari_header_label( this );
   _Header->SetParent( this );

   _DataView = new hikari_view( this );
   _DataView->SetParent( this );
   
   _Chapters = new hikari_chapters( this );
   _Chapters->SetParent( this );
   _Chapters->Init( );
   
   // create control panel

   _Ctrl_Hikari = new hikari_ctrl;
   _Ctrl_Hikari->SetParent( this );
   _Ctrl_Hikari->Init( );
   
   // create mani splitters

   _ContentsSplitter->addWidget( _Header );
   _ContentsSplitter->addWidget( _DataView );
   _ContentsSplitter->addWidget( _Chapters );
#ifdef _USE_DOC_WIDGET
#else
   _ContentsSplitter->addWidget( _Ctrl_Hikari );
#endif // _USE_DOC_WIDGET

   _ContentsSplitter->setStretchFactor( 0, 0 );
   _ContentsSplitter->setStretchFactor( 1, 0 );
   _ContentsSplitter->setStretchFactor( 2, 0 );
#ifdef _USE_DOC_WIDGET
#else
   _ContentsSplitter->setStretchFactor( 3, 0 );
#endif // _USE_DOC_WIDGET

   _ContentsSplitter->setCollapsible( 0, false );
   _ContentsSplitter->setCollapsible( 1, false );
   _ContentsSplitter->setCollapsible( 2, false );
#ifdef _USE_DOC_WIDGET
#else
   _ContentsSplitter->setCollapsible( 3, false );
#endif // _USE_DOC_WIDGET

   _ContentsSplitter->setHandleWidth( 2 );

   // create main splitter

#ifdef _USE_DOC_WIDGET
   main->setCentralWidget( _ContentsSplitter );
   main->setWindowFlags( Qt::Widget );
   setCentralWidget( main );
#else
   _MainSplitter->addWidget( _Books );
   _MainSplitter->addWidget( _ContentsSplitter );
   _MainSplitter->setHandleWidth( 2 );
   _MainSplitter->setStretchFactor( 0, 1 );
   _MainSplitter->setStretchFactor( 1, 1 );
   _MainSplitter->setCollapsible( 0, false );
   _MainSplitter->setCollapsible( 1, false );

   setCentralWidget( _MainSplitter );
#endif // _USE_DOC_WIDGET
   

   // *** add docks ***
   //
   // notes:
   // using main-> for _Ctrl_Dock_Hikari is a trick to show books
   // for the full height
   //

   // docking control panel 

#ifdef _USE_DOC_WIDGET
   _Ctrl_Dock_Hikari = new QDockWidget( "Control Panel", main ); 
   _Ctrl_Dock_Hikari->setAllowedAreas( yoko_areas );  
   _Ctrl_Dock_Hikari->setWidget( _Ctrl_Hikari ); 
   _Ctrl_Dock_Hikari->setMinimumHeight( 200 );  
   _Ctrl_Dock_Hikari->setMaximumHeight( 400 ); 
   _Ctrl_Dock_Hikari->setFloating( false ); 
   _Ctrl_Dock_Hikari->hide( ); 

   main->addDockWidget( Qt::BottomDockWidgetArea, _Ctrl_Dock_Hikari ); 
   _Ctrl_Hikari->SetDock( _Ctrl_Dock_Hikari ); 
#endif // _USE_DOC_WIDGET

   // docking books panel 

#ifdef _USE_DOC_WIDGET
   _Ctrl_Dock_Books = new QDockWidget( "Books", main ); 
   _Ctrl_Dock_Books->setAllowedAreas( side_areas );  
   _Ctrl_Dock_Books->setWidget( _Books ); 
   _Ctrl_Dock_Books->setMinimumWidth( 120 );  
   _Ctrl_Dock_Books->setMaximumWidth( 400 ); 
   _Ctrl_Dock_Books->setFloating( false ); 
   _Ctrl_Dock_Books->show( ); 

   addDockWidget( Qt::LeftDockWidgetArea, _Ctrl_Dock_Books ); 
#endif // _USE_DOC_WIDGET

   // menu gamen
   
#ifdef _USE_DOC_WIDGET
   SetDockLabels( );
   menu_gamen->addSeparator( ); 
   menu_gamen->addAction( _Ctrl_Dock_Hikari->toggleViewAction( ) ); 
   menu_gamen->addAction( _Ctrl_Dock_Books->toggleViewAction( ) ); 
   //ui->menu_gamen->menuAction()->setVisible( true );
#else
   ui->menu_gamen->menuAction()->setVisible( false );
#endif // _USE_DOC_WIDGET

   // create status bar

   for( k = 0 ; k < 3 ; k++ ) {
      _statusLabel[k] = new QLabel( "Hikari", this );
      _statusLabel[k]->setFrameShape( QFrame::Panel );
      _statusLabel[k]->setFrameStyle( QFrame::Plain );
      _statusLabel[k]->setLineWidth( 2 );
   }

   statusBar()->addPermanentWidget( _statusLabel[0], 1 );
   statusBar()->addPermanentWidget( _statusLabel[1], 1 );
   statusBar()->addPermanentWidget( _statusLabel[2], 1 );

   // *** tray icon ***

#ifdef _USE_TRAY_ICON
   createTrayIcon();

   icon = QIcon( ":/images/ehagaki2x.png" );
   setWindowIcon( icon );

   _trayIcon->setIcon( icon );
   _trayIcon->setToolTip( _strApplication );
   _trayIcon->show( );
#endif // _USE_TRAY_ICON

   // *** create meanu and actions

   setWindowTitle( _strApplication );

   CreateToolBars( );

   //
   
   SetShioriMenu( );

   // restore last window gometry

   readSettings( );

   ShowContent( );

   return;
}

hikari_window::~hikari_window() 
{
   delete ui;
    
   if( _DailyEnv ) {
      delete _DailyEnv;
      _DailyEnv = NULL;
   }

   if ( _assistant_proc ) {
      if( QProcess::Running == _assistant_proc->state() ) {
         _assistant_proc->terminate();
         _assistant_proc->waitForFinished(3000);
      }
      delete _assistant_proc;
      _assistant_proc = NULL;
   }

   return;
}

void hikari_window::CreateToolBars( void )
{
   // main tool bar

   ui->mainToolBar->addAction( ui->action_file_old_testament );
   ui->mainToolBar->addAction( ui->action_file_new_testament );
   ui->mainToolBar->addAction( ui->action_file_devotion );
   ui->mainToolBar->addAction( ui->action_file_options );
   //ui->mainToolBar->addAction( ui->action_file_close );

   ui->mainToolBar->addSeparator( );

   ui->mainToolBar->addAction( ui->action_view_previous_words );
   ui->mainToolBar->addAction( ui->action_view_next_words );

   ui->mainToolBar->addSeparator( );

   ui->mainToolBar->addAction( ui->action_view_show_one_version );
   ui->mainToolBar->addAction( ui->action_view_show_two_versions );

   ui->mainToolBar->addAction( ui->action_view_verse_same_column );
   ui->mainToolBar->addAction( ui->action_view_verse_separate_column );

   ui->mainToolBar->addSeparator( );

   ui->mainToolBar->addAction( ui->action_gamen_search_word );
   ui->mainToolBar->addAction( ui->action_gamen_bible_plan );

   return;
}

void hikari_window::iconActivated(QSystemTrayIcon::ActivationReason reason)
{
   switch (reason) {
   case QSystemTrayIcon::Trigger:
      break;

   case QSystemTrayIcon::DoubleClick:
      show( );
      break; 

   case QSystemTrayIcon::MiddleClick:
      break;
   default:
      break;
   }

   return;
}

//
// make icons and set up menu in the system tray icon
//
#ifdef _USE_TRAY_ICON
void hikari_window::createTrayIcon( void )
{
   QIcon icon_restore, icon_exit;

   // *** action from tray icon menu ***

   _trayRestoreAction = new QAction( tr("開く"), this );
   connect( _trayRestoreAction, SIGNAL(triggered()), this, SLOT( show( ) ) );

   _trayQuitAction = new QAction( tr("終了"), this );
   connect( _trayQuitAction, SIGNAL(triggered()), qApp, SLOT( quit( ) ) );

   SetTrayIconLabels( );

   // *** tray icon menu ***

   _trayIconMenu = new QMenu( this );
   _trayIconMenu->addAction( _trayRestoreAction );
   _trayIconMenu->addAction( _trayQuitAction );

   // set icon

   icon_restore = QIcon( ":/images/format-indent-less.png" );
   icon_exit = QIcon( ":/images/system-log-out.png" );

   _trayRestoreAction->setIcon( icon_restore );
   _trayQuitAction->setIcon( icon_exit );

   // *** tray icon menu ***

   _trayIcon = new QSystemTrayIcon( this );
   _trayIcon->setContextMenu( _trayIconMenu );
   
   _trayRestoreAction->setEnabled( true );
   _trayQuitAction->setEnabled( true );

   connect( _trayIcon, SIGNAL(activated(QSystemTrayIcon::ActivationReason)), this, 
      SLOT(iconActivated(QSystemTrayIcon::ActivationReason)));

   return;
}
#endif // _USE_TRAY_ICON

void hikari_window::timerEvent( QTimerEvent *ev )
{
   if( _iHikariBagsterTimerId == ev->timerId( ) ) {
      CheckTimer( );
   } else {
      QObject::timerEvent( ev );
   }

   return;
}

void hikari_window::resizeEvent( QResizeEvent * /* ev */ )
{ 
   int nSizes, nHeights[4];
   QList<int> sizes;

   QSize sz;
   QPoint ps;

   // height of each part

   if( !_bMainShown ) {
      goto PIX_EXIT;
   }

   sizes = _ContentsSplitter->sizes( );
   nSizes = (int)sizes.size( );
   if( 4 == nSizes ) {
      nHeights[0] = sizes.at( 0 );
      nHeights[1] = sizes.at( 1 );
      nHeights[2] = sizes.at( 2 );
      nHeights[3] = sizes.at( 3 );
   }

   sz = _DataView->size( );

PIX_EXIT:
   return;
}

void hikari_window::showEvent( QShowEvent * /*ev*/ )
{
   // wait until first show event!

   if( !_bMainShown ) { 
      CreateMain( );
   }

   _bMainShown = true;

   return;
}

void hikari_window::closeEvent( QCloseEvent * /* ev */ )
{
   // just hide the window in the task tray
   // do not exit

   close( );
   //hide( );
   //ev->ignore( );
  
   return;
}

void hikari_window::keyPressEvent(QKeyEvent *event)
{
   switch (event->key()) {
   case Qt::Key_Left:
      ShowPrevContent( );
      break;

   case Qt::Key_Right:
      ShowNextContent( );
      break;

   case Qt::Key_Plus:
   case Qt::Key_Minus:
   case Qt::Key_Space:
   case Qt::Key_Enter:
   case Qt::Key_Up:
   case Qt::Key_Down:
      break;

   case Qt::Key_Escape:
      //hide( );
      //close( );
      break;

   default:
      break;
   }

   return;
}

//***
//***
//*** File
//***
//***

void hikari_window::on_action_file_old_testament_triggered()
{
   int iContent = pixq_Properties::ContentOldTestament;
   ContentSelected( iContent );

   return; 
} 

void hikari_window::on_action_file_new_testament_triggered()
{ 
   int iContent = pixq_Properties::ContentNewTestament;
   ContentSelected( iContent );

   return;
}

void hikari_window::on_action_file_devotion_triggered()
{
   int iContent = pixq_Properties::ContentDevotion;
   ContentSelected( iContent );
 
   return;
} 

void hikari_window::on_action_file_options_triggered()
{
   ShowSetProperties( );
   
   return;
}

void hikari_window::on_action_file_reset_all_options_triggered()
{
   ResetAllProperties( );

   return;
}


void hikari_window::on_action_file_close_triggered()
{
   close( );
   
   return;
}

void hikari_window::on_action_file_exit_triggered()
{
   writeSettings( );
   qApp->quit( );
   
   return;
}

//***
//***
//*** 表示
//***
//***

void hikari_window::on_action_view_next_words_triggered()
{
   ShowNextContent( );

   return;
}

void hikari_window::on_action_view_previous_words_triggered()
{
   ShowPrevContent( );

   return;
}

void hikari_window::on_action_view_show_one_version_triggered()
{
   pixq_Properties *pEnv = GetHikariEnv( );
   int iVers = 1;

   pEnv->_HikariVieBibleNum.Set( iVers );
   pEnv->SetRegEnv( _strOrganisation, _strApplication );

   ShowContent( );
   
   return;
}

void hikari_window::on_action_view_show_two_versions_triggered()
{
   pixq_Properties *pEnv = GetHikariEnv( );
   int iVers = 2;

   pEnv->_HikariVieBibleNum.Set( iVers );
   pEnv->SetRegEnv( _strOrganisation, _strApplication );

   ShowContent( );

   return;
}

void hikari_window::on_action_view_verse_same_column_triggered()
{
    pixq_Properties *pEnv = GetHikariEnv( );
    bool bVerseSep = false;

    pEnv->_HikariViewVersesSeparateColumn.Set( bVerseSep );
    pEnv->SetRegEnv( _strOrganisation, _strApplication );

    ShowContent( );
    return;
}

void hikari_window::on_action_view_verse_separate_column_triggered()
{
    pixq_Properties *pEnv = GetHikariEnv( );
    bool bVerseSep = true;

    pEnv->_HikariViewVersesSeparateColumn.Set( bVerseSep );
    pEnv->SetRegEnv( _strOrganisation, _strApplication );

    ShowContent( ); 
    
    return;
}

//***
//***
//*** Shiori ***
//***
//***

void hikari_window::on_action_shiori_store_1_triggered()
{
   StoreShiori( 0 );
}

void hikari_window::on_action_shiori_store_2_triggered()
{
   StoreShiori( 1 );
}

void hikari_window::on_action_shiori_store_3_triggered()
{
   StoreShiori( 2 );
}

void hikari_window::on_action_shiori_store_4_triggered()
{
   StoreShiori( 3 );
}

void hikari_window::on_action_shiori_store_5_triggered()
{
   StoreShiori( 4 );
}

void hikari_window::on_action_shiori_open_1_triggered()
{
   OpenShiori( 0 );
}

void hikari_window::on_action_shiori_open_2_triggered()
{
   OpenShiori( 1 );
}

void hikari_window::on_action_shiori_open_3_triggered()
{
   OpenShiori( 2 );
}

void hikari_window::on_action_shiori_open_4_triggered()
{
   OpenShiori( 3 );
}

void hikari_window::on_action_shiori_open_5_triggered()
{
   OpenShiori( 4 );
}

//***
//***
//*** Gamen ***
//***
//***

void hikari_window::on_action_gamen_search_word_triggered()
{
   // show search  panel

   _Ctrl_Dock_Hikari->show( ); 
   _Ctrl_Hikari->SelectTabSearch( );

   return;
}

void hikari_window::on_action_gamen_bible_plan_triggered()
{
   // show bible plan panel

   _Ctrl_Dock_Hikari->show( ); 
   _Ctrl_Hikari->SelectTabPlan( );

    return;
}

//***
//***
//*** Data
//***
//***

void hikari_window::on_action_data_bible_to_xml_triggered()
{
   ConvertBibleToXml( );

   return;
}

void hikari_window::on_action_data_shinkai3_to_xml_triggered()
{
    ConvertShinkai3BibleXml( );

    return;
}

void hikari_window::on_action_data_read_bible_plan_triggered()
{
    CreateBibleReadPlan( );

    return;
}

void hikari_window::on_action_data_check_all_bible_single_xml_triggered()
{
   //
   // 
   //

   CheckAllBiblesSingleVer( );

   return;
}

void hikari_window::on_action_data_check_all_bible_dual_xml_triggered()
{
   CheckAllBiblesDoubleVer( );

    return;
}

//----------------

void hikari_window::on_action_data_check_all_bagster_data_triggered()
{
    //
    // Bagster�S�f�[�^�̃G���g���[�������v���Ă��邩�`�F�b�N
    //

   if( !CheckBagsterLineCount( ) ) {
      goto PIX_EXIT;
   }

PIX_EXIT:
   return;
}


void hikari_window::on_action_data_bagster_data_to_xml_triggered()
{
    CreateBagsterXmlFromTxt( );

    return;
}

void hikari_window::on_action_data_occasional_csv_to_xml_triggered()
{
    CreateOccasionsXmlFromCsv( );

    return;
}

void hikari_window::on_action_data_prepare_tabiji_data_triggered()
{
   CreateTabijiData( );

   return;
}

void hikari_window::on_action_data_prepare_category_kjv_triggered()
{
    CreateOccasionsData( );

    return;
}

//----------------

void hikari_window::on_action_data_torrey_topical_clean_up_triggered()
{
   CheckTorreyTopicalFile( );

   return;
}

void hikari_window::on_action_data_create_sample_mikotoba_list_triggered()
{

    CreateSampleMikotobaList( );
    return;
}

//
//
// *** Help ***
//
//

void hikari_window::on_action_help_about_hikari_triggered()
{
    pixq_Version ver = Version( _strApplication );
    ShowPixAbout_PC( &ver );

    return;
}

void hikari_window::on_action_help_hikari_usage_triggered()
{
   ShowDocumentation( );

   return;
}

void hikari_window::on_action_help_check_latest_version_triggered()
{
    //
   // check XML file of the website
   // get the latest version and tell the user if this is not the latest version
   //

   if( !ReadVersionXml( ) ) {
      goto PIX_EXIT;
   }

PIX_EXIT:
   return;
}

void hikari_window::on_action_help_update_latest_version_xml_triggered()
{
    if( !CreateVersionXml( ) ) {
       goto PIX_EXIT;
    }

 PIX_EXIT:
    return;
}
