//
// *** MainWindow ***
//

#pragma once

#include <QtCore>
#include <QtGui>
#include <QApplication>
#include <QNetworkAccessManager>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

QT_BEGIN_NAMESPACE
class QLabel;
class QDialogButtonBox;
class QFile;
class QLineEdit;
class QPushButton;
class QSslError;
class QAuthenticator;
class QNetworkReply;
QT_END_NAMESPACE

class hikari_view;
class hikari_ctrl;
class hikari_bagster;

class hikari_header_label;
class hikari_books;
class hikari_chapters;
class hikari_content;

namespace Ui {
    class hikari_window;
}

#define _USE_DOC_WIDGET 
#define _USE_TRAY_ICON

class hikari_window : public QMainWindow
{
    Q_OBJECT

public:
   enum {
      // 
      WordsTableSingle = 0,
      // 
      WordsTableDouble,
   } HikariBibleClumnFormat;

public:
   static QString _strOrganisation;
   static QString _strApplication;

public:
    explicit hikari_window(QWidget *parent = 0);
    ~hikari_window();

private:
    Ui::hikari_window *ui;

private:
    QString _strHeaderLabel;

    // 
    // ShowingContents
    short _sDisplayContents;

    // bile chaoters
   BibleAllBooks _bl;

   hikari_content *_Content;

   pixq_Properties *_DailyEnv;


   bool _bMainShown;

   //
   // controls
   //
   
   // status bar

   QLabel *_statusLabel[3];

   QSplitter *_MainSplitter;
   QSplitter *_ContentsSplitter;
   
   hikari_header_label *_Header;
   hikari_view *_DataView;
   hikari_ctrl *_Ctrl_Hikari;
   hikari_books  *_Books;
   hikari_chapters  *_Chapters;

#ifdef _USE_DOC_WIDGET
   QDockWidget *_Ctrl_Dock_Books; 
   QDockWidget *_Ctrl_Dock_Hikari; 
#endif // _USE_DOC_WIDGET

   // *** tray icon ***

#ifdef _USE_TRAY_ICON
   QSystemTrayIcon *_trayIcon;
   QMenu *_trayIconMenu;

   QAction *_trayRestoreAction;
   QAction *_trayQuitAction;
#endif // _USE_TRAY_ICON

   // for getting XML file from the net
   // to check the sofware update
   
   QNetworkAccessManager _UpdateXmlQnam;
   QNetworkReply *_UpdateXmlReply;

   // help
   QProcess *_assistant_proc;

   // timer
   int _iHikariBagsterTimerId;
   
   // last time hikari was shown by timer
   QDateTime _LastCheckedTime;
   bool _bShownAmToday;
   bool _bShownPmToday;

private slots:
    void on_action_file_old_testament_triggered();
    void on_action_file_new_testament_triggered();
    void on_action_file_devotion_triggered();
    void on_action_file_options_triggered();
    void on_action_file_close_triggered();
    void on_action_file_reset_all_options_triggered();
    void on_action_file_exit_triggered();

    void on_action_view_next_words_triggered();
    void on_action_view_previous_words_triggered();
    void on_action_view_show_one_version_triggered();
    void on_action_view_show_two_versions_triggered();
    void on_action_view_verse_same_column_triggered();
    void on_action_view_verse_separate_column_triggered();

    void on_action_shiori_store_1_triggered();
    void on_action_shiori_store_2_triggered();
    void on_action_shiori_store_3_triggered();
    void on_action_shiori_store_4_triggered();
    void on_action_shiori_store_5_triggered();
    void on_action_shiori_open_1_triggered();
    void on_action_shiori_open_2_triggered();
    void on_action_shiori_open_3_triggered();
    void on_action_shiori_open_4_triggered();
    void on_action_shiori_open_5_triggered();

    void on_action_gamen_search_word_triggered();
    void on_action_gamen_bible_plan_triggered();

    void on_action_data_bible_to_xml_triggered();
    void on_action_data_prepare_tabiji_data_triggered();
    void on_action_data_prepare_category_kjv_triggered();
    void on_action_data_occasional_csv_to_xml_triggered();
    void on_action_data_read_bible_plan_triggered();
    void on_action_data_create_sample_mikotoba_list_triggered();
    
    void on_action_data_torrey_topical_clean_up_triggered();
    void on_action_data_bagster_data_to_xml_triggered();
    void on_action_data_check_all_bagster_data_triggered();
    void on_action_data_check_all_bible_single_xml_triggered();
    void on_action_data_check_all_bible_dual_xml_triggered();
    void on_action_data_shinkai3_to_xml_triggered();

    void on_action_help_about_hikari_triggered();
    void on_action_help_check_latest_version_triggered();
    void on_action_help_hikari_usage_triggered();
    void on_action_help_update_latest_version_xml_triggered();

private slots:
    void iconActivated(QSystemTrayIcon::ActivationReason reason);

private slots:
    void httpFinished( void );
    void httpReadyRead( void );

protected:
   void closeEvent(QCloseEvent *event); 
   void keyPressEvent(QKeyEvent *event);
   void showEvent(QShowEvent *event);
   void resizeEvent( QResizeEvent* );
   void timerEvent(QTimerEvent *e);
  
private:
   void CreateMain( void );
   void downloadFile( void );
    
    /*
#ifdef QT_NO_OPENSSL
#else
    void sslErrors(QNetworkReply*,const QList<QSslError> &errors);
#endif
*/

public:
   //
   // each function to show content must be called from here!
   //
   void ShowContent( void );
   bool HikariSystemJapanese( );

private:
#ifdef _USE_TRAY_ICON
   void createTrayIcon( );
#endif // _USE_TRAY_ICON
   void CreateSampleMikotobaList( );

   bool CreateVersionXml( void );
   bool ReadVersionXml( void );

   void readSettings( void );
   void writeSettings( void );

   void CreateToolBars( void );

   bool ReadTorreyIndex( QStringList &strTitles );
   bool ReadTorreyBuffers( QStringList &strBuffers );
   bool CheckTorreyTopicalFile( void );

   void CreateBibleReadPlan( void );
   void SetMenuStatus( void );
   bool SetShioriMenu( void );

   bool ConvertBibleToXml( void );
   bool CheckAllBiblesSingleVer( void );
   bool CheckAllBiblesDoubleVer( void );

   bool ConvertShinkai3BibleXml( void );
   bool ConvertRaguetBibleXml( void );
   bool ConvertIsvBibleXml( void );
   bool CovertBibleVersionToXml( int iVersion );

   bool CreateTabijiData( void );

   bool CreateOccasionsData( void );
   bool CreateOccasionsXmlFromCsv( void );
   bool CreateBagsterXmlFromTxt( int iVersion );
   bool CreateBagsterXmlFromTxt( void );

   bool CheckBagsterLineCount( void );

   bool CreateOneTabiji( int iCategory, QStringList *strBuffers, 
      QTextStream *out );

   bool CreateOneOccasion( int iCategory, QStringList *strBuffers, 
      QTextStream *out );
  
   bool DecompOneOccasion( int iCategory, int iLine, QString *strBuffer,
      QTextStream *out );
  
   bool DecompOneTabiji( int iCategory, int iLine, QString *strBuffer,
      QTextStream *out );

   bool DecompTabijiVerse( QString *strVerse, int &iChapter,
      QVector<int> &viVerseList );

   void ShowNextDay( void );
   void ShowPrevDay( void );

   void ShowNextChapter( void );
   void ShowPrevChapter( void );

   void ShowNextOccasion( void );
   void ShowPrevOccasion( void );

   void SetChaptersStatusBar( void );
   void SetBagsterStatusBar( void );
   
   void ContentSelected( int iContent );

   bool GetShinkaiyakuBuffer( int iBook, int iChapter, 
      QVector<int> viVerseList, QString &strWords );

   bool GetShinkaiyakuBuffer( int iBook, int iChapter, 
      int iVerse, QString &strWords );

   bool GetKougoyakuBuffer( int iBook, int iChapter, 
      QVector<int> viVerseList, QString &strWords );

   bool GetKougoyakuBuffer( int iBook, int iChapter, 
      int iVerse, QString &strWords );

   bool GetKjvBuffer( int iBook, int iChapter, 
      QVector<int> viVerseList, QString &strWords );

   bool GetKjvBuffer( int iBook, int iChapter, 
      int iVerse, QString &strWords );

   bool DecodeCsvOccasion( QString *strBuffers, // [i]
      BibleOccasion *occ );

   void ShowBagsterDaysContent( void );

   void ShowBagsterOccContent( void );

   void SetTodaysWords( void );
   void ShowBagsterContent( void );
   bool ShowBibleContent( void );
   
   bool GetDaysXmlWords( QFile *file, int iMonth, int iDay, bool bAm, 
      QStringList *strLines );

   bool GetDaysTxtWords( QFile *file, int iMonth, int iDay, bool bAm, 
      QStringList *strLines );

   bool GetDaysWords( int iMonth, int iDay, bool bAm, int iVer,  
      QStringList *strLines );

   bool GetOccasionWords( QFile *file, int iOccasion, int iVer, QStringList *strLines );

   bool GetOccasionWords( int iOccasion, int iVer, 
      QStringList *strLines );

   bool FindAllOccEntries( int nEntries, int iVersion, QString &strLines,
      QXmlStreamReader &reader );

   QString GetShinkai2BookFile( int iBook );
   QString GetKougoBookFile( int iBook );
   QString GetKjvBookFile( int iBook );

   QString SetDateLabel( int iMonth, int iDay, bool bAm );

   void SetChaptersHeaderLabel( void );
   void SetBagsterDaysHeaderLabel( void );
   void SetBagsterOccHeaderLabel( void );
   void SetikariHeaderLabel( void );

   void ResetAllProperties( void );
   bool SearchWordVersion( int iVersion, int iSearchMode,
      QStringList strWords, BibleListVerse &res ); 

   bool SearchWordVerse( int iSearchMode, 
      QStringList strWords, 
      QString strVerse ); 

   //
   // common utility functions
   //

   void SetDisplayContents( short sContents ) { _sDisplayContents = sContents; }

   hikari_books *GetBooks( void ) { return _Books; }
   hikari_chapters *GetChapters( void ) { return _Chapters; }

   hikari_ctrl *GetControlPanel( void ) const { return _Ctrl_Hikari; }
   
   void CheckTimer( void );  
   void ShowDaysWords( void );

   void SetTrayIconLabels( void );
   void SetDockLabels( void );

public:
   //
   // data access
   //
   QString GetHeaderLabel( void ) { return _strHeaderLabel; }
   QSplitter *GetContentsSplitter( void )  { return _ContentsSplitter; }

   BibleAllBooks *GetBibleBooks( void ) { return &_bl; }
   pixq_Properties *GetHikariEnv( void ) { return _DailyEnv; }
   hikari_content *GetContent( void ) { return _Content; }
   
   bool GetChapterVerses( QFile *file, int iBook, int iChapter,
      QList<int> &iVerseNum, QStringList &vstrLines ); 
   bool GetChapterVerses( int iVer, int iBook, int iChapter, 
      QList<int> &iVerseNum, QStringList &vstrLines );

   void ShowNextContent( void );
   void ShowPrevContent( void );
   bool OpenShiori( int iShiori );
   void SelectBibleVerse( int iVerse );

   bool MakeCccasionsList( QStringList &strOccasions, 
      QStringList &strEnOccasions );

   void refreshPlanChart( void ) const;
   void EnableVerseRange( int iVerse0, int iVerse1 );
   bool StoreShiori( int iShiori );
   void ShowSetProperties( short sPage = -1 );
   void SearchWordStart( int iSearchMode, QStringList strWords, BibleListVerse &res ); 
   void CheckSearchCondition( int &nJpCount, int &nEnCount ); 

   bool StartAssistant( void );

   void SetStatusLabel( int iLabel, QString strLabel );
   void ShowDocumentation( void );
};

