#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"


#include "hikari_window.h"

//
// get occasion's in string list
//
bool hikari_window::GetOccasionWords( int iOccasion, 
                                     int iVer,
                                    QStringList *strLines )
{
   bool bRetCode = false;
   QString strError, strXmlFile;
   
   QFile *file = NULL;

   //_tsetlocale( LC_ALL, _T("Japanese_Japan.932"));

   strXmlFile = GetBagsterOccasionsXmlFile_PC( );

   file = new QFile( strXmlFile );
   if ( !file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      strError = "ERROR! Failed to open file " + strXmlFile + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   if( !GetOccasionWords( file, iOccasion, iVer, strLines ) ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}

static bool FindOccasion( int iOccasion, 
                          int &nLines, // [o]
                       QXmlStreamReader &reader ) // [i/o] 
{
   bool bRetCode = false;
   bool bFound, bStatus, bOK;
   int iValue;
   QString strName, strValue;
   QXmlStreamAttributes attr;
   
   bStatus = true;
   bFound = false;
   while( bStatus ) {

      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }
   
      // find the month
   
      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }
   
      strName = reader.name().toString( );
   
      if( "Occasion" != strName ) {
         continue;
      }

      attr = reader.attributes();
      strValue = attr.value( "ID" ).toString();
      iValue = strValue.toInt( &bOK );
      if( !bOK ) {
         bStatus = false;
         continue;
      }
   
      if( iValue == iOccasion ) {
         bStatus = false;
         bFound = true;
         
         strValue = attr.value( "MaxLine" ).toString();
         nLines = strValue.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }

         continue;
      }

      reader.skipCurrentElement();
      
   }

   if( ! bFound ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// hikari in xml
//
bool hikari_window::GetOccasionWords( QFile *file, // [i]
                                 int iOccasion,
                                 int iVer,
                                 QStringList *strLines ) // [o]
{
   bool bRetCode = false;
   int iVersion, nEntries, iLine, nLines, nSize, iValue;
   bool bOK, bStatus, bFound;
   QString strName, strWords, strValue, strLine;

#ifdef _DEBUG
   int iXmlLine;
#endif

   QXmlStreamReader reader;
   QXmlStreamAttributes attr;

   pixq_Properties *pEnv = GetHikariEnv( );

   if( 0 == iVer ) {
      iVersion = pEnv->_HikariBagsterBibleVer.iGet( );
   } else {
      iVersion = pEnv->_HikariBagster2ndBibleVer.iGet( );
   }

   //
   // check xml file
   //

   reader.setDevice( file );

   if( !reader.readNextStartElement( ) ) {
      goto PIX_EXIT;
   }

   if( reader.name() != "occasions" ) {
      goto PIX_EXIT;
   }

   if( reader.attributes().value("version") != "1.0") {
      goto PIX_EXIT;
   }

   //
	 
   if( !FindOccasion( iOccasion, nLines, reader ) ) {
      goto PIX_EXIT;
   }
   
   // get all words
   
   strLines->clear( );

   bStatus = true;
   bFound = false;
   while( bStatus ) {
      
      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }

      // find the month
   
#ifdef _DEBUG
      iXmlLine = reader.lineNumber( );
#endif
      
      reader.readNext( );

#ifdef _DEBUG
      iXmlLine = reader.lineNumber( );
#endif

  //    if( !reader.readNextStartElement()) {
  //       bStatus = false;
  //       continue;
  //    }
   
      strName = reader.name().toString( );
   
      if( "Line" != strName ) {
         continue;
      }

      attr = reader.attributes();

      strValue = attr.value( "ID" ).toString();
      iValue = strValue.toInt( &bOK );
      if( !bOK ) {
         bStatus = false;
         continue;
      }

      iLine = iValue;

      strValue = attr.value( "Size" ).toString();
      iValue = strValue.toInt( &bOK );
      if( !bOK ) {
         bStatus = false;
         continue;
      }

      nEntries = iValue;

      // read entries

      if( !FindAllOccEntries( nEntries, iVersion, strLine, reader ) ) {
         goto PIX_EXIT;
      } 

      strLines->push_back( strLine );

#ifdef _DEBUG
      iXmlLine = reader.lineNumber( );
#endif

      reader.skipCurrentElement();

#ifdef _DEBUG
      iXmlLine = reader.lineNumber( );
#endif

      //

      nSize = (int)strLines->size( );
      if( nSize >= nLines ) {
         bStatus = false;
         bFound = true;
         continue;
      }
   }

   if( !bFound ) {
      goto PIX_EXIT;
   }
       
#ifdef _DEBUG
   nSize = strLines->size( );
   for( int i = 0 ; i < nLines ; i++ ) {
      strWords = strLines->at( i );
   }
#endif

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}


//
// Bagster special occasions
//
static bool FindOccVersionEntries( int iVersion,
                                QString &strWords,
                                QXmlStreamReader &reader ) // [i/o] 
{
   bool bRetCode = false;
   bool bFound, bStatus;
   QString strName, strValue, strVersion, strVerses, strSource;
   QXmlStreamAttributes attr;
   
   // get all words

   switch( iVersion ) {     
   case pixq_Properties::BibleShinkaiyaku2: 
      strVersion = "Shin";
      break;
  
   case pixq_Properties::BibleKougoyaku:
      strVersion = "Kougo";
      break;
      
   case pixq_Properties::BibleKingJames:
      strVersion = "Kjv";
      break;
         
   default:
      goto PIX_EXIT;
      break;
   }

   bStatus = true;
   bFound = false;
   while( bStatus ) {
      
      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }

      reader.readNext( );
      
      strValue = reader.name( ).toString( );

      if( !reader.isStartElement( ) ) {
         continue;
      }

      if( strVersion == strValue ) {
         strWords = reader.readElementText( );
         bFound = true;
         bStatus = false;
      }
   }

   if( ! bFound ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// Bagster special occasions
//
bool hikari_window::FindAllOccEntries( int nEntries, // [o]
                                      int iVersion,
                                      QString &strLines,
                                      QXmlStreamReader &reader ) // [i/o] 
{
   bool bRetCode = false;
   bool bFound, bStatus, bOK;
   int i, nSize, iBook, iValue;
   QString strValue, strName, strWords, strLine, strSource, strChapter, strVerses;
   QXmlStreamAttributes attr;
   
   BibleAllBooks *pBL = GetBibleBooks( );
   bool bJapanese = pixq_Properties::BibleVersionJapanese( iVersion );

   QStringList strEntries;
   
   strEntries.clear( );

   bStatus = true;
   bFound = false;
   while( bStatus ) {

      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }
   
      // find the month
   
      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }
   
      strName = reader.name().toString( );
   
      if( "Entry" != strName ) {
         continue;
      }

      // get attributes

      attr = reader.attributes();

      strValue = attr.value( "ID" ).toString();
      iValue = strValue.toInt( &bOK );
      if( !bOK ) {
         bStatus = false;
         continue;
      }
   
      strValue = attr.value( "Book" ).toString();
      iBook = strValue.toInt( &bOK );
      if( !bOK ) {
         bStatus = false;
         continue;
      }
   
      strChapter = attr.value( "Chapter" ).toString();   
      strVerses = attr.value( "Verses" ).toString();

      // generate verse string

      strSource = "(";
      if( bJapanese ) {
         strSource = strSource + pBL->GetShinkaiName( iBook, 0 );
      } else {
         strSource = strSource + pBL->GetBookEnAbbrev( iBook, 0 );
      }
      strSource = strSource + strChapter;
      strSource = strSource + ":";
      strSource = strSource + strVerses;
      strSource = strSource + ")";

      //

      if( !FindOccVersionEntries( iVersion, strWords, reader ) ) {
         goto PIX_EXIT;
      } 

      strLine = strWords + strSource;
      strEntries.push_back( strLine );
      
      reader.skipCurrentElement();

      nSize = strEntries.size( );
      if( nSize >= nEntries ) {
         bStatus = false;
         bFound = true;
         continue;
      }
      
   }

   if( ! bFound ) {
      goto PIX_EXIT;
   }

   // create output line

   strLines.clear( );
   for( i = 0 ; i < nEntries ; i++ ) {
      strLine = strEntries.at( i );
      strLines = strLines + strLine + " ";
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

static bool bFindMonth( int iMonth, 
                       QXmlStreamReader &reader ) // [i/o] 
{
   bool bRetCode = false;
   bool bFound, bStatus, bOK;
   int iValue;
   QString strName, strValue;
   QXmlStreamAttributes attr;
   
   bStatus = true;
   bFound = false;
   while( bStatus ) {

      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }
   
      // find the month
   
      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }
   
      strName = reader.name().toString( );
   
      if( "Month" != strName ) {
         continue;
      }

      attr = reader.attributes();
      strValue = attr.value( "ID" ).toString();
      iValue = strValue.toInt( &bOK );
      if( !bOK ) {
         bStatus = false;
         continue;
      }
   
      if( iValue == iMonth ) {
         bStatus = false;
         bFound = true;
         continue;
      }

      reader.skipCurrentElement();
      
   }

   if( ! bFound ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

static bool bFindDay( int iDay, 
                       QXmlStreamReader &reader ) // [i/o] 
{
   bool bRetCode = false;
   bool bFound, bStatus, bOK;
   int iValue;
   QString strName, strValue;
   QXmlStreamAttributes attr;
   
   bStatus = true;
   bFound = false;
   while( bStatus ) {
	
      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }

      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }

      strName = reader.name().toString( );
   
      if( "Day" != strName ) {
         continue;
      }

      attr = reader.attributes();
      strValue = attr.value( "ID" ).toString();
      iValue = strValue.toInt( &bOK );
      if( !bOK ) {
         continue;
      }

      if( iValue == iDay ) {
         bFound = true;
         bStatus = false;
         continue;
      } 
      
      reader.skipCurrentElement();
   }

   if( ! bFound ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}


static bool bFindAmPm( bool bAm, 
                      int &nLines, // [o] number of lines
                       QXmlStreamReader &reader ) // [i/o] 
{
   bool bRetCode = false;
   bool bFound, bOK, bStatus;
   QString strName, strValue;
   QChar chValue, chAm;
   QXmlStreamAttributes attr;
   
   chAm = bAm ? 'A' : 'P';

   bStatus = true;
   bFound = false;
   while( bStatus ) {

      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }

      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }

      strName = reader.name().toString( );
   
      if( "AMPM" != strName ) {
         continue;
      }
      
      attr = reader.attributes();
      strValue = attr.value( "ID" ).toString();
      chValue = strValue.at( 0 );

      if( chValue == chAm ) {
         bFound = true;
         bStatus = false;
         
         strValue = attr.value( "Size" ).toString();
         nLines = strValue.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }

         continue;
      } 
      
      reader.skipCurrentElement();
   }

   if( ! bFound ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}   

//
// get todays words in string list
//
bool hikari_window::GetDaysWords( int iMonth, // [i] xml
                                    int iDay, 
                                    bool bAm,
                                    int iVer,  // [i] 0 or 1, bible version
                                    QStringList *strLines )
{
   bool bRetCode = false;
   QString strError, strDate, strDailyFile;
   pixq_Properties *pEnv = GetHikariEnv( );
   
   QFile *file = NULL;

   //_tsetlocale( LC_ALL, _T("Japanese_Japan.932"));

   strDailyFile = GetHikariBagsterDailyWordsFile_PC( pEnv, iVer );

   file = new QFile( strDailyFile );
   if ( !file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      strError = "ERROR! Failed to open file " + strDailyFile + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   if( !GetDaysXmlWords( file, iMonth, iDay, bAm, strLines ) ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}

//
// hikari in xml
//
bool hikari_window::GetDaysXmlWords( QFile *file, // [i] xml
                                 int iMonth,
                                 int iDay, 
                                 bool bAm,
                                 QStringList *strLines ) // [o]
{
   bool bRetCode = false;
   int nLines, nSize;
   bool bStatus, bFound;
   QString strWords, strValue;
   QXmlStreamReader reader;

   //
   // check xml file 
   //

   reader.setDevice( file );

   if( !reader.readNextStartElement( ) ) {
      goto PIX_EXIT;
   }

   if( reader.name() != "bagster" ) {
      goto PIX_EXIT;
   }

   if( reader.attributes().value("version") != "1.0") {
      goto PIX_EXIT;
   }

   //
	 
   if( !bFindMonth( iMonth, reader ) ) {
      goto PIX_EXIT;
   }

   if( !bFindDay( iDay, reader ) ) {
      goto PIX_EXIT;
   }

   if( !bFindAmPm( bAm, nLines, reader ) ) {
      goto PIX_EXIT;
   }
   
   // get all words
   
   strLines->clear( );
   bStatus = true;
   bFound = false;
   while( bStatus ) {
      
      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }

      reader.readNext( );

      if( !reader.isStartElement( ) ) {
         continue;
      }

      strValue = reader.name( ).toString( );
      if( "Words" == strValue ) {
         strWords = reader.readElementText( );
         strLines->push_back( strWords );
      }

      nSize = (int)strLines->size( );
      if( nSize >= nLines ) {
         bStatus = false;
         bFound = true;
         continue;
      }
   }

   if( !bFound ) {
      goto PIX_EXIT;
   }
       
#ifdef _DEBUG
   nSize = strLines->size( );
   for( int i = 0 ; i < nLines ; i++ ) {
      strWords = strLines->at( i );
   }
#endif

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// hikari file in formated txt
//
bool hikari_window::GetDaysTxtWords( QFile *file, // [i]
                                 int iMonth,
                                    int iDay, 
                                    bool bAm,
                                    QStringList *strLines ) // [o]
{
   bool bRetCode = false;
   bool bStatus, bFound;
   QString strDate, strBuffer, strRef;
   
   QTextStream *in = NULL;

   //

   in = new QTextStream( file );
   in->setCodec( "UTF-16" );
   //out->setGenerateByteOrderMark( true );

   //

   if( bAm ) {
      strDate.sprintf( "%02d%02dAM", iMonth, iDay );
   } else {
      strDate.sprintf( "%02d%02dPM", iMonth, iDay );
   }

   strLines->clear( );

   in->seek( 0 );

   bStatus = true;
   bFound = false;
   while( bStatus ) {
	
      if( in->atEnd( ) ) {
			bStatus = false;
	   	continue;
      }

      //
      // read sinlge line from file
      //
   	strBuffer = in->readLine( );

      if( strBuffer.isNull( ) ) {
			bStatus = false;
	   	continue;
	   }   
      
      if( bFound ) {
         if( strBuffer.startsWith( '#' ) ) {
            // end of the day's data
            bStatus = false;
            continue;
         } 
         
         strLines->push_back( strBuffer );

      } else {
         strRef = strBuffer.left( 6 );
         if( 0 == strRef.compare( strDate, Qt::CaseInsensitive ) ) {
            bFound = true;
         }
      }
   }

   // --- DONE ---
   bRetCode = true;
//PIX_EXIT:
   return bRetCode;
}

void hikari_window::SetTodaysWords( void )
{
   hikari_content *pContent = GetContent( );
   int iMonth = pContent->GetCurrentMonth( );
   int iDay = pContent->GetCurrentDay( );

   QDate date;
   QTime time;
   int iHour;

   date = QDate::currentDate( );
   time = QTime::currentTime( );

   // get date and time

   //iYear = time.GetYear( );
   pContent->SetCurrentMonth( date.month( ) );
   pContent->SetCurrentDay( date.day( ) );
   iHour = time.hour( );
   pContent->SetCurrentAm( ( 12 > iHour ) ? true : false );

   if( 2 == iMonth && 29 == iDay ) {
      pContent->SetCurrentDay( 28 );
   }

   return;
}

void hikari_window::ShowNextDay( void ) 
{
   hikari_content *pContent = GetContent( );
   int iMonth = pContent->GetCurrentMonth( );
   int iDay = pContent->GetCurrentDay( );
   bool bAm = pContent->GetCurrentAm( );

   int nDays[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, -1 };
   int nMonthDays;

   if( 0 > iMonth ) {
      SetTodaysWords( );   
      goto PIX_EXIT;
   }

   if( 12 == iMonth && ( 31 == iDay ) && ( !bAm ) ) {
      
      pContent->SetCurrentMonth( 1 );
      pContent->SetCurrentDay( 1 );
      pContent->SetCurrentAm( true );
      ShowContent( ); 
      goto PIX_EXIT;
   }

   if( bAm ) {
      pContent->SetCurrentAm( false );
      ShowContent( ); 
      goto PIX_EXIT;
   }

   nMonthDays = nDays[iMonth-1];
   if( iDay == nMonthDays ) {
      pContent->ShiftCurrentMonth( 1 );
      pContent->SetCurrentDay( 1 );
      pContent->SetCurrentAm( true );
      ShowContent( ); 
      goto PIX_EXIT;
   }

   pContent->ShiftCurrentDay( 1 );
   pContent->SetCurrentAm( true );
   ShowContent( ); 

PIX_EXIT:
   return;
}

void hikari_window::ShowPrevDay( void )
{
   hikari_content *pContent = GetContent( );
   int iMonth = pContent->GetCurrentMonth( );
   int iDay = pContent->GetCurrentDay( );
   bool bAm = pContent->GetCurrentAm( );

   int nDays[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, -1 };
   int nMonthDays;

   if( 0 > iMonth ) {
      SetTodaysWords( );   
      ShowContent( );   
      goto PIX_EXIT;
   }

   if( 1 == iMonth && ( 1 == iDay ) && ( bAm ) ) {
      pContent->SetCurrentMonth( 12 );
      pContent->SetCurrentDay( 31 );
      pContent->SetCurrentAm( false );
      ShowContent( ); 
      goto PIX_EXIT;
   }

   if( !bAm ) {
      pContent->SetCurrentAm( true );
      ShowContent( ); 
      goto PIX_EXIT;
   }

   nMonthDays = nDays[iMonth-1];
   if( 1 == iDay ) {
      pContent->ShiftCurrentMonth( -1 );
      pContent->SetCurrentDay( nDays[iMonth-1] );
      pContent->SetCurrentAm( false );
      ShowContent( ); 
      goto PIX_EXIT;
   }

   pContent->ShiftCurrentDay( -1 );
   pContent->SetCurrentAm( false );
   ShowContent( ); 

PIX_EXIT:
   return;
}

void hikari_window::ShowNextOccasion( void ) 
{
   hikari_content *pContent = GetContent( );
   QStringList strOccasions, strEnOccasions;
   int iOccasion = pContent->GetCurrentOccasion( );
   int nOccasions;

   if( !MakeCccasionsList( strOccasions, strEnOccasions ) ) {
      goto PIX_EXIT;
   }

   nOccasions = (int)strOccasions.size( );
   iOccasion = iOccasion + 1;
   if( nOccasions < iOccasion ) {
      iOccasion = 1;
   }

   pContent->SetCurrentOccasion( iOccasion );
   ShowContent( ); 

PIX_EXIT:
   return;
}

void hikari_window::ShowPrevOccasion( void ) 
{
   hikari_content *pContent = GetContent( );
   QStringList strOccasions, strEnOccasions;
   int iOccasion = pContent->GetCurrentOccasion( );
   int nOccasions;

   if( !MakeCccasionsList( strOccasions, strEnOccasions ) ) {
      goto PIX_EXIT;
   }

   nOccasions = (int)strOccasions.size( );
   iOccasion = iOccasion - 1;
   if( 1 > iOccasion ) {
      if( !MakeCccasionsList( strOccasions, strEnOccasions ) ) {
         goto PIX_EXIT;
      }
      iOccasion = nOccasions;
   }

   pContent->SetCurrentOccasion( iOccasion );
   ShowContent( ); 

PIX_EXIT:
   return;
}

void hikari_window::ShowBagsterDaysContent( void )
{
   QStringList vstrLines1;
   QStringList vstrLines2;
   hikari_content *pContent = GetContent( );

   pixq_Properties *pEnv = GetHikariEnv( );
   int nVersions = pEnv->_HikariVieBibleNum.iGet( );

   int iMonth = pContent->GetCurrentMonth( );
   int iDay = pContent->GetCurrentDay( );
   bool bAm = pContent->GetCurrentAm( );

   if( 0 > iMonth ) {
      SetTodaysWords( );
      iMonth = pContent->GetCurrentMonth( );
      iDay = pContent->GetCurrentDay( );
      bAm = pContent->GetCurrentAm( );
   }

   // get today's data

   if( !GetDaysWords( iMonth, iDay, bAm, 0, &vstrLines1 ) ) {
      qDebug( "ERROR! GetDaysWords Failed.\n" );
      goto PIX_EXIT;
   }

   if( 2 <= nVersions ) {
      if( !GetDaysWords( iMonth, iDay, bAm, 1, &vstrLines2 ) ) {
         qDebug( "ERROR! GetDaysWords Failed.\n" );
         goto PIX_EXIT;
      }
   }

   //
   // set the words in the table view
   //
   
   _DataView->clearSelection ( );
   _DataView->SetDaysWords( nVersions, &vstrLines1, &vstrLines2 );

   // set status bar

   SetBagsterStatusBar( );

   // set header label

   SetBagsterDaysHeaderLabel( );
   
   //

   _Ctrl_Hikari->SelectTodayCalendar( );

PIX_EXIT:
   return;
}

void hikari_window::ShowBagsterOccContent( void )
{
   QString strLines;
   QStringList vstrLines1;
   QStringList vstrLines2;
   hikari_content *pContent = GetContent( );
   int iOccasion = pContent->GetCurrentOccasion( );
   
   pixq_Properties *pEnv = GetHikariEnv( );
   int nVersions = pEnv->_HikariVieBibleNum.iGet( );

   if( 1 > iOccasion ) {
      pContent->SetCurrentOccasion( 1 );
   }

   // get today's data

   if( !GetOccasionWords( iOccasion, 0, &vstrLines1 ) ) {
      qDebug( "ERROR! GetOccasionWords Failed.\n" );
      goto PIX_EXIT;
   }

   if( 2 <= nVersions ) {
      if( !GetOccasionWords( iOccasion, 1, &vstrLines2 ) ) {
         qDebug( "ERROR! GetDaysWords Failed.\n" );
         goto PIX_EXIT;
      }
   }

   //
   
   _DataView->clearSelection ( );
   _DataView->SetDaysWords( nVersions, &vstrLines1, &vstrLines2 );

   // set status bar

   SetBagsterStatusBar( );

   // set header label

   SetBagsterOccHeaderLabel( );

   //

   _Ctrl_Hikari->SelectOccasion( );

PIX_EXIT:
   return;
}

QString hikari_window::SetDateLabel( int iMonth,
                                 int iDay,
                                 bool bAm )
{
   QString strBuffer;
   bool bJapanese = HikariSystemJapanese( );

   if( bJapanese ) {
      if( bAm ) {
         strBuffer.sprintf( "%d%d", iMonth, iDay );
      } else {
         strBuffer.sprintf( "%d%d[", iMonth, iDay );
      }
   } else {
      if( bAm ) {
         strBuffer.sprintf( "Month %d, Day %d, Morning", iMonth, iDay );
      } else {
         strBuffer.sprintf( "Month %d, Day %d, Evening", iMonth, iDay );
      }
   }

   return strBuffer;
}

//
// set header label
//
void hikari_window::SetBagsterDaysHeaderLabel( void )
{
   pixq_Properties *pEnv = GetHikariEnv( );
   int nVersions = pEnv->_HikariVieBibleNum.iGet( );

   QString strBible[2], strDate, strProgram, strVersion;

   hikari_content *pContent = GetContent( );
   int iMonth = pContent->GetCurrentMonth( );
   int iDay = pContent->GetCurrentDay( );
   bool bAm = pContent->GetCurrentAm( );

   bool bJapanese = HikariSystemJapanese( );

   // what is this?

   if( bJapanese ) {
      strProgram = "X̌";
   } else {
      strProgram = "Daily Light on Daily Path";
   }

   // date

   strDate = SetDateLabel( iMonth, iDay, bAm );
   _strHeaderLabel = strProgram + " : " + strDate;
   
   // bible versions

   strBible[0] = pEnv->HikariGetBagsterVersionName( );
   if( 2 <= nVersions ) {
      strBible[1] = pEnv->HikariGet2ndBagsterVersionName( );
      strVersion = strBible[0] + "|" + strBible[1];
   } else {
      strVersion = strBible[0];
   }
   
   //

   _strHeaderLabel = _strHeaderLabel + "[" + strVersion + "]";
   _Header->repaint( );

   return;
}


void hikari_window::SetBagsterOccHeaderLabel( void )
{
   pixq_Properties *pEnv = GetHikariEnv( );
   int nVersions = pEnv->_HikariVieBibleNum.iGet( );

   QStringList strOccasions, strEnOccasions;
   QString strOccasion, strProgram, strBible[2], strVersion;

   hikari_content *pContent = GetContent( );
   int iOccasion = pContent->GetCurrentOccasion( );
   bool bJapanese = HikariSystemJapanese( );

   // set header label

   if( bJapanese ) {
      strProgram = "X̌-ʂȓ";
   } else {
      strProgram = "Daily Light - Special Occasions";
   }

   //
   // set header label
   //

   if( !MakeCccasionsList( strOccasions, strEnOccasions ) ) {
      qDebug( "ERROR! MakeCccasionsList Failed.\n" );
      goto PIX_EXIT;
   }

   if( bJapanese ) {
      strOccasion = strOccasions.at( iOccasion-1 );
   } else {
      strOccasion = strEnOccasions.at( iOccasion-1 );
   }
   _strHeaderLabel = strProgram + " : " + strOccasion;

   //

   strBible[0] = pEnv->HikariGetBagsterVersionName( );
   if( 2 <= nVersions ) {
      strBible[1] = pEnv->HikariGet2ndBagsterVersionName( );
      strVersion = strBible[0] + "|" + strBible[1];
   } else {
      strVersion = strBible[0];
   }

   //_strHeaderLabel = strDate + "[" + strBible + "]";
   _strHeaderLabel = _strHeaderLabel + "[" + strVersion + "]";
   _Header->repaint( );

PIX_EXIT:
   return;
}

void hikari_window::SetBagsterStatusBar( void )
{
   QString strDate, strProgram, strBible;
   QStringList strEnOccasions, strOccasions;

   hikari_content *pContent = GetContent( );
   int iDev = pContent->GetDevotion( );
   int iMonth = pContent->GetCurrentMonth( );
   int iDay = pContent->GetCurrentDay( );
   bool bAm = pContent->GetCurrentAm( );
   int iOccasion = pContent->GetCurrentOccasion( );

   bool bJapanese = HikariSystemJapanese( );

   // set date on status bar

   if( bJapanese ) {
      strProgram = "X̌";
   } else {
      strProgram = "Daily Light on Daily Path";
   }
   SetStatusLabel( 0, strProgram );

   SetStatusLabel( 1, strBible );

   switch( iDev ) {
   case pixq_Properties::DevotionTypeDailyDays:
      strDate = SetDateLabel( iMonth, iDay, bAm );
      break;

   case pixq_Properties::DevotionTypeDailyOccasion:
      if( !MakeCccasionsList( strOccasions, strEnOccasions ) ) {
         qDebug( "ERROR! MakeCccasionsList Failed.\n" );
         goto PIX_EXIT;
      }

      if( bJapanese ) {
         strDate = strOccasions.at( iOccasion-1 );
      } else {
         strDate = strEnOccasions.at( iOccasion-1 );
      }
      break;
      
   default:
      strDate = "--------";
      break;
   }
   SetStatusLabel( 2, strDate );

PIX_EXIT:
   return;
}

void hikari_window::ShowBagsterContent( void )
{
   hikari_content *pContent = GetContent( );
   int iDev = pContent->GetDevotion( );

   switch( iDev ) {
   case pixq_Properties::DevotionTypeDailyDays:
      ShowBagsterDaysContent( );
      break;

   case pixq_Properties::DevotionTypeDailyOccasion:
      ShowBagsterOccContent( );
      break;
   }

   _Books->ShowSelection( );

   return;
}