#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"
#include "hikari_window.h"

static bool FindBook( int iBook, 
                     QXmlStreamReader &reader ) // [i/o] 
{
   bool bRetCode = false;
   bool bFound, bStatus, bOK;
   int iValue;
   QString strName, strValue;
   QXmlStreamAttributes attr;
   
   bStatus = true;
   bFound = false;
   while( bStatus ) {

      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }
   
      // find the book
   
      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }
   
      strName = reader.name().toString( );
   
      if( "Book" != strName ) {
         continue;
      }

      attr = reader.attributes();
      strValue = attr.value( "ID" ).toString();
      iValue = strValue.toInt( &bOK );
      if( !bOK ) {
         bStatus = false;
         continue;
      }
   
      if( iValue == iBook ) {
         bStatus = false;
         bFound = true;
         continue;
      }

      reader.skipCurrentElement();     
   }

   if( !bFound ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

static bool FindChapter( int iChapter, 
                         int &nVerses, //[o] number of verses
                         QXmlStreamReader &reader ) // [i/o] 
{
   bool bRetCode = false;
   bool bFound, bStatus, bOK;
   int iValue;
   QString strName, strValue;
   QXmlStreamAttributes attr;
   
   bStatus = true;
   bFound = false;
   while( bStatus ) {
	
      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }

      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }

      strName = reader.name().toString( );
   
      if( "Chapter" != strName ) {
         continue;
      }

      attr = reader.attributes();

      strValue = attr.value( "ID" ).toString();
      iValue = strValue.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }

      if( iValue == iChapter ) {
      
         strValue = attr.value( "Verses" ).toString();
         nVerses = strValue.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }

         bFound = true;
         bStatus = false;
         continue;
      }

      reader.skipCurrentElement();
   }

   if( ! bFound ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool hikari_window::GetChapterVerses( QFile *file, // [i]
                               int iBook, // [i]
                               int iChapter, // [i]
                               QList<int> &iVerseNum,  // [o]/ list of verse numbers
                               QStringList &vstrLines ) // [o]/ list of verses
{
   bool bRetCode = false;
   int nChapterVerses, nSize, nVerses, iVerse;
   bool bVerseZero, bStatus, bOK;
   QString strWords, strValue, strVerse;
   QXmlStreamReader reader;
   QXmlStreamAttributes attr;

   BibleAllBooks *pBL = GetBibleBooks( );
   BibleBook bc;

   //
   // check xml file
   //

   reader.setDevice( file );

   if( !reader.readNextStartElement( ) ) {
      goto PIX_EXIT;
   }

   if( reader.name() != "hikari" ) {
      goto PIX_EXIT;
   }

   if( reader.attributes().value("version") != "1.0") {
      goto PIX_EXIT;
   }

   //
	 
   if( !FindBook( iBook, reader ) ) {
      goto PIX_EXIT;
   }

   if( !FindChapter( iChapter, nVerses, reader ) ) {
      goto PIX_EXIT;
   }
   
   // get all verses of the chapter
   
   iVerseNum.clear( );
   vstrLines.clear( );

   bStatus = true;
   while( bStatus ) {
            
      if( reader.atEnd( ) ) {
         // end of the chapter
         bStatus = false;
         continue;
      }

      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }
 
    //  if( reader.isEndElement( ) ) {
         // end of the chapter
    //     bStatus = false;
    //     continue;
    //  }
     
      strValue = reader.name().toString( );
      if( "Verse" != strValue ) {
         continue;
      }
      
      attr = reader.attributes();
      strValue = attr.value( "ID" ).toString();
      iVerse = strValue.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }

      strValue = attr.value( "Words" ).toString();         
      iVerseNum.push_back( iVerse );
      vstrLines.push_back( strValue );

      reader.skipCurrentElement( );
   }
  
   // special handling for psalms

   if( 19 == iBook ) {
      // some chapters have verse zero
      bc = pBL->GetBook( iBook-1 );
      bVerseZero = bc.GetVerseZero( iChapter-1 );
      nChapterVerses = bc.GetChapterVerseNumber( iChapter );
   }

   // add verse number

   nSize = iVerseNum.size( );
   if( nSize != vstrLines.size( ) ) {
      // something is wroing!
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool hikari_window::GetChapterVerses( int iSide, // [i] side, 0 or 1 
                                     int iBook, // [i]
                                     int iChapter, // [i]
                                     QList<int> &iVerseNum,     // [o] list of verse numbers
                                     QStringList &vstrLines )  // [o] list of verses
{
   bool bRetCode = false;
   QString strError, strBibleFile;
   pixq_Properties *pEnv = GetHikariEnv( );
   QFile *file = NULL;

   //

   vstrLines.clear( );
   strBibleFile = pEnv->GetHikariBibleXmlFile( iSide );
 
   file = new QFile( strBibleFile );
   if ( !file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      strError = "ERROR! Failed to open file " + strBibleFile + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   if( !GetChapterVerses( file, iBook, iChapter, iVerseNum, vstrLines ) ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}


void hikari_window::ShowNextChapter( void ) 
{
   BibleAllBooks *pBL = GetBibleBooks( );
   int nChapters, nBooks;
   int iContent = _Content->GetContent( );
   int iBook = _Content->GetBook( );
   int iChapter = _Content->GetBookChapter( );

   BibleBook *pBc;
   
   nBooks = pBL->GetLength( );
   if( 1 > iBook ) goto PIX_EXIT;
   if( nBooks < iBook ) goto PIX_EXIT;

   pBc = pBL->pGetBook( iBook-1 );
   nChapters = pBc->GetChapters( );

   if( iChapter == nChapters ) {
      if( iBook == nBooks ) {
         // this is the last chapter of the last book
         goto PIX_EXIT;
      } else {
         iBook = iBook + 1;
         iChapter = 1;
         if( hikari_content::_iFirstNewBook == iBook ) {
            iContent = pixq_Properties::ContentNewTestament;
            _Content->SetContent( iContent );
         }
         _Content->SetBook( iBook );
         _Content->SetChapter( iChapter );
      }
   } else {
      iChapter = iChapter + 1;
      _Content->SetChapter( iChapter );
   }

   ShowContent( ); 

PIX_EXIT:
   return;
}

void hikari_window::ShowPrevChapter( void ) 
{
   BibleAllBooks *pBL = GetBibleBooks( );
   int nChapters, nBooks;
   int iContent = _Content->GetContent( );
   int iBook = _Content->GetBook( );
   int iChapter = _Content->GetBookChapter( );

   BibleBook *pBc;
   
   nBooks = pBL->GetLength( );
   if( 1 > iBook ) goto PIX_EXIT;
   if( nBooks < iBook ) goto PIX_EXIT;

   if( iChapter == 1 ) {
      if( iBook == 1 ) {
         // this is the last chapter of the last book
         goto PIX_EXIT;
      } else {
         iBook = iBook - 1;
         pBc = pBL->pGetBook( iBook-1 );
         nChapters = pBc->GetChapters( );
         iChapter = nChapters;

         if( hikari_content::_iLastOldBook == iBook ) {
            iContent = pixq_Properties::ContentOldTestament;
            _Content->SetContent( iContent );
         }
         
         _Content->SetBook( iBook );
         _Content->SetChapter( iChapter );
      }
   } else {
      iChapter = iChapter - 1;
      _Content->SetChapter( iChapter );
   }

   ShowContent( ); 

PIX_EXIT:
   return;
}

//
// count number of bible version selected for word search
//
void hikari_window::CheckSearchCondition( int &nJpCount, // [o] selected japanese bibles
                                         int &nEnCount ) // [o] selected japanese bibles
{
   pixq_Properties *pEnv = GetHikariEnv( ); 
   bool bSearch;
   vector<int> viVersionsJp;
   vector<int> viVersionsEn;
   int nJpVersions, nEnVersions, iVersion, i;

   // make a list of bible version

   viVersionsJp = pEnv->HikariBibleJpVersions( );
   nJpVersions = (int)viVersionsJp.size( );

   viVersionsEn = pEnv->HikariBibleEnVersions( );
   nEnVersions = (int)viVersionsEn.size( );

   // japanese bible

   nJpCount = 0;   
   for( i = 0 ; i < nJpVersions ; i++ ) {
      iVersion = viVersionsJp.at( i );
      bSearch = pEnv->VersionUsedForSearch( iVersion );
      if( bSearch ) nJpCount++;
   }

   // english bible

   nEnCount = 0;
   for( i = 0 ; i < nEnVersions ; i++ ) {
      iVersion = viVersionsEn.at( i );
      bSearch = pEnv->VersionUsedForSearch( iVersion );
      if( bSearch ) nEnCount++;
   }

//PIX_EXIT:
   return;
} 

//
// start to search the word
//
void hikari_window::SearchWordStart( int iSearchMode, 
                                    QStringList strWords, 
                                    BibleListVerse &res ) // [o] list of found verses
{
   pixq_Properties *pEnv = GetHikariEnv( ); 
   bool bSearch;
   vector<int> viVersions;
   int nVersions, iVersion, i;

   QString strOrganisation = hikari_window::_strOrganisation;
   QString strApplication = hikari_window::_strApplication;

QApplication::setOverrideCursor( Qt::BusyCursor );

   // make a list of bible version

   viVersions = pEnv->HikariBibleVersions( );
   nVersions = (int)viVersions.size( );
   if( 0 >= nVersions ) goto PIX_EXIT;

   //

   res.Clear( );

   for( i = 0 ; i < nVersions ; i++ ) {
      iVersion = viVersions.at( i );
      bSearch = pEnv->VersionUsedForSearch( iVersion );
      if( !bSearch ) continue;

      // ̔łXMLt@CȂ΁ȂΏۂO

      if( !pixq_Properties::VersionBibleXmlExist( iVersion ) ) {
         pEnv->SetVersionUsedForSearch( iVersion, false );
         pEnv->SetRegEnv( strOrganisation, strApplication );
         continue;
      }

      // !
      SearchWordVersion( iVersion, iSearchMode, strWords, res );
   }

PIX_EXIT:
QApplication::restoreOverrideCursor();
   return;
}

