#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"


#include "hikari_window.h"

#ifdef _DEBUG
int g_iLine;
#endif

//
// string for onbe reference of chapter and verse
//
// notes:
// should look like
// 12:1-4
// should include one:
//
bool hikari_window::DecompTabijiVerse( QString *strVerse,
                                      int &iChapter,
                                      QVector<int> &viVerseList )
{
   bool bRetCode = false;
   bool bOK, bStatus;
   int nVerseSize, nVerses, nLength, iKugiri, nKugiri, iPos, i;
   int iVerse, iStart, iEnd, nOneVerse, iSize, k, iVerse0, iVerse1;
   QString strChapter, strVerses, strOneVerse, strVerse0, strVerse1;
   QVector<int> viKugiriPos, viVersePos;
   QStringList strAllVerse;
   QChar chKugiri = ':';
   QChar chVerse = ',';
   QChar chDummy = '*';
   QChar chTsunagi = '-';

   // find positions of :
   
   // make a list of positions of '('
   bStatus = true;
   viKugiriPos.clear( );
   while( bStatus ) {
      iPos = strVerse->indexOf( chKugiri, 0 );
      if( 0 > iPos ) {
         bStatus =false;
         continue;
      }
      viKugiriPos.push_back( iPos );
      strVerse->replace( iPos, 1, chDummy );
   }

   nKugiri = (int)viKugiriPos.size( );
   if( 1 != nKugiri ) {
      //something is wrong!
      goto PIX_EXIT;
   }

   // get chapter number

   iKugiri = viKugiriPos.at( 0 );
   strChapter = strVerse->mid( 0, iKugiri );

   iChapter = strChapter.toInt( &bOK );
   if( !bOK ) {
      //something is wrong!
      goto PIX_EXIT;
   }

   if( 0 >= iChapter ) {
      //something is wrong!
      goto PIX_EXIT;
   }

   nLength = strVerse->size( );
   nVerseSize = nLength - iKugiri - 1;
   strVerses = strVerse->mid( iKugiri+1, nVerseSize );

   // find a position of kugiri(,)
   viVersePos.clear( );
   for( i = 0 ; i < nVerseSize ; i++ ) {
      if( chVerse == strVerses.at( i ) ) {
         viVersePos.push_back( i );
      }
   }
   
   nVerses = (int)viVersePos.size( );
   viVersePos.push_back( nVerseSize );
   nVerses = (int)viVersePos.size( );

   strAllVerse.clear( );
   for( i = 0 ; i < nVerses ; i++ ) {
      iStart = 0 == i ? 0 : viVersePos.at( i - 1 ) + 1;
      iEnd = viVersePos.at( i );
      iSize = iEnd - iStart;
      strOneVerse = strVerses.mid( iStart, iSize );
      strAllVerse.push_back( strOneVerse );
   }

   // decompose each single verse
   // examples
   // 19 
   // 20-22

   viVerseList.clear( );
   for( i = 0 ; i < nVerses ; i++ ) {
      strOneVerse = strAllVerse.at( i );
      nVerseSize = strOneVerse.size( );
      // check if this verse include '-'
      
      iPos = strOneVerse.indexOf( chTsunagi, 0 );
      if( 0 > iPos ) {
         // no '-', single verse
         iVerse = strOneVerse.toInt( &bOK );
         if( !bOK ) {
            //something is wrong!
            goto PIX_EXIT;
         }
         viVerseList.push_back( iVerse );
      } else if( 0 == iPos ) {
         //something is wrong!
         goto PIX_EXIT;
      } else if( nVerseSize-1 == iPos ) {
         //something is wrong!
         goto PIX_EXIT;
      } else {
         nOneVerse = (int)strOneVerse.size( );
         strVerse0 = strOneVerse.left( iPos );
         strVerse1 = strOneVerse.right( nOneVerse - iPos - 1 );
         //
         iVerse0 = strVerse0.toInt( &bOK );
         if( !bOK ) {
            //something is wrong!
            goto PIX_EXIT;
         }
         //
         iVerse1 = strVerse1.toInt( &bOK );
         if( !bOK ) {
            //something is wrong!
            goto PIX_EXIT;
         }
         //
         if( iVerse1 <= iVerse0 ) {
            //something is wrong!
            goto PIX_EXIT;
         }
         for( k = iVerse0 ; k <= iVerse1 ; k++ ) {
            viVerseList.push_back( k );
         }
      }
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

QString hikari_window::GetShinkai2BookFile( int iBook )
{
   BibleAllBooks *pBL = GetBibleBooks( );

   QString strPath, strBook;
   BibleBook bc;
   
   bc = pBL->GetBook( iBook );
   strBook = bc.GetShinkaiFile( );
   strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );

   strPath.append( "Files_Shinkai/" );
   strPath.append( strBook );

   return strPath;
}

QString hikari_window::GetKjvBookFile( int iBook )
{
   QString strPath, strBook;
   BibleBook bc;

   BibleAllBooks *pBL = GetBibleBooks( );
   
   bc = pBL->GetBook( iBook );
   strBook = bc.GetKjvFile( );
   strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );

   strPath.append( "/" );
   strPath.append( strBook );

   return strPath;
}

//
// make a buffer of hikari
// 
bool hikari_window::GetShinkaiyakuBuffer( int iBook,
                                   int iChapter, 
                                   QVector<int> viVerseList,
                                   QString &strShinkai )
{
   bool bRetCode = false;
   bool bStatus, bFound;
   int nHeaderSize, nLength, k, iVerse, nVerses;
   QString strBuffer, strError, strWord, strLeft, strBook, strHeader;
   QFile *in_file = NULL;
   QTextStream *in = NULL;

   strShinkai.clear( );
   strShinkai.append( "\"" );

   //

   strBook = GetShinkai2BookFile( iBook );

   in_file = new QFile( strBook );
   if ( !in_file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      qDebug() << "ERROR! Failed to open file:" << strBook << "\n";
      strError = "ERROR! Failed to open file " + strBook + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   in = new QTextStream( in_file );
//   in->setCodec( "UTF-16" );

   //

   nVerses = viVerseList.size( );
   for( k = 0 ; k < nVerses ; k++ ) {
      iVerse = viVerseList.at( k );

      nHeaderSize = 3;
      if( 10 > iChapter ) {
         nHeaderSize = nHeaderSize + 1;
      } else if( 100 > iChapter ) { 
         nHeaderSize = nHeaderSize + 2;
      } else {
         nHeaderSize = nHeaderSize + 3;
      }
      if( 10 > iVerse ) {
         nHeaderSize = nHeaderSize + 1;
      } else if( 100 > iVerse ) { 
         nHeaderSize = nHeaderSize + 2;
      } else {
         nHeaderSize = nHeaderSize + 3;
      }

      strHeader.sprintf( " %d:%d \0", iChapter, iVerse );
   
      in->seek( 0 );

      // start reading
      bStatus = true;
      bFound = false;

      while( bStatus ) {
	   
         if( in->atEnd( ) ) {
			   bStatus = false;
	   	   continue;
         }

         //
         // read sinlge line from file
         //
      	strBuffer = in->readLine( );

         if( strBuffer.isNull( ) ) {
		   	bStatus = false;
	   	   continue;
	      }   

         nLength = (int)strBuffer.size( );
         if( nHeaderSize >= nLength ) {
            continue;
         }

         strLeft = strBuffer.left( nHeaderSize );
         if( 0 != strLeft.compare( strHeader ) ) {
            continue;
         }

         strWord = strBuffer.right( nLength - nHeaderSize );
         strShinkai.append( strWord );

         bStatus = false;
         bFound = true;
      }
      
      if( !bFound ) {
         // not found!
         goto PIX_EXIT;
      }

   }

   strShinkai.append( "\"" );

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( in_file ) {
      in_file->close( );
      in_file = NULL;
   }
   return bRetCode;
}

bool hikari_window::GetShinkaiyakuBuffer( int iBook,
                                   int iChapter, 
                                   int iVerse,
                                   QString &strShinkai )
{
   bool bRetCode = false;
   bool bStatus, bFound;
   int nHeaderSize, nLength;
   QString strBuffer, strError, strWord, strLeft, strBook, strHeader;
   QFile *in_file = NULL;
   QTextStream *in = NULL;

   strShinkai.clear( );
   strShinkai.append( "\"" );

   //

   strBook = GetShinkai2BookFile( iBook );

   in_file = new QFile( strBook );
   if ( !in_file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      qDebug() << "ERROR! Failed to open file:" << strBook << "\n";
      strError = "ERROR! Failed to open file " + strBook + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   in = new QTextStream( in_file );
//   in->setCodec( "UTF-16" );

   //


   nHeaderSize = 3;
   if( 10 > iChapter ) {
      nHeaderSize = nHeaderSize + 1;
   } else if( 100 > iChapter ) { 
      nHeaderSize = nHeaderSize + 2;
   } else {
      nHeaderSize = nHeaderSize + 3;
   }
   if( 10 > iVerse ) {
      nHeaderSize = nHeaderSize + 1;
   } else if( 100 > iVerse ) { 
      nHeaderSize = nHeaderSize + 2;
   } else {
      nHeaderSize = nHeaderSize + 3;
   }

   strHeader.sprintf( " %d:%d \0", iChapter, iVerse );
   
   in->seek( 0 );

   // start reading
   bStatus = true;
   bFound = false;

   while( bStatus ) {
	
      if( in->atEnd( ) ) {
		   bStatus = false;
		   continue;
      }

      //
      // read sinlge line from file
      //
   	strBuffer = in->readLine( );

      if( strBuffer.isNull( ) ) {
	   	bStatus = false;
		   continue;
	   }   

      nLength = (int)strBuffer.size( );
      if( nHeaderSize >= nLength ) {
         continue;
      }

      strLeft = strBuffer.left( nHeaderSize );
      if( 0 != strLeft.compare( strHeader ) ) {
         continue;
      }

      strWord = strBuffer.right( nLength - nHeaderSize );
      strShinkai.append( strWord );

      bStatus = false;
      bFound = true;
   }
   
   if( !bFound ) {
      // not found!
      goto PIX_EXIT;
   }


   strShinkai.append( "\"" );

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( in_file ) {
      in_file->close( );
      in_file = NULL;
   }
   return bRetCode;
}

QString hikari_window::GetKougoBookFile( int iBook )
{
   QString strPath, strBook;
   BibleBook bc;

   BibleAllBooks *pBL = GetBibleBooks( );

   bc = pBL->GetBook( iBook );
   strBook = bc.GetKougoFile( );
   strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );

   strPath.append( "/" );
   strPath.append( strBook );

   return strPath;
}

//
// make a buffer of hikari
// 
bool hikari_window::GetKougoyakuBuffer( int iBook,
                                   int iChapter, 
                                   QVector<int> viVerseList,
                                   QString &strKougo )
{
   bool bRetCode = false;
   bool bStatus, bFound;
   int nHeaderSize, nLength, k, iVerse, nIndent, nVerses;
   QString strBuffer, strError, strWord, strLeft, strBook, strHeader;
   QString strShortBook;
   QFile *in_file = NULL;
   QTextStream *in = NULL;

   BibleAllBooks *pBL = GetBibleBooks( );

   strKougo.clear( );
   strKougo.append( "\"" );

   //

   strBook = GetKougoBookFile( iBook );

   in_file = new QFile( strBook );
   if ( !in_file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      qDebug() << "ERROR! Failed to open file:" << strBook << "\n";
      strError = "ERROR! Failed to open file " + strBook + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   in = new QTextStream( in_file );
//   in->setCodec( "UTF-16" );

   //

   strShortBook = pBL->GetBookEnAbbrev( iBook, 0 );

   nVerses = viVerseList.size( );
   for( k = 0 ; k < nVerses ; k++ ) {
      iVerse = viVerseList.at( k );

      nIndent = 3;
      nIndent = nIndent + (int)strShortBook.size( );
      nIndent = nIndent + 1;

      nHeaderSize = 0;
      if( 10 > iChapter ) {
         nHeaderSize = nHeaderSize + 1;
      } else if( 100 > iChapter ) { 
         nHeaderSize = nHeaderSize + 2;
      } else {
         nHeaderSize = nHeaderSize + 3;
      }

      nHeaderSize = nHeaderSize + 1;

      if( 10 > iVerse ) {
         nHeaderSize = nHeaderSize + 1;
      } else if( 100 > iVerse ) { 
         nHeaderSize = nHeaderSize + 2;
      } else {
         nHeaderSize = nHeaderSize + 3;
      }

      nHeaderSize = nHeaderSize + 1;

      strHeader.sprintf( "%d:%d\t\0", iChapter, iVerse );
   
      in->seek( 0 );

      // start reading
      bStatus = true;
      bFound = false;

      while( bStatus ) {
	   
         if( in->atEnd( ) ) {
			   bStatus = false;
	   	   continue;
         }

         //
         // read sinlge line from file
         //
      	strBuffer = in->readLine( );

         if( strBuffer.isNull( ) ) {
		   	bStatus = false;
	   	   continue;
	      }   

         nLength = (int)strBuffer.size( );
         if( nHeaderSize >= nLength ) {
            continue;
         }

         strLeft = strBuffer.mid( nIndent, nHeaderSize );
         if( 0 != strLeft.compare( strHeader ) ) {
            continue;
         }

         strWord = strBuffer.right( nLength - nIndent - nHeaderSize );
         strKougo.append( strWord );

         bStatus = false;
         bFound = true;
      }
      
      if( !bFound ) {
         // not found!
         goto PIX_EXIT;
      }

   }

   strKougo.append( "\"" );

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( in_file ) {
      in_file->close( );
      in_file = NULL;
   }
   return bRetCode;
}


//
// make a buffer of hikari
// 
bool hikari_window::GetKougoyakuBuffer( int iBook,
                                   int iChapter, 
                                   int iVerse,
                                   QString &strKougo )
{
   bool bRetCode = false;
   bool bStatus, bFound;
   int nHeaderSize, nLength, nIndent;
   QString strBuffer, strError, strWord, strLeft, strBook, strHeader;
   QString strShortBook;
   QFile *in_file = NULL;
   QTextStream *in = NULL;

   BibleAllBooks *pBL = GetBibleBooks( );

   strKougo.clear( );
   strKougo.append( "\"" );

   //

   strBook = GetKougoBookFile( iBook );

   in_file = new QFile( strBook );
   if ( !in_file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      qDebug() << "ERROR! Failed to open file:" << strBook << "\n";
      strError = "ERROR! Failed to open file " + strBook + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   in = new QTextStream( in_file );
//   in->setCodec( "UTF-16" );

   //

   strShortBook = pBL->GetBookEnAbbrev( iBook, 0 );

   nIndent = 3;
   nIndent = nIndent + (int)strShortBook.size( );
   nIndent = nIndent + 1;

   nHeaderSize = 0;
   if( 10 > iChapter ) {
      nHeaderSize = nHeaderSize + 1;
   } else if( 100 > iChapter ) { 
      nHeaderSize = nHeaderSize + 2;
   } else {
      nHeaderSize = nHeaderSize + 3;
   }

   nHeaderSize = nHeaderSize + 1;

   if( 10 > iVerse ) {
      nHeaderSize = nHeaderSize + 1;
   } else if( 100 > iVerse ) { 
      nHeaderSize = nHeaderSize + 2;
   } else {
      nHeaderSize = nHeaderSize + 3;
   }

   nHeaderSize = nHeaderSize + 1;

   strHeader.sprintf( "%d:%d\t\0", iChapter, iVerse );
   
   in->seek( 0 );

   // start reading
   bStatus = true;
   bFound = false;

   while( bStatus ) {
	
      if( in->atEnd( ) ) {
		   bStatus = false;
		   continue;
      }

      //
      // read sinlge line from file
      //
   	strBuffer = in->readLine( );

      if( strBuffer.isNull( ) ) {
	   	bStatus = false;
		   continue;
	   }   

      nLength = (int)strBuffer.size( );
      if( nHeaderSize >= nLength ) {
         continue;
      }

      strLeft = strBuffer.mid( nIndent, nHeaderSize );
      if( 0 != strLeft.compare( strHeader ) ) {
         continue;
      }

      strWord = strBuffer.right( nLength - nIndent - nHeaderSize );
      strKougo.append( strWord );

      bStatus = false;
      bFound = true;
   }
   
   if( !bFound ) {
      // not found!
      goto PIX_EXIT;
   }

   strKougo.append( "\"" );

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( in_file ) {
      in_file->close( );
      in_file = NULL;
   }
   return bRetCode;
}

//
// make a buffer of hikari
// 
bool hikari_window::GetKjvBuffer( int iBook,
                                   int iChapter, 
                                   QVector<int> viVerseList,
                                   QString &strKjv )
{
   bool bRetCode = false;
   bool bStatus, bFound;
   int nHeaderSize, nLength, k, iVerse, nIndent, nVerses;
   QString strBuffer, strError, strWord, strLeft, strBook, strHeader;
   QString strShortBook;
   QFile *in_file = NULL;
   QTextStream *in = NULL;

   BibleAllBooks *pBL = GetBibleBooks( );

   strKjv.clear( );
   strKjv.append( "\"" );

   //

   strBook = GetKjvBookFile( iBook );

   in_file = new QFile( strBook );
   if ( !in_file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      qDebug() << "ERROR! Failed to open file:" << strBook << "\n";
      strError = "ERROR! Failed to open file " + strBook + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   in = new QTextStream( in_file );
//   in->setCodec( "UTF-16" );

   //

   strShortBook = pBL->GetBookEnAbbrev( iBook, 0 );

   nVerses = viVerseList.size( );
   for( k = 0 ; k < nVerses ; k++ ) {

      if( 0 < k ) {
         strKjv.append( " " );
      }

      iVerse = viVerseList.at( k );

      // _Etrans 
      nIndent = 9;
      nIndent = nIndent + (int)strShortBook.size( );
      nIndent = nIndent + 1;

      nHeaderSize = 0;
      if( 10 > iChapter ) {
         nHeaderSize = nHeaderSize + 1;
      } else if( 100 > iChapter ) { 
         nHeaderSize = nHeaderSize + 2;
      } else {
         nHeaderSize = nHeaderSize + 3;
      }

      nHeaderSize = nHeaderSize + 1;

      if( 10 > iVerse ) {
         nHeaderSize = nHeaderSize + 1;
      } else if( 100 > iVerse ) { 
         nHeaderSize = nHeaderSize + 2;
      } else {
         nHeaderSize = nHeaderSize + 3;
      }

      nHeaderSize = nHeaderSize + 1;

      strHeader.sprintf( "%d:%d\t\0", iChapter, iVerse );
   
      in->seek( 0 );

      // start reading
      bStatus = true;
      bFound = false;

      while( bStatus ) {
	   
         if( in->atEnd( ) ) {
			   bStatus = false;
	   	   continue;
         }

         //
         // read sinlge line from file
         //
      	strBuffer = in->readLine( );

         if( strBuffer.isNull( ) ) {
		   	bStatus = false;
	   	   continue;
	      }   

         nLength = (int)strBuffer.size( );
         if( nHeaderSize >= nLength ) {
            continue;
         }

         strLeft = strBuffer.mid( nIndent, nHeaderSize );
         if( 0 != strLeft.compare( strHeader ) ) {
            continue;
         }

         strWord = strBuffer.right( nLength - nIndent - nHeaderSize );
         strKjv.append( strWord );

         bStatus = false;
         bFound = true;
      }
      
      if( !bFound ) {
         // not found!
         goto PIX_EXIT;
      }

   }

   strKjv.append( "\"" );

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( in_file ) {
      in_file->close( );
      in_file = NULL;
   }
   return bRetCode;
}


bool hikari_window::GetKjvBuffer( int iBook,
                                   int iChapter, 
                                   int iVerse,
                                   QString &strKjv )
{
   bool bRetCode = false;
   bool bStatus, bFound;
   int nHeaderSize, nLength, nIndent;
   QString strBuffer, strError, strWord, strLeft, strBook, strHeader;
   QString strShortBook;
   QFile *in_file = NULL;
   QTextStream *in = NULL;

   BibleAllBooks *pBL = GetBibleBooks( );

   strKjv.clear( );
   strKjv.append( "\"" );

   //

   strBook = GetKjvBookFile( iBook );

   in_file = new QFile( strBook );
   if ( !in_file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      qDebug() << "ERROR! Failed to open file:" << strBook << "\n";
      strError = "ERROR! Failed to open file " + strBook + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   in = new QTextStream( in_file );
//   in->setCodec( "UTF-16" );

   //

   strShortBook = pBL->GetBookEnAbbrev( iBook, 0 );

   // _Etrans 
   nIndent = 9;
   nIndent = nIndent + (int)strShortBook.size( );
   nIndent = nIndent + 1;

   nHeaderSize = 0;
   if( 10 > iChapter ) {
      nHeaderSize = nHeaderSize + 1;
   } else if( 100 > iChapter ) { 
      nHeaderSize = nHeaderSize + 2;
   } else {
      nHeaderSize = nHeaderSize + 3;
   }

   nHeaderSize = nHeaderSize + 1;

   if( 10 > iVerse ) {
      nHeaderSize = nHeaderSize + 1;
   } else if( 100 > iVerse ) { 
      nHeaderSize = nHeaderSize + 2;
   } else {
      nHeaderSize = nHeaderSize + 3;
   }

   nHeaderSize = nHeaderSize + 1;

   strHeader.sprintf( "%d:%d\t\0", iChapter, iVerse );
   
   in->seek( 0 );

   // start reading
   bStatus = true;
   bFound = false;

   while( bStatus ) {
	
      if( in->atEnd( ) ) {
		   bStatus = false;
		   continue;
      }

      //
      // read sinlge line from file
      //
   	strBuffer = in->readLine( );

      if( strBuffer.isNull( ) ) {
	   	bStatus = false;
		   continue;
	   }   

      nLength = (int)strBuffer.size( );
      if( nHeaderSize >= nLength ) {
         continue;
      }

      strLeft = strBuffer.mid( nIndent, nHeaderSize );
      if( 0 != strLeft.compare( strHeader ) ) {
         continue;
      }

      strWord = strBuffer.right( nLength - nIndent - nHeaderSize );
      strKjv.append( strWord );

      bStatus = false;
      bFound = true;
   }
   
   if( !bFound ) {
      // not found!
      goto PIX_EXIT;
   }

   

   strKjv.append( "\"" );

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( in_file ) {
      in_file->close( );
      in_file = NULL;
   }
   return bRetCode;
}

bool hikari_window::DecompOneTabiji( int iCategory,
                                    int iLine,
                                    QString *strBuffer,
                                    QTextStream *out )
{
   bool bRetCode = false;
   bool bStatus;
   int iBook, iSide, nShortName, iSize, iPos, iLeft, iRight, k, nLeft, nRight;
   int iVerse, nAllVerses, iChapter, i, iStart, iEnd, iWordSize;
   QString strShinkai, strCategory, strChapter, strVerse, strOneVerse, strVerses, strBook;
   QString strKjv, strLine, strWord, strKotoba, strKougo;
   QVector<int> viLeftPos, viRightPos;
   QVector<int> viVerseList;
    
   BibleAllBooks *pBL = GetBibleBooks( );

   QChar chL = '(';
   QChar chR = ')';
   QChar chDummy = '*';

   // check how many hikari this line contains 
   
   // make a list of positions of (
   bStatus = true;
   viLeftPos.clear( );
   while( bStatus ) {
      iPos = strBuffer->indexOf( chL, 0 );
      if( 0 > iPos ) {
         bStatus =false;
         continue;
      }
      viLeftPos.push_back( iPos );
      strBuffer->replace( iPos, 1, chDummy );
   }

   // make a list of positions of )
   bStatus = true;
   viRightPos.clear( );
   while( bStatus ) {
      iPos = strBuffer->indexOf( chR, 0 );
      if( 0 > iPos ) {
         bStatus =false;
         continue;
      }
      viRightPos.push_back( iPos );
      strBuffer->replace( iPos, 1, chDummy );
   }

   // 

   nLeft = (int)viLeftPos.size( );
   nRight = (int)viRightPos.size( );
   if( nLeft != nRight ) {
      //something is wrong!
      goto PIX_EXIT;
   }
   
   if( 0 >= nLeft ) {
      //something is wrong!
      goto PIX_EXIT;
   }

   for( k = 0 ; k < nLeft ; k++ ) {
      iLeft = viLeftPos.at( k );
      iRight = viRightPos.at( k );
      if( iLeft >= iRight ) {
         //something is wrong!
         goto PIX_EXIT;
      }

      iSize = iRight - iLeft - 1; 
      strChapter = strBuffer->mid( iLeft+1, iSize );

      // check the book

      iBook = pBL->FindFromShinkai( strChapter, &iSide );
      if( 0 > iBook ) {
         goto PIX_EXIT;
      }
     
      // check the verse

      nShortName = pBL->ShinkaiShortNameSize( iBook, iSide );
      if( 0 >= nShortName ) {
         goto PIX_EXIT;
      }

      strVerse = strChapter.mid( nShortName, iSize - nShortName + 1 );
      if( !DecompTabijiVerse( &strVerse, iChapter, viVerseList ) ) {
         goto PIX_EXIT;
      }

      // save to csv file

      nAllVerses = viVerseList.size( );
      for( i = 0 ; i < nAllVerses ; i++ ) {
         iVerse = viVerseList.at( i );
      }

      //  hikari

      iStart = ( 0 == k ) ? 0 : viRightPos.at( k-1 ) + 1;
      iEnd = iLeft - 1;
      iWordSize = iEnd - iStart + 1;
      strKotoba = strBuffer->mid( iStart, iWordSize ); 

      // create a line of output buffer

      strCategory.setNum( iCategory );
      *out << strCategory << ",";

      strLine.setNum( iLine+1 );
      *out << strLine << ",";

      strWord.setNum( k+1 );
      *out << strWord << ",";

      strBook = pBL->GetShinkaiName( iBook, 0 );
      *out << strBook << ",";

      strChapter.setNum( iChapter );
      *out << strChapter << ",";

      strVerses = "\"";
      for( i = 0 ; i < nAllVerses ; i++ ) {
         if( 0 < i ) {
            strVerses.append( "," );
         }
         iVerse = viVerseList.at( i );
         strOneVerse.setNum( iVerse );
         strVerses.append( strOneVerse );
      }
      strVerses.append( "\"" );
      *out << strVerses << ",";

      //

      strKotoba.insert( 0, "\"" );
      strKotoba.append( "\"" );
      *out << strKotoba << ",";

      // get from shinkai-yaku file

      if( !GetShinkaiyakuBuffer( iBook, iChapter, viVerseList, strShinkai ) ) {
         goto PIX_EXIT;
      }

      *out << strShinkai << ","<< "*" << ",";

      // get from kugo-yaku file

      if( !GetKougoyakuBuffer( iBook, iChapter, viVerseList, strKougo ) ) {
         goto PIX_EXIT;
      }

      *out << strKougo << "," << "*" << ",";

      // get from KJV file

      if( !GetKjvBuffer( iBook, iChapter, viVerseList, strKjv ) ) {
         goto PIX_EXIT;
      }

      *out << strKjv << "," << "*";

      //

      *out << endl;
   }

   // --- DONE ---
   bRetCode = true; 
PIX_EXIT:
   return bRetCode;
}

bool hikari_window::DecompOneOccasion( int iCategory,
                                    int iLine,
                                    QString *strBuffer,
                                    QTextStream *out )
{
   bool bRetCode = false;
   bool bFound, bStatus, bOK;
   int iBookStart, nBooks, iBook, iPos, iDiv, k, nDivs, iVerseEnd;
   int iBlankPos, nShort, iVerse, iChapter, i, iStart, iEnd, iWordSize;
   
   QString strShort, strVerse, strChapter, strShinkai, strLine, strTmp;
   QString strCategory, strKjv, strKotoba, strKougo, strWord, strBook;

   QVector<int> viBookList, viChapterList, viVerseList;
   QVector<int> viDivPos, viStartList, viEndList;
    
   BibleAllBooks *pBL = GetBibleBooks( );

   QChar chDiv = ':';
   QChar chBlank = ' ';
   QChar chDummy = '*';

   // check how many hikari this line contains 
   
   // make a list of positions of :
   bStatus = true;
   viDivPos.clear( );
   while( bStatus ) {
      iPos = strBuffer->indexOf( chDiv, 0 );
      if( 0 > iPos ) {
         bStatus =false;
         continue;
      }
      viDivPos.push_back( iPos );
      strBuffer->replace( iPos, 1, chDummy );
   }

   //

   nBooks = pBL->GetLength( );

   // 

   nDivs = (int)viDivPos.size( );
   
   if( 0 >= nDivs ) {
      //something is wrong!
      goto PIX_EXIT;
   }

   //
   // should look like
   // Num 6:24
   //

   viBookList.clear( );
   viChapterList.clear( );
   viVerseList.clear( );
   viStartList.clear( );
   viEndList.clear( );

   for( k = 0 ; k < nDivs ; k++ ) { 
      iDiv = viDivPos.at( k );

      // find blank before :

      iPos = iDiv - 1;
      bFound = false;
      while( !bFound ) {
         if( 0 >= iPos ) {
            // somthing is wrong!
            goto PIX_EXIT;
         }

         if( chBlank == strBuffer->at( iPos ) ) {
            bFound = true;
            iBlankPos = iPos;
            continue;
         } 
         iPos = iPos - 1;
      } 
 
      if( !bFound ) {
         // somthing is wrong!
         goto PIX_EXIT; 
      }

      // find short bible name on left side of iPos

      iBook = -1;
      bFound = false; 
      for( i = 0 ; !bFound && i < nBooks ; i++ ) {
         strShort = pBL->GetKjvBookOccShort( i );
         nShort = (int)strShort.size( );
         iStart = iBlankPos - nShort;
         if( 0 > iStart ) continue; 
         strTmp = strBuffer->mid( iStart, nShort );
         if( 0 == strShort.compare( strTmp ) ) {
            iBook = i;
            iBookStart = iStart;
            bFound = true;
            continue;
         }
      } 

      if( !bFound ) { 
         // somthing is wrong!
         goto PIX_EXIT;
      }

      // get chapter

      strChapter = strBuffer->mid( iBlankPos+1, iDiv - iBlankPos - 1 );
      iChapter = strChapter.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }
     
      // get verse

      bFound = false;
      iPos = iDiv + 1;
      for( i = 1 ; !bFound && i <= 3 ; i++ ) {
         if( chBlank == strBuffer->at( iPos+i ) ) {
            strVerse = strBuffer->mid( iPos, i );
            iVerse = strVerse.toInt( &bOK );
            if( bOK ) {
               iVerseEnd = iPos+i;
               bFound = true;
               continue;
            }
         }
      }

      if( !bFound ) {
         // somthing is wrong!
         goto PIX_EXIT;
      }

      //

      viBookList.push_back( iBook );
      viChapterList.push_back( iChapter );
      viVerseList.push_back( iVerse );

      viStartList.push_back( iVerseEnd );

      if( k > 0 ) {
         viEndList.push_back( iBookStart - 1 );
      }

   }

   viEndList.push_back( strBuffer->size( ) - 1 );

   // get words

   for( k = 0 ; k < nDivs ; k++ ) { 
      
      iBook = viBookList.at( k );
      iChapter = viChapterList.at( k );
      iVerse = viVerseList.at( k );

      iStart = viStartList.at( k );
      iEnd = viEndList.at( k );

      iWordSize = iEnd - iStart + 1;
      strKotoba = strBuffer->mid( iStart, iWordSize ); 

      // create a line of output buffer

      strCategory.setNum( iCategory );
      *out << strCategory << ",";

      strLine.setNum( iLine+1 );
      *out << strLine << ",";

      strWord.setNum( k+1 );
      *out << strWord << ",";

      strBook = pBL->GetShinkaiName( iBook, 0 );
      *out << strBook << ",";

      strChapter.setNum( iChapter );
      *out << strChapter << ",";

      strVerse.setNum( iVerse );
      *out << strVerse << ",";

      //

      strKotoba.insert( 0, "\"" );
      strKotoba.append( "\"" );
      *out << strKotoba << "," << "*" << ",";

      // get from KJV file

      if( !GetKjvBuffer( iBook, iChapter, iVerse, strKjv ) ) {
         goto PIX_EXIT;
      }

      *out << strKjv << ",";

      // get from shinkai-yaku file

      if( !GetShinkaiyakuBuffer( iBook, iChapter, iVerse, strShinkai ) ) {
         goto PIX_EXIT;
      }

      *out << strShinkai << ",";

      // get from kugo-yaku file

      if( !GetKougoyakuBuffer( iBook, iChapter, iVerse, strKougo ) ) {
         goto PIX_EXIT;
      }

      *out << strKougo;

      //

      *out << endl;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
//
//
bool hikari_window::DecodeCsvOccasion( QString *strBuffer, // [i]
                                    BibleOccasion *occ ) // [o]
{
   bool bRetCode = false;
   bool bOK, bStatus;
   int iSection, iLine, iStartVerse, iEndVerse, iBook, iPos, k, nDivs;
   int iOccasion, iSide, iChapter, iStart, iEnd, iWordSize, nSize;
   
   QString strOccasion, strShort, strVerse, strChapter, strShinkai, strLine, strTmp;
   QString strCategory, strKjv, strKotoba, strKougo, strWord, strBook;

   QString strInKjv;
   QVector<int> viDivPos;
    
   QStringList strBuffers;

   QChar chDelimit = '*';
   QChar chVerse = '-';
   QChar chComma = ',';
   QChar chDummy = '#';

   BibleAllBooks *pBL = GetBibleBooks( );

   occ->Clear( );

   // make a list of positions of *
   bStatus = true;
   viDivPos.clear( );
   while( bStatus ) {
      iPos = strBuffer->indexOf( chDelimit, 0 );
      if( 0 > iPos ) {
         bStatus =false;
         continue;
      }
      viDivPos.push_back( iPos );
      strBuffer->replace( iPos, 1, chDummy );
   }

   // 

   nDivs = (int)viDivPos.size( );
   nSize = (int)strBuffer->size( );

   if( 10 > nDivs ) {
      //something is wrong!
      goto PIX_EXIT;
   }

   strBuffers.clear( );
   for( k = 0 ; k <= nDivs ; k++ ) { 
      // 
      // remove "
      //
      iStart = ( 0 == k ) ? 1 : viDivPos.at( k-1 )+2;
      iEnd = ( nDivs == k ) ? nSize - 2 : viDivPos.at( k )-2;
      
      //

      iWordSize = iEnd - iStart + 1;
      strLine = strBuffer->mid( iStart, iWordSize ); 

      strBuffers.push_back( strLine );
   }

   // category

   k = 0;
   strLine = strBuffers.at( k );
   iOccasion = strLine.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }
   occ->SetOccasion( iOccasion );

   // 
   k++;
   strOccasion = strBuffers.at( k );
   occ->SetOccasion( strOccasion );

   occ->SetEnOccasion( );

   // occasion #
   k++;
   strLine = strBuffers.at( k );
   iLine = strLine.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }
   occ->SetOccasionLine( iLine );
   
   // occasion section
   k++;
   strLine = strBuffers.at( k );
   iSection = strLine.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }
   occ->SetOccasionSection( iSection );

   // book
   k++;
   strBook = strBuffers.at( k );
   iBook = pBL->FindFromShinkai( strBook, &iSide );
   occ->SetBook( iBook );

   // chapter
   k++;
   strLine = strBuffers.at( k );
   iChapter = strLine.toInt( &bOK );
   if( !bOK ) {
      goto PIX_EXIT;
   }
   occ->SetChapter( iChapter );

   // verse(s)

   k++;
   strLine = strBuffers.at( k );
   iPos = strLine.indexOf( chVerse, 0 );
   if( 0 > iPos ) {
      //
      iPos = strLine.indexOf( chComma, 0 );
      //
      if( 0 > iPos ) {
         //
         // 11
         //
         iStartVerse = strLine.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }
         occ->AddVerse( iStartVerse );
      } else {
         //
         // 11,15
         //
         iWordSize = iPos;
         strVerse = strLine.left( iWordSize ); 
         iStartVerse = strVerse.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }
         occ->AddVerse( iStartVerse );
         //
         iWordSize = strLine.size( ) - iPos - 1;
         strVerse = strLine.mid( iPos + 1, iWordSize ); 
         iEndVerse = strVerse.toInt( &bOK );
         if( !bOK ) {
            goto PIX_EXIT;
         }
         occ->AddVerse( iEndVerse );         
      }
   } else {
      //
      // 12-13
      //
      iWordSize = iPos;
      strVerse = strLine.left( iWordSize ); 
      iStartVerse = strVerse.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }
      //
      iWordSize = strLine.size( ) - iPos - 1;
      strVerse = strLine.mid( iPos + 1, iWordSize ); 
      iEndVerse = strVerse.toInt( &bOK );
      if( !bOK ) {
         goto PIX_EXIT;
      }
      occ->AddVerseSeq( iStartVerse, iEndVerse );
   }
   
   //

   k++;
   strInKjv = strBuffers.at( k );
   occ->SetInKjvLine( strInKjv );

   //

   k++;
   strKjv = strBuffers.at( k );
   occ->SetKjvLinet( strKjv );

   //

   k++;
   strShinkai = strBuffers.at( k );
   occ->SetShinkaiLin( strShinkai );

   //

   k++;
   strKougo = strBuffers.at( k );
   occ->SetKougoLine( strKougo );

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool hikari_window::CreateOneTabiji( int iCategory,
                                    QStringList *strBuffers,
                                    QTextStream *out )
{
   bool bRetCode = false;
   int nBuffers, i;
   QString strBuffer;
    
   //

   nBuffers = strBuffers->size( );
   for( i = 0 ; i < nBuffers ; i++ ) {
      strBuffer = strBuffers->at( i );

      // check how many hikari this line contains 
      
      // make a list of positions of (
      if( !DecompOneTabiji( iCategory, i, &strBuffer, out ) ) {
         goto PIX_EXIT;
      }
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool hikari_window::CreateOneOccasion( int iCategory,
                                    QStringList *strBuffers,
                                    QTextStream *out )
{
   bool bRetCode = false;
   int nBuffers, i;
   QString strBuffer;
    
   //

   nBuffers = strBuffers->size( );
   for( i = 0 ; i < nBuffers ; i++ ) {
      strBuffer = strBuffers->at( i );

      // check how many hikari this line contains 
      
      // make a list of positions of (
      if( !DecompOneOccasion( iCategory, i, &strBuffer, out ) ) {
         goto PIX_EXIT;
      }
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// X̌AJeS[ɕꂽ݌t̃t@C
//
// category_all.txt́AnotepadUTF-8IvVŃZ[uĂ
//
bool hikari_window::CreateTabijiData( void )
{
   bool bRetCode = false;
   bool bOK[2], bStatus, bFound;
   int iNumber[2], iCategory, iLastCategory, nLength;
   QFileInfo fi;
   QString strError, strTabijiFile, strBuffer, strCsvFile;
   QString strMessage, strNumber[2];
   QStringList strBuffers;

   QFile *in_file = NULL;
   QFile *out_file = NULL;

   QTextStream *in = NULL;
   QTextStream *out = NULL;

   // get file name

   strTabijiFile = GetTabijiWordsFile_PC( );
   fi.setFile( strTabijiFile );
   if( !fi.exists( ) ) {
      goto PIX_EXIT;
   }

   in_file = new QFile( strTabijiFile );
   if ( !in_file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      qDebug() << "ERROR! Failed to open file:" << strTabijiFile << "\n";
      strError = "ERROR! Failed to open file " + strTabijiFile + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   in = new QTextStream( in_file );
   in->setCodec( "UTF-16" );

   // create output csv file

   strCsvFile = GetCsvTabijiFile_PC( );

   out_file = new QFile( strCsvFile );
   if ( !out_file->open( QIODevice::WriteOnly | QIODevice::Text ) ) {
      strMessage = "ERROR! Failed to Create Temporary File:\n" + strCsvFile;
      QMessageBox::critical( NULL, _strApplication, strMessage );
      goto PIX_EXIT;
   }

   out = new QTextStream( out_file );
   out->setCodec( "UTF-16" );
   out->setGenerateByteOrderMark( true );

   // start reading
   bStatus = true;
   bFound = false;
   iCategory = -1;
   iLastCategory = -1;
   strBuffers.clear( );

   while( bStatus ) {
	
      if( in->atEnd( ) ) {
         if( 0 < iCategory ) {
            if( !CreateOneTabiji( iCategory, &strBuffers, out ) ) {
               goto PIX_EXIT;
            }
         }

			bStatus = false;
	   	continue;
      }

      //
      // read sinlge line from file
      //
   	strBuffer = in->readLine( );

      if( strBuffer.isNull( ) ) {
			bStatus = false;
	   	continue;
	   }   

      nLength = (int)strBuffer.size( );
      if( 0 >= nLength ) {
         continue;
      }

      // check if this is the number line
      // example

      strNumber[0] = strBuffer.left( 1 );
      iNumber[0] = strNumber[0].toInt( &bOK[0] );
      if( bOK[0] ) {
         iLastCategory = iCategory;
         strNumber[1] = strBuffer.mid( 1,1 );
         iNumber[1] = strNumber[1].toInt( &bOK[1] );
         if( bOK[1] ) {
            iCategory = iNumber[1] + 10 * iNumber[0];
         } else {
            iCategory = iNumber[0];
         }
   
         // make a list of category buffers
         if( 0 < iLastCategory ) {
            if( !CreateOneTabiji( iLastCategory, &strBuffers, out ) ) {
               goto PIX_EXIT;
            }
         }

         // start new buffer list
         strBuffers.clear( );

         continue;
      }

      // get string lines

      strBuffers.append( strBuffer );
      iLastCategory = iCategory;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( in_file ) {
      in_file->close( );
      in_file = NULL;
   }
   if( out_file ) {
      out_file->close( );
      out_file = NULL;
   }
   return bRetCode;
}

//
// X̌ASpecial Occasion - KJV
// t̃t@C
//
// read category_kjv.txt
// taken from
//
bool hikari_window::CreateOccasionsData( void )
{
   bool bRetCode = false;
   bool bOK, bStatus, bFound;
   int iCategory, iLastCategory, nLength;
   QFileInfo fi;
   QString strError, strOccFile, strBuffer, strCsvFile;
   QString strMessage, strNumber;
   QStringList strBuffers;

   QFile *in_file = NULL;
   QFile *out_file = NULL;

   QTextStream *in = NULL;
   QTextStream *out = NULL;

   // get file name

   strOccFile = GetOccasionsWordsFile_PC( );
   fi.setFile( strOccFile );
   if( !fi.exists( ) ) {
      goto PIX_EXIT;
   }

   in_file = new QFile( strOccFile );
   if ( !in_file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      qDebug() << "ERROR! Failed to open file:" << strOccFile << "\n";
      strError = "ERROR! Failed to open file " + strOccFile + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   in = new QTextStream( in_file );
   //in->setCodec( "UTF-16" );

   // create output csv file

   strCsvFile = GetCsvOccasionsFile_PC( );

   out_file = new QFile( strCsvFile );
   if ( !out_file->open( QIODevice::WriteOnly | QIODevice::Text ) ) {
      strMessage = "ERROR! Failed to Create Temporary File:\n" + strCsvFile;
      QMessageBox::critical( NULL, _strApplication, strMessage );
      goto PIX_EXIT;
   }

   out = new QTextStream( out_file );
   out->setCodec( "UTF-16" );
   out->setGenerateByteOrderMark( true );

   // start reading
   bStatus = true;
   bFound = false;
   iCategory = -1;
   iLastCategory = -1;
   strBuffers.clear( );

#ifdef _DEBUG
   g_iLine = 0;
#endif

   while( bStatus ) {

      if( in->atEnd( ) ) {
         if( 0 < iLastCategory ) {
            if( !CreateOneOccasion( iLastCategory, &strBuffers, out ) ) {
               goto PIX_EXIT;
            }
         }
         bStatus = false;
         continue;
      }

      //
      // read sinlge line from file
      //
      strBuffer = in->readLine( );

#ifdef _DEBUG
      g_iLine = 1 + g_iLine;
#endif

      if( strBuffer.isNull( ) ) {
         bStatus = false;
         continue;
      }

      nLength = (int)strBuffer.size( );
      if( 0 >= nLength ) {
         continue;
      }

      // check if this is the number line
      // example

      strNumber = strBuffer.mid( 0, 2 );
      iCategory = strNumber.toInt( &bOK );
      
      if( bOK ) {

         // make a list of category buffers
         if( 0 < iLastCategory ) {
            if( !CreateOneOccasion( iLastCategory, &strBuffers, out ) ) {
               goto PIX_EXIT;
            }           
         }
 
         // start new buffer list
         iLastCategory = iCategory;
         strBuffers.clear( );

         continue;
      }

      // get string lines

      strBuffers.append( strBuffer );
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( in_file ) {
      in_file->close( );
      in_file = NULL;
   }
   if( out_file ) {
      out_file->close( );
      out_file = NULL;
   }
   return bRetCode;
}

//
// CSVŕҏWꂽSpecial Occasions̃t@C
// XMLt@C𐶐
//
// oオAL3t@C
// occasions.xml
// ȉ̃fBNg[Ɉړ
// qtBagster\\Files
// qtHikari\\Files
//
bool hikari_window::CreateOccasionsXmlFromCsv( void )
{
   bool bRetCode = false;
   bool bStatus;
   int nOccasions, iOccasion, k, nBuffers, nLength;
   int nMaxLine, iLine, i, nLineWords, ii;
   QFileInfo fi;
   QString strLineSize, strMaxLine, strXmlFile, strCsvFile, strBuffer;
   QString strMessage, strError, strID, strOccasion, strEntry, strEnOccasion;
   
   QString strLine, strBook, strChapter, strVerses;

   BibleOccasion Occ;
   QVector<BibleOccasion> AllOcc;
   QVector<BibleOccasion> LineOcc;

   QFile *in_file = NULL;
   QFile *out_file = NULL;

   QTextStream *in = NULL;
   //QTextStream *out = NULL;

   QXmlStreamWriter writer;

   // get file name

   strCsvFile = GetOccasionsCsvFile_PC( );
   fi.setFile( strCsvFile );
   if( !fi.exists( ) ) {
      goto PIX_EXIT;
   }

   in_file = new QFile( strCsvFile );
   if ( !in_file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      qDebug() << "ERROR! Failed to open file:" << strCsvFile << "\n";
      strError = "ERROR! Failed to open file " + strCsvFile + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   in = new QTextStream( in_file );
   in->setCodec( "UTF-8" );

   // create output xml file

   strXmlFile = GetBagsterOccasionsXmlFile_PC( );
   out_file = new QFile( strXmlFile );
   if ( !out_file->open( QFile::WriteOnly | QFile::Text ) ) {
      strMessage = "ERROR! Failed to Create Temporary File:\n" + strXmlFile;
      QMessageBox::critical( NULL, _strApplication, strMessage );
      goto PIX_EXIT;
   }

   writer.setAutoFormatting(true);
   writer.setDevice( out_file );

   writer.writeStartDocument();
   //writer.writeDTD("<!DOCTYPE occasions>");

   writer.writeStartElement( "occasions" );
   writer.writeAttribute( "version", "1.0" );
   writer.writeAttribute( "data", "bagster" );
   writer.writeAttribute( "revision", "special_occasions" );

   // start reading
   bStatus = true;
   AllOcc.clear( );
   while( bStatus ) {

      if( in->atEnd( ) ) {
         bStatus = false;
         continue;
      }

      // 
      // read sinlge line from file
      //
      strBuffer = in->readLine( );

      if( strBuffer.isNull( ) ) {
         bStatus = false;
         continue;
      }

      nLength = (int)strBuffer.size( );
      if( 0 >= nLength ) {
         continue;
      } 

      // check if this is the number line
      // example

      if( !DecodeCsvOccasion( &strBuffer, &Occ ) ) {
         goto PIX_EXIT;
      }

      AllOcc.push_back( Occ );   
   }

   //

   nOccasions = 38;
   nBuffers = AllOcc.size( );
   for( i = 1 ; i <= nOccasions ; i++ ) {
      nMaxLine = 0;
      for( k = 0 ; k < nBuffers ; k++ ) {
         Occ = AllOcc.at( k );
         iOccasion = Occ.GetOccasion( );
         if( iOccasion != i ) continue;
         
         strOccasion = Occ.GetNamOccasion( );
         strEnOccasion = Occ.GetEnOccasion( );

         iLine = Occ.GetOccasionLine( );
         nMaxLine = max( nMaxLine, iLine );
      }

      //
      
      writer.writeStartElement( "Occasion" );

      strID.sprintf( "%d", i );
      writer.writeAttribute( "ID", strID );

      writer.writeAttribute( "Name", strOccasion );
      writer.writeAttribute( "EnName", strEnOccasion );

      strMaxLine.sprintf( "%d", nMaxLine );
      writer.writeAttribute( "MaxLine", strMaxLine );

      // write lines

      for( ii = 1 ; ii <= nMaxLine ; ii++ ) {
         
         writer.writeStartElement( "Line" );

         strLine.sprintf( "%d", ii );
         writer.writeAttribute( "ID", strLine );
   
         // make a list of entries of thie line

         LineOcc.clear( );
         for( k = 0 ; k < nBuffers ; k++ ) {
            Occ = AllOcc.at( k );
            iOccasion = Occ.GetOccasion( );
            if( iOccasion != i ) continue;

            iLine = Occ.GetOccasionLine( );
            if( ii != iLine ) continue;

            LineOcc.push_back( Occ );
         }

         // write this line

         nLineWords = (int)LineOcc.size( );
         strLineSize.sprintf( "%d", nLineWords );
         writer.writeAttribute( "Size", strLineSize );
         for( k = 0 ; k < nLineWords ; k++ ) {
            Occ = LineOcc.at( k );

            //
            
            writer.writeStartElement( "Entry" );

            strEntry.sprintf( "%d", k+1 );
            writer.writeAttribute( "ID", strEntry );

            strBook.sprintf( "%d", Occ.GetBook( ) );
            writer.writeAttribute( "Book", strBook );

            strChapter.sprintf( "%d", Occ.GetChapter( ) );
            writer.writeAttribute( "Chapter", strChapter );

            strVerses = Occ.strVerseBuffer( );
            writer.writeAttribute( "Verses", strVerses );

            writer.writeTextElement( "Kjv", Occ.GetKjvLinet( ) );
            writer.writeTextElement( "Shin", Occ.GetShinkaiLin( ) );
            writer.writeTextElement( "Kougo", Occ.GetKougoLine( ) );

            //
            writer.writeEndElement(); // Entry
         }
         writer.writeEndElement(); // Line
      }
   
      //      
      writer.writeEndElement(); // occasion
      
   }

   // end the last section

   writer.writeEndElement();

   // create output xml file
   //writer.writeEndElement();
   writer.writeEndDocument();

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( in_file ) {
      in_file->close( );
      in_file = NULL;
   }
   if( out_file ) {
      out_file->close( );
      out_file = NULL;
   }
   return bRetCode;
}

//
// TXT`́wX̌xt@C
// XMLt@C𐶐
//
bool hikari_window::CreateBagsterXmlFromTxt( int iVersion )
{
   bool bRetCode = false;
   bool bAM[2];
   int nMonthDays, k, i, iMonth, iDay, nLines;
   QString strKjvLine, strShinkai, strKougo, strLine, strSize, strMonth;
   QString strMessage, strError, strAm, strDay;
   QString strXmlFile, strFile;

   int nDays[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, -1 };

   QStringList strLines;

   QFile *in_file = NULL;
   QFile *out_file = NULL;

   QXmlStreamWriter writer;

   // get file name

   switch( iVersion ) {
   case pixq_Properties::BibleKingJames:
      strFile = GetDailyWordsTxtFile_PC( iVersion );
      break;
   case pixq_Properties::BibleKougoyaku:
      strFile = GetDailyWordsTxtFile_PC( iVersion );
      break;
   case pixq_Properties::BibleShinkaiyaku2: 
      strFile = GetDailyWordsTxtFile_PC( iVersion );
      break;
   default:
      goto PIX_EXIT;
   }

   //

   in_file = new QFile( strFile );
   if ( !in_file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      strError = "ERROR! Failed to open file " + strFile + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   // create output xml file

   strXmlFile = GetXmlBagsterFile_PC( iVersion );
   out_file = new QFile( strXmlFile );
   if ( !out_file->open( QFile::WriteOnly | QFile::Text ) ) {
      strMessage = "ERROR! Failed to Create Temporary File:\n" + strXmlFile;
      QMessageBox::critical( NULL, _strApplication, strMessage );
      goto PIX_EXIT;
   }

   writer.setAutoFormatting(true);
   writer.setDevice( out_file );

   writer.writeStartDocument();
   //writer.writeDTD("<!DOCTYPE occasions>");

   writer.writeStartElement( "bagster" );
   writer.writeAttribute( "version", "1.0");
   writer.writeAttribute( "data", "bagster" );
   writer.writeAttribute( "revision", "daily_words" );

   // start reading
   bAM[0] = true;
   bAM[1] = false;
   for( iMonth = 1 ; iMonth <= 12 ; iMonth++ ) {
      
      writer.writeStartElement( "Month" );
      strMonth.sprintf( "%d", iMonth );
      writer.writeAttribute( "ID", strMonth );

      nMonthDays = nDays[iMonth-1];      
      for( iDay = 1 ; iDay <= nMonthDays ; iDay++ ) {
         
         writer.writeStartElement( "Day" );
         strDay.sprintf( "%d", iDay );
         writer.writeAttribute( "ID", strDay );

         for( k = 0 ; k < 2 ; k++ ) {
            
            writer.writeStartElement( "AMPM" );
            strAm = bAM[k]? "AM" : "PM";
            writer.writeAttribute( "ID", strAm );

            // get words
            
            strLines.clear( );
            if( !GetDaysTxtWords( in_file, iMonth, iDay, bAM[k], &strLines ) ) {
               goto PIX_EXIT;
            }

            //
         
            nLines = strLines.size( );
            strSize.sprintf( "%d", nLines );
            writer.writeAttribute( "Size", strSize );

            for( i = 0 ; i < nLines ; i++ ) {
/*
               writer.writeStartElement( "Line" );
               strLine.sprintf( "%d", i+1 );
               writer.writeAttribute( "ID", strLine );
            */

               strLine = strLines.at( i );

               writer.writeTextElement( "Words", strLine ); 
/*
               writer.writeEndElement(); // Line
            */
            }

            writer.writeEndElement(); // AM/PM
         }
         writer.writeEndElement(); // Day
      }
      writer.writeEndElement(); // Month
   }

   // end the last section
   writer.writeEndElement();

   // create output xml file
   writer.writeEndDocument();

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( in_file ) {
      in_file->close( );
      in_file = NULL;
   }
   if( out_file ) {
      out_file->close( );
      out_file = NULL;
   }
   return bRetCode;
}

//
// csvt@CwX̌xXMLt@C𐶐
//
// oオAL3t@C
// daily_shin.xml
// daily_kougo.xml
// daily_kjv.xml
// ȉ̃fBNg[Ɉړ
// qtBagster\\Files
// qtHikari\\Files
//
bool hikari_window::CreateBagsterXmlFromTxt( void )
{
   bool bRetCode = false;
   int iVersion;

   // get file name

   iVersion  = pixq_Properties::BibleKingJames;
   if( !CreateBagsterXmlFromTxt( iVersion ) ) {
      goto PIX_EXIT;
   }

   iVersion  = pixq_Properties::BibleKougoyaku;
   if( !CreateBagsterXmlFromTxt( iVersion ) ) {
      goto PIX_EXIT;
   }

   iVersion  = pixq_Properties::BibleShinkaiyaku2; 
   if( !CreateBagsterXmlFromTxt( iVersion ) ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool hikari_window::MakeCccasionsList( QStringList &strOccasions, // [o] japanese
                                      QStringList &strEnOccasions ) // [o] 
{
   bool bRetCode = false;
   bool bFound, bOK, bStatus;
   int iValue;
   QString strEnName, strXmlFile, strError, strName, strValue;
   QChar chValue, chAm;
   QXmlStreamReader reader;
   QXmlStreamAttributes attr;
   QFile *file = NULL;
   
   strXmlFile = GetBagsterOccasionsXmlFile_PC( );

   file = new QFile( strXmlFile );
   if ( !file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      strError = "ERROR! Failed to open file " + strXmlFile + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   reader.setDevice( file );

   // check the header

   if( !reader.readNextStartElement( ) ) {
      goto PIX_EXIT;
   }

   if( reader.name() != "occasions" ) {
      goto PIX_EXIT;
   }

   if( reader.attributes().value("version") != "1.0") {
      goto PIX_EXIT;
   }

   //

   strOccasions.clear( );
   strEnOccasions.clear( );

   bStatus = true;
   bFound = false;
   while( bStatus ) {

      if( reader.atEnd( ) ) {
         bStatus = false;
         continue;
      }
   
      // find the month
   
      if( !reader.readNextStartElement()) {
         bStatus = false;
         continue;
      }
   
      strName = reader.name().toString( );
   
      if( "Occasion" != strName ) {
         continue;
      }

      attr = reader.attributes();

      strValue = attr.value( "ID" ).toString();
      iValue = strValue.toInt( &bOK );
      if( !bOK ) {
         bStatus = false;
         continue;
      }
   
      strName = attr.value( "Name" ).toString();
      strEnName = attr.value( "EnName" ).toString();

      strOccasions.push_back( strName );
      strEnOccasions.push_back( strEnName );

      reader.skipCurrentElement();      
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}   

//
// CSV`́wX̌xt@CŁASo[W̍svĂ邩A`FbN
//
bool hikari_window::CheckBagsterLineCount( void )
{
   bool bRetCode = false;
   bool bAM[2];
   int nMonthDays, iLine, k, iWord, iVer, iMonth, iDay, nLines[3];
   QString strKjvLine, strShinkai, strKougo, strSize, strMonth;
   QString strMessage, strError, strAm, strDay;
   QString strFile[3], strLine[3], strNamBook[3];
   int iVersions[3], nWords[3];

   BibleAllBooks *pBL = GetBibleBooks( );

   int nDays[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, -1 };

   QStringList strLines[3];
   QStringList strBooks[3];
   QFile *in_file[3];
   BibleSetVerses bv[3];

   //
   
   for( iVer = 0 ; iVer < 3 ; iVer++ ) {
      in_file[iVer] = NULL;
   }

   // get file name

   iVersions[0] = pixq_Properties::BibleKougoyaku;
   iVersions[1] = pixq_Properties::BibleShinkaiyaku2;
   iVersions[2] = pixq_Properties::BibleKingJames;

   // check the number of lines for each day am and pm

   for( iVer = 0 ; iVer < 3 ; iVer++ ) {

      strFile[iVer] = GetDailyWordsTxtFile_PC( iVersions[iVer] );

      in_file[iVer] = new QFile( strFile[iVer] );
      if ( !in_file[iVer]->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
         strError = "ERROR! Failed to open file " + strFile[iVer] + ".";
         QMessageBox::critical( NULL, _strApplication, strError );
         goto PIX_EXIT;
      }
   }

   bAM[0] = true;
   bAM[1] = false;
   for( iMonth = 1 ; iMonth <= 12 ; iMonth++ ) {
      
      nMonthDays = nDays[iMonth-1];      
      for( iDay = 1 ; iDay <= nMonthDays ; iDay++ ) {
         
         for( k = 0 ; k < 2 ; k++ ) {
           
            for( iVer = 0 ; iVer < 3 ; iVer++ ) {
               // get words
               strLines[iVer].clear( );
               if( !GetDaysTxtWords( in_file[iVer], iMonth, iDay, bAM[k], &strLines[iVer] ) ) {
                  goto PIX_EXIT;
               }
         
               nLines[iVer] = strLines[iVer].size( );
            }
        
            // check number of lines for each days, am/pm

            if( nLines[0] != nLines[1] ) {
               goto PIX_EXIT;
            }   
 
            if( nLines[0] != nLines[2] ) {
               goto PIX_EXIT;
            }

            // check number of words in each line

            for( iLine = 0 ; iLine < nLines[0] ; iLine++ ) {
               for( iVer = 0 ; iVer < 3 ; iVer++ ) {
                  strLine[iVer] = strLines[iVer].at( iLine );
                  if( !NumberOfWords_PC( strLine[iVer], strBooks[iVer] ) ) {   
                     goto PIX_EXIT; 
                  }

                  nWords[iVer] = (int)strBooks[iVer].size( );
            
                  if( 0 >= nWords[iVer] ) {
                     // line is invalid
                      goto PIX_EXIT;
                  }
               }
 
               if( nWords[0] != nWords[1] ) {
                  goto PIX_EXIT;
               }

               if( nWords[0] != nWords[2] ) {
                  goto PIX_EXIT;
               } 

               // check the book name for each word

               for( iWord = 0 ; iWord < nWords[0] ; iWord++ ) {
                  for( iVer = 0 ; iVer < 3 ; iVer++ ) {
                     strNamBook[iVer] = strBooks[iVer].at( iWord );

                     // get book number in bible

                     if( !bv[iVer].GetBool( pBL, iVersions[iVer], strNamBook[iVer] ) ) {
                        goto PIX_EXIT;
                     }
                  } 

                  // check if book numbers are same

                  if( !bv[0].IsSameBookChapter( bv[1] ) ) {
                     goto PIX_EXIT;
                  }

                  if( !bv[0].IsSameBookChapter( bv[2] ) ) {
                     goto PIX_EXIT;
                  }
               }
            }
         }
      } 
   }

   // --- DONE ---
   bRetCode = true; 
PIX_EXIT: 
   for( iVer = 0 ; iVer < 3 ; iVer++ ) {
      if( in_file[iVer] ) {
         in_file[iVer]->close( );
         in_file[iVer] = NULL;
      }
   }
 
   return bRetCode;
}

//  
// ʓǕ\
// 
void hikari_window::CreateBibleReadPlan( void ) 
{
   BiblePlanYear plan;
   
   plan.LoadInitPlan( pixq_Properties::BiblePlanThematic );  

   plan.LoadInitPlan( pixq_Properties::BiblePlanClassic );  
   plan.LoadInitPlan( pixq_Properties::BiblePlanBookOrder );

   //plan.CreateHikariOldNew( pixq_Properties::BiblePlanHikariOldNew );
   //plan.CreateHikariNewOldNew( pixq_Properties::BiblePlanHikariNewOldNew );

   plan.LoadInitPlan( pixq_Properties::BiblePlanBeginingToEnd );
   plan.LoadInitPlan( pixq_Properties::BiblePlanChronological );
   plan.LoadInitPlan( pixq_Properties::BiblePlanOldChronological );
   plan.LoadInitPlan( pixq_Properties::BiblePlanNewChronological );
   plan.LoadInitPlan( pixq_Properties::BiblePlanHistorical );
   plan.LoadInitPlan( pixq_Properties::BiblePlanOldAndNewOneDay );

   plan.LoadInitPlan( pixq_Properties::BiblePlanMichaelColey ); 

   return;
}
