#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"


#include "hikari_window.h"


#define ISV_DIVIDE_VERSE_CHAR '*'

#ifdef _DEBUG
int g_iBook;
int g_iChapter;
#endif

static QString GetIsvTextFile( void ) 
{
   QString strPath;
   strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );
   strPath.append( "/Files_ISV/all_edit.txt\0" );  
   return strPath;
}

static QString strIsvBookFile( void ) 
{
   QString strPath;
   strPath = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );
   strPath.append( "/Files_ISV/books.txt\0" );  
   return strPath;
}

static bool ReadBooks( QStringList &strBooks )
{
   bool bRetCode = false;
   bool bStatus;
   QString strBook, strBookFile;
#ifdef _DEBUG
   int i, nBooks;
#endif 

   QFile *file = NULL;
   QTextStream *in = NULL;

   // read all titles

   strBookFile = strIsvBookFile( );

   file = new QFile( strBookFile );
   if ( !file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      goto PIX_EXIT;
   }

   //

   strBooks.clear( );

   in = new QTextStream( file );
   in->seek( 0 );

   bStatus = true;
   while( bStatus ) {
	
      if( in->atEnd( ) ) {
		   bStatus = false;
		   continue;
      }

      //
      // read sinlge line from file
      //
   	strBook = in->readLine( );
      strBook = strBook.trimmed( );
      strBooks.append( strBook );
   }  

#ifdef _DEBUG
   nBooks = strBooks.size( );
   for( i = 0 ; i < nBooks ; i++ ) {
      strBook = strBooks.at( i );
   }
#endif 

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}  

static bool FindVerseNum( QString strAll,
                          int iVerse, 
                          int &iStartPos, // [i/o]
                          int &iVersePos ) // [o] verse start pos
{
   bool bRetCode = false;
   bool bFound;
   int nLength, nWidth, iPrev, iNext;
   QString strVerse;
   QChar chDiv = ISV_DIVIDE_VERSE_CHAR;
   QChar chHyphen = '-';
   QChar chHyphen2 = 8213; // long hyphen
   QChar chPeriod = '.';
   QChar chNext, chPrev;

#ifdef _DEBUG
   QString strRight;
   QString strFirstRight;
   int iFirstStartPos;
#endif

   nLength = strAll.size( );

   strVerse.sprintf( "%d", iVerse );
   if( 10 > iVerse ) {
      nWidth = 1;
   } else if( 100 > iVerse ) {
      nWidth = 2;
   } else {
      nWidth = 3;
   }

#ifdef _DEBUG
   strFirstRight = strAll.right( nLength - iStartPos );
   iFirstStartPos = iStartPos;
#endif

   bFound = false;
   while( !bFound ) {

      if( iStartPos >= nLength ) {
         goto PIX_EXIT;
      }

#ifdef _DEBUG
      strRight = strAll.right( nLength - iStartPos );
#endif

      iVersePos = strAll.indexOf( strVerse, iStartPos );
      if( 0 > iVersePos ) {
         // verse not found at all
         goto PIX_EXIT;
      }

      iStartPos = iVersePos + nWidth;

      //
      if( 0 == iVersePos ) {
         bFound = true;
         continue;
      }

      iPrev = iVersePos - 1;
      chPrev = strAll.at( iPrev );
      if( chDiv == chPrev ) {
         // OK
      } else if( chPrev.isSpace( ) ) {
         // OK
      } else if( chHyphen == chPrev ) {
         // OK
      } else if( chHyphen2 == chPrev ) {
         // OK
      } else if( chPeriod == chPrev ) {
         // OK
      } else if( chPrev.isNumber( ) ) {
         continue;
      } else {
         continue;
      }

      iNext = iVersePos + nWidth;
      chNext = strAll.at( iNext );
      if( chDiv == chNext ) {
         continue;
      } else if( chNext.isNumber( ) ) {
         continue;
      } else if( chNext.isSpace( ) ) {
         //continue;
      }

      bFound = true;
   }

   if( !bFound ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}   

//
// decompose verse buffer into buffers with one verse in one line
//
static bool DecomposeVerses( int iChapter,
                             BibleBook bc, 
                             QStringList &strVerses, // [i] all lines in this verses
                             QStringList &strDecompVerses ) // [o] one verse in one line
{
   bool bRetCode = false;
   int k, iPos, iVersePos, iNext, nLength, nVerses, nWidth, nLines;
   int kStart, kEnd;
   bool bVerseZero;
   QString strAll, strVerse, strBuffer;
   QStringList strVerseNums;
   QVector<int> viVersePos;
   
   QChar chDiv = ISV_DIVIDE_VERSE_CHAR;

   nLines = strVerses.size( );
   nVerses = bc.GetChapterVerseNumber( iChapter+1 );
   bVerseZero = bc.GetVerseZero( iChapter );

   // make one big buffer with * at the end of input lines

   strAll.clear( );
   for( k = 0 ; k < nLines ; k++ ) {
      strBuffer = strVerses.at( k );
      strAll = strAll + chDiv;
      strAll = strAll + strBuffer;      
   }

   nLength = strAll.size( );

   // set positions of verse numbers

#ifdef _DEBUG
g_iChapter = iChapter;
#endif

   viVersePos.resize( nVerses+1 );
   iPos = 0;
   kStart = bVerseZero ? 0 : 1;
   kEnd = nVerses;
   for( k = kStart ; k <= kEnd ; k++ ) {
      if( !FindVerseNum( strAll, k, iPos, iVersePos ) ) {
         goto PIX_EXIT;
      }
      viVersePos.replace( k, iVersePos );
   }

   //

#ifdef _DEBUG
   for( k = 0 ; k < nVerses ; k++ ) {
      iPos = viVersePos.at( k );
   }
#endif

   // divide into one-line-one-verse string

   strDecompVerses.clear( );

   for( k = 0 ; k < kStart ; k++ ) {
      strDecompVerses.push_back( "-" );
   }

   for( k = kStart ; k <= kEnd ; k++ ) {

      if( 9 >= k ) {
         nWidth = 1;
      } else if( 99 >= k ) {
         nWidth = 2;
      } else {
         nWidth = 3;
      }

      iPos = viVersePos.at( k );
      if( k == kEnd ) {
         iNext = nLength - 1;
      } else {
         iNext = viVersePos.at( k+1 ) - 1;
      }

      strBuffer = strAll.mid( iPos + nWidth, iNext - iPos - nWidth );
      strDecompVerses.push_back( strBuffer );
   }

   //

#ifdef _DEBUG
   for( k = 0 ; k < nVerses ; k++ ) {
      strBuffer = strDecompVerses.at( k );
   }
#endif

   // check the last verse and make sure there is no more verse
   // this is to check the number of verses of all chapters set in BibleAllBooks

   k = kEnd;
   strBuffer = strDecompVerses.at( k );
   strVerse.sprintf( "%d", nVerses+1 ); 
   iVersePos = strBuffer.indexOf( strVerse, 0 );
   if( 0 <= iVersePos ) {
      // suspicious!
      goto PIX_EXIT;
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}   

static bool ReadSingleBook( int iBook, 
                           BibleAllBooks *pBL,
                           QStringList &strBooks,
                           QXmlStreamWriter &writer )
{
   bool bRetCode = false;
   bool bVerseZero, bFound, bStatus;
   int i, k, iChapter, nBuffers, nChapters, iChapterStart, iChapterEnd;
   int nChapterVerses, nVerses, iDiv, iStart, iEnd;
   QString strChapter, strVerse, strBuffer, strNextBook, strBook, strFile;
   QString strChapters, strBookName, strSplit, strBookNum;

   QStringList strBuffers, strSplits;

   QFile *file = NULL;
   QTextStream *in = NULL;
   BibleBook bc;
   QStringList strChapterVerses;
   QStringList strDecompVerses;
   QVector<int> viVerses;
   QVector<int> viChapterPos;
   QVector<bool> vbVerseFound;

   int iVersion = pixq_Properties::BibleIntlStandard;
   QChar chDiv = ISV_DIVIDE_VERSE_CHAR;

   // read all titles

   strFile = GetIsvTextFile( );

   file = new QFile( strFile );
   if ( !file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      goto PIX_EXIT;
   }

   // Book name and next

   strBook = strBooks.at( iBook );
   if( 65 == iBook ) {
      strNextBook.clear( );
   } else {
      strNextBook = strBooks.at( iBook+1 );
   }
   //

   strBuffers.clear( );

   in = new QTextStream( file );
   in->seek( 0 );

   bStatus = true;
   bFound = false;
   while( bStatus ) {
	
      if( in->atEnd( ) ) {
		   bStatus = false;
		   continue;
      }

   	strBuffer = in->readLine( );
      strBuffer = strBuffer.trimmed( );
      if( strBuffer.isEmpty( ) ) continue;

      if( 0 == strBuffer.compare( strBook ) ) {
         bFound = true;
      }

      if( 0 == strBuffer.compare( strNextBook ) ) {
         bStatus = false;
         continue;
      }

      //
      // read sinlge line from file
      //
      if( bFound ) {
         strBuffers.append( strBuffer );
      }
   } 

   if( !bFound ) {
      goto PIX_EXIT;
   }

   // check all chapter positions

   bc = pBL->GetBook( iBook );
   bc.GetChapterVerseNumbers( viVerses );
   nChapters = viVerses.size( );
   viChapterPos.resize( nChapters );
   viChapterPos.fill( -1 );

   nBuffers = strBuffers.size( );

   for( k = 0 ; k < nChapters ; k++ ) {
      if( 18 == iBook ) {
         strChapter.sprintf( "Psalm %d", k+1 );
      } else {
         strChapter.sprintf( "Chapter %d", k+1 );
      }

      bFound = false;
      for( i = 0 ; !bFound && i < nBuffers ; i++ ) {
         strBuffer = strBuffers.at( i );
         if( 0 == strBuffer.compare( strChapter ) ) {
            viChapterPos.replace( k, i );
            bFound = true;
         }
      }         
   }

   for( k = 0 ; k < nChapters ; k++ ) {
      iChapter = viChapterPos.at( k );
      if( 0 >= iChapter ) {
         goto PIX_EXIT;
      }
   }

   // write book info

   writer.writeStartElement( "Book" );

   strBookNum.sprintf( "%d", iBook + 1 );
   writer.writeAttribute( "ID", strBookNum );

   strBookName = bc.GetVersionBookName( iVersion );
   writer.writeAttribute( "Name", strBookName );

   strChapters.sprintf( "%d", nChapters );
   writer.writeAttribute( "Chapters", strChapters );

   // each chapter

   for( k = 0 ; k < nChapters ; k++ ) {
      iChapter = k + 1;
      
      iChapterStart = viChapterPos.at( k ) + 1;
      if( k == nChapters - 1 ) {
         // last chapter
         iChapterEnd = nBuffers - 1;
      } else {
         iChapterEnd = viChapterPos.at( k+1 ) - 1;
      }

      // chapter verses

      strChapterVerses.clear( );
      strDecompVerses.clear( );

      for( i = iChapterStart ; i <= iChapterEnd ; i++ ) {
         strBuffer = strBuffers.at( i );
         strChapterVerses.push_back( strBuffer );
      }

      // decompose vector into verses - one line for one verse

      if( !DecomposeVerses( k, bc, strChapterVerses, strDecompVerses ) ) {
         goto PIX_EXIT;
      }

      // write chapter

      writer.writeStartElement( "Chapter" ); // Chapter

      strChapter.sprintf( "%d", iChapter );
      writer.writeAttribute( "ID", strChapter );

      nChapterVerses = bc.GetChapterVerseNumber( iChapter );
      strVerse.sprintf( "%d", nChapterVerses );
      writer.writeAttribute( "Verses", strVerse );

      // check verses
      
      vbVerseFound.resize( nChapterVerses+1 );
      vbVerseFound.fill( false );

      nVerses = (int)strDecompVerses.size( );

      if( 18 == iBook ) {
         // check psalm first line!
         bVerseZero = bc.GetVerseZero( k );
         if( !bVerseZero ) {
            vbVerseFound.replace( 0, true );
         }
      } else {
         bVerseZero = false;
         vbVerseFound.replace( 0, true );
      }
      
      if( nVerses != (1+nChapterVerses) ) {
         goto PIX_EXIT;
      }

      iStart = bVerseZero ? 0 : 1;
      iEnd = nVerses - 1;
      for( i = iStart ; i <= iEnd ; i++ ) {

         writer.writeStartElement( "Verse" ); // Verse

         strVerse.sprintf( "%d", i );
         writer.writeAttribute( "ID", strVerse );
   
         
         // divide by lines

         strBuffer = strDecompVerses.at( i );
         iDiv = strBuffer.indexOf( chDiv, 0 );
         if( 0 > iDiv ) {
            // one line
            strBuffer = strBuffer.trimmed( );
            //writer.writeTextElement( "Words", strBuffer ); 
            writer.writeAttribute( "Words", strBuffer ); 
         } else {
            // there are more than one lines
            // lines are divided by '*'            
            // split into separate lines
            /*
            strSplits = strBuffer.split( chDiv, QString::SkipEmptyParts );
            nSplits = (int)strSplits.size( );
            for( ii = 0 ; ii < nSplits ; ii++ ) {
               strSplit = strSplits.at( ii );
               strSplit = strSplit.trimmed( );
               writer.writeTextElement( "Words", strSplit ); 
            }
            */

            // do not split, just replace '*'; by ' '
            strBuffer.replace( chDiv, ' ' );
            strBuffer = strBuffer.trimmed( );
            //writer.writeTextElement( "Words", strBuffer ); 
            writer.writeAttribute( "Words", strBuffer ); 
         }

         writer.writeEndElement(); // Verse
         vbVerseFound.replace( i, true );
      }

      for( i = 0 ; i <= nChapterVerses ; i++ ) {
         bFound = vbVerseFound.at( i );
         if( !bFound ) {
            // verse does not exist
            goto PIX_EXIT;
         }
      }

      writer.writeEndElement(); // Chapter

   }

   // end of the book

   writer.writeEndElement(); // Book

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}  

//
// convert bible text files to xml
//
// notes:
// three bibles, kougoyaku, shinkaiyaku, kjv
// 
bool hikari_window::ConvertIsvBibleXml( void )
{
   bool bRetCode = false;
   int iVersion, i;
   QString strVersion, strIsvFile, strXmlFile;
   QStringList strBooks;
   QFile *out_file = NULL;
   QXmlStreamWriter writer;

   BibleAllBooks *pBL = GetBibleBooks( );
   int nBooks = pBL->GetLength( );
   
   // input file

   strIsvFile = GetIsvTextFile( );

   // output file

   iVersion = pixq_Properties::BibleIntlStandard;
   strXmlFile = GetBibleXmlFile_PC( iVersion ); // OK

   out_file = new QFile( strXmlFile );
   if ( !out_file->open( QFile::WriteOnly | QFile::Text ) ) {
      goto PIX_EXIT;
   }

   writer.setAutoFormatting(true);
   writer.setDevice( out_file );

   writer.writeStartDocument();
   //writer.writeDTD("<!DOCTYPE occasions>");

   strVersion = pixq_Properties::GetBibleVersionName( iVersion );
   writer.writeStartElement( "hikari" );
   writer.writeAttribute( "version", "1.0" );
   writer.writeAttribute( "data", "bibles" );
   writer.writeAttribute( "translation", strVersion );

   // read Books list

   if( !ReadBooks( strBooks ) ) {
      goto PIX_EXIT;
   }

   for( i = 0 ; i < nBooks ; i++ ) {
#ifdef _DEBUG
      g_iBook = i;
#endif
      if( !ReadSingleBook( i, pBL, strBooks, writer ) ) {
         goto PIX_EXIT;
      }
   }

   // end the last section

   writer.writeEndElement();

   // create output xml file

   writer.writeEndDocument();

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( out_file ) {
      out_file->close( );
      out_file = NULL;
   } 
   return bRetCode;
}



