#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"

#include "hikari_window.h"

bool hikari_window::ReadTorreyIndex( QStringList &strTitles )
{   
   bool bRetCode = false;
   bool bHeader, bStatus;
   int i, nBuffers, nLength, iStartPos, iEndPos;
   QString strBuffer, strError, strIndexFile;
   QFile *file = NULL;
   QTextStream *in = NULL;
   QChar ch;
   QStringList strBuffers;

   // read all titles

   strIndexFile = GetTorreyIndexFile_PC( );

   file = new QFile( strIndexFile );
   if ( !file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      strError = "ERROR! Failed to open file " + strIndexFile + ".";
      QMessageBox::critical( NULL, _strApplication, strError );
      goto PIX_EXIT;
   }

   //

   strBuffers.clear( );

   in = new QTextStream( file );
   in->seek( 0 );

   bStatus = true;
   while( bStatus ) {
	
      if( in->atEnd( ) ) {
		   bStatus = false;
		   continue;
      }

      //
      // read sinlge line from file
      //
   	strBuffer = in->readLine( );

      strBuffers.append( strBuffer );
   }  

   // clean up index

   nBuffers = strBuffers.size( );

   strTitles.clear( );

   bHeader = true;
   bStatus = true;
   for( i = 0 ; i < nBuffers ; i++ ) {

      if( !bStatus ) {
         continue;
      }

      strBuffer = strBuffers.at( i );
      nLength = (int)strBuffer.size( );
      if( 0 >= nLength ) {
         continue;
      }

      ch = strBuffer.at( 0 );

      if( bHeader ) {
      
         // wait until ------
         if( '-' == ch ) {
            // end of header
            bHeader = false;
         }
         continue;
      }

      // - marks the end of contents
       
      if( '-' == ch ) {
         bStatus = false;         
         continue;
      }

      // get index

      if( '<' == ch ) {      
         continue;
      }

      // remove link between < and > if any

      iStartPos = strBuffer.indexOf( '<', 0 );
      iEndPos = strBuffer.indexOf( '>', 0 );

      if( 0 < iStartPos ) {
         if( iEndPos <= iStartPos ) {
            // something is wrong!
            continue;
         }

         strBuffer.remove( iStartPos, iEndPos - iStartPos + 1 );
      }

      strBuffer = strBuffer.trimmed( );
      strTitles.push_back( strBuffer );
   }

#ifdef _DEBUG
   nBuffers = strTitles.size( );
   for( i = 0 ; i < nBuffers ; i++ ) {
      strBuffer = strTitles.at( i );
   }
#endif 

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}   

//
// check if the line only consists oif : ; , . number or bible book name
//
static bool bLineContinuing( BibleAllBooks *pBL,                                        
                            QString strLine )
{
   bool bRetCode = false;
   QString strTmp = strLine;
   QString strShort, strPattern;
   int i, nLength, nPatterns;

   strTmp = strLine;

   // remove short book names

   nPatterns = (int)pBL->TorreyBookPatterns( );
   for( i = 0 ; i < nPatterns ; i++ ) {
      strPattern = pBL->GetTorreyBookPatterns( i );
      strTmp.remove( strPattern, Qt::CaseSensitive );
   }

   // remove numbers , ; :

   strTmp.remove( QRegExp("[0-9]") );
   strTmp.remove( ":" );
   strTmp.remove( ";" );
   strTmp.remove( "." );
   strTmp.remove( "," );
   strTmp.remove( "-" );
   strTmp = strTmp.trimmed( );

   nLength = strTmp.size( );
   if( 0 >= nLength ) {
      // this is title line
      bRetCode = true;
      goto PIX_EXIT;
   } else if( 10 >= nLength ) {
      goto PIX_EXIT;
   }

   // --- DONE ---
PIX_EXIT:
   return bRetCode;
}

static bool ReadPageBuffers( BibleAllBooks *pBL,
                             QString strPageFile,
                             QStringList &strAllBuffers ) 
{
   bool bRetCode = false;
   bool bCont, bHeader, bStatus;
   int i, nLines, nLength, nBuffers, nSize, iStartPos, iEndPos;
   QFile *file = NULL;
   QTextStream *in = NULL;
   QChar ch;
   QVector<bool> vbContinue;

   QString strLine, strTorreyFile, strBuffer, strError;
   QStringList strLines, strReadBuffers, strPageBuffers;
   
   // open file

   file = new QFile( strPageFile );
   if ( !file->open( QIODevice::ReadOnly | QIODevice::Text ) ) {
      goto PIX_EXIT;
   }

   //

   strReadBuffers.clear( );

   in = new QTextStream( file );
   in->seek( 0 );

   bStatus = true;
   while( bStatus ) {
	
      if( in->atEnd( ) ) {
		   bStatus = false;
		   continue;
      }

   	strBuffer = in->readLine( );
      strReadBuffers.append( strBuffer );
   }  

   //

   strLines.clear( );
   nBuffers = (int)strReadBuffers.size( );

   bHeader = true;
   bStatus = true;
   nLines = 0;
   for( i = 0 ; i < nBuffers ; i++ ) {

      if( !bStatus ) {
         continue;
      }

      strBuffer = strReadBuffers.at( i );
      nSize = (int)strBuffer.size( );
      if( 0 >= nSize ) continue;
      
      ch = strBuffer.at( 0 );

      if( bHeader ) {      
         // wait until  ------
         if( '-' == ch ) {
            nLines++;
         }
         if( 2 == nLines ) {
            // end of header
            bHeader = false;
         }
         continue;
      }

      // - marks the end of contents
       
      if( '-' == ch ) {
         bStatus = false;         
         continue;
      }

      strLines.push_back( strBuffer );
   }

#ifdef _DEBUG
   nBuffers = strLines.size( );
   for( i = 0 ; i < nBuffers ; i++ ) {
      strBuffer = strLines.at( i );
   }
#endif 

   // remove unused lines

   strPageBuffers.clear( );
   nBuffers = strLines.size( );

   for( i = 0 ; i < nBuffers ; i++ ) {
      strBuffer = strLines.at( i );
      strLine = strBuffer.trimmed( );
      nSize = (int)strLine.size( );
      if( 0 >= nSize ) continue;

      // skip empty line
      nLength = (int)strLine.size( );
      if( 0 >= nLength ) {
         continue;
      }

      // remove line only has link
      ch = strLine.at( 0 );
      if( '<' == ch ) {
         continue;
      }

      // remove <......>
      
      iStartPos = strBuffer.indexOf( '<', 0 );
      iEndPos = strBuffer.indexOf( '>', 0 );

      if( 0 < iStartPos ) {
         if( iEndPos <= iStartPos ) {
            // something is wrong!
            continue;
         }

         strBuffer.remove( iStartPos, iEndPos - iStartPos + 1 );
      }

      strPageBuffers.push_back( strBuffer );
   }

   // if a line only consists of book name number / : / ; / , / . 
   // concatinate to the previous line

   nBuffers = strPageBuffers.size( );
   vbContinue.resize( nBuffers );
   vbContinue.fill( false );

   for( i = 0 ; i < nBuffers ; i++ ) {
      strBuffer = strPageBuffers.at( i );

      if( bLineContinuing( pBL, strBuffer ) ) {
         // this line continues from the previous
         vbContinue.replace( i, true );
      }
   }

   for( i = 1 ; i < nBuffers ; i++ ) {
      bCont = vbContinue.at( i );

      if( !bCont ) {
         continue;
      }

      strBuffer = strPageBuffers.at( i );
      strBuffer = strBuffer.trimmed( );

      strLine = strPageBuffers.at( i-1 );
      strLine.append( " " ); 
      strLine.append( strBuffer ); 

      strPageBuffers.replace( i-1, strLine );
   }

   // append to the all buffers

   nBuffers = strPageBuffers.size( );
   for( i = 0 ; i < nBuffers ; i++ ) {
      strBuffer = strPageBuffers.at( i );
      bCont = vbContinue.at( i );

      if( bCont ) {
         continue;
      }

      strAllBuffers.push_back( strBuffer );
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( file ) {
      file->close( );
      file = NULL;
   }
   return bRetCode;
}   

bool hikari_window::ReadTorreyBuffers( QStringList &strAllBuffers ) 
{
   bool bRetCode = false;
   int i;
   int iStartPage = 1;
   int iEndPage = 157;
   QString strTorreyFile;

   BibleAllBooks *pBL = GetBibleBooks( );

   // open file

   strAllBuffers.clear( );
   for( i = iStartPage ; i <= iEndPage ; i++ ) {
      strTorreyFile = GetTorreyTopicalFile_PC( i );

      if( !ReadPageBuffers( pBL, strTorreyFile, strAllBuffers ) ) {
         goto PIX_EXIT;
      }
   }  

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}   

bool hikari_window::CheckTorreyTopicalFile( void ) 
{
   bool bRetCode = false;
   bool bFound;
   int nBuffers, iPos, i, k, nTitles;
   QString strTitle, strBuffer, strLogFile;
   QStringList strAllBuffers, strTitles;
   QVector<int> viTitleLine;
   QVector<int> viTitlePosition;

   BibleBook bc;

   QFile *out_file = NULL;
   QTextStream *out = NULL;

   // read all titles
   // should be 630

   strTitles.clear( );
   if( !ReadTorreyIndex( strTitles ) ) {
      goto PIX_EXIT;
   }

   nTitles = (int)strTitles.size( );

   // read all buffers

   if( !ReadTorreyBuffers( strAllBuffers ) ) {
      goto PIX_EXIT;
   }

   // find title lines
   
   nBuffers = (int)strAllBuffers.size( );

   viTitlePosition.resize( nTitles );
   viTitlePosition.fill( -1 );

   for( k = 0 ; k < nTitles ; k++ ) {
      strTitle = strTitles.at( k );
      strTitle.append( "." );

      bFound = false;
      for( i = 0 ; i < nBuffers ; i++ ) {
         strBuffer = strAllBuffers.at( i );
         strBuffer = strBuffer.trimmed( );
         
         if( 0 == strBuffer.compare( strTitle ) ) {
            if( bFound ) {
               // found twice!
               goto PIX_EXIT;
            }
            
            viTitlePosition.replace( k, i );
            bFound = true;
         }
      }

      if( !bFound ) {
         goto PIX_EXIT;
      }
   }

   // check the short bible book name 

   viTitleLine.resize( nBuffers );
   viTitleLine.fill( -1 );

   for( k = 0 ; k < nTitles ; k++ ) {
      iPos = viTitlePosition.at( k );
      viTitleLine.replace( iPos, k+1 );
   }

   //

   strLogFile = "c:\\agent\\torrey_all.txt";

   out_file = new QFile( strLogFile );
   if ( !out_file->open( QIODevice::WriteOnly | QIODevice::Text ) ) {
      goto PIX_EXIT;
   }

   out = new QTextStream( out_file );
   out->setCodec( "UTF-16" );
   out->setGenerateByteOrderMark( true );

   for( i = 0 ; i < nBuffers ; i++ ) {
      
      strBuffer = strAllBuffers.at( i );

      iPos = viTitleLine.at( i );
      if( 0 <= iPos ) {
         strBuffer = strBuffer.trimmed( );
         strTitle.sprintf( "[%d] ", iPos );
         *out << endl;
         *out << strTitle << strBuffer << endl;
         *out << endl;
      } else {
         *out << strBuffer << endl;
      }
   }

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   if( out_file ) {
      out_file->close( );
      out_file = NULL;
   }
   return bRetCode;
}   