#include <pixqt_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include "hikari_common.h"
#include "hikari_window.h"
#include "ui_hikari_window.h"


void hikari_window::SetTrayIconLabels( void )
{
#ifdef _USE_TRAY_ICON
   bool bJapanese = HikariSystemJapanese( );

   if( bJapanese ) {
      _trayRestoreAction->setText( tr("J") ); 
      _trayQuitAction->setText( tr("I") ); 
   } else {
      _trayRestoreAction->setText( "Restore" ); 
      _trayQuitAction->setText( "Exit" ); 
   }
#endif // _USE_TRAY_ICON
   
   return;
}

void hikari_window::SetDockLabels( void )
{   
   bool bJapanese = HikariSystemJapanese( );

#ifdef _USE_DOC_WIDGET
   if( bJapanese ) {
      _Ctrl_Dock_Hikari->setWindowTitle( tr("Rg[pl") ); 
      _Ctrl_Dock_Books->setWindowTitle( tr("݂Ƃ") ); 
   } else {
      _Ctrl_Dock_Hikari->setWindowTitle( "Control Panel" ); 
      _Ctrl_Dock_Books->setWindowTitle( "Books" ); 
   }
#endif // _USE_DOC_WIDGET
   
   return;
}

void hikari_window::ShowSetProperties( short sPage ) 
{ 
   pixq_Properties *pEnv = GetHikariEnv( );
   int iNewLang;
   int iOldLang = pEnv->_HikariBibleSystemLanguage.iGet( );

   // remember the language setting
    
   if( !ShowPixProperty_PC( _strOrganisation, _strApplication, pEnv, EnvModeHikari, sPage ) ) {
      goto PIX_EXIT;
   }

   iNewLang = pEnv->_HikariBibleSystemLanguage.iGet( );

   // store the changed env

   pEnv->SetRegEnv( _strOrganisation, _strApplication );

   // reset contents and interface

   if( iNewLang != iOldLang ) {
      SetTrayIconLabels( );
      SetDockLabels( );
      _Books->SetBooks( );
   }

   ShowContent( );

   _Ctrl_Hikari->SetOccasionsList( );

PIX_EXIT:
   return;
}

void hikari_window::ResetAllProperties( void ) 
{ 
   pixq_Properties *pEnv = GetHikariEnv( );
   int iNewLang;
   int iOldLang = pEnv->_HikariBibleSystemLanguage.iGet( );

   // remember the language setting
    
   pEnv->ResetEnv( _strOrganisation, _strApplication );

   iNewLang = pEnv->_HikariBibleSystemLanguage.iGet( );

   // reset contents and interface

   if( iNewLang != iOldLang ) {
       _Books->SetBooks( );
   }

   ShowContent( );

   _Ctrl_Hikari->SetOccasionsList( );

//PIX_EXIT:
   return;
}

void hikari_window::SetMenuStatus( void )
{
   hikari_content *pContent = GetContent( );
   int iContent = pContent->GetContent( );

   int nActions;
   QVector<QAction*> shiori_store_actions;
   QVector<QAction*>::Iterator it;

   shiori_store_actions.clear( );
   shiori_store_actions.push_back( ui->action_shiori_store_1 );
   shiori_store_actions.push_back( ui->action_shiori_store_2 );
   shiori_store_actions.push_back( ui->action_shiori_store_3 );
   shiori_store_actions.push_back( ui->action_shiori_store_4 );
   shiori_store_actions.push_back( ui->action_shiori_store_5 );

   nActions = (int)shiori_store_actions.size( );

   //

   switch( iContent ) {
   case pixq_Properties::ContentOldTestament: 
   case pixq_Properties::ContentNewTestament:
      for( it = shiori_store_actions.begin() ; it != shiori_store_actions.end() ; ++it ) {
         (*it)->setEnabled( true );
      }
      break;

   case pixq_Properties::ContentDevotion:
      for( it = shiori_store_actions.begin() ; it != shiori_store_actions.end() ; ++it ) {
         (*it)->setEnabled( false );
      }
      break;

   default:
      goto PIX_EXIT;
      break;
   }

PIX_EXIT:
   return;
}

//
// read all shiori and set it on menu
//
bool hikari_window::SetShioriMenu( void )
{
   bool bRetCode = false;
   bool bEnabled;
   int nShiori, k;
   BibleAllShiori data;
   BibleShiori shiori;
   QDate dt;
   QString strLabel;
   QAction *shori_menu[5];
   BibleAllBooks *pBL = GetBibleBooks( );
   hikari_books *pBooks = GetBooks( );
   bool bJapanese = HikariSystemJapanese( );

   if( !data.Load( ) ) {
      goto PIX_EXIT;
   }

   shori_menu[0] = ui->action_shiori_open_1;
   shori_menu[1] = ui->action_shiori_open_2;
   shori_menu[2] = ui->action_shiori_open_3;
   shori_menu[3] = ui->action_shiori_open_4;
   shori_menu[4] = ui->action_shiori_open_5;

   nShiori = (int)data.Size( );
   nShiori = min( nShiori, BibleAllShiori::MaxShioriNumber( ) );

   for( k = 0 ; k < nShiori ; k++ ) {
      shiori = data.GetNthShiori( k );
      strLabel = shiori.SetLabel( pBL, bJapanese );
      bEnabled = shiori.Valid( );

      shori_menu[k]->setText( strLabel );
      shori_menu[k]->setEnabled( bEnabled );
   }
   
   // change book list

   pBooks->SetShiori( );

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// store/replace the current book chapter ion the shiori file
//
bool hikari_window::StoreShiori( int iShiori )
{
   bool bRetCode = false;
   int nShiori;
   QString strShoriFile;
   BibleAllShiori data;
   BibleShiori shiori;

   hikari_content *pContent = GetContent( );
   int iContent = pContent->GetContent( );
   int iBook = _Content->GetBook( );
   int iChapter = _Content->GetBookChapter( );
   
   switch( iContent ) {
   case pixq_Properties::ContentOldTestament:
   case pixq_Properties::ContentNewTestament:
      break;

   default:
      goto PIX_EXIT;
   } 
    
   nShiori = (int)BibleAllShiori::MaxShioriNumber( );
   if( 0 > iShiori || nShiori <= iShiori ) {
      goto PIX_EXIT;
   }

   // load

   data.Init( );

   if( !data.Load( ) ) {
      goto PIX_EXIT;
   }

   // save this shiori
   
   data.SetShiori( iShiori, iBook, iChapter );

/*
   data.SetShiori( 0, 11, 21 );
   data.SetShiori( 1, 12, 31 );
   data.SetShiori( 2, 13, 4 );
   data.SetShiori( 3, 14, 15 );
   data.SetShiori( 4, 19, 18 );
*/

   if( !data.Save( ) ) {
      goto PIX_EXIT;
   }

//   for( k = 0 ; k < data.Size( ) ; k++ ) {
  //    shiori = data.GetNthShiori( k );
  // }

   SetShioriMenu( );

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

bool hikari_window::OpenShiori( int iShiori )
{
   bool bRetCode = false;
   int iContent, iChapter, iBook, nShiori;
   QString strShoriFile;
   BibleAllShiori data;
   BibleShiori shiori;

   hikari_content *pContent = GetContent( );
   
   // load

   data.Init( );
   if( !data.Load( ) ) {
      goto PIX_EXIT;
   }

   nShiori = (int)BibleAllShiori::MaxShioriNumber( );
   if( 0 > iShiori || nShiori <= iShiori ) {
      goto PIX_EXIT;
   }

   shiori = data.GetNthShiori( iShiori );
   if( !shiori.Valid( ) ) {
      goto PIX_EXIT;
   }

   // open the stord page
   
   iBook = shiori.GetBook( );
   iChapter = shiori.GetChapter( );

   if( iBook <= hikari_content::_iLastOldBook ) {
      iContent = pixq_Properties::ContentOldTestament;
   } else {
      iContent = pixq_Properties::ContentNewTestament;
   }

   pContent->SetContent( iContent );
   pContent->SetBook( iBook );
   pContent->SetChapter( iChapter );

   ShowContent( );

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

void hikari_window::readSettings( void )
{
   int iCount;
   QByteArray sta;
   QByteArray geo;

   QSettings settings( _strOrganisation, _strApplication );

   geo = settings.value("geometry").toByteArray( );
   iCount = geo.count( );
   if( 0 >= iCount ) {
      // first time
      QSize sz( 800, 600 );
      QPoint ps( 40, 40 );

      move( ps );
      resize( sz );
   } else {
      restoreGeometry( geo );
   }

   //

   sta = settings.value("splitterSizes").toByteArray( );
   iCount = sta.count( );
   if( 0 < iCount ) {
      _ContentsSplitter->restoreState ( sta );
   }

   return;
}

void hikari_window::writeSettings( void )
{
   QByteArray sta;
   QByteArray geo;

   QSettings settings( _strOrganisation, _strApplication );

   //

   geo = saveGeometry( );
   settings.setValue( "geometry", geo );

   //

   sta = _ContentsSplitter->saveState( );
   settings.setValue( "splitterSizes", sta );

   return;
}

//
// check if the system language is japanese or not
//
bool hikari_window::HikariSystemJapanese( void )
{
   bool bJapanese = true;
   pixq_Properties *pEnv = GetHikariEnv( );
   int iLang = pEnv->_HikariBibleSystemLanguage.iGet( );

   switch( iLang ) {
   case pixq_Properties::PixTopoLanguangeJp:
      bJapanese = true;
      break;
   
   case pixq_Properties::PixTopoLanguangeEn:
   default: 
      bJapanese = false;
      break;
   }

   return bJapanese;
}

void hikari_window::ShowDaysWords( void )
{
   hikari_content *pContent = GetContent( );

   int iContent = pixq_Properties::ContentDevotion;
   int iDev = pixq_Properties::DevotionTypeDailyDays;
   
   pContent->SetContent( iContent );
   pContent->SetBook( iDev );

   ShowContent( );

   return;
}

void hikari_window::CheckTimer( void )
{
   pixq_Properties *pEnv = GetHikariEnv( );
   bool bShow;
   QDateTime current, show_am, show_pm;
   QDate dt, last_dt;
   QTime tm;
   int iHour, iMin, iSecond;
   int iLastDay, iMonth, iDay, iYear;
   
   current = QDateTime::currentDateTime( );
   //((CDailyLightMainFrame*)AfxGetMainWnd())->Restore( );

   bShow = pEnv->_HikariBagsterShowEveryDay.GetBool( );
   if( !bShow ) {
      goto PIX_EXIT;
   }

   // has date changed?
   
   dt = current.date( );
   tm = current.time( );
   iYear = dt.year( ); 
   iMonth = dt.month( ); 
   iDay = dt.day( );
   last_dt = _LastCheckedTime.date( );
   iLastDay = last_dt.day( );
   if( iLastDay != iDay ) {
      _bShownAmToday = false; 
      _bShownPmToday = false; 
   }

   // time to show the morning words

   if( !_bShownAmToday ) {
      iHour = pEnv->_HikariBagsterAmShowHour.iGet( );
      iMin = pEnv->_HikariBagsterAmShowMinuite.iGet( );
      iSecond = pEnv->_HikariBagsterAmShowSecond.iGet( );
      dt.setYMD( iYear, iMonth, iDay );
      tm.setHMS( iHour, iMin, iSecond );
      show_am.setDate( dt );
      show_am.setTime( tm );

      if( current > show_am ) {
         // show today's morning word   
         showNormal( );  
         SetTodaysWords( );
         ShowDaysWords( );
         setWindowState( Qt::WindowActive );
         _bShownAmToday = true;
      }
   }

   // time to show the evening words

   if( !_bShownPmToday ) {
      iHour = pEnv->_HikariBagsterPmShowHour.iGet( );
      iMin = pEnv->_HikariBagsterPmShowMinuite.iGet( );
      iSecond = pEnv->_HikariBagsterPmShowSecond.iGet( );
      dt.setYMD( iYear, iMonth, iDay );
      tm.setHMS( iHour, iMin, iSecond );
      show_pm.setDate( dt );
      show_pm.setTime( tm );
      
      if( current > show_pm ) {
         // show today's evening word 
         showNormal( );
         SetTodaysWords( );
         ShowDaysWords( );
         setWindowState( Qt::WindowActive );
         _bShownPmToday = true;
      }
   }

PIX_EXIT:
   _LastCheckedTime = current;
   return;
}

//
// create a xml file containing the current version info
// this file must be uploaded to the ftp server
//
// notes:
// the temporal XML file is made in the same directory as the program.
// the XML should be sent to sourceforge server using WinSCP.
//
// version up
// [1]WinSCPg/home/groups/h/hi/hikari/htdocsɃAv
// [2] - NOT ANYMORE - NextFTPgwww.pixtopo.com/hikariɃAv
//
bool hikari_window::CreateVersionXml( void )
{
   bool bRetCode = false;
   pixq_Version ver = Version( _strApplication );
   int iMode = EnvModeHikari;
   QFileInfo fi;
   QString strMessage, strWebPath, strTmpFile, strFile;

QApplication::setOverrideCursor( Qt::BusyCursor );
   
   // get version file name

   strTmpFile = GetLatestVerXmlFile_PC( iMode );

   if( !ver.WriteXml( strTmpFile ) ) {
      QString strMessage = "ERROR! Failed to Create Version XML File:\n" + strTmpFile;
      QMessageBox::critical( NULL, _strApplication, strMessage );
      goto PIX_EXIT;
   }

   //strMessage = "Version XML file was saved as:\n" + strTmpFile;
   //QMessageBox::information( NULL, _strApplication, strMessage );

   // copy xml file to website hikari
   // temporal

   fi.setFile( strTmpFile );
   strFile = fi.fileName( );
   strWebPath = "C:\\PixPLOT\\website\\hikari\\" + strFile;

   if( !ver.WriteXml( strWebPath ) ) {
      QString strMessage = "ERROR! Failed to Create Version XML File:\n" + strWebPath;
      QMessageBox::critical( NULL, _strApplication, strMessage );
      goto PIX_EXIT;
   }

   strMessage = "Version XML file was saved as:\n\n";
   strMessage = strMessage + strWebPath;
   strMessage = strMessage + "\n";
   strMessage = strMessage + strTmpFile;
   strMessage = strMessage + "\n\n\n";
   strMessage = strMessage + "Upload this file to the website under hikari.";
   QMessageBox::information( NULL, _strApplication, strMessage );

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
QApplication::restoreOverrideCursor( );
   return bRetCode;
}

//
// read version infor from xml file
//
bool hikari_window::ReadVersionXml( void )
{
   bool bRetCode = false;
   QString strWebFile, strTmpFile;
   QUrl url;
   int iMode = EnvModeHikari;

   QNetworkRequest req;

QApplication::setOverrideCursor( Qt::BusyCursor );
   
   //

   if( _UpdateXmlReply ) {
      _UpdateXmlReply->deleteLater( );
      _UpdateXmlReply = (QNetworkReply*)NULL;
   }

   // get version file name

   //strFile = GetLatestVerXmlFile_PC( iMode );
   strWebFile = GetUpdateVerXmlFile_PC( iMode );

   // get the tentative xml file name to copy the from the web

   strTmpFile = GetTentativeVerXmlFile_PC( iMode );

   if (QFile::exists( strTmpFile )) {
      if( !QFile::remove( strTmpFile ) ) {
         QString strMessage = "ERROR! Failed to Remove the Local File:\n" + strTmpFile;
         QMessageBox::critical( NULL, _strApplication, strMessage );
         goto PIX_EXIT;
      }      
   }

   // download the xml file from the net to the local file

   url.setUrl( strWebFile );
   
   req.setUrl( url );
   _UpdateXmlReply = _UpdateXmlQnam.get( req );

   connect( _UpdateXmlReply, SIGNAL(finished()), this, SLOT(httpFinished()));
   connect( _UpdateXmlReply, SIGNAL(readyRead()), this, SLOT(httpReadyRead()));

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
QApplication::restoreOverrideCursor( );
   return bRetCode;
}


//
// read file content from the web and save it in the temporary file
//
void hikari_window::httpReadyRead( void )
{
   QFile *file = NULL;
   QString strTmpFile;
   int iMode = EnvModeHikari;
    
   strTmpFile = GetTentativeVerXmlFile_PC( iMode );

   file = new QFile( strTmpFile );
   if (!file->open(QIODevice::Append)) {
      QString strMessage = "ERROR! Unable to save the file:\n" + strTmpFile;
      QMessageBox::information( NULL , _strApplication, strMessage );
      goto PIX_EXIT;
   }

    // this slot gets called every time the QNetworkReply has new data.
    // We read all of its new data and write it into the file.
    // That way we use less RAM than when reading it at the finished()
    // signal of the QNetworkReply
    
   if ( !file ) {
      QString strMessage = "ERROR! Unable to save the file:\n" + strTmpFile;
      QMessageBox::information( NULL, _strApplication, strMessage );
      goto PIX_EXIT;
   }
   
   file->write( _UpdateXmlReply->readAll( ) );
   file->flush( );
   file->close( );  

PIX_EXIT:
   if( file ) {
      delete file;
      file = NULL;
   }
   return;
}

//
// reading XML(latest version) on the web is finished
//
void hikari_window::httpFinished( void )
{
   pixq_Version current_ver = Version( _strApplication );
   pixq_Version latest_ver;

   int iMode = EnvModeHikari;
   QString strUrl = GetProjectTopUrl_PC( iMode );
   QString strTmpFile = GetTentativeVerXmlFile_PC( iMode );

   // disconnect signals and slots

   disconnect( _UpdateXmlReply, SIGNAL(finished()), this, NULL );
   disconnect( _UpdateXmlReply, SIGNAL(readyRead()), this, NULL );  

   if( _UpdateXmlReply->error( ) ) {
      QString strError = _UpdateXmlReply->errorString( );
      QString strMessage = "G[! ŐVo[W̏ɐڑł܂łe:\n" + strError;
      QMessageBox::critical( NULL, _strApplication, strMessage );
      goto PIX_EXIT;
   }

   // latest version info saved in temporary file

   latest_ver.Clear( );
   if( !latest_ver.ReadXml( strTmpFile ) ) {
      QString strMessage = "ERROR! Failed to Read Version XML File:\n" + strTmpFile;
      QMessageBox::critical( NULL, _strApplication, strMessage );
      goto PIX_EXIT;
   }

   //
   // check whether the latest version from the file is newer than
   // that of the program that is currently used
   //

   if( current_ver >= latest_ver ) {
      // this is the latest version!
      QMessageBox msgBox;
      QString strVersion = current_ver.GetVersionString( );
      QString strMessage = "Ȃ͍ŐṼvOHikarigĂ܂.";
      QIcon icon = QIcon( ":/images/ehagaki2x.png" );

      msgBox.addButton( QMessageBox::Ok );
      msgBox.setInformativeText( strVersion );
      msgBox.setWindowIcon( icon );
      msgBox.setIcon( QMessageBox::Information );
      msgBox.setText( strMessage );
      msgBox.setWindowTitle( _strApplication );
      msgBox.exec( );
   } else {

      int iReply;
            
      QMessageBox msgBox;
      QString strVersion;
      QString strCurVersion = current_ver.GetVersionString( );
      QString strNewVersion = latest_ver.GetVersionString( );
      QString strMessage = "ŐVo[WJĂ܂.";
      QIcon icon = QIcon( ":/images/ehagaki2x.png" );

      msgBox.addButton( QMessageBox::Ok );

      strVersion = "ŐVo[W: "; 
      strVersion = strVersion + strNewVersion;
      strVersion = strVersion + "\n"; 
      strVersion = strVersion + "gp̃o[W: "; 
      strVersion = strVersion + strCurVersion;
      strVersion = strVersion + "\n"; 
      strVersion = strVersion + "\n"; 
      strVersion = strVersion + "\n"; 
      strVersion = strVersion + "PixTOPÕEFuTCgŐVłł܂"; 

      msgBox.setInformativeText( strVersion );
      msgBox.setWindowIcon( icon );
      msgBox.setIcon( QMessageBox::Information );
      msgBox.setText( strMessage );
      msgBox.setWindowTitle( _strApplication );
      
      msgBox.setStandardButtons( QMessageBox::Open | QMessageBox::Cancel );

      iReply = msgBox.exec( );     
      if( QMessageBox::Open == iReply ) {
         QDesktopServices::openUrl( QUrl( strUrl ) );
      }
   }

   //
PIX_EXIT:
   if( _UpdateXmlReply ) {
      _UpdateXmlReply->deleteLater( );
      _UpdateXmlReply = (QNetworkReply*)NULL;
   }
QApplication::restoreOverrideCursor();
   return;
}

/*
#ifdef QT_NO_OPENSSL
#else
void HttpWindow::sslErrors(QNetworkReply*,const QList<QSslError> &errors)
{
    QString errorString;
    foreach (const QSslError &error, errors) {
        if (!errorString.isEmpty())
            errorString += ", ";
        errorString += error.errorString();
    }
    
    if (QMessageBox::warning( this, _strApplication,
                             tr("One or more SSL errors has occurred: %1").arg(errorString),
                             QMessageBox::Ignore | QMessageBox::Abort) == QMessageBox::Ignore) {
        reply->ignoreSslErrors();
    }
}
#endif
*/

void hikari_window::refreshPlanChart( void )
const
{
   hikari_ctrl *pCtrl = GetControlPanel( );
   hikari_bible_plan *pPlanPanel = pCtrl->GetBiblePlanPanel( );

   pPlanPanel->readSetChart( );
   pPlanPanel->update( );

   return;
}


void hikari_window::SetStatusLabel( int iLabel, QString strLabel )
{
   _statusLabel[iLabel]->setText( strLabel );
}

bool hikari_window::StartAssistant( void )
{
   bool bRetCode = false;
   QString strApp;
   QStringList strArgs;
   QString strFile;

   // start qt assistant

   if( !_assistant_proc ) {
      _assistant_proc = new QProcess();
   }

   if ( QProcess::Running == _assistant_proc->state( ) ) {
      bRetCode = true;
      goto PIX_EXIT;
   } 
 
   strFile = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );
   strFile += QDir::separator();
   strFile += QLatin1String("hikari_index.qhc\0");

   //strApp = QLibraryInfo::location(QLibraryInfo::BinariesPath);
   strApp = QFileInfo( QCoreApplication::applicationDirPath( ) ).filePath( );
   strApp += QDir::separator();
   strApp += QLatin1String("assistant.exe");
 
   strArgs.clear( );
   strArgs.push_back( QLatin1String("-collectionFile") );
   strArgs.push_back( strFile );
   strArgs.push_back( QLatin1String("-enableRemoteControl") );

   _assistant_proc->start( strApp, strArgs );

   if (!_assistant_proc->waitForStarted()) {
      QMessageBox::critical(0, _strApplication,
         QObject::tr("Unable to launch Qt Assistant (%1)").arg(strApp));
      goto PIX_EXIT;
   }    

   // --- DONE ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

void hikari_window::ShowDocumentation( void )
{     
   QString strPage = "hikari_index.html";
   QByteArray ba;

   // start qt assistant
  
   if (!StartAssistant( ) ) {
      goto PIX_EXIT;
   }

   // open the first page

   ba.clear( );
   ba.append("SetSource ");
   ba.append("qthelp://com.pixtopo2.hikari/doc/");
   _assistant_proc->write(ba + strPage.toLocal8Bit() + '\n');

PIX_EXIT:
   return;
}

