#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "sampler_common.h" 
#include "sampler_panes.h"

#include "image_side_label.h"
#include "ui_image_side_label.h"

#include "sampler_window.h"

ImageSideLabel::ImageSideLabel(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::ImageSideLabel)
{
    ui->setupUi(this);

    setMaximumHeight( 26 );
}

ImageSideLabel::~ImageSideLabel()
{
    delete ui;
}

//
// two image panes must be of same width!
//
void ImageSideLabel::resizeEvent( QResizeEvent * /*ev*/ )
{
   QSize szFrame, szImage, szDerived, szLabel;
   QPoint posFrame, posImage, posDerived;
   int nWidth[3], nLabelsWidth, nLabelsHeight, nWinWidth, nWinHeight;

   int nSkima = 2;

   szLabel = size( );

   nWinWidth = szLabel.width( );
   nWinHeight = szLabel.height( );
   
   if( 1 >= nWinWidth ) goto PIX_EXIT;
   if( 1 >= nWinHeight ) goto PIX_EXIT;

   nLabelsWidth = nWinWidth - nSkima - nSkima - nSkima - nSkima;
   nLabelsHeight = nWinHeight - nSkima - nSkima;

   nWidth[0] = nLabelsWidth * 2 / 10;
   nWidth[2] = nLabelsWidth * 2 / 10;
   nWidth[1] = nLabelsWidth - nWidth[0] - nWidth[2];

   szFrame.setWidth( nWidth[0] );
   szFrame.setHeight( nLabelsHeight );

   szImage.setWidth( nWidth[1] );
   szImage.setHeight( nLabelsHeight );

   szDerived.setWidth( nWidth[2] );
   szDerived.setHeight( nLabelsHeight );


   posFrame.setX( nSkima );
   posFrame.setY( nSkima );

   posImage.setX( posFrame.x( ) + szFrame.width( ) + nSkima );
   posImage.setY( nSkima );

   posDerived.setX( posImage.x( ) + szImage.width( ) + nSkima );
   posDerived.setY( nSkima );

   //

   ui->frame_label->resize( szFrame );
   ui->image_label->resize( szImage );
   ui->derived_label->resize( szDerived );
  
   ui->frame_label->move( posFrame );
   ui->image_label->move( posImage );
   ui->derived_label->move( posDerived );

PIX_EXIT:
   return;
}

void ImageSideLabel::RefreshLabel( void )
{
   SamplerWindow *pMain = (SamplerWindow*)GetMainWindow( );
   pixq_ImageSingleSet *pData = pMain->GetImageData( );
   QString strFrame, strImage, strDerived;
   short sPaneMode;
   QPalette pal;

   // frame

   strFrame = pData->GetFrameString( );
   
   if( !pData->GetCurrentFile( &strImage ) ) {
      strImage = "Failed to Get Image.";
   }

   sPaneMode = pMain->GetPaneShowMode( _iSide );

   switch( sPaneMode ) {
   case SamplerPane::SamplerPaneShowFirst:
      strDerived = tr( "Input" );
      pal.setColor( QPalette::Window, Qt::white );
      pal.setColor( QPalette::WindowText, Qt::blue );
      break;
   case SamplerPane::SamplerPaneShowSecond:
      strDerived = tr( "Derived" );
      pal.setColor( QPalette::Window, Qt::blue );
      pal.setColor( QPalette::WindowText, Qt::white );
      break;;
   }

   //

   ui->frame_label->setText( strFrame );
   ui->image_label->setText( strImage );

   ui->derived_label->setAutoFillBackground( true );
   ui->derived_label->setPalette( pal );
   ui->derived_label->setText( strDerived );

   //update( );

//PIX_EXIT:
   return;
}

void ImageSideLabel::showEvent( QShowEvent * /*eve*/ )
{
   return;
}