#pragma once

#include <QWidget>

class SamplerWindow;

namespace Ui {
    class ImageSideLabel;
}

class ImageSideLabel : public QWidget
{
    Q_OBJECT

public:
    explicit ImageSideLabel(QWidget *parent = 0);
    ~ImageSideLabel();

private:
    Ui::ImageSideLabel *ui;
    
protected:
   void resizeEvent( QResizeEvent* );
   
public:
   void SetMainWindow( SamplerWindow *pMain ) { _pMainWindow = pMain; }
   SamplerWindow *GetMainWindow( void ) { return _pMainWindow; }

   void SetSide( int iSide ) { _iSide = iSide; }
   int GetSide( void ) { return _iSide; }

   void RefreshLabel( void );

private:
   // pointer to the main window
   SamplerWindow *_pMainWindow;
   
   int _iSide;
   
protected:   
   void showEvent( QShowEvent *eve );
};
