#pragma once

#include <property_page.h>

class SamplerWindow;

namespace Ui {
    class props_op_dft_filter;
}

class props_op_dft_filter : public QWidget, public property_page
{
    Q_OBJECT

public:
    explicit props_op_dft_filter(QWidget *parent = 0);
    ~props_op_dft_filter();

private slots:
    void on_dt_filter_dft_visualize_color_red_radio_clicked();
    void on_dt_filter_dft_visualize_color_green_radio_clicked();
    void on_dt_filter_dft_visualize_color_blue_radio_clicked();
    void on_dt_filter_dft_visualize_color_gray_radio_clicked();
    void on_dft_filter_shape_low_pass_radio_clicked();
    void on_dft_filter_shape_high_pass_radio_clicked();
    void on_dft_filter_shape_band_pass_radio_clicked();
    void on_dft_filter_shape_notch_radio_clicked();

private:
   void SetDigitalFilterShape( void );
   void SetVisualizeColor( void );

private:
    Ui::props_op_dft_filter *ui;
    
public:
   virtual void SetData( void );
   virtual bool Check( void );
   virtual void Init( pixq_Properties *pEnv );
};
