#pragma once

#include <QtCore>
#include <QtGui>
#include <QWidget>

class SamplerWindow;

class SamplerDock : public QDockWidget
{
   Q_OBJECT
 
public:
   enum {
      SamplerDockNone = 0,
      SamplerDockIndex,
      SamplerDockChart,
      SamplerDockProps,
      SamplerDockMonitor,
   } SamplerDockType;

public:
   SamplerDock ( const QString & title, QWidget * parent = 0 );
   SamplerDock ( QWidget * parent = 0 );
   ~SamplerDock();

private:

protected:

public:
   void SetMainWindow( SamplerWindow *pMain ) { _pMainWindow = pMain; }
   SamplerWindow *GetMainWindow( void ) { return _pMainWindow; }

private slots:

private:
   // pointer to the main window
   SamplerWindow *_pMainWindow;
   
   // dock type, one of SamplerDockType
   short _sType;

   // this set to true for the first time when the dock is actually visiable
   bool _bInit;

protected:   
   void resizeEvent( QResizeEvent* );
   void moveEvent( QMoveEvent *eve );
   void showEvent( QShowEvent *eve );
   
public:
   void SetType( short sType ) { _sType = sType; }
   short sGetType( void ) { return _sType; }

   void SetInit( bool bInit ) { _bInit = bInit; }
   bool GetInit( void ) { return _bInit; }

};
