#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "sampler_common.h"
#include "sampler_panes.h"
#include "sampler_monitor.h"

#include "sampler_window.h"
#include "ui_sampler_window.h"

void SamplerWindow::CreateMain( void )
{
   int k;
   QIcon icon;
   QString strHeader; 

   QMenu *menu = ui->menuControl;

   Qt::DockWidgetAreas areas = Qt::LeftDockWidgetArea | 
      Qt::RightDockWidgetArea | 
      Qt::TopDockWidgetArea | 
      Qt::BottomDockWidgetArea;

   menu->addSeparator( );

   // windows

   _ImageSplitter = new ImageSplitter( Qt::Horizontal );
   _ImageSplitter->SetMainWindow( this );

   for( k = 0 ; k < 2 ; k++ ) {
      _ImageSideSplitter[k] = new ImageSideSplitter( Qt::Vertical );
      _ImageSideSplitter[k]->SetMainWindow( this );
      _ImageSideSplitter[k]->SetSide( k );
      //
      _Image_Label[k] = new ImageSideLabel;
      _Image_Label[k]->SetMainWindow( this );
      _Image_Label[k]->SetSide( k );
      //
      _Image_Pane[k] = new SamplerPane; 
      _Image_Pane[k]->SetMainWindow( this ); 
      //
      _ImageSideSplitter[k]->insertWidget( 0, _Image_Label[k] );
      _ImageSideSplitter[k]->insertWidget( 1, _Image_Pane[k] ); 
      _ImageSideSplitter[k]->setChildrenCollapsible( false );
   }

   _ImageSplitter->insertWidget( 0, _ImageSideSplitter[0] );
   _ImageSplitter->insertWidget( 1, _ImageSideSplitter[1] );
   _ImageSplitter->setChildrenCollapsible( false );

   setCentralWidget( _ImageSplitter );

   connect( _ImageSplitter, SIGNAL( splitterMoved(int,int)),
         this, SLOT(ImageSplitterMoved(int,int)) );

   for( k = 0 ; k < 2 ; k++ ) {
      connect( _ImageSideSplitter[k], SIGNAL( splitterMoved(int,int)),
            this, SLOT(ImageSideSplitterMoved(int,int)) );
   }

   // *** control pane ***

   // index 

   _Dock_Index = new SamplerDock( tr("Index Image"), this ); 
   _Dock_Index->SetType( (short)SamplerDock::SamplerDockIndex );  
   _Dock_Index->setAllowedAreas( areas );  

   _Index_Pane = new SamplerPane;  
   _Index_Pane->SetMainWindow( this );  

    _Dock_Index->setWidget( _Index_Pane ); 
    addDockWidget( Qt::BottomDockWidgetArea, _Dock_Index ); 
    menu->addAction(_Dock_Index->toggleViewAction()); 

    _Dock_Index->setMinimumWidth( 350 );  
    _Dock_Index->setMaximumWidth( 350 ); 
    _Dock_Index->setFloating( false ); 
    _Dock_Index->show( ); 

   // image properties

   _Dock_Props = new SamplerDock( tr("Parameters"), this );
   _Dock_Props->SetType( (short)SamplerDock::SamplerDockProps );  
   _Dock_Props->setAllowedAreas( Qt::LeftDockWidgetArea | Qt::RightDockWidgetArea |
       Qt::TopDockWidgetArea | Qt::BottomDockWidgetArea );

   _Image_Props = new ImageCtrl( this );
   _Image_Props->SetMainWindow( this );

    _Dock_Props->setWidget( _Image_Props );
    addDockWidget(Qt::BottomDockWidgetArea, _Dock_Props);
    menu->addAction(_Dock_Props->toggleViewAction());

    _Image_Props->SetParent( _Dock_Props );

    _Dock_Props->setFloating( false );
    _Dock_Props->hide( );

    // monitor

   _Dock_Monitor = new SamplerDock( tr("Monitor"), this );
   _Dock_Monitor->SetType( (short)SamplerDock::SamplerDockMonitor );  
   _Dock_Monitor->setAllowedAreas( Qt::LeftDockWidgetArea | Qt::RightDockWidgetArea |
       Qt::TopDockWidgetArea | Qt::BottomDockWidgetArea );

   _Sampler_Monitor = new SamplerMonitor( this );

    _Dock_Monitor->setWidget( _Sampler_Monitor );
    addDockWidget( Qt::BottomDockWidgetArea, _Dock_Monitor);
    menu->addAction(_Dock_Monitor->toggleViewAction());

    _Dock_Monitor->setFloating( false );
    _Dock_Monitor->show( );

   // *** create meanu and actions

   CreateActions( );

   CreateToolBars( );

   SetMenuState( );

   // window title bars

   strHeader = _strOrganisation + tr(" - ") + _strApplication;
   setWindowTitle( strHeader );

   icon = QIcon( ":/images/coolfrog.png" );
   setWindowIcon( icon );

   return;
}

void SamplerWindow::AddMenuAction( QAction *pAction, int iSelectMode )
{
   _list_menu_actions.push_back( pAction );
   pAction->setData( QVariant( iSelectMode ) );

   return;
}


void SamplerWindow::CreateToolBars( void )
{
   // main tool bar

   ui->mainToolBar->addAction( ui->action_file_select_files );
   ui->mainToolBar->addAction( ui->action_file_select_sequence );
   ui->mainToolBar->addAction( ui->action_file_properties );

   ui->mainToolBar->addSeparator( );

   ui->mainToolBar->addAction( ui->action_frame_first );
   ui->mainToolBar->addAction( ui->action_frame_previous );
   ui->mainToolBar->addAction( ui->action_frame_next );
   ui->mainToolBar->addAction( ui->action_frame_last );
   ui->mainToolBar->addAction( ui->action_frame_select_frame );
   ui->mainToolBar->addAction( ui->action_frame_reload );

   // view tool bar

   ui->viewToolBar->addAction( ui->action_view_first_image );
   ui->viewToolBar->addAction( ui->action_view_second_image );
   ui->viewToolBar->addAction( ui->action_view_wiper );

   ui->viewToolBar->addSeparator( );

   ui->viewToolBar->addAction( ui->action_view_rgb );
   ui->viewToolBar->addAction( ui->action_view_red_channel );
   ui->viewToolBar->addAction( ui->action_view_green_channel );
   ui->viewToolBar->addAction( ui->action_view_blue_channel );

   return;
}

void SamplerWindow::CreateActions( void )
{
   _list_menu_actions.clear( );

   // *** file menu ***

   AddMenuAction( ui->action_file_select_files, (int)MouseActionItemEnabled );
   AddMenuAction( ui->action_file_select_sequence, (int)MouseActionItemEnabled );

   AddMenuAction( ui->action_file_properties, (int)MouseActionItemEnabled );

   AddMenuAction( ui->action_file_exit, (int)MouseActionItemEnabled );

   // *** Basic menu ***

   AddMenuAction( ui->action_basic_original, (int)MouseActionItemSingleDouble );

   AddMenuAction( ui->action_basic_dft_value, (int)MouseActionItemSingleDouble );
   AddMenuAction( ui->action_basic_dft_filter_shape, (int)MouseActionItemSingleDouble );
   AddMenuAction( ui->action_basic_dft_filtered_image, (int)MouseActionItemSingleDouble );

   // *** Data menu ***
   
   AddMenuAction( ui->action_data_statistics, (int)MouseActionItemSingleDouble );

   // *** View menu ***

   AddMenuAction( ui->action_view_first_image, (int)MouseActionItemSingleDouble );
   AddMenuAction( ui->action_view_second_image, (int)MouseActionItemSingleDouble );
   AddMenuAction( ui->action_view_wiper, (int)MouseActionItemSingleDouble );

   AddMenuAction( ui->action_view_rgb, (int)MouseActionItemSingleDouble );
   AddMenuAction( ui->action_view_red_channel, (int)MouseActionItemSingleDouble );
   AddMenuAction( ui->action_view_green_channel, (int)MouseActionItemSingleDouble );
   AddMenuAction( ui->action_view_blue_channel, (int)MouseActionItemSingleDouble );

   // *** Frame menu ***

   AddMenuAction( ui->action_frame_next, (int)MouseActionItemSingleDouble );
   AddMenuAction( ui->action_frame_previous, (int)MouseActionItemSingleDouble );
   AddMenuAction( ui->action_frame_first, (int)MouseActionItemSingleDouble );
   AddMenuAction( ui->action_frame_last, (int)MouseActionItemSingleDouble );
   AddMenuAction( ui->action_frame_reload, (int)MouseActionItemSingleDouble );
   AddMenuAction( ui->action_frame_select_frame, (int)MouseActionItemSingleDouble );

   // *** Help menu ***

   AddMenuAction( ui->action_help_about, (int)MouseActionItemEnabled );

   return;
}
