#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "sampler_common.h"
#include "sampler_panes.h"
#include "sampler_monitor.h"
#include "sampler_window.h"

void SamplerWindow::OpenGlHigherThanTwo( void )
{
   SamplerMonitor *pMonitor = (SamplerMonitor*)GetMonitorPane( );
   char szVersion[STANDARD_BUFFER_SIZE];
   char szVendor[STANDARD_BUFFER_SIZE];
   char szExtensions[STANDARD_BUFFER_SIZE], szRenderer[STANDARD_BUFFER_SIZE];
   QString strMessage;

   //
   strncpy( szVendor, (char*)glGetString( GL_VENDOR ), STANDARD_BUFFER_SIZE );
   strncpy( szRenderer, (char*)glGetString( GL_RENDERER ), STANDARD_BUFFER_SIZE );
   strncpy( szVersion, (char*)glGetString( GL_VERSION ), STANDARD_BUFFER_SIZE );
   strncpy( szExtensions, (char*)glGetString( GL_EXTENSIONS ), STANDARD_BUFFER_SIZE );

   strMessage.sprintf( "===> OpenGL Vendor: %s", szVendor );
   pMonitor->DisplayMessage( strMessage );

   strMessage.sprintf( "===> OpenGL Renderer: %s", szRenderer );
   pMonitor->DisplayMessage( strMessage );

   strMessage.sprintf( "===> OpenGL Version: %s", szVersion );
   pMonitor->DisplayMessage( strMessage );

   //strMessage.sprintf( "===> OpenGL Extensions: %s", szExtensions );
   //pMonitor->DisplayMessage( strMessage );

   return;
}

//
// create the second image matrix according to the mode
// copy the first image matrix to second
//
bool SamplerWindow::CreateSecondOriginal( void )
{
   bool bRetCode = false;
   int k;
	
   // copy the input matrix(0) to the third matrix(2)

   for( k = 0 ; k < 3 ; k++ ) {
    
      if( !_ImageDrvMtx[k].Copy( &_ImageInMtx[k] ) ) {
         QMessageBox::warning( this, _strApplication, "Failed to Copy Image." );
         goto PIX_EXIT; 
      }
   }
  
   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   return bRetCode;
}

//
// load single image from file and set it to the left pane
//
bool SamplerWindow::CreateSingleBitmap( void )
{
   bool bRetCode = false;
   pixq_ImageSingleSet *pData = GetImageData( );

	QString strImageFile, strMessage;
   int k, nWidth, nHeight;
   SamplerPane *pPanes[3];
   int iCurrentFrame = pData->GetCurrentFrame( );
   int iFirstFrame = pData->GetFirstFrame( );
   int iLastFrame = pData->GetLastFrame( );
   SamplerMonitor *pMonitor = (SamplerMonitor*)GetMonitorPane( );
   QSize rect;

   pPanes[0] = (SamplerPane*)_Image_Pane[0];  
   pPanes[1] = (SamplerPane*)_Image_Pane[1]; 
   pPanes[2] = (SamplerPane*)_Index_Pane; 

   // get image 

   if( !pData->GetCurrentFile( &strImageFile ) ) {
      goto PIX_EXIT; 
   } 

   // --- initialize viewport ---
   // --- init image texture ---
   for( k = 0 ; k < 3 ; k++ ) {
      pPanes[k]->SetCurrentViewport( );
      pPanes[k]->InitTexture( );
   }

   // *** load image and change to 3-channel and 8-bit depth ***
   
   if( !LoadFrame( strImageFile, &_ImageInMtx[0], &_ImageInMtx[1], &_ImageInMtx[2] ) ) {
      strMessage = QString( "Failed to Load Image:\n") + strImageFile;
      QMessageBox::warning( this, _strApplication, strMessage );
      pMonitor->DisplayMessage( strMessage );
      goto PIX_EXIT; 
   }

   strMessage = QString( "Image Loaded: ") + strImageFile;
   pMonitor->DisplayMessage( strMessage );

   // --- set the image size to global ---

   nWidth = _ImageInMtx[0].GetWidth( );
   nHeight = _ImageInMtx[0].GetHeight( );
   
   strMessage.sprintf( "Frame %d[%d-%d] Loaded: [%dW*%dH].", iCurrentFrame+1, 
      iFirstFrame+1, iLastFrame+1, nWidth, nHeight );
   pMonitor->DisplayMessage( strMessage );

   // --- create OpenGL texture from loaded image matrix ---
     
   if( !CreateLoadedTexture( ) ) { 
      pMonitor->DisplayMessage( "ERROR! Failed to Create loaded texture." );
      goto PIX_EXIT;
   }

   // index

   if( !CreateImageTexture( pPanes[2], true ) ) { 
      pMonitor->DisplayMessage( "ERROR! Failed to Create texture." );
      goto PIX_EXIT;
   }

   // *** copy the input image matrix to the loaded matrix 1 ***
  
   for( k = 0 ; k < 3 ; k++ ) {
      if( !_ImageDrvMtx[k].Copy( &_ImageInMtx[k] ) ) {
         strMessage = QString( "Failed to Copy Image to the 2nd matrix" );
         pMonitor->DisplayMessage( strMessage );
         goto PIX_EXIT; 
      }   
   }

   // --- initialize texture copy parameters ---

   rect = _Image_Pane[0]->size( ); 
   _SplitPara->SetFlipRatio( rect ); 
   _SplitPara->InitFlip( nWidth, nHeight, nWidth, nHeight ); 
   _SplitPara->SetSingleViewports( rect ); 
   _SplitPara->SetSingleConversion( ); 

   rect = _Index_Pane->size( ); 
   _IndexPara->SetFlipRatio( rect );  
   _IndexPara->InitFlip( nWidth, nHeight, nWidth, nHeight );  
   _IndexPara->SetSingleViewports( rect );  
   _IndexPara->SetSingleConversion( );  

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   return bRetCode;
}

//
// reallocate second/third image matrixces for three colors
//
bool SamplerWindow::AllocDerivedMatrix( void ) // [i] 1(second source) or 2(derived)
{
   bool bRetCode = false;
   int k, nCurWidth, nCurHeight, nWidth, nHeight;
   
   nWidth = _ImageInMtx[0].GetWidth( );
   nHeight = _ImageInMtx[0].GetHeight( );
   
   for( k = 0 ; k < 3 ; k++ ) {
      nCurWidth = _ImageDrvMtx[k].GetWidth( );
      nCurHeight = _ImageDrvMtx[k].GetHeight( );
   
      if( nCurWidth == nWidth && nCurHeight == nHeight ) continue;
   
      _ImageDrvMtx[k].Free( );
      if( !_ImageDrvMtx[k].Alloc( nHeight, nWidth ) ) {
         goto PIX_EXIT; 
      }
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   return bRetCode;
}

//
// create image texture for given pane from given image matrix(0/1/2)
//
bool SamplerWindow::CreateImageTexture( SamplerPane *pPane, // [i] for which pane?
                                       bool bLoaded ) // [i] loaded or derived image
{
   bool bRetCode = false;

   if( bLoaded ) {

      if( !pPane->CreateImageTexture( &_ImageInMtx[0], 
         &_ImageInMtx[1], &_ImageInMtx[2], bLoaded ) ) {
            goto PIX_EXIT;
      }

   } else {

      if( !pPane->CreateImageTexture( &_ImageDrvMtx[0], 
         &_ImageDrvMtx[1], &_ImageDrvMtx[2], bLoaded ) ) {
            goto PIX_EXIT;
      }

   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   return bRetCode;
}
