#include <pixqt_common.h>
#include <piximg_common.h>

#include <pixqtlib.h>
using namespace _pix_plot_qt_framework;

#include <piximglib.h>
using namespace _pix_plot_img_framework;

#include "sampler_common.h"
#include "sampler_panes.h"
#include "sampler_monitor.h"
#include "sampler_window.h"
#include "ui_sampler_window.h"

void SamplerWindow::HideImageProp( void )
{
   _Dock_Props->hide( );

   return;
}

void SamplerWindow::ShowImagePropPage( int iPage )
{
   _Image_Props->setCurrentPage( iPage );
   _Dock_Props->setFloating( false );
   _Dock_Props->show( );

   _Image_Props->EnableCtrlButtons( true );

   return;
}

void SamplerWindow::SetLeftMouseMode( short sMode )
{
   _sLeftMouseMode = sMode;

   _Image_Pane[0]->SetModeCursor( ); 
   _Image_Pane[1]->SetModeCursor( ); 
   
   _Index_Pane->setCursor( Qt::ArrowCursor );  

   return;
}

void SamplerWindow::ResetLeftMouseMode( void )
{
   _sLeftMouseMode = MouseLeftClickNone;

   _Image_Pane[0]->SetModeCursor( ); 
   _Image_Pane[1]->SetModeCursor( ); 

   _Index_Pane->setCursor( Qt::ArrowCursor ); 

   return;
}

//
// notes:
// this should be only called onece at the start-up!
//
void SamplerWindow::InitData( void )
{
   int k;

   _sLeftMouseMode = MouseLeftClickNone;
   _sDerivedImage = pixq_Properties::SamplerDerivedNone;
   
   // --- env setting --- 

   _pDepthEnv = new pixq_Properties;
   _pDepthEnv->InitEnv( _strOrganisation, _strApplication );

   // --- new project and data shot ---

   // input image data set / sequence
   if( _pImageDataSet ) { 
      delete _pImageDataSet;
      _pImageDataSet = NULL; 
   }

   _pImageDataSet = new pixq_ImageSingleSet; 
   _pImageDataSet->Init( ); 

   for( k = LEFT ; k <= RIGHT ; k++ ) {
      
      // texture 

      if( _pImgTexture[k] ) {
         delete _pImgTexture[k];
         _pImgTexture[k] = NULL;
      }

      _pImgTexture[k] = new pixq_DepthTexture;
      _pImgTexture[k]->Init( );
   
   }

   // --- working buffers ---

   _MainTexBuffer = new pixq_TextureBuffer; 
   _MainTexBuffer->Reset( ); 

   // --- init flip parameters ---

   _SplitPara = new pixq_FlipPara; 
   _IndexPara = new pixq_FlipPara; 

   return;
}

void SamplerWindow::DeInitData( void )
{   
   int k, l;
	
   if( NULL != _SplitPara ) { 
      delete _SplitPara; 
      _SplitPara = NULL; 
   }

   if( NULL != _IndexPara ) { 
      delete _IndexPara;  
      _IndexPara = NULL;  
   }

   if( NULL != _pDepthEnv ) {
      delete _pDepthEnv;
      _pDepthEnv = NULL;
   }
      
   if( _pImageDataSet ) { 
      delete _pImageDataSet;
      _pImageDataSet = NULL; 
   }

   for( k = LEFT ; k <= RIGHT ; k++ ) {

      if( _pImgTexture[k] ) {
         delete _pImgTexture[k];
         _pImgTexture[k] = NULL;
      }
   }

   for( l = 0 ; l < 3 ; l++ ) {
      _ImageInMtx[l].Free( );
      _ImageDrvMtx[l].Free( );
   }
   
   // *** others ***
 
   _sLeftMouseMode = MouseLeftClickNone;
   _sDerivedImage = pixq_Properties::SamplerDerivedNone;

   if( _MainTexBuffer ) { 
      delete _MainTexBuffer; 
      _MainTexBuffer = NULL; 
   }

   return;
}

void SamplerWindow::StoreEnv( void )
{
   pixq_Properties *pEnv = GetEnv( );

   pEnv->SetRegEnv( _strOrganisation, _strApplication );

   return;
}

//
// store window position in the setting
//
void SamplerWindow::StoreWindowPosition()
{
   QByteArray sta;
   QByteArray geo;

   QSettings settings( _strOrganisation, _strApplication );

   //

   geo = saveGeometry( );
   settings.setValue( "geometry", geo );

   //

   sta = saveState( );
   settings.setValue( "windowState", sta );

   return;
}

//
// restore the last window geometry
//
void SamplerWindow::RestoreWindowPosition()
{
   int iCount;
   QByteArray sta;
   QByteArray geo;

   QSettings settings( _strOrganisation, _strApplication );

   geo = settings.value("geometry").toByteArray( );
   iCount = geo.count( );
   if( 0 >= iCount ) {
      // first time
      int iLeft = 30;
      int iTop = 30;
      int iWidth = 600;
      int iHeight = 700;
      QSize sz;
      QPoint ps;

      ps.setX ( iLeft );
      ps.setY ( iTop );
      sz.setWidth ( iWidth );
      sz.setHeight ( iHeight );
      move( ps );
      resize( sz );
   } else {
      restoreGeometry( geo );
   }

   //

   sta = settings.value("windowState").toByteArray( );
   iCount = sta.count( );
   if( 0 < iCount ) {
      restoreState ( sta );
   }

   return;
}

//
// to maintain left and right image image panes, same width
//
void SamplerWindow::fixSamplerPanes( void )
{
   int iHandle, iPaneWidth[2], iWidth, iSum;
   QList<int> sp_sz;

   iHandle = _ImageSplitter->handleWidth( );

   sp_sz = _ImageSplitter->sizes( );
   
   // two images panesmust be of same width

   iPaneWidth[0] = sp_sz.at( 0 );
   iPaneWidth[1] = sp_sz.at( 1 );
   iSum = iPaneWidth[0] + iPaneWidth[1];

   iPaneWidth[0] = iSum / 2;
   iPaneWidth[1] = iSum - iPaneWidth[0];

   iWidth = iPaneWidth[0];
   
   _Image_Pane[0]->setFixedWidth( iWidth ); 
   _ImageSplitter->handle(1)->setCursor( Qt::ArrowCursor );

//PIX_EXIT:
   return;
}

//
// notes:
// ResetDocAll
// 
void SamplerWindow::ResetMain( void )
{
   pixq_FrameImageStat *pStat = GetImageStat( ); 
   int l;

   // --- init sequences ---

   SetImageLoaded( false );

   _pImageDataSet->Init( ); 

   for( l = 0 ; l < 3 ; l++ ) {
      _ImageInMtx[l].Free( );
      _ImageDrvMtx[l].Free( );
   }

   // *** reset panes ***

   _sLeftMouseMode = MouseLeftClickNone;
   _sDerivedImage = pixq_Properties::SamplerDerivedNone;

   // --- delete texture ---
     
   _pImgTexture[LEFT]->UnloadAll( ); 
   _pImgTexture[RIGHT]->UnloadAll( ); 
   
   _Image_Pane[0]->ResetPane( ); 
   _Image_Pane[1]->ResetPane( ); 
   _Index_Pane->ResetPane( ); 

   // release texture work buffer

   _MainTexBuffer->Reset( ); 

   _SplitPara->DeInit( ); 
   _IndexPara->DeInit( ); 
   
   ResetLeftMouseMode( );
   SetMenuState( );

   _Dock_Props->hide( );

   // init statistics

   pStat->Init( );

   //

   _Image_Props->EnableCtrlButtons( false );

   return;
}

bool SamplerWindow::GetImageFile( int iFrame, // [i] frame number
                                 QString *strFile ) // [o] file name
{
   bool bRetCode = false;
   pixq_ImageSingleSet *pData = GetImageData( );

   if( !pData->CheckFrame( iFrame ) ) {
      goto PIX_EXIT;
   }

   if( !pData->GetImageFile( iFrame, strFile ) ) {
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   return bRetCode;
}

//
// get texture ID for the side/frame
//
unsigned int SamplerWindow::GetTexture( int iSide, // [i] 0 or 1
                                      int iFrame ) // [i] frame number
{
   unsigned int uiImgTexture = _pImgTexture[iSide]->GetTexture( iFrame );

   return uiImgTexture;
}

void SamplerWindow::SetDisplayColor( short sDisplayColor )
{
   // left pane -> always rgb color

   _Image_Pane[0]->SetDisplayColor( sDisplayColor ); 
	_Image_Pane[1]->SetDisplayColor( sDisplayColor ); 
   
   // index pane -> always rgb color
   _Index_Pane->SetDisplayColor( PixImageDisplayColorRgb ); 
   
   return;
}

//
// get display color mode from the right pane
//
short SamplerWindow::GetDisplayColor( void ) 
{
   return _Image_Pane[1]->GetDisplayColor( );  
}


//
// set the "second pane mode" for the second pane
//
// notes:
// second pane mode for the pane0 and the index 0 has no meaning
// 
void SamplerWindow::SetPanesShowMode( short sPaneMode )
{
   _Image_Pane[0]->SetPaneShowMode( sPaneMode ); 
	_Image_Pane[1]->SetPaneShowMode( sPaneMode );
   _Index_Pane->SetPaneShowMode( SamplerPane::SamplerPaneShowFirst ); 
   
   //

   SetMenuState( );
   
   _Image_Label[0]->RefreshLabel( );
   _Image_Label[1]->RefreshLabel( );

   return;
}

void SamplerWindow::ResetPanesShowMode( void )
{
   _Image_Pane[0]->SetPaneShowMode( SamplerPane::SamplerPaneShowNone ); 
	_Image_Pane[1]->SetPaneShowMode( SamplerPane::SamplerPaneShowNone ); 
   _Index_Pane->SetPaneShowMode( SamplerPane::SamplerPaneShowNone ); 
   
   //

   SetMenuState( );
   return;
}

short SamplerWindow::GetPaneShowMode( int iSide )
{
   short sPaneMode;

   if( 0 == iSide ) {
      sPaneMode = _Image_Pane[0]->GetPaneShowMode( ); 
   } else {
      sPaneMode = _Image_Pane[1]->GetPaneShowMode( ); 
   }

   return sPaneMode;
}

bool SamplerWindow::SetProperties( void )
{
   bool bRetCode = false;
   pixq_Properties *pEnv = GetEnv( );
   int iMode;

   // show dialog and get the results

   iMode = EnvModeSampler;
   if( !ShowPixProperty_PC( _strOrganisation, _strApplication, pEnv, iMode ) ) {
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

static void EnableMenuActions( QList<QAction*> _actions,
                              bool bEnable )
{
   int i, nActions;
   QAction *action;

   nActions = _actions.size( );
   for( i = 0 ; i < nActions ; i++ ) {
      action = (QAction*)_actions.at( i );
      action->setEnabled( bEnable );
   }

   return;
}

//
// set menu status according to the conditions
//
void SamplerWindow::SetMenuState( void )
{
   int i, iSelectMode, nActions;
   QAction *action;

   short sPaneMode = _Image_Pane[1]->GetPaneShowMode( ); 
	short sPaneColor = _Image_Pane[1]->GetDisplayColor( ); 

   // enable/disable all menus

   nActions = _list_menu_actions.size( );
   for( i = 0 ; i < nActions ; i++ ) {
      action = (QAction*)_list_menu_actions.at( i );
      iSelectMode = ((QVariant)action->data( )).toInt( );

      switch( iSelectMode ) {
      case MouseActionItemEnabled:
         action->setEnabled( true );
         break;


      case MouseActionItemSingleDouble:
         if( CheckLoadSequence( ) ) {
            action->setEnabled( true );
         } else {
            action->setEnabled( false );
         }
         break;

      case MouseActionItemDisabled:
      default:
         action->setEnabled( false );
         break;
      }

      // uncheck action
      action->setCheckable( true );
      action->setChecked( false );
   }

   // check items - view comparison mode
   
   switch( sPaneMode ) {
   case SamplerPane::SamplerPaneShowFirst:
      ui->action_view_first_image->setChecked( true );
      break;

   case SamplerPane::SamplerPaneShowSecond:
      ui->action_view_second_image->setChecked( true );
      break;

   case SamplerPane::SamplerPaneShowWiper:
      ui->action_view_wiper->setChecked( true );
      break;

   case SamplerPane::SamplerPaneShowNone:
   default:
      break;
   }

   // check items - view color mode

   switch( sPaneColor ) {
   case PixImageDisplayColorRgb:
      ui->action_view_rgb->setChecked( true );
      break;
   case PixImageDisplayColorRed:
      ui->action_view_red_channel->setChecked( true );
      break;
   case PixImageDisplayColorGreen:
      ui->action_view_green_channel->setChecked( true );
      break;
   case PixImageDisplayColorBlue:
      ui->action_view_blue_channel->setChecked( true );
      break;
   case PixImageDisplayColorPseudoRed:
   case PixImageDisplayColorPseudoGreen:
   case PixImageDisplayColorPseudoBlue:
   default:
      break;
   }

   return;
}

//
// add a new line of message to the monitor 
//
void SamplerWindow::DisplayMessage( const char *szFormat, ... )
{   
   char szBuffer[RECORD_SIZE];
   va_list ap;	
   
   va_start( ap, szFormat );
	sprintf( szBuffer, szFormat, ap );
	va_end( ap );

   _Sampler_Monitor->DisplayMessage( szBuffer );

   return;
}

void SamplerWindow::DisplayMessage( QString strBuffer )
{
   _Sampler_Monitor->DisplayMessage( strBuffer );
}

void SamplerWindow::DisplayFrameInfo( void )
{
   pixq_ImageSingleSet *pData = GetImageData( );
   QString strMessage, strFile; 

   if( !pData->GetCurrentFile( &strFile ) ) {
      goto PIX_EXIT;
   }

   strMessage = pData->GetFrameString( );
   
   strMessage = strMessage + " : ";
   strMessage = strMessage + strFile;

   _Sampler_Monitor->DisplayMessage( strMessage );

   // set status bar

PIX_EXIT:
   return;
}

bool SamplerWindow::ShiftFrame( int iShift ) // [i] frame number increment
{
   bool bRetCode = false;
   int iNewFrame;   
   pixq_ImageSingleSet *pData = GetImageData( );
   int iCurrentFrame = pData->GetCurrentFrame( );
   int iFirstFrame = pData->GetFirstFrame( );
   int iLastFrame = pData->GetLastFrame( );

   // --- check conditions --- 
   
   if( 0 > iCurrentFrame ) {
      goto PIX_EXIT;
   }
  
   iNewFrame = iCurrentFrame + iShift;
   if( iFirstFrame > iNewFrame ) {
      iNewFrame = iLastFrame;
   }

   while( iLastFrame < iNewFrame ) {
      iNewFrame = iFirstFrame;
   }

   // --- move to the frame ---

   SelectFrame( iNewFrame );

   SetFrameStatusBar( );

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   return bRetCode;
}

bool SamplerWindow::FirstFrame( void )
{
   bool bRetCode = false;   
   int iFrame;
   pixq_ImageSingleSet *pData = GetImageData( );

QApplication::setOverrideCursor( Qt::BusyCursor );

   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }
   
   iFrame = pData->GetFirstFrame( ); 
   if( !SelectFrame( iFrame ) ) {
      goto PIX_EXIT;
   }

   SetFrameStatusBar( );

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
QApplication::restoreOverrideCursor();
   return bRetCode;
}

bool SamplerWindow::LastFrame( void )
{
   bool bRetCode = false;   
   int iFrame;
   pixq_ImageSingleSet *pData = GetImageData( );

QApplication::setOverrideCursor( Qt::BusyCursor );

   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }
   
   iFrame = pData->GetLastFrame( ); 
   if( !SelectFrame( iFrame ) ) {
      goto PIX_EXIT;
   }

   SetFrameStatusBar( );

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
QApplication::restoreOverrideCursor();
   return bRetCode;
}


bool SamplerWindow::ReloadFrame( void )
{   
   bool bRetCode = false;   
   pixq_ImageSingleSet *pData = GetImageData( );
   int iFrame= pData->GetCurrentFrame( );

QApplication::setOverrideCursor( Qt::BusyCursor );

   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }
   
   if( !SelectFrame( iFrame ) ) {
      goto PIX_EXIT;
   }

   SetFrameStatusBar( );

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
QApplication::restoreOverrideCursor();
   return bRetCode;
}


void SamplerWindow::SetPanesCursor( QCursor cur )
{
   setCursor( cur );

   _Image_Pane[0]->setCursor( cur ); 
	_Image_Pane[1]->setCursor( cur ); 
   _Index_Pane->setCursor( cur ); 

   QApplication::processEvents( );

   return;
}

void SamplerWindow::RefreshPanes( void )
{
   _Image_Pane[0]->RefreshSingle( ); 
	_Image_Pane[1]->RefreshSingle( ); 

   _Index_Pane->RefreshSingle( ); 



   _Image_Label[0]->RefreshLabel( );
   _Image_Label[1]->RefreshLabel( );

   return;
}

//
// create derived image from the single or double images
//
bool SamplerWindow::CreateDerivedBitmap( short sSecond )
{
   bool bRetCode = false;
             
QApplication::setOverrideCursor(Qt::BusyCursor);

   // *** create the second image matrix according to the mode
  
   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   // derive image from the single image in the first matrix
   // and set the result in the second matrix 
   if( !DeriveFromSingleBitmap( sSecond ) ) {
      QMessageBox::warning( this, _strApplication, "ERROR! Failed to Create Derived Image." );
      goto PIX_EXIT;
   }

   _sDerivedImage = sSecond;

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
QApplication::restoreOverrideCursor();
   return bRetCode;
}
 

bool SamplerWindow::LoadFrame( const QString strFile, 
                                pixq_Matrix<unsigned short> *usRed, 
                                pixq_Matrix<unsigned short> *usGrn, 
                                pixq_Matrix<unsigned short> *usBlu )
{
   bool bRetCode = false;
   
   // --- file existence ---

   if( !FileExist_PC( strFile ) ) {
      goto PIX_EXIT;  
   }

   // load supported image 

   if( !MagickLoadImage_PC( strFile, usRed, usGrn, usBlu ) ) {
      goto PIX_EXIT;
   }

	// --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// derive some image from the loaded single image
// and set the result in second matrix
//
// notes:
// all functions to create single output image from the currently load image
// should take the input image from the image matrix 0
// then make the output image matrix of the same size in the matrix 2
// and copy the input matrix from 0 to 1
//
bool SamplerWindow::DeriveFromSingleBitmap( short sSecond )
{
   bool bRetCode = false;
   SamplerMonitor *pMonitor = (SamplerMonitor*)GetMonitorPane( );
      
   // allocate second matrix to store the derived image

   if( !AllocDerivedMatrix( ) ) {
      QMessageBox::warning( this, _strApplication, "ERROR! Failed to allocate the third matrix." );
      goto PIX_EXIT; 
   }

   // *** create the second image matrix according to the mode ***

   switch( sSecond ) {
   case pixq_Properties::SamplerDerivedOriginal:
   case pixq_Properties::SamplerDerivedNone:
      // copy the first image matrix to second
      if( !CreateSecondOriginal( ) ) {
         goto PIX_EXIT;
      }
      break;

   case pixq_Properties::SamplerDerivedVisualDftValue:
      if( !CreateSecondDftImage( ) ) {
         goto PIX_EXIT;
      }
      break;

   case pixq_Properties::SamplerDerivedVisualDftShape:
      if( !CreateSecondDftShape( ) ) {
         goto PIX_EXIT;
      }
      break;

   case pixq_Properties::SamplerDerivedVisualDftFilter:
      if( !CreateSecondDftFiltered( ) ) {
         goto PIX_EXIT;
      }
      break;

   default:
      goto PIX_EXIT;
      break;
   }
   
   // create derived images texture
   
   if( !CreateDerivedTexture( ) ) {
      pMonitor->DisplayMessage( "ERROR! Failed to Create Derived Image Texture." );
      goto PIX_EXIT;
   }      

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   return bRetCode;
}

//
// set loade image matrix to inout 
//
bool SamplerWindow::CreateLoadedTexture( void )
{
   bool bRetCode = false;
   SamplerMonitor *pMonitor = (SamplerMonitor*)GetMonitorPane( );
   SamplerPane *pLeftPane = (SamplerPane*)_Image_Pane[0]; 
   SamplerPane *pRightPane = (SamplerPane*)_Image_Pane[1]; 
   
   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   // *** create image texture for the right pane from the derive image matrices ***
   
   // --- create OpenGL texture from the image matrix 1 in the right pane's first texture ---
   // --- create OpenGL texture from the image matrix 2 in the right pane's second texture ---
     
   if( !CreateImageTexture( pLeftPane, true ) ) { 
      pMonitor->DisplayMessage( "ERROR! Failed to Create texture." );
      goto PIX_EXIT;
   }

   if( !CreateImageTexture( pRightPane, true ) ) { 
      pMonitor->DisplayMessage( "ERROR! Failed to Create texture." );
      goto PIX_EXIT;
   }
   
   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   return bRetCode;
}

//
// create texture on the right pane from the derived image matrices
//
bool SamplerWindow::CreateDerivedTexture( void )
{
   bool bRetCode = false;
   SamplerMonitor *pMonitor = (SamplerMonitor*)GetMonitorPane( );
   SamplerPane *pLeftPane = (SamplerPane*)_Image_Pane[0]; 
   SamplerPane *pRightPane = (SamplerPane*)_Image_Pane[1]; 
            
   // *** create image texture for the right pane from the derive image matrices ***

   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   // *** create image texture for the right pane from the derive image matrices ***

   // --- create OpenGL texture from the image matrix 1 in the right pane's first texture ---
   // --- create OpenGL texture from the image matrix 2 in the right pane's second texture ---
     
   if( !CreateImageTexture( pLeftPane, false ) ) { 
      pMonitor->DisplayMessage( "ERROR! Failed to Create texture." );
      goto PIX_EXIT;
   }

   if( !CreateImageTexture( pRightPane, false ) ) { 
      pMonitor->DisplayMessage( "ERROR! Failed to Create texture." );
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   return bRetCode;
}

//
// returns true if one or two sequence is selected
//
bool SamplerWindow::CheckLoadSequence( void ) 
{
   bool bRetCode = false;
   pixq_ImageSingleSet *pData = GetImageData( );
   
   if( !pData->CheckCurrentFrame( ) ) {
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   return bRetCode;
}

//
// display color under the mouse on status bar
//
void SamplerWindow::GetColor( int iSide, int iMouseX, int iMouseY )
{
   int iPixX, iPixY;
   double dPixX, dPixY;

   unsigned short usRed, usGrn, usBlu;
   QString strValue;

   // more precise coordinate information(double)
   bool bDouble = true;

   // coordinate    
   switch( iSide ) {

   case SamplerPane::SamplerPaneSplitLeft: // left split pane 
   case SamplerPane::SamplerPaneSplitRight: // right split pane 
      if( bDouble ) {
         _SplitPara->ViewportToPixelCoo( iMouseX, iMouseY, &dPixX, &dPixY ); 
         iPixX = (int)floor( dPixX );
         iPixY = (int)floor( dPixY );
      } else {
         _SplitPara->ViewportToPixelCoo( iMouseX, iMouseY, &iPixX, &iPixY ); 
      }
      break;

   case SamplerPane::SamplerPaneIndex:
      if( bDouble ) {
         _IndexPara->ViewportToPixelCoo( iMouseX, iMouseY, &dPixX, &dPixY ); 
         iPixX = (int)floor( dPixX );
         iPixY = (int)floor( dPixY );
      } else {
         _IndexPara->ViewportToPixelCoo( iMouseX, iMouseY, &iPixX, &iPixY ); 
      }
      break;

   case SamplerPane::SamplerPaneUnknown: 
   default:
      goto PIX_EXIT;
   }

   // *** First image -> always display pixel value! ***

   switch( iSide ) {

   case SamplerPane::SamplerPaneSplitLeft: // left split pane 
   case SamplerPane::SamplerPaneSplitRight: // right split pane 
   case SamplerPane::SamplerPaneIndex:
      if( _ImageInMtx[0].IsInside( iPixX, iPixY ) ) {
         usRed = _ImageInMtx[0].Get( iPixY, iPixX );
         usGrn = _ImageInMtx[1].Get( iPixY, iPixX );
         usBlu = _ImageInMtx[2].Get( iPixY, iPixX );
         if( bDouble ) {
            strValue.sprintf( "Coo(%.2f,%.2f)/(%d,%d)=>Color[%03d,%03d,%03d]",
               dPixX, dPixY,
               iPixX, iPixY, usRed, usGrn, usBlu );
         } else {
            strValue.sprintf( "Coo(%d,%d)=>Color[%03d,%03d,%03d]", iPixX, iPixY,
               usRed, usGrn, usBlu );
         }
      } else {
         if( bDouble ) {
            strValue.sprintf( "Coo(%.2f,%.2f)/(%d,%d)=>Color[***,***,***]", dPixX, dPixY, 
               iPixX, iPixY );
         } else {
            strValue.sprintf( "Coo(%d,%d)=>Color[***,***,***]", iPixX, iPixY );
         }
      }

      _statusLabel[0]->setText( strValue );

      // *** Second image -> pixel value! ***
   
      if( _ImageDrvMtx[0].IsInside( iPixX, iPixY ) ) {
         usRed = _ImageDrvMtx[0].Get( iPixY, iPixX );
         usGrn = _ImageDrvMtx[1].Get( iPixY, iPixX );
         usBlu = _ImageDrvMtx[2].Get( iPixY, iPixX );
         strValue.sprintf( "Coo(%d,%d)=>Color[%03d,%03d,%03d]", iPixX, iPixY, usRed, usGrn, usBlu );
      } else {
         strValue.sprintf( "Coo(%d,%d)=>Color[***,***,***]", iPixX, iPixY );
      }

      _statusLabel[1]->setText( strValue );
      break;

   }

PIX_EXIT:
   return;
}

pixq_FlipPara *SamplerWindow::GetFlipPara( short sPane ) 
{ 
   switch( sPane ) {
   case SamplerPane::SamplerPaneIndex:
      return GetIndexPara( ); 
      break;

   case SamplerPane::SamplerPaneSplitLeft: 
   case SamplerPane::SamplerPaneSplitRight: 
   default:
      return GetSplitPara( ); 
      break;
   }
}

bool SamplerWindow::ValidPaneDisplayMode( void )
{
   bool bRetCode = false;
   
   if( !_Image_Pane[0]->ValidPaneDisplayMode( ) ) { 
      goto PIX_EXIT;
   }

   if( !_Image_Pane[1]->ValidPaneDisplayMode( ) ) { 
      goto PIX_EXIT;
   }

   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}

//
// handle key input
//
// returns:
// true: key input in handled
//
bool SamplerWindow::ProcessKeyEvent( short sPane, int iKey )
{
   bool bProc = false;
   pixq_FlipPara *pFlip = NULL; 

	switch( sPane ) {
   case SamplerPane::SamplerPaneSplitLeft: 
   case SamplerPane::SamplerPaneSplitRight: 
      pFlip = GetFlipPara( sPane ); 
		break;

   case SamplerPane::SamplerPaneUnknown:
   case SamplerPane::SamplerPaneIndex:
   default:
      goto PIX_EXIT;
      break;
   }

	switch( iKey ) {
	case Qt::Key_Right:	
      if( ValidPaneDisplayMode( ) ) {
         ShiftFrame( 1 );
      }
      bProc = true;
		break;

	case Qt::Key_Left:
      if( ValidPaneDisplayMode( ) ) {
         ShiftFrame( -1 );
      }
      bProc = true;
		break;

   case Qt::Key_1: // 1 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pFlip->XYViewShift( 1, 1 );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_2: // 2 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pFlip->XYViewShift( 0, 1 );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_3: // 3 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pFlip->XYViewShift( -1, 1 );
         RefreshPanes( );
      }
      break;

   case Qt::Key_4: // 4 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pFlip->XYViewShift( 1, 0 );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_5: // 5 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         //BlackOutWindow_ITFM( (CWnd*)this );
         pFlip->FlipRecenter( );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_6: // 6 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pFlip->XYViewShift( -1, 0 );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_7: // 7 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pFlip->XYViewShift( 1, -1 );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_8: // 8 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pFlip->XYViewShift( 0, -1 );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_9: // 9 on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pFlip->XYViewShift( -1, -1 );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_Home: 
      if( ValidPaneDisplayMode( ) ) {
         pFlip->ViewOneToOne( );
         RefreshPanes( );
      }
      bProc = true;
      break;

	case Qt::Key_Plus: // + on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pFlip->ZViewShift( -1 );
         RefreshPanes( );
      }
      bProc = true;
      break;

   case Qt::Key_Minus:	// - on NumPad
      if( ValidPaneDisplayMode( ) ) {
         pFlip->ZViewShift( 1 );
         RefreshPanes( );
      }
      bProc = true;
      break;

	// ESCAPE stop play/repeat thread
   case Qt::Key_Escape:
      // no mouse mode
      ResetLeftMouseMode( );
      RefreshPanes( );
      bProc = true;
      break;  

	// SPACE: pause play/repeat thread
	case Qt::Key_Space:
      break;
	}

PIX_EXIT:
   return bProc;
}

bool SamplerWindow::ProcessWheelEvent( short sPane, int iDelta )
{
   bool bProc = false;
   int iShift;
   pixq_FlipPara *pFlip = NULL;  

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

	switch( sPane ) {
   case SamplerPane::SamplerPaneSplitLeft: 
   case SamplerPane::SamplerPaneSplitRight: 
      pFlip = GetSplitPara( ); 
      break;


   case SamplerPane::SamplerPaneIndex:
   case SamplerPane::SamplerPaneUnknown:
   default:
      goto PIX_EXIT;
      break;
   }

   iShift = (int)-iDelta / 10;
   pFlip->ZViewShift( iShift );
   RefreshPanes( );

PIX_EXIT:
   return bProc;
}

bool SamplerWindow::ProcessScrollEvent( short sPane,
                                         int iX, 
                                         int iY )
{
   bool bProc = false;
   pixq_FlipPara *pFlip = NULL; 

   if( !ValidPaneDisplayMode( ) ) {
      goto PIX_EXIT;
   }

	switch( sPane ) {
   case SamplerPane::SamplerPaneSplitLeft: 
   case SamplerPane::SamplerPaneSplitRight: 
      pFlip = GetSplitPara( ); 
      break;

   case SamplerPane::SamplerPaneIndex:
   case SamplerPane::SamplerPaneUnknown:
   default:
      goto PIX_EXIT;
      break;
   }

   pFlip->XYViewStep( -iX, iY );
   RefreshPanes( );

PIX_EXIT:
   return bProc;
}


void SamplerWindow::ImageSplitterMoved( int /* pos */,
                                       int /* index */ )
{
   SetImageSplitterWidth( );

   return;
}


void SamplerWindow::ImageSideSplitterMoved(int /* pos */,
                                       int /* index */ )
{


   return;
}

void SamplerWindow::SetImageSplitterWidth( void )
{
   QList<int> sp_sz;
   int nSize;
   int iHandle, nWidth, iPaneWidth[2];

   QSize sz = _ImageSplitter->size( );

   iHandle = _ImageSplitter->handleWidth( );
   sp_sz = _ImageSplitter->sizes( );
   nSize = (int)sp_sz.size( ); 
   if( 2 != nSize ) {
      goto PIX_EXIT;
   }

   iPaneWidth[0] = sp_sz.at( 0 );
   iPaneWidth[1] = sp_sz.at( 1 );
   nWidth = iPaneWidth[0] + iPaneWidth[1];
   if( 0 >= nWidth ) {
      goto PIX_EXIT;
   }

   iPaneWidth[0] = nWidth / 2;
   iPaneWidth[1] = iPaneWidth[0];

   sp_sz.replace( 0, iPaneWidth[0] );
   sp_sz.replace( 1, iPaneWidth[1] );
   _ImageSplitter->setSizes( sp_sz );

PIX_EXIT:
   return;
}

void SamplerWindow::SetImageSideSplitterHeight( int iSide )
{
   QList<int> sp_sz;
   int nSize;
   int iHandle, nHeight, iPaneHeight[2];
   QSize sz;

   if( 0 > iSide || 1 < iSide ) goto PIX_EXIT;

   sz = _ImageSideSplitter[iSide]->size( );

   iHandle = _ImageSideSplitter[iSide]->handleWidth( );

   sp_sz = _ImageSideSplitter[iSide]->sizes( );
   nSize = (int)sp_sz.size( ); 
   if( 2 != nSize ) {
      goto PIX_EXIT;
   }

   iPaneHeight[0] = sp_sz.at( 0 );
   iPaneHeight[1] = sp_sz.at( 1 );
   nHeight = iPaneHeight[0] + iPaneHeight[1];
   if( 30 > nHeight ) {
      goto PIX_EXIT;
   }

   iPaneHeight[0] = 30;
   iPaneHeight[1] = nHeight - iPaneHeight[0];

   sp_sz.replace( 0, iPaneHeight[0] );
   sp_sz.replace( 1, iPaneHeight[1] );
   _ImageSideSplitter[iSide]->setSizes( sp_sz );

PIX_EXIT:
   return;
}

void SamplerWindow::SetFrameStatusBar( void )
{
   QString strFile, strFrame;
   pixq_ImageSingleSet *pData = GetImageData( );
       
   if( pData->CheckCurrentFrame( ) ) {

      int iCurrentFrame = pData->GetCurrentFrame( );
      int iFirstFrame = pData->GetFirstFrame( );
      int iLastFrame = pData->GetLastFrame( );

      if( !pData->GetCurrentFile( &strFile ) ) {
         goto PIX_EXIT;
      }

      strFrame = pData->GetFrameString( );

      _statusProgress->setRange( iFirstFrame+1, iLastFrame+1 );
      _statusProgress->setValue( iCurrentFrame+1 );
      _statusProgress->setEnabled( true );

   } else {
      
      strFile.clear( );
      strFrame.clear( );
      
      _statusProgress->setRange( 1, 100 );
      _statusProgress->setValue( 1 );
      _statusProgress->setEnabled( false );
   }

   _statusLabel[0]->setText( strFile );
   _statusLabel[1]->setText( strFrame );

PIX_EXIT:
   return;
}

// 
// select single sequence
//
bool SamplerWindow::SelectSingleSequence( void )
{
   bool bRetCode = false;
   pixq_Properties *pEnv = GetEnv( );
   pixq_ImageSingleSet *pData = GetImageData( );
   int iFrame;

   // reset data settings 
   
   ResetMain( ); 
   ResetPanesShowMode( );

   // show dialog and get the results

   if( !SelectSingleSequence_ITF( _strOrganisation, _strApplication, pEnv, pData ) ) {
      goto PIX_EXIT;
   }

   // select the current frame as the first frame in the sequence ---
     
   _sDerivedImage = pixq_Properties::SamplerDerivedOriginal;
   SetPanesShowMode( SamplerPane::SamplerPaneShowFirst );

   iFrame = pData->GetCurrentFrame( );
   if( !SelectFrame( iFrame ) ) {
      goto PIX_EXIT;
   }
   
   SetMenuState( );

   // --- Done ---
   bRetCode = true;
PIX_EXIT:
   return bRetCode;
}


//
// check whether image dimensions are power of two
//
bool SamplerWindow::CheckImagePowerOfTwo( void )
{
   bool bRetCode = false;
   int nPower, nImageWidth, nImagwHeight;
   SamplerMonitor *pMonitor = (SamplerMonitor*)GetMonitorPane( );
   QString strMessage;

   if( !CheckLoadSequence( ) ) {
      goto PIX_EXIT;
   }

   nImageWidth = _ImageInMtx[0].GetWidth( );
   nImagwHeight = _ImageInMtx[0].GetHeight( );

   // check image dimension must be power of two

   if( !IsPowerOfTwo_ITF( nImageWidth, &nPower ) ) {
      strMessage.sprintf( "WARNING! Image width is not a power of two(%d).", nImageWidth );
      pMonitor->DisplayMessage( strMessage );
      goto PIX_EXIT;
   }

   if( !IsPowerOfTwo_ITF( nImagwHeight, &nPower ) ) {
      strMessage.sprintf( "WARNING! Image height is not a power of two(%d*%d).", nImagwHeight );
      pMonitor->DisplayMessage( strMessage );
      goto PIX_EXIT;
   }

   // --- Done ---
   bRetCode = true;
PIX_EXIT: 
   return bRetCode;
}


void SamplerWindow::SetDerivedImage( short sDerivedImage ) 
{
   _sDerivedImage = sDerivedImage;
}

