#pragma once

#include <QtCore>
#include <QWidget>

#include <QBrush>
#include <QPen>

#include <vector>
#include <string>
#include <algorithm>
using namespace std;

class scope_window;
class ScopeMonitor;

class ChartPane : public QWidget
{
   Q_OBJECT
        
protected:
   void paintEvent( QPaintEvent * );

public:
   enum {
      ChartTypeNone = 0,
      //
      ChartTypeRgb0Histogram,
      ChartTypeRgb1Histogram,
      //
      ChartTypeRedHistogram,
      ChartTypeGrnHistogram,
      ChartTypeBluHistogram,
      //
      ChartTypeRedCorrelation,
      ChartTypeGrnCorrelation,
      ChartTypeBluCorrelation,
   } ChartTypeToPlot;

private slots:
    void chart_menu( void );

private:
    void createActions( void );

private:
    QAction *_rgb0_histogram_act;
    QAction *_rgb1_histogram_act;

    QAction *_red_histogram_act;
    QAction *_grn_histogram_act;
    QAction *_blu_histogram_act;

    QAction *_red_correlation_act;
    QAction *_grn_correlation_act;
    QAction *_blu_correlation_act;

protected:
    void contextMenuEvent(QContextMenuEvent *event);

public:
   ChartPane(QWidget *parent = 0);
   ~ChartPane();

private:
   // pointer to the main window
   scope_window *_pMainWindow;

   // line width to draw tag/wiper line
   float _fMinLineWidth;
   float _fMaxLineWidth;
   float _fSelectedLineWidth;

   // required resourced initialized
   bool _bPaneInitialized;

   // what t0 plot on chart, one of ChartTypeToPlot
   int _iChartType;

protected:
   void closeEvent(QCloseEvent *eve);
   void resizeEvent( QResizeEvent* );
   
protected:   
   void keyPressEvent( QKeyEvent *eve );
   void mousePressEvent( QMouseEvent *eve );
   void mouseMoveEvent( QMouseEvent *eve );
   void wheelEvent ( QWheelEvent *eve  );   

public:
   void Init( void );

   void DrawHistogram( double dMaxHist, 
      const vector<double> &pBinLow,
      const vector<double> &pBinHigh,
      int nHists, // [i] 2 or 3
      QColor pen_color0,
      QColor pen_color1,
      QColor pen_color2,
      const vector<int> *pHist0, 
      const vector<int> *pHist1, 
      const vector<int> *pHist2 );

   void DrawColorBar( int iViewX, int iViewW, int iViewY, int iViewH );

   bool ValidChartDisplayMode( void );

   void ResetPane( void );

   void SetMainWindow( scope_window *pMain ) { _pMainWindow = pMain; }
   scope_window *GetMainWindow( void ) { return _pMainWindow; }

   void PlotChart( void );
   void PlotCorrChart( void );

   void PlotColorHistgram( void );
   void PlotRgbHistgram( void );
   void PlotBlank( void );
   
   bool InitializeOpenGL( void );

   int GetChartType( void ) { return _iChartType; }
   void SetChartType( int iChartType ) { _iChartType = iChartType; }
   
private:
   void SetDockLabel( void );
   void PlotNextChart( void );
   void PlotPrevChart( void );

};

