#include "itfqt_common.h"

#include <itfqtlib.h>
using namespace _imax_imgtec_qt_framework;

#include "property_page.h"
#include "props_page_match_depth.h"
#include "ui_props_page_match_depth.h"

props_page_match_depth::props_page_match_depth(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::props_page_match_depth)
{
    ui->setupUi(this);

    _propPage = value_prop_page_match_depth;
}

props_page_match_depth::~props_page_match_depth()
{
    delete ui;
}

void props_page_match_depth::Init( ITQF_DepthEnv *pEnv )
{
   Store( pEnv );

   // set current value
   SetData( );

   return;
}

//
// set current data
//
void props_page_match_depth::SetData( void )
{
   ITQF_DepthEnv *pEnv = GetDepthEnv( );

   // *** set current data ***

   // *******************************
   // *** Stereo Matching - Depth ***
   // *******************************

   // *** depth interpolation ***

   // do the interpolation for all red(low correlation) points
   
   SetBool( &pEnv->_MatchSmoothLowCorrelation, ui->match_smooth_low_corr_check ); 

   // do the interpolation for all blue(low texture) points
    
   SetBool( &pEnv->_MatchSmoothPoorTexture, ui->match_smooth_poor_tex_check ); 

   // do the interpolation according to the Disparity angle threshold
    
   SetBool( &pEnv->_MatchSmoothByDisparityAngle, ui->mtch_smooth_by_disparity_angle_check ); 

   // smallest disparity angle threshold, if the disparity angle from all four neighbours are smaller than this, it is excluded(degree)
    
   Set2Double( &pEnv->_MatchSmallDisparityAngle, ui->match_small_disparity_angle_edit );

   // largest disparity angle threshold, if the disparity angle from all four neighbours are larger than this, it is excluded(degree)
    
   Set2Double( &pEnv->_MatchLargeDisparityAngle, ui->match_large_disparity_angle_edit );

   // max number of iteration of interpolatin based on angle
    
   SetInteger( &pEnv->_MatchMaxIterationAngleSmooth, ui->match_max_iteration_angle_smooth_edit ); 

   // --- Done ---
   return;
}

bool props_page_match_depth::Check( void )
{
   bool bRetCode = false;
   ITQF_DepthEnv *pEnv = GetDepthEnv( );

   // *******************************
   // *** Stereo Matching - Depth ***
   // *******************************

   // *** depth interpolation ***

   // do the interpolation for all red(low correlation) points
   
   GetBool( &pEnv->_MatchSmoothLowCorrelation, ui->match_smooth_low_corr_check ); 

   // do the interpolation for all blue(low texture) points
    
   GetBool( &pEnv->_MatchSmoothPoorTexture, ui->match_smooth_poor_tex_check ); 

   // do the interpolation according to the Disparity angle threshold
    
   GetBool( &pEnv->_MatchSmoothByDisparityAngle, ui->mtch_smooth_by_disparity_angle_check ); 

   // smallest disparity angle threshold, if the disparity angle from all four neighbours are smaller than this, it is excluded(degree)
    
   if( !GetDouble( &pEnv->_MatchSmallDisparityAngle, ui->match_small_disparity_angle_edit ) ) { 
      QMessageBox::critical( this, _strApplication, "Enter Real Value." );
      goto DMR_EXIT;
   } 

   // largest disparity angle threshold, if the disparity angle from all four neighbours are larger than this, it is excluded(degree)
    
   if( !GetDouble( &pEnv->_MatchLargeDisparityAngle, ui->match_large_disparity_angle_edit ) ) { 
      QMessageBox::critical( this, _strApplication, "Enter Real Value." );
      goto DMR_EXIT;
   } 

   // max number of iteration of interpolatin based on angle
    
   if( !GetInteger( &pEnv->_MatchMaxIterationAngleSmooth, ui->match_max_iteration_angle_smooth_edit ) ) { 
      QMessageBox::critical( this, _strApplication, "Enter Integer Value." );
      goto DMR_EXIT;
   }  

   // --- Done ---
   bRetCode = true;
DMR_EXIT:
   return bRetCode;
}
